# coding: utf-8

"""
WorkforceManagementApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class WorkforceManagementApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_workforcemanagement_managementunit(self, mu_id, **kwargs):
        """
        Delete management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `delete_workforcemanagement_managementunit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_activitycode(self, mu_id, ac_id, **kwargs):
        """
        Deletes an activity code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_activitycode(mu_id, ac_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str ac_id: The ID of the activity code to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'ac_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_activitycode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `delete_workforcemanagement_managementunit_activitycode`")
        # verify the required parameter 'ac_id' is set
        if ('ac_id' not in params) or (params['ac_id'] is None):
            raise ValueError("Missing the required parameter `ac_id` when calling `delete_workforcemanagement_managementunit_activitycode`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']
        if 'ac_id' in params:
            path_params['acId'] = params['ac_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_scheduling_run(self, management_unit_id, run_id, **kwargs):
        """
        Cancel a schedule run
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_scheduling_run(management_unit_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str run_id: The ID of the schedule run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'run_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_scheduling_run" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_scheduling_run`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `delete_workforcemanagement_managementunit_scheduling_run`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'run_id' in params:
            path_params['runId'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_servicegoalgroup(self, management_unit_id, service_goal_group_id, **kwargs):
        """
        Delete a service goal group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_servicegoalgroup(management_unit_id, service_goal_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str service_goal_group_id: The ID of the service goal group to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'service_goal_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_servicegoalgroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_servicegoalgroup`")
        # verify the required parameter 'service_goal_group_id' is set
        if ('service_goal_group_id' not in params) or (params['service_goal_group_id'] is None):
            raise ValueError("Missing the required parameter `service_goal_group_id` when calling `delete_workforcemanagement_managementunit_servicegoalgroup`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'service_goal_group_id' in params:
            path_params['serviceGoalGroupId'] = params['service_goal_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_week_schedule(self, management_unit_id, week_id, schedule_id, **kwargs):
        """
        Delete a schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_week_schedule(management_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param str schedule_id: The ID of theschedule to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'schedule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_week_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_week_schedule`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `delete_workforcemanagement_managementunit_week_schedule`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `delete_workforcemanagement_managementunit_week_schedule`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_week_shorttermforecast(self, management_unit_id, week_date_id, forecast_id, **kwargs):
        """
        Delete a short term forecast
        Must not be tied to any schedules

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_week_shorttermforecast(management_unit_id, week_date_id, forecast_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The management unit ID of the management unit to which the forecast belongs (required)
        :param str week_date_id: The week start date of the forecast in yyyy-MM-dd format (required)
        :param str forecast_id: The ID of the forecast (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'forecast_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_week_shorttermforecast" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_week_shorttermforecast`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `delete_workforcemanagement_managementunit_week_shorttermforecast`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `delete_workforcemanagement_managementunit_week_shorttermforecast`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workforcemanagement_managementunit_workplan(self, management_unit_id, work_plan_id, **kwargs):
        """
        Delete a work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workforcemanagement_managementunit_workplan(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workforcemanagement_managementunit_workplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `delete_workforcemanagement_managementunit_workplan`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `delete_workforcemanagement_managementunit_workplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_adherence(self, user_id, **kwargs):
        """
        Get a list of UserScheduleAdherence records for the requested users
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_adherence(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] user_id: User Id(s) for which to fetch current schedule adherence information.  Min 1, Max of 100 userIds per request (required)
        :return: list[UserScheduleAdherence]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_adherence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_workforcemanagement_adherence`")


        resource_path = '/api/v2/workforcemanagement/adherence'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'user_id' in params:
            query_params['userId'] = params['user_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[UserScheduleAdherence]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_adhocmodelingjob(self, job_id, **kwargs):
        """
        Get status of the modeling job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_adhocmodelingjob(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the modeling job (required)
        :return: ModelingStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_adhocmodelingjob" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_workforcemanagement_adhocmodelingjob`")


        resource_path = '/api/v2/workforcemanagement/adhocmodelingjobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ModelingStatusResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit(self, mu_id, **kwargs):
        """
        Get management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param list[str] expand: 
        :return: ManagementUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_activitycode(self, mu_id, ac_id, **kwargs):
        """
        Get an activity code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_activitycode(mu_id, ac_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str ac_id: The ID of the activity code to fetch (required)
        :return: ActivityCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'ac_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_activitycode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_activitycode`")
        # verify the required parameter 'ac_id' is set
        if ('ac_id' not in params) or (params['ac_id'] is None):
            raise ValueError("Missing the required parameter `ac_id` when calling `get_workforcemanagement_managementunit_activitycode`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']
        if 'ac_id' in params:
            path_params['acId'] = params['ac_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActivityCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_activitycodes(self, mu_id, **kwargs):
        """
        Get activity codes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_activitycodes(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: ActivityCodeContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_activitycodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_activitycodes`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActivityCodeContainer',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_agent(self, management_unit_id, agent_id, **kwargs):
        """
        Get data for agent in the management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_agent(management_unit_id, agent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The id of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str agent_id: The agent id (required)
        :return: WfmAgent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'agent_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_agent" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_agent`")
        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params) or (params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `get_workforcemanagement_managementunit_agent`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/agents/{agentId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmAgent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_intraday_queues(self, mu_id, date, **kwargs):
        """
        Get intraday queues for the given date
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_intraday_queues(mu_id, date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The management unit ID of the management unit (required)
        :param str date: yyyy-MM-dd date string interpreted in the configured management unit time zone (required)
        :return: WfmIntradayQueueListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'date']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_intraday_queues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_intraday_queues`")
        # verify the required parameter 'date' is set
        if ('date' not in params) or (params['date'] is None):
            raise ValueError("Missing the required parameter `date` when calling `get_workforcemanagement_managementunit_intraday_queues`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/intraday/queues'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}
        if 'date' in params:
            query_params['date'] = params['date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmIntradayQueueListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_scheduling_run(self, management_unit_id, run_id, **kwargs):
        """
        Gets the status for a specific scheduling run
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_scheduling_run(management_unit_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str run_id: The ID of the schedule run (required)
        :return: SchedulingRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'run_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_scheduling_run" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_scheduling_run`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `get_workforcemanagement_managementunit_scheduling_run`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'run_id' in params:
            path_params['runId'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchedulingRunResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_scheduling_run_result(self, management_unit_id, run_id, **kwargs):
        """
        Gets the result of a specific scheduling run
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_scheduling_run_result(management_unit_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str run_id: The ID of the schedule run (required)
        :return: RescheduleResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'run_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_scheduling_run_result" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_scheduling_run_result`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `get_workforcemanagement_managementunit_scheduling_run_result`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}/result'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'run_id' in params:
            path_params['runId'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RescheduleResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_scheduling_runs(self, management_unit_id, **kwargs):
        """
        Get the status of all the ongoing schedule runs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_scheduling_runs(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :return: SchedulingRunListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_scheduling_runs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_scheduling_runs`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchedulingRunListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_servicegoalgroup(self, management_unit_id, service_goal_group_id, **kwargs):
        """
        Get a service goal group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_servicegoalgroup(management_unit_id, service_goal_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str service_goal_group_id: The ID of the service goal group to fetch (required)
        :return: ServiceGoalGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'service_goal_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_servicegoalgroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_servicegoalgroup`")
        # verify the required parameter 'service_goal_group_id' is set
        if ('service_goal_group_id' not in params) or (params['service_goal_group_id'] is None):
            raise ValueError("Missing the required parameter `service_goal_group_id` when calling `get_workforcemanagement_managementunit_servicegoalgroup`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'service_goal_group_id' in params:
            path_params['serviceGoalGroupId'] = params['service_goal_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ServiceGoalGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_servicegoalgroups(self, management_unit_id, **kwargs):
        """
        Get service goal groups
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_servicegoalgroups(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: ServiceGoalGroupList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_servicegoalgroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_servicegoalgroups`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ServiceGoalGroupList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_settings(self, mu_id, **kwargs):
        """
        Get the settings for the requested management unit. Deprecated, use the GET management unit route instead
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_settings(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: ManagementUnitSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_settings`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/settings'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnitSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_shifttrades_matched(self, mu_id, **kwargs):
        """
        Gets a summary of all shift trades in the matched state
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_shifttrades_matched(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The management unit ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: ShiftTradeMatchesSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_shifttrades_matched" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_shifttrades_matched`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/matched'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShiftTradeMatchesSummaryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_shifttrades_users(self, mu_id, **kwargs):
        """
        Gets list of users available for whom you can send direct shift trade requests
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_shifttrades_users(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The management unit ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: WfmUserEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_shifttrades_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_shifttrades_users`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/shifttrades/users'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmUserEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_user_timeoffrequest(self, mu_id, user_id, time_off_request_id, **kwargs):
        """
        Get a time off request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_user_timeoffrequest(mu_id, user_id, time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The muId of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str user_id: The userId to whom the Time Off Request applies. (required)
        :param str time_off_request_id: Time Off Request Id (required)
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'user_id', 'time_off_request_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_user_timeoffrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest`")
        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequest`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_user_timeoffrequests(self, mu_id, user_id, **kwargs):
        """
        Get a list of time off requests for a given user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_user_timeoffrequests(mu_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The muId of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str user_id: The userId to whom the Time Off Request applies. (required)
        :param bool recently_reviewed: Limit results to requests that have been reviewed within the preceding 30 days
        :return: TimeOffRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'user_id', 'recently_reviewed']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_user_timeoffrequests" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequests`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_workforcemanagement_managementunit_user_timeoffrequests`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'recently_reviewed' in params:
            query_params['recentlyReviewed'] = params['recently_reviewed']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_users(self, mu_id, **kwargs):
        """
        Get users in the management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_users(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The management unit ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :return: WfmUserEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `get_workforcemanagement_managementunit_users`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmUserEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_week_schedule(self, management_unit_id, week_id, schedule_id, **kwargs):
        """
        Get a week schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_week_schedule(management_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param str schedule_id: The ID of the schedule to fetch (required)
        :param str expand: Which fields, if any, to expand
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :return: WeekScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'schedule_id', 'expand', 'force_download_service']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_week_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_week_schedule`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_managementunit_week_schedule`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_workforcemanagement_managementunit_week_schedule`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WeekScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_week_schedule_generationresults(self, management_unit_id, week_id, schedule_id, **kwargs):
        """
        Get week schedule generation results
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_week_schedule_generationresults(management_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param str schedule_id: The ID of the schedule to fetch generation results (required)
        :return: WeekScheduleGenerationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'schedule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_week_schedule_generationresults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_week_schedule_generationresults`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_managementunit_week_schedule_generationresults`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_workforcemanagement_managementunit_week_schedule_generationresults`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/generationresults'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WeekScheduleGenerationResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_week_schedules(self, management_unit_id, week_id, **kwargs):
        """
        Get the list of schedules in a week in management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_week_schedules(management_unit_id, week_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param bool include_only_published: Return only published schedules
        :param str earliest_week_date: The start date of the earliest week to query in yyyy-MM-dd format
        :param str latest_week_date: The start date of the latest week to query in yyyy-MM-dd format
        :return: WeekScheduleListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'include_only_published', 'earliest_week_date', 'latest_week_date']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_week_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_week_schedules`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `get_workforcemanagement_managementunit_week_schedules`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}
        if 'include_only_published' in params:
            query_params['includeOnlyPublished'] = params['include_only_published']
        if 'earliest_week_date' in params:
            query_params['earliestWeekDate'] = params['earliest_week_date']
        if 'latest_week_date' in params:
            query_params['latestWeekDate'] = params['latest_week_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WeekScheduleListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_week_shorttermforecast_final(self, management_unit_id, week_date_id, forecast_id, **kwargs):
        """
        Get the final result of a short term forecast calculation with modifications applied
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_week_shorttermforecast_final(management_unit_id, week_date_id, forecast_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The management unit ID of the management unit to which the forecast belongs (required)
        :param str week_date_id: The week start date of the forecast in yyyy-MM-dd format (required)
        :param str forecast_id: The ID of the forecast (required)
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :return: ForecastResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'forecast_id', 'force_download_service']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_week_shorttermforecast_final" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_week_shorttermforecast_final`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_managementunit_week_shorttermforecast_final`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `get_workforcemanagement_managementunit_week_shorttermforecast_final`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/final'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ForecastResultResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_week_shorttermforecasts(self, management_unit_id, week_date_id, **kwargs):
        """
        Get short term forecasts
        Use \"recent\" for the `weekDateId` path parameter to fetch all forecasts for +/- 26 weeks from the current date

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_week_shorttermforecasts(management_unit_id, week_date_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The management unit ID of the management unit to which the forecast belongs (required)
        :param str week_date_id: The week start date of the forecast in yyyy-MM-dd format (required)
        :return: ShortTermForecastListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_week_shorttermforecasts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_week_shorttermforecasts`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `get_workforcemanagement_managementunit_week_shorttermforecasts`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShortTermForecastListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_workplan(self, management_unit_id, work_plan_id, **kwargs):
        """
        Get a work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_workplan(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to fetch (required)
        :return: WorkPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_workplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_workplan`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `get_workforcemanagement_managementunit_workplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunit_workplans(self, management_unit_id, **kwargs):
        """
        Get work plans
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunit_workplans(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param list[str] expand: 
        :return: WorkPlanListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunit_workplans" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `get_workforcemanagement_managementunit_workplans`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlanListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunits(self, **kwargs):
        """
        Get management units
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: 
        :param int page_number: 
        :param str expand: 
        :param str feature: 
        :param str division_id: 
        :return: ManagementUnitListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'expand', 'feature', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/managementunits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'feature' in params:
            query_params['feature'] = params['feature']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnitListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_managementunits_divisionviews(self, **kwargs):
        """
        Get management units across divisions
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_managementunits_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] division_id: The divisionIds to filter by. If omitted, will return all divisions
        :return: ManagementUnitListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_managementunits_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/managementunits/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnitListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_notifications(self, **kwargs):
        """
        Get a list of notifications for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_notifications(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: NotificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_notifications" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/notifications'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NotificationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_schedulingjob(self, job_id, **kwargs):
        """
        Get status of the scheduling job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_schedulingjob(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the scheduling job (required)
        :return: SchedulingStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_schedulingjob" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_workforcemanagement_schedulingjob`")


        resource_path = '/api/v2/workforcemanagement/schedulingjobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchedulingStatusResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_shifttrades(self, **kwargs):
        """
        Gets all of my shift trades
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_shifttrades(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ShiftTradeListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_shifttrades" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/shifttrades'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShiftTradeListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_timeoffrequest(self, time_off_request_id, **kwargs):
        """
        Get a time off request for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_timeoffrequest(time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str time_off_request_id: Time Off Request Id (required)
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['time_off_request_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_timeoffrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `get_workforcemanagement_timeoffrequest`")


        resource_path = '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}'.replace('{format}', 'json')
        path_params = {}
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workforcemanagement_timeoffrequests(self, **kwargs):
        """
        Get a list of time off requests for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workforcemanagement_timeoffrequests(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool recently_reviewed: Limit results to requests that have been reviewed within the preceding 30 days
        :return: TimeOffRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recently_reviewed']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workforcemanagement_timeoffrequests" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/timeoffrequests'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'recently_reviewed' in params:
            query_params['recentlyReviewed'] = params['recently_reviewed']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit(self, mu_id, **kwargs):
        """
        Update the requested management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param UpdateManagementUnitRequest body: body
        :return: ManagementUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `patch_workforcemanagement_managementunit`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_activitycode(self, mu_id, ac_id, **kwargs):
        """
        Update an activity code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_activitycode(mu_id, ac_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str ac_id: The ID of the activity code to update (required)
        :param UpdateActivityCodeRequest body: body
        :return: ActivityCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'ac_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_activitycode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `patch_workforcemanagement_managementunit_activitycode`")
        # verify the required parameter 'ac_id' is set
        if ('ac_id' not in params) or (params['ac_id'] is None):
            raise ValueError("Missing the required parameter `ac_id` when calling `patch_workforcemanagement_managementunit_activitycode`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes/{acId}'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']
        if 'ac_id' in params:
            path_params['acId'] = params['ac_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActivityCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_scheduling_run(self, management_unit_id, run_id, **kwargs):
        """
        Marks a specific scheduling run as applied, allowing a new rescheduling run to be started
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_scheduling_run(management_unit_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit. (required)
        :param str run_id: The ID of the schedule run (required)
        :param UpdateSchedulingRunRequest body: body
        :return: RescheduleResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'run_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_scheduling_run" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_scheduling_run`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `patch_workforcemanagement_managementunit_scheduling_run`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/scheduling/runs/{runId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'run_id' in params:
            path_params['runId'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RescheduleResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_servicegoalgroup(self, management_unit_id, service_goal_group_id, **kwargs):
        """
        Update a service goal group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_servicegoalgroup(management_unit_id, service_goal_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str service_goal_group_id: The ID of the service goal group to update (required)
        :param ServiceGoalGroup body: body
        :return: ServiceGoalGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'service_goal_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_servicegoalgroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_servicegoalgroup`")
        # verify the required parameter 'service_goal_group_id' is set
        if ('service_goal_group_id' not in params) or (params['service_goal_group_id'] is None):
            raise ValueError("Missing the required parameter `service_goal_group_id` when calling `patch_workforcemanagement_managementunit_servicegoalgroup`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups/{serviceGoalGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'service_goal_group_id' in params:
            path_params['serviceGoalGroupId'] = params['service_goal_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ServiceGoalGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_settings(self, mu_id, **kwargs):
        """
        Update the settings for the requested management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_settings(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param ManagementUnitSettings body: config
        :return: ManagementUnitSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `patch_workforcemanagement_managementunit_settings`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/settings'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnitSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_user_timeoffrequest(self, mu_id, user_id, time_off_request_id, **kwargs):
        """
        Update a time off request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_user_timeoffrequest(mu_id, user_id, time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The muId of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str user_id: The id of the user the requested time off request belongs to (required)
        :param str time_off_request_id: The id of the time off request to update (required)
        :param AdminTimeOffRequestPatch body: body
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'user_id', 'time_off_request_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_user_timeoffrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `patch_workforcemanagement_managementunit_user_timeoffrequest`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_workforcemanagement_managementunit_user_timeoffrequest`")
        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `patch_workforcemanagement_managementunit_user_timeoffrequest`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/users/{userId}/timeoffrequests/{timeOffRequestId}'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_week_schedule(self, management_unit_id, week_id, schedule_id, **kwargs):
        """
        Update a week schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_week_schedule(management_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param str schedule_id: The ID of the schedule to update. Use partial uploads of user schedules if activity count in schedule is greater than 17500 (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :param UpdateWeekScheduleRequest body: body
        :return: AsyncWeekScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'schedule_id', 'force_async', 'force_download_service', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_week_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_week_schedule`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `patch_workforcemanagement_managementunit_week_schedule`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `patch_workforcemanagement_managementunit_week_schedule`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncWeekScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_managementunit_workplan(self, management_unit_id, work_plan_id, **kwargs):
        """
        Update a work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_managementunit_workplan(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to update (required)
        :param WorkPlan body: body
        :return: WorkPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_managementunit_workplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `patch_workforcemanagement_managementunit_workplan`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `patch_workforcemanagement_managementunit_workplan`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_workforcemanagement_timeoffrequest(self, time_off_request_id, **kwargs):
        """
        Update a time off request for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_workforcemanagement_timeoffrequest(time_off_request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str time_off_request_id: Time Off Request Id (required)
        :param AgentTimeOffRequestPatch body: body
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['time_off_request_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_workforcemanagement_timeoffrequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'time_off_request_id' is set
        if ('time_off_request_id' not in params) or (params['time_off_request_id'] is None):
            raise ValueError("Missing the required parameter `time_off_request_id` when calling `patch_workforcemanagement_timeoffrequest`")


        resource_path = '/api/v2/workforcemanagement/timeoffrequests/{timeOffRequestId}'.replace('{format}', 'json')
        path_params = {}
        if 'time_off_request_id' in params:
            path_params['timeOffRequestId'] = params['time_off_request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_adherence_historical(self, **kwargs):
        """
        Request a historical adherence report for users across management units
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_adherence_historical(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WfmHistoricalAdherenceQueryForUsers body: body
        :return: WfmHistoricalAdherenceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_adherence_historical" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/adherence/historical'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmHistoricalAdherenceResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_activitycodes(self, mu_id, **kwargs):
        """
        Create a new activity code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_activitycodes(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param CreateActivityCodeRequest body: body
        :return: ActivityCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_activitycodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `post_workforcemanagement_managementunit_activitycodes`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/activitycodes'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActivityCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_historicaladherencequery(self, mu_id, **kwargs):
        """
        Request a historical adherence report
        The maximum supported range for historical adherence queries is 31 days, or 7 days with includeExceptions = true

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_historicaladherencequery(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The management unit ID of the management unit (required)
        :param WfmHistoricalAdherenceQuery body: body
        :return: WfmHistoricalAdherenceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_historicaladherencequery" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `post_workforcemanagement_managementunit_historicaladherencequery`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/historicaladherencequery'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WfmHistoricalAdherenceResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_intraday(self, mu_id, **kwargs):
        """
        Get intraday data for the given date for the requested queueIds
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_intraday(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The management unit ID of the management unit (required)
        :param IntradayQueryDataCommand body: body
        :return: IntradayResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_intraday" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `post_workforcemanagement_managementunit_intraday`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/intraday'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IntradayResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_move(self, mu_id, **kwargs):
        """
        Move the requested management unit to a new business unit
        Returns status 200 if the management unit is already in the requested business unit

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_move(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param MoveManagementUnitRequest body: body
        :return: MoveManagementUnitResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_move" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `post_workforcemanagement_managementunit_move`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/move'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MoveManagementUnitResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_schedules_search(self, mu_id, **kwargs):
        """
        Query published schedules for given given time range for set of users
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_schedules_search(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The management unit ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param UserListScheduleRequestBody body: body
        :return: UserScheduleContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_schedules_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `post_workforcemanagement_managementunit_schedules_search`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/schedules/search'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserScheduleContainer',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_servicegoalgroups(self, management_unit_id, **kwargs):
        """
        Create a new service goal group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_servicegoalgroups(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param CreateServiceGoalGroupRequest body: body
        :return: ServiceGoalGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_servicegoalgroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_servicegoalgroups`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/servicegoalgroups'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ServiceGoalGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeoffrequests(self, mu_id, **kwargs):
        """
        Create a new time off request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeoffrequests(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The muId of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param CreateAdminTimeOffRequest body: body
        :return: TimeOffRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeoffrequests" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `post_workforcemanagement_managementunit_timeoffrequests`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeoffrequests_fetchdetails(self, mu_id, **kwargs):
        """
        Gets a list of time off requests from lookup ids
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeoffrequests_fetchdetails(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The muId of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param TimeOffRequestLookupList body: body
        :return: TimeOffRequestEntityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeoffrequests_fetchdetails" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `post_workforcemanagement_managementunit_timeoffrequests_fetchdetails`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/fetchdetails'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestEntityList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_timeoffrequests_query(self, mu_id, **kwargs):
        """
        Gets the lookup ids to fetch the specified set of requests
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_timeoffrequests_query(mu_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str mu_id: The muId of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param TimeOffRequestQueryBody body: body
        :return: TimeOffRequestLookupList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mu_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_timeoffrequests_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'mu_id' is set
        if ('mu_id' not in params) or (params['mu_id'] is None):
            raise ValueError("Missing the required parameter `mu_id` when calling `post_workforcemanagement_managementunit_timeoffrequests_query`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{muId}/timeoffrequests/query'.replace('{format}', 'json')
        path_params = {}
        if 'mu_id' in params:
            path_params['muId'] = params['mu_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestLookupList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_schedule_copy(self, management_unit_id, week_id, schedule_id, **kwargs):
        """
        Copy a week schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_schedule_copy(management_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param str schedule_id: The ID of the schedule to copy from (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :param CopyWeekScheduleRequest body: body
        :return: AsyncWeekScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'schedule_id', 'force_async', 'force_download_service', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_schedule_copy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_schedule_copy`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_managementunit_week_schedule_copy`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `post_workforcemanagement_managementunit_week_schedule_copy`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncWeekScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_schedule_reschedule(self, management_unit_id, week_id, schedule_id, **kwargs):
        """
        Start a scheduling run to compute the reschedule. When the scheduling run finishes, a client can get the reschedule changes and then the client can apply them to the schedule, save the schedule, and mark the scheduling run as applied
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_schedule_reschedule(management_unit_id, week_id, schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param str schedule_id: The ID of the schedule to re-optimize (required)
        :param RescheduleRequest body: body
        :return: AsyncWeekScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'schedule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_schedule_reschedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_schedule_reschedule`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_managementunit_week_schedule_reschedule`")
        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `post_workforcemanagement_managementunit_week_schedule_reschedule`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/{scheduleId}/reschedule'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncWeekScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_schedules(self, management_unit_id, week_id, **kwargs):
        """
        Add a schedule for a week in management unit using imported data. Use partial uploads of user schedules if activity count in schedule is greater than 17500
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_schedules(management_unit_id, week_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :param bool force_download_service: Force the result of this operation to be sent via download service.  For testing/app development purposes
        :param ImportWeekScheduleRequest body: body
        :return: AsyncWeekScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'force_async', 'force_download_service', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_schedules`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_managementunit_week_schedules`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']
        if 'force_download_service' in params:
            query_params['forceDownloadService'] = params['force_download_service']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncWeekScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_schedules_generate(self, management_unit_id, week_id, **kwargs):
        """
        Generate a week schedule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_schedules_generate(management_unit_id, week_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param GenerateWeekScheduleRequest body: body
        :return: GenerateWeekScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_schedules_generate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_schedules_generate`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_managementunit_week_schedules_generate`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/generate'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GenerateWeekScheduleResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_schedules_partialupload(self, management_unit_id, week_id, **kwargs):
        """
        Partial upload of user schedules where activity count is greater than 17500
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_schedules_partialupload(management_unit_id, week_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str week_id: First day of schedule week in yyyy-MM-dd format. (required)
        :param UserSchedulesPartialUploadRequest body: body
        :return: PartialUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_schedules_partialupload" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_schedules_partialupload`")
        # verify the required parameter 'week_id' is set
        if ('week_id' not in params) or (params['week_id'] is None):
            raise ValueError("Missing the required parameter `week_id` when calling `post_workforcemanagement_managementunit_week_schedules_partialupload`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekId}/schedules/partialupload'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_id' in params:
            path_params['weekId'] = params['week_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PartialUploadResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_shorttermforecast_copy(self, management_unit_id, week_date_id, forecast_id, body, **kwargs):
        """
        Copy a short term forecast
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_shorttermforecast_copy(management_unit_id, week_date_id, forecast_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The management unit ID of the management unit to which the forecast belongs (required)
        :param str week_date_id: The week start date of the forecast in yyyy-MM-dd format (required)
        :param str forecast_id: The ID of the forecast to copy (required)
        :param CopyShortTermForecastRequest body: body (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :return: ShortTermForecastResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'forecast_id', 'body', 'force_async']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_shorttermforecast_copy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecast_copy`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecast_copy`")
        # verify the required parameter 'forecast_id' is set
        if ('forecast_id' not in params) or (params['forecast_id'] is None):
            raise ValueError("Missing the required parameter `forecast_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecast_copy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_managementunit_week_shorttermforecast_copy`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/{forecastId}/copy'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']
        if 'forecast_id' in params:
            path_params['forecastId'] = params['forecast_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShortTermForecastResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_shorttermforecasts(self, management_unit_id, week_date_id, body, **kwargs):
        """
        Import a short term forecast
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_shorttermforecasts(management_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The management unit ID of the management unit to which the forecast belongs (required)
        :param str week_date_id: The week start date of the forecast in yyyy-MM-dd format (required)
        :param ImportShortTermForecastRequest body: body (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :return: ShortTermForecastResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'body', 'force_async']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_shorttermforecasts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShortTermForecastResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_shorttermforecasts_generate(self, management_unit_id, week_date_id, body, **kwargs):
        """
        Generate a short term forecast
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_shorttermforecasts_generate(management_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The management unit ID of the management unit to which the forecast belongs (required)
        :param str week_date_id: The week start date of the forecast in yyyy-MM-dd format (required)
        :param GenerateShortTermForecastRequest body:  (required)
        :param bool force_async: Force the result of this operation to be sent asynchronously via notification.  For testing/app development purposes
        :return: GenerateShortTermForecastResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'body', 'force_async']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_shorttermforecasts_generate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts_generate`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts_generate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts_generate`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/generate'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}
        if 'force_async' in params:
            query_params['forceAsync'] = params['force_async']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GenerateShortTermForecastResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_week_shorttermforecasts_partialupload(self, management_unit_id, week_date_id, body, **kwargs):
        """
        Import a short term forecast
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_week_shorttermforecasts_partialupload(management_unit_id, week_date_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The management unit ID of the management unit to which the forecast belongs (required)
        :param str week_date_id: The week start date of the forecast in yyyy-MM-dd format (required)
        :param RouteGroupList body: body (required)
        :return: PartialUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'week_date_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_week_shorttermforecasts_partialupload" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts_partialupload`")
        # verify the required parameter 'week_date_id' is set
        if ('week_date_id' not in params) or (params['week_date_id'] is None):
            raise ValueError("Missing the required parameter `week_date_id` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts_partialupload`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workforcemanagement_managementunit_week_shorttermforecasts_partialupload`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/weeks/{weekDateId}/shorttermforecasts/partialupload'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'week_date_id' in params:
            path_params['weekDateId'] = params['week_date_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PartialUploadResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_workplan_copy(self, management_unit_id, work_plan_id, **kwargs):
        """
        Create a copy of work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_workplan_copy(management_unit_id, work_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param str work_plan_id: The ID of the work plan to create a copy (required)
        :param CopyWorkPlan body: body
        :return: WorkPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'work_plan_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_workplan_copy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_workplan_copy`")
        # verify the required parameter 'work_plan_id' is set
        if ('work_plan_id' not in params) or (params['work_plan_id'] is None):
            raise ValueError("Missing the required parameter `work_plan_id` when calling `post_workforcemanagement_managementunit_workplan_copy`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans/{workPlanId}/copy'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']
        if 'work_plan_id' in params:
            path_params['workPlanId'] = params['work_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunit_workplans(self, management_unit_id, **kwargs):
        """
        Create a new work plan
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunit_workplans(management_unit_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str management_unit_id: The ID of the management unit, or 'mine' for the management unit of the logged-in user. (required)
        :param CreateWorkPlan body: body
        :return: WorkPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['management_unit_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunit_workplans" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'management_unit_id' is set
        if ('management_unit_id' not in params) or (params['management_unit_id'] is None):
            raise ValueError("Missing the required parameter `management_unit_id` when calling `post_workforcemanagement_managementunit_workplans`")


        resource_path = '/api/v2/workforcemanagement/managementunits/{managementUnitId}/workplans'.replace('{format}', 'json')
        path_params = {}
        if 'management_unit_id' in params:
            path_params['managementUnitId'] = params['management_unit_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_managementunits(self, **kwargs):
        """
        Add a management unit
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_managementunits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateManagementUnitApiRequest body: body
        :return: ManagementUnit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_managementunits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/managementunits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ManagementUnit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_notifications_update(self, **kwargs):
        """
        Mark a list of notifications as read or unread
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_notifications_update(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UpdateNotificationsRequest body: body
        :return: UpdateNotificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_notifications_update" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/notifications/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UpdateNotificationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_schedules(self, **kwargs):
        """
        Get published schedule for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_schedules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CurrentUserScheduleRequestBody body: body
        :return: UserScheduleContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_schedules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/schedules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserScheduleContainer',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workforcemanagement_timeoffrequests(self, **kwargs):
        """
        Create a time off request for the current user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workforcemanagement_timeoffrequests(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateAgentTimeOffRequest body: body
        :return: TimeOffRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workforcemanagement_timeoffrequests" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/workforcemanagement/timeoffrequests'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeOffRequestResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
