# coding: utf-8

"""
TelephonyProvidersEdgeApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class TelephonyProvidersEdgeApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_telephony_providers_edge(self, edge_id, **kwargs):
        """
        Delete a edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edge(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edge" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `delete_telephony_providers_edge`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edge_logicalinterface(self, edge_id, interface_id, **kwargs):
        """
        Delete an edge logical interface
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edge_logicalinterface(edge_id, interface_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param str interface_id: Interface ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'interface_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edge_logicalinterface" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `delete_telephony_providers_edge_logicalinterface`")
        # verify the required parameter 'interface_id' is set
        if ('interface_id' not in params) or (params['interface_id'] is None):
            raise ValueError("Missing the required parameter `interface_id` when calling `delete_telephony_providers_edge_logicalinterface`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']
        if 'interface_id' in params:
            path_params['interfaceId'] = params['interface_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edge_softwareupdate(self, edge_id, **kwargs):
        """
        Cancels any in-progress update for this edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edge_softwareupdate(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edge_softwareupdate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `delete_telephony_providers_edge_softwareupdate`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/softwareupdate'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_certificateauthority(self, certificate_id, **kwargs):
        """
        Delete a certificate authority.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_certificateauthority(certificate_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str certificate_id: Certificate ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificate_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_certificateauthority" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'certificate_id' is set
        if ('certificate_id' not in params) or (params['certificate_id'] is None):
            raise ValueError("Missing the required parameter `certificate_id` when calling `delete_telephony_providers_edges_certificateauthority`")


        resource_path = '/api/v2/telephony/providers/edges/certificateauthorities/{certificateId}'.replace('{format}', 'json')
        path_params = {}
        if 'certificate_id' in params:
            path_params['certificateId'] = params['certificate_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_didpool(self, did_pool_id, **kwargs):
        """
        Delete a DID Pool by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_didpool(did_pool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str did_pool_id: DID pool ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['did_pool_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_didpool" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'did_pool_id' is set
        if ('did_pool_id' not in params) or (params['did_pool_id'] is None):
            raise ValueError("Missing the required parameter `did_pool_id` when calling `delete_telephony_providers_edges_didpool`")


        resource_path = '/api/v2/telephony/providers/edges/didpools/{didPoolId}'.replace('{format}', 'json')
        path_params = {}
        if 'did_pool_id' in params:
            path_params['didPoolId'] = params['did_pool_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_edgegroup(self, edge_group_id, **kwargs):
        """
        Delete an edge group.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_edgegroup(edge_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_group_id: Edge group ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_edgegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_group_id' is set
        if ('edge_group_id' not in params) or (params['edge_group_id'] is None):
            raise ValueError("Missing the required parameter `edge_group_id` when calling `delete_telephony_providers_edges_edgegroup`")


        resource_path = '/api/v2/telephony/providers/edges/edgegroups/{edgeGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_group_id' in params:
            path_params['edgeGroupId'] = params['edge_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_extensionpool(self, extension_pool_id, **kwargs):
        """
        Delete an extension pool by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_extensionpool(extension_pool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str extension_pool_id: Extension pool ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extension_pool_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_extensionpool" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'extension_pool_id' is set
        if ('extension_pool_id' not in params) or (params['extension_pool_id'] is None):
            raise ValueError("Missing the required parameter `extension_pool_id` when calling `delete_telephony_providers_edges_extensionpool`")


        resource_path = '/api/v2/telephony/providers/edges/extensionpools/{extensionPoolId}'.replace('{format}', 'json')
        path_params = {}
        if 'extension_pool_id' in params:
            path_params['extensionPoolId'] = params['extension_pool_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_outboundroute(self, outbound_route_id, **kwargs):
        """
        Delete Outbound Route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_outboundroute(outbound_route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outbound_route_id: Outbound route ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outbound_route_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_outboundroute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outbound_route_id' is set
        if ('outbound_route_id' not in params) or (params['outbound_route_id'] is None):
            raise ValueError("Missing the required parameter `outbound_route_id` when calling `delete_telephony_providers_edges_outboundroute`")


        resource_path = '/api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId}'.replace('{format}', 'json')
        path_params = {}
        if 'outbound_route_id' in params:
            path_params['outboundRouteId'] = params['outbound_route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_phone(self, phone_id, **kwargs):
        """
        Delete a Phone by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_phone(phone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_id: Phone ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_phone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_id' is set
        if ('phone_id' not in params) or (params['phone_id'] is None):
            raise ValueError("Missing the required parameter `phone_id` when calling `delete_telephony_providers_edges_phone`")


        resource_path = '/api/v2/telephony/providers/edges/phones/{phoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'phone_id' in params:
            path_params['phoneId'] = params['phone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_phonebasesetting(self, phone_base_id, **kwargs):
        """
        Delete a Phone Base Settings by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_phonebasesetting(phone_base_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_base_id: Phone base ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_base_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_phonebasesetting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_base_id' is set
        if ('phone_base_id' not in params) or (params['phone_base_id'] is None):
            raise ValueError("Missing the required parameter `phone_base_id` when calling `delete_telephony_providers_edges_phonebasesetting`")


        resource_path = '/api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'phone_base_id' in params:
            path_params['phoneBaseId'] = params['phone_base_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_site(self, site_id, **kwargs):
        """
        Delete a Site by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_site(site_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_site" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `delete_telephony_providers_edges_site`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_site_outboundroute(self, site_id, outbound_route_id, **kwargs):
        """
        Delete Outbound Route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_site_outboundroute(site_id, outbound_route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param str outbound_route_id: Outbound route ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'outbound_route_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_site_outboundroute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `delete_telephony_providers_edges_site_outboundroute`")
        # verify the required parameter 'outbound_route_id' is set
        if ('outbound_route_id' not in params) or (params['outbound_route_id'] is None):
            raise ValueError("Missing the required parameter `outbound_route_id` when calling `delete_telephony_providers_edges_site_outboundroute`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId}'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']
        if 'outbound_route_id' in params:
            path_params['outboundRouteId'] = params['outbound_route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_telephony_providers_edges_trunkbasesetting(self, trunk_base_settings_id, **kwargs):
        """
        Delete a Trunk Base Settings object by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_telephony_providers_edges_trunkbasesetting(trunk_base_settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trunk_base_settings_id: Trunk Base ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trunk_base_settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telephony_providers_edges_trunkbasesetting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trunk_base_settings_id' is set
        if ('trunk_base_settings_id' not in params) or (params['trunk_base_settings_id'] is None):
            raise ValueError("Missing the required parameter `trunk_base_settings_id` when calling `delete_telephony_providers_edges_trunkbasesetting`")


        resource_path = '/api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'trunk_base_settings_id' in params:
            path_params['trunkBaseSettingsId'] = params['trunk_base_settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_configuration_schemas_edges_vnext(self, **kwargs):
        """
        Lists available schema categories (Deprecated)
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_configuration_schemas_edges_vnext(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: SchemaCategoryEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_configuration_schemas_edges_vnext" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/configuration/schemas/edges/vnext'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchemaCategoryEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_configuration_schemas_edges_vnext_schema_category(self, schema_category, **kwargs):
        """
        List schemas of a specific category (Deprecated)
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_configuration_schemas_edges_vnext_schema_category(schema_category, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_category: Schema category (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: SchemaReferenceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_category', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_configuration_schemas_edges_vnext_schema_category" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_category' is set
        if ('schema_category' not in params) or (params['schema_category'] is None):
            raise ValueError("Missing the required parameter `schema_category` when calling `get_configuration_schemas_edges_vnext_schema_category`")


        resource_path = '/api/v2/configuration/schemas/edges/vnext/{schemaCategory}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_category' in params:
            path_params['schemaCategory'] = params['schema_category']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchemaReferenceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_configuration_schemas_edges_vnext_schema_category_schema_type(self, schema_category, schema_type, **kwargs):
        """
        List schemas of a specific category (Deprecated)
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_configuration_schemas_edges_vnext_schema_category_schema_type(schema_category, schema_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_category: Schema category (required)
        :param str schema_type: Schema type (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: SchemaReferenceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_category', 'schema_type', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_configuration_schemas_edges_vnext_schema_category_schema_type" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_category' is set
        if ('schema_category' not in params) or (params['schema_category'] is None):
            raise ValueError("Missing the required parameter `schema_category` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type`")
        # verify the required parameter 'schema_type' is set
        if ('schema_type' not in params) or (params['schema_type'] is None):
            raise ValueError("Missing the required parameter `schema_type` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type`")


        resource_path = '/api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_category' in params:
            path_params['schemaCategory'] = params['schema_category']
        if 'schema_type' in params:
            path_params['schemaType'] = params['schema_type']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchemaReferenceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id(self, schema_category, schema_type, schema_id, **kwargs):
        """
        Get a json schema (Deprecated)
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id(schema_category, schema_type, schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_category: Schema category (required)
        :param str schema_type: Schema type (required)
        :param str schema_id: Schema ID (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_category', 'schema_type', 'schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_category' is set
        if ('schema_category' not in params) or (params['schema_category'] is None):
            raise ValueError("Missing the required parameter `schema_category` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id`")
        # verify the required parameter 'schema_type' is set
        if ('schema_type' not in params) or (params['schema_type'] is None):
            raise ValueError("Missing the required parameter `schema_type` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id`")
        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id`")


        resource_path = '/api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_category' in params:
            path_params['schemaCategory'] = params['schema_category']
        if 'schema_type' in params:
            path_params['schemaType'] = params['schema_type']
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Organization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id_extension_type_metadata_id(self, schema_category, schema_type, schema_id, extension_type, metadata_id, **kwargs):
        """
        Get metadata for a schema (Deprecated)
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id_extension_type_metadata_id(schema_category, schema_type, schema_id, extension_type, metadata_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_category: Schema category (required)
        :param str schema_type: Schema type (required)
        :param str schema_id: Schema ID (required)
        :param str extension_type: extension (required)
        :param str metadata_id: Metadata ID (required)
        :param str type: Type
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_category', 'schema_type', 'schema_id', 'extension_type', 'metadata_id', 'type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id_extension_type_metadata_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_category' is set
        if ('schema_category' not in params) or (params['schema_category'] is None):
            raise ValueError("Missing the required parameter `schema_category` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id_extension_type_metadata_id`")
        # verify the required parameter 'schema_type' is set
        if ('schema_type' not in params) or (params['schema_type'] is None):
            raise ValueError("Missing the required parameter `schema_type` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id_extension_type_metadata_id`")
        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id_extension_type_metadata_id`")
        # verify the required parameter 'extension_type' is set
        if ('extension_type' not in params) or (params['extension_type'] is None):
            raise ValueError("Missing the required parameter `extension_type` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id_extension_type_metadata_id`")
        # verify the required parameter 'metadata_id' is set
        if ('metadata_id' not in params) or (params['metadata_id'] is None):
            raise ValueError("Missing the required parameter `metadata_id` when calling `get_configuration_schemas_edges_vnext_schema_category_schema_type_schema_id_extension_type_metadata_id`")


        resource_path = '/api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId}/{extensionType}/{metadataId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_category' in params:
            path_params['schemaCategory'] = params['schema_category']
        if 'schema_type' in params:
            path_params['schemaType'] = params['schema_type']
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']
        if 'extension_type' in params:
            path_params['extensionType'] = params['extension_type']
        if 'metadata_id' in params:
            path_params['metadataId'] = params['metadata_id']

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Organization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge(self, edge_id, **kwargs):
        """
        Get edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param list[str] expand: Fields to expand in the response, comma-separated
        :return: Edge
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Edge',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_line(self, edge_id, line_id, **kwargs):
        """
        Get line
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_line(edge_id, line_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param str line_id: Line ID (required)
        :return: EdgeLine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'line_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_line" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_line`")
        # verify the required parameter 'line_id' is set
        if ('line_id' not in params) or (params['line_id'] is None):
            raise ValueError("Missing the required parameter `line_id` when calling `get_telephony_providers_edge_line`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/lines/{lineId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']
        if 'line_id' in params:
            path_params['lineId'] = params['line_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeLine',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_lines(self, edge_id, **kwargs):
        """
        Get the list of lines.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_lines(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: EdgeLineEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_lines" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_lines`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/lines'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeLineEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_logicalinterface(self, edge_id, interface_id, **kwargs):
        """
        Get an edge logical interface
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_logicalinterface(edge_id, interface_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param str interface_id: Interface ID (required)
        :param list[str] expand: Field to expand in the response
        :return: DomainLogicalInterface
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'interface_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_logicalinterface" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_logicalinterface`")
        # verify the required parameter 'interface_id' is set
        if ('interface_id' not in params) or (params['interface_id'] is None):
            raise ValueError("Missing the required parameter `interface_id` when calling `get_telephony_providers_edge_logicalinterface`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']
        if 'interface_id' in params:
            path_params['interfaceId'] = params['interface_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainLogicalInterface',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_logicalinterfaces(self, edge_id, **kwargs):
        """
        Get edge logical interfaces.
        Retrieve a list of all configured logical interfaces from a specific edge.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_logicalinterfaces(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param list[str] expand: Field to expand in the response
        :return: LogicalInterfaceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_logicalinterfaces" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_logicalinterfaces`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LogicalInterfaceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_logs_job(self, edge_id, job_id, **kwargs):
        """
        Get an Edge logs job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_logs_job(edge_id, job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param str job_id: Job ID (required)
        :return: EdgeLogsJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_logs_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_logs_job`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_telephony_providers_edge_logs_job`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeLogsJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_metrics(self, edge_id, **kwargs):
        """
        Get the edge metrics.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_metrics(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge Id (required)
        :return: EdgeMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_metrics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_metrics`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/metrics'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeMetrics',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_physicalinterface(self, edge_id, interface_id, **kwargs):
        """
        Get edge physical interface.
        Retrieve a physical interface from a specific edge.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_physicalinterface(edge_id, interface_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param str interface_id: Interface ID (required)
        :return: DomainPhysicalInterface
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'interface_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_physicalinterface" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_physicalinterface`")
        # verify the required parameter 'interface_id' is set
        if ('interface_id' not in params) or (params['interface_id'] is None):
            raise ValueError("Missing the required parameter `interface_id` when calling `get_telephony_providers_edge_physicalinterface`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces/{interfaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']
        if 'interface_id' in params:
            path_params['interfaceId'] = params['interface_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainPhysicalInterface',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_physicalinterfaces(self, edge_id, **kwargs):
        """
        Retrieve a list of all configured physical interfaces from a specific edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_physicalinterfaces(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :return: PhysicalInterfaceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_physicalinterfaces" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_physicalinterfaces`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhysicalInterfaceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_setuppackage(self, edge_id, **kwargs):
        """
        Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_setuppackage(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :return: VmPairingInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_setuppackage" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_setuppackage`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/setuppackage'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='VmPairingInfo',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_softwareupdate(self, edge_id, **kwargs):
        """
        Gets software update status information about any edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_softwareupdate(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :return: DomainEdgeSoftwareUpdateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_softwareupdate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_softwareupdate`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/softwareupdate'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEdgeSoftwareUpdateDto',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_softwareversions(self, edge_id, **kwargs):
        """
        Gets all the available software versions for this edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_softwareversions(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :return: DomainEdgeSoftwareVersionDtoEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_softwareversions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_softwareversions`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/softwareversions'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEdgeSoftwareVersionDtoEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edge_trunks(self, edge_id, **kwargs):
        """
        Get the list of available trunks for the given Edge.
        Trunks are created by assigning trunk base settings to an Edge or Edge Group.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edge_trunks(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Value by which to sort
        :param str sort_order: Sort order
        :param str trunk_base_id: Filter by Trunk Base Ids
        :param str trunk_type: Filter by a Trunk type
        :return: TrunkEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'page_number', 'page_size', 'sort_by', 'sort_order', 'trunk_base_id', 'trunk_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edge_trunks" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_telephony_providers_edge_trunks`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/trunks'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'trunk_base_id' in params:
            query_params['trunkBase.id'] = params['trunk_base_id']
        if 'trunk_type' in params:
            query_params['trunkType'] = params['trunk_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges(self, **kwargs):
        """
        Get the list of edges.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :param str site_id: Filter by site.id
        :param str edge_group_id: Filter by edgeGroup.id
        :param str sort_by: Sort by
        :param bool managed: Filter by managed
        :return: EdgeEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'site_id', 'edge_group_id', 'sort_by', 'managed']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'site_id' in params:
            query_params['site.id'] = params['site_id']
        if 'edge_group_id' in params:
            query_params['edgeGroup.id'] = params['edge_group_id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'managed' in params:
            query_params['managed'] = params['managed']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_availablelanguages(self, **kwargs):
        """
        Get the list of available languages.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_availablelanguages(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: AvailableLanguageList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_availablelanguages" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/availablelanguages'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AvailableLanguageList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_certificateauthorities(self, **kwargs):
        """
        Get the list of certificate authorities.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_certificateauthorities(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: CertificateAuthorityEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_certificateauthorities" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/certificateauthorities'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CertificateAuthorityEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_certificateauthority(self, certificate_id, **kwargs):
        """
        Get a certificate authority.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_certificateauthority(certificate_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str certificate_id: Certificate ID (required)
        :return: DomainCertificateAuthority
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificate_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_certificateauthority" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'certificate_id' is set
        if ('certificate_id' not in params) or (params['certificate_id'] is None):
            raise ValueError("Missing the required parameter `certificate_id` when calling `get_telephony_providers_edges_certificateauthority`")


        resource_path = '/api/v2/telephony/providers/edges/certificateauthorities/{certificateId}'.replace('{format}', 'json')
        path_params = {}
        if 'certificate_id' in params:
            path_params['certificateId'] = params['certificate_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainCertificateAuthority',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_did(self, did_id, **kwargs):
        """
        Get a DID by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_did(did_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str did_id: DID ID (required)
        :return: DID
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['did_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_did" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'did_id' is set
        if ('did_id' not in params) or (params['did_id'] is None):
            raise ValueError("Missing the required parameter `did_id` when calling `get_telephony_providers_edges_did`")


        resource_path = '/api/v2/telephony/providers/edges/dids/{didId}'.replace('{format}', 'json')
        path_params = {}
        if 'did_id' in params:
            path_params['didId'] = params['did_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DID',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_didpool(self, did_pool_id, **kwargs):
        """
        Get a DID Pool by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_didpool(did_pool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str did_pool_id: DID pool ID (required)
        :return: DIDPool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['did_pool_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_didpool" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'did_pool_id' is set
        if ('did_pool_id' not in params) or (params['did_pool_id'] is None):
            raise ValueError("Missing the required parameter `did_pool_id` when calling `get_telephony_providers_edges_didpool`")


        resource_path = '/api/v2/telephony/providers/edges/didpools/{didPoolId}'.replace('{format}', 'json')
        path_params = {}
        if 'did_pool_id' in params:
            path_params['didPoolId'] = params['did_pool_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DIDPool',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_didpools(self, **kwargs):
        """
        Get a listing of DID Pools
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_didpools(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :return: DIDPoolEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_didpools" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/didpools'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DIDPoolEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_dids(self, **kwargs):
        """
        Get a listing of DIDs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_dids(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str phone_number: Filter by phoneNumber
        :param str owner_id: Filter by the owner of a phone number
        :param str did_pool_id: Filter by the DID Pool assignment
        :return: DIDEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order', 'phone_number', 'owner_id', 'did_pool_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_dids" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/dids'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'phone_number' in params:
            query_params['phoneNumber'] = params['phone_number']
        if 'owner_id' in params:
            query_params['owner.id'] = params['owner_id']
        if 'did_pool_id' in params:
            query_params['didPool.id'] = params['did_pool_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DIDEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_edgegroup(self, edge_group_id, **kwargs):
        """
        Get edge group.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_edgegroup(edge_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_group_id: Edge group ID (required)
        :param list[str] expand: Fields to expand in the response
        :return: EdgeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_group_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_edgegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_group_id' is set
        if ('edge_group_id' not in params) or (params['edge_group_id'] is None):
            raise ValueError("Missing the required parameter `edge_group_id` when calling `get_telephony_providers_edges_edgegroup`")


        resource_path = '/api/v2/telephony/providers/edges/edgegroups/{edgeGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_group_id' in params:
            path_params['edgeGroupId'] = params['edge_group_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_edgegroup_edgetrunkbase(self, edgegroup_id, edgetrunkbase_id, **kwargs):
        """
        Gets the edge trunk base associated with the edge group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_edgegroup_edgetrunkbase(edgegroup_id, edgetrunkbase_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edgegroup_id: Edge Group ID (required)
        :param str edgetrunkbase_id: Edge Trunk Base ID (required)
        :return: EdgeTrunkBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edgegroup_id', 'edgetrunkbase_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_edgegroup_edgetrunkbase" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edgegroup_id' is set
        if ('edgegroup_id' not in params) or (params['edgegroup_id'] is None):
            raise ValueError("Missing the required parameter `edgegroup_id` when calling `get_telephony_providers_edges_edgegroup_edgetrunkbase`")
        # verify the required parameter 'edgetrunkbase_id' is set
        if ('edgetrunkbase_id' not in params) or (params['edgetrunkbase_id'] is None):
            raise ValueError("Missing the required parameter `edgetrunkbase_id` when calling `get_telephony_providers_edges_edgegroup_edgetrunkbase`")


        resource_path = '/api/v2/telephony/providers/edges/edgegroups/{edgegroupId}/edgetrunkbases/{edgetrunkbaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'edgegroup_id' in params:
            path_params['edgegroupId'] = params['edgegroup_id']
        if 'edgetrunkbase_id' in params:
            path_params['edgetrunkbaseId'] = params['edgetrunkbase_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeTrunkBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_edgegroups(self, **kwargs):
        """
        Get the list of edge groups.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_edgegroups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :param str sort_by: Sort by
        :param bool managed: Filter by managed
        :return: EdgeGroupEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'sort_by', 'managed']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_edgegroups" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/edgegroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'managed' in params:
            query_params['managed'] = params['managed']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeGroupEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_edgeversionreport(self, **kwargs):
        """
        Get the edge version report.
        The report will not have consistent data about the edge version(s) until all edges have been reset.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_edgeversionreport(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EdgeVersionReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_edgeversionreport" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/edgeversionreport'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeVersionReport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_extension(self, extension_id, **kwargs):
        """
        Get an extension by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_extension(extension_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str extension_id: Extension ID (required)
        :return: Extension
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extension_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_extension" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'extension_id' is set
        if ('extension_id' not in params) or (params['extension_id'] is None):
            raise ValueError("Missing the required parameter `extension_id` when calling `get_telephony_providers_edges_extension`")


        resource_path = '/api/v2/telephony/providers/edges/extensions/{extensionId}'.replace('{format}', 'json')
        path_params = {}
        if 'extension_id' in params:
            path_params['extensionId'] = params['extension_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Extension',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_extensionpool(self, extension_pool_id, **kwargs):
        """
        Get an extension pool by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_extensionpool(extension_pool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str extension_pool_id: Extension pool ID (required)
        :return: ExtensionPool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extension_pool_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_extensionpool" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'extension_pool_id' is set
        if ('extension_pool_id' not in params) or (params['extension_pool_id'] is None):
            raise ValueError("Missing the required parameter `extension_pool_id` when calling `get_telephony_providers_edges_extensionpool`")


        resource_path = '/api/v2/telephony/providers/edges/extensionpools/{extensionPoolId}'.replace('{format}', 'json')
        path_params = {}
        if 'extension_pool_id' in params:
            path_params['extensionPoolId'] = params['extension_pool_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExtensionPool',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_extensionpools(self, **kwargs):
        """
        Get a listing of extension pools
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_extensionpools(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str number: Number
        :return: ExtensionPoolEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_extensionpools" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/extensionpools'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'number' in params:
            query_params['number'] = params['number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExtensionPoolEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_extensions(self, **kwargs):
        """
        Get a listing of extensions
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_extensions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str number: Filter by number
        :return: ExtensionEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order', 'number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_extensions" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/extensions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'number' in params:
            query_params['number'] = params['number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExtensionEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_line(self, line_id, **kwargs):
        """
        Get a Line by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_line(line_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str line_id: Line ID (required)
        :return: Line
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['line_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_line" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'line_id' is set
        if ('line_id' not in params) or (params['line_id'] is None):
            raise ValueError("Missing the required parameter `line_id` when calling `get_telephony_providers_edges_line`")


        resource_path = '/api/v2/telephony/providers/edges/lines/{lineId}'.replace('{format}', 'json')
        path_params = {}
        if 'line_id' in params:
            path_params['lineId'] = params['line_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Line',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_linebasesetting(self, line_base_id, **kwargs):
        """
        Get a line base settings object by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_linebasesetting(line_base_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str line_base_id: Line base ID (required)
        :return: LineBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['line_base_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_linebasesetting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'line_base_id' is set
        if ('line_base_id' not in params) or (params['line_base_id'] is None):
            raise ValueError("Missing the required parameter `line_base_id` when calling `get_telephony_providers_edges_linebasesetting`")


        resource_path = '/api/v2/telephony/providers/edges/linebasesettings/{lineBaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'line_base_id' in params:
            path_params['lineBaseId'] = params['line_base_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LineBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_linebasesettings(self, **kwargs):
        """
        Get a listing of line base settings objects
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_linebasesettings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Value by which to sort
        :param str sort_order: Sort order
        :return: LineBaseEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_linebasesettings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/linebasesettings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LineBaseEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_lines(self, **kwargs):
        """
        Get a list of Lines
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_lines(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :param str sort_by: Value by which to sort
        :param list[str] expand: Fields to expand in the response, comma-separated
        :return: LineEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'sort_by', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_lines" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/lines'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LineEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_lines_template(self, line_base_settings_id, **kwargs):
        """
        Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_lines_template(line_base_settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str line_base_settings_id: The id of a Line Base Settings object upon which to base this Line (required)
        :return: Line
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['line_base_settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_lines_template" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'line_base_settings_id' is set
        if ('line_base_settings_id' not in params) or (params['line_base_settings_id'] is None):
            raise ValueError("Missing the required parameter `line_base_settings_id` when calling `get_telephony_providers_edges_lines_template`")


        resource_path = '/api/v2/telephony/providers/edges/lines/template'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'line_base_settings_id' in params:
            query_params['lineBaseSettingsId'] = params['line_base_settings_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Line',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_logicalinterfaces(self, edge_ids, **kwargs):
        """
        Get edge logical interfaces.
        Retrieve the configured logical interfaces for a list edges. Only 100 edges can be requested at a time.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_logicalinterfaces(edge_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_ids: Comma separated list of Edge Id's (required)
        :param list[str] expand: Field to expand in the response
        :return: LogicalInterfaceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_ids', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_logicalinterfaces" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_ids' is set
        if ('edge_ids' not in params) or (params['edge_ids'] is None):
            raise ValueError("Missing the required parameter `edge_ids` when calling `get_telephony_providers_edges_logicalinterfaces`")


        resource_path = '/api/v2/telephony/providers/edges/logicalinterfaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'edge_ids' in params:
            query_params['edgeIds'] = params['edge_ids']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LogicalInterfaceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_metrics(self, edge_ids, **kwargs):
        """
        Get the metrics for a list of edges.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_metrics(edge_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_ids: Comma separated list of Edge Id's (required)
        :return: list[EdgeMetrics]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_metrics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_ids' is set
        if ('edge_ids' not in params) or (params['edge_ids'] is None):
            raise ValueError("Missing the required parameter `edge_ids` when calling `get_telephony_providers_edges_metrics`")


        resource_path = '/api/v2/telephony/providers/edges/metrics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'edge_ids' in params:
            query_params['edgeIds'] = params['edge_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[EdgeMetrics]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_outboundroute(self, outbound_route_id, **kwargs):
        """
        Get outbound route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_outboundroute(outbound_route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outbound_route_id: Outbound route ID (required)
        :return: OutboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outbound_route_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_outboundroute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outbound_route_id' is set
        if ('outbound_route_id' not in params) or (params['outbound_route_id'] is None):
            raise ValueError("Missing the required parameter `outbound_route_id` when calling `get_telephony_providers_edges_outboundroute`")


        resource_path = '/api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId}'.replace('{format}', 'json')
        path_params = {}
        if 'outbound_route_id' in params:
            path_params['outboundRouteId'] = params['outbound_route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_outboundroutes(self, **kwargs):
        """
        Get outbound routes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_outboundroutes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :param str site_id: Filter by site.id
        :param str external_trunk_bases_ids: Filter by externalTrunkBases.ids
        :param str sort_by: Sort by
        :return: OutboundRouteEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'site_id', 'external_trunk_bases_ids', 'sort_by']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_outboundroutes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/outboundroutes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'site_id' in params:
            query_params['site.id'] = params['site_id']
        if 'external_trunk_bases_ids' in params:
            query_params['externalTrunkBases.ids'] = params['external_trunk_bases_ids']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundRouteEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_phone(self, phone_id, **kwargs):
        """
        Get a Phone by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_phone(phone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_id: Phone ID (required)
        :return: Phone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_phone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_id' is set
        if ('phone_id' not in params) or (params['phone_id'] is None):
            raise ValueError("Missing the required parameter `phone_id` when calling `get_telephony_providers_edges_phone`")


        resource_path = '/api/v2/telephony/providers/edges/phones/{phoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'phone_id' in params:
            path_params['phoneId'] = params['phone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Phone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_phonebasesetting(self, phone_base_id, **kwargs):
        """
        Get a Phone Base Settings object by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_phonebasesetting(phone_base_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_base_id: Phone base ID (required)
        :return: PhoneBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_base_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_phonebasesetting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_base_id' is set
        if ('phone_base_id' not in params) or (params['phone_base_id'] is None):
            raise ValueError("Missing the required parameter `phone_base_id` when calling `get_telephony_providers_edges_phonebasesetting`")


        resource_path = '/api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'phone_base_id' in params:
            path_params['phoneBaseId'] = params['phone_base_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhoneBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_phonebasesettings(self, **kwargs):
        """
        Get a list of Phone Base Settings objects
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_phonebasesettings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Value by which to sort
        :param str sort_order: Sort order
        :param list[str] expand: Fields to expand in the response, comma-separated
        :param str name: Name
        :return: PhoneBaseEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order', 'expand', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_phonebasesettings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/phonebasesettings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhoneBaseEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_phonebasesettings_availablemetabases(self, **kwargs):
        """
        Get a list of available makes and models to create a new Phone Base Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_phonebasesettings_availablemetabases(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: PhoneMetaBaseEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_phonebasesettings_availablemetabases" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/phonebasesettings/availablemetabases'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhoneMetaBaseEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_phonebasesettings_template(self, phone_metabase_id, **kwargs):
        """
        Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_phonebasesettings_template(phone_metabase_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_metabase_id: The id of a metabase object upon which to base this Phone Base Settings (required)
        :return: PhoneBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_metabase_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_phonebasesettings_template" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_metabase_id' is set
        if ('phone_metabase_id' not in params) or (params['phone_metabase_id'] is None):
            raise ValueError("Missing the required parameter `phone_metabase_id` when calling `get_telephony_providers_edges_phonebasesettings_template`")


        resource_path = '/api/v2/telephony/providers/edges/phonebasesettings/template'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'phone_metabase_id' in params:
            query_params['phoneMetabaseId'] = params['phone_metabase_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhoneBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_phones(self, **kwargs):
        """
        Get a list of Phone Instances
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_phones(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Value by which to sort
        :param str sort_order: Sort order
        :param str site_id: Filter by site.id
        :param str web_rtc_user_id: Filter by webRtcUser.id
        :param str phone_base_settings_id: Filter by phoneBaseSettings.id
        :param str lines_logged_in_user_id: Filter by lines.loggedInUser.id
        :param str lines_default_for_user_id: Filter by lines.defaultForUser.id
        :param str phone_hardware_id: Filter by phone_hardwareId
        :param str lines_id: Filter by lines.id
        :param str lines_name: Filter by lines.name
        :param str name: Name of the Phone to filter by
        :param list[str] expand: Fields to expand in the response, comma-separated
        :param list[str] fields: Fields and properties to get, comma-separated
        :return: PhoneEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'site_id', 'web_rtc_user_id', 'phone_base_settings_id', 'lines_logged_in_user_id', 'lines_default_for_user_id', 'phone_hardware_id', 'lines_id', 'lines_name', 'name', 'expand', 'fields']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_phones" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/phones'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'site_id' in params:
            query_params['site.id'] = params['site_id']
        if 'web_rtc_user_id' in params:
            query_params['webRtcUser.id'] = params['web_rtc_user_id']
        if 'phone_base_settings_id' in params:
            query_params['phoneBaseSettings.id'] = params['phone_base_settings_id']
        if 'lines_logged_in_user_id' in params:
            query_params['lines.loggedInUser.id'] = params['lines_logged_in_user_id']
        if 'lines_default_for_user_id' in params:
            query_params['lines.defaultForUser.id'] = params['lines_default_for_user_id']
        if 'phone_hardware_id' in params:
            query_params['phone_hardwareId'] = params['phone_hardware_id']
        if 'lines_id' in params:
            query_params['lines.id'] = params['lines_id']
        if 'lines_name' in params:
            query_params['lines.name'] = params['lines_name']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhoneEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_phones_template(self, phone_base_settings_id, **kwargs):
        """
        Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_phones_template(phone_base_settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_base_settings_id: The id of a Phone Base Settings object upon which to base this Phone (required)
        :return: Phone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_base_settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_phones_template" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_base_settings_id' is set
        if ('phone_base_settings_id' not in params) or (params['phone_base_settings_id'] is None):
            raise ValueError("Missing the required parameter `phone_base_settings_id` when calling `get_telephony_providers_edges_phones_template`")


        resource_path = '/api/v2/telephony/providers/edges/phones/template'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'phone_base_settings_id' in params:
            query_params['phoneBaseSettingsId'] = params['phone_base_settings_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Phone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_physicalinterfaces(self, edge_ids, **kwargs):
        """
        Get physical interfaces for edges.
        Retrieves a list of all configured physical interfaces for a list of edges. Only 100 edges can be requested at a time.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_physicalinterfaces(edge_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_ids: Comma separated list of Edge Id's (required)
        :return: PhysicalInterfaceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_physicalinterfaces" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_ids' is set
        if ('edge_ids' not in params) or (params['edge_ids'] is None):
            raise ValueError("Missing the required parameter `edge_ids` when calling `get_telephony_providers_edges_physicalinterfaces`")


        resource_path = '/api/v2/telephony/providers/edges/physicalinterfaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'edge_ids' in params:
            query_params['edgeIds'] = params['edge_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhysicalInterfaceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_site(self, site_id, **kwargs):
        """
        Get a Site by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_site(site_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :return: Site
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_site" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `get_telephony_providers_edges_site`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Site',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_site_numberplan(self, site_id, number_plan_id, **kwargs):
        """
        Get a Number Plan by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_site_numberplan(site_id, number_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param str number_plan_id: Number Plan ID (required)
        :return: NumberPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'number_plan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_site_numberplan" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `get_telephony_providers_edges_site_numberplan`")
        # verify the required parameter 'number_plan_id' is set
        if ('number_plan_id' not in params) or (params['number_plan_id'] is None):
            raise ValueError("Missing the required parameter `number_plan_id` when calling `get_telephony_providers_edges_site_numberplan`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/numberplans/{numberPlanId}'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']
        if 'number_plan_id' in params:
            path_params['numberPlanId'] = params['number_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NumberPlan',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_site_numberplans(self, site_id, **kwargs):
        """
        Get the list of Number Plans for this Site. Only fetches the first 200 records.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_site_numberplans(site_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :return: list[NumberPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_site_numberplans" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `get_telephony_providers_edges_site_numberplans`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/numberplans'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[NumberPlan]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_site_numberplans_classifications(self, site_id, **kwargs):
        """
        Get a list of Classifications for this Site
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_site_numberplans_classifications(site_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param str classification: Classification
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'classification']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_site_numberplans_classifications" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `get_telephony_providers_edges_site_numberplans_classifications`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/numberplans/classifications'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}
        if 'classification' in params:
            query_params['classification'] = params['classification']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[str]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_site_outboundroute(self, site_id, outbound_route_id, **kwargs):
        """
        Get an outbound route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_site_outboundroute(site_id, outbound_route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param str outbound_route_id: Outbound route ID (required)
        :return: OutboundRouteBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'outbound_route_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_site_outboundroute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `get_telephony_providers_edges_site_outboundroute`")
        # verify the required parameter 'outbound_route_id' is set
        if ('outbound_route_id' not in params) or (params['outbound_route_id'] is None):
            raise ValueError("Missing the required parameter `outbound_route_id` when calling `get_telephony_providers_edges_site_outboundroute`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId}'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']
        if 'outbound_route_id' in params:
            path_params['outboundRouteId'] = params['outbound_route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundRouteBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_site_outboundroutes(self, site_id, **kwargs):
        """
        Get outbound routes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_site_outboundroutes(site_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :param str external_trunk_bases_ids: externalTrunkBases.ids
        :param str sort_by: Sort by
        :return: OutboundRouteBaseEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'page_size', 'page_number', 'name', 'external_trunk_bases_ids', 'sort_by']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_site_outboundroutes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `get_telephony_providers_edges_site_outboundroutes`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'external_trunk_bases_ids' in params:
            query_params['externalTrunkBases.ids'] = params['external_trunk_bases_ids']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundRouteBaseEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_sites(self, **kwargs):
        """
        Get the list of Sites.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_sites(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name
        :param str location_id: Location Id
        :param bool managed: Filter by managed
        :return: SiteEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order', 'name', 'location_id', 'managed']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_sites" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/sites'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'location_id' in params:
            query_params['location.id'] = params['location_id']
        if 'managed' in params:
            query_params['managed'] = params['managed']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SiteEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_timezones(self, **kwargs):
        """
        Get a list of Edge-compatible time zones
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_timezones(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: TimeZoneEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_timezones" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/timezones'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeZoneEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunk(self, trunk_id, **kwargs):
        """
        Get a Trunk by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunk(trunk_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trunk_id: Trunk ID (required)
        :return: Trunk
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trunk_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trunk_id' is set
        if ('trunk_id' not in params) or (params['trunk_id'] is None):
            raise ValueError("Missing the required parameter `trunk_id` when calling `get_telephony_providers_edges_trunk`")


        resource_path = '/api/v2/telephony/providers/edges/trunks/{trunkId}'.replace('{format}', 'json')
        path_params = {}
        if 'trunk_id' in params:
            path_params['trunkId'] = params['trunk_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trunk',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunk_metrics(self, trunk_id, **kwargs):
        """
        Get the trunk metrics.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunk_metrics(trunk_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trunk_id: Trunk Id (required)
        :return: TrunkMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trunk_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunk_metrics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trunk_id' is set
        if ('trunk_id' not in params) or (params['trunk_id'] is None):
            raise ValueError("Missing the required parameter `trunk_id` when calling `get_telephony_providers_edges_trunk_metrics`")


        resource_path = '/api/v2/telephony/providers/edges/trunks/{trunkId}/metrics'.replace('{format}', 'json')
        path_params = {}
        if 'trunk_id' in params:
            path_params['trunkId'] = params['trunk_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkMetrics',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunkbasesetting(self, trunk_base_settings_id, **kwargs):
        """
        Get a Trunk Base Settings object by ID
        Managed properties will not be returned unless the user is assigned the internal:trunk:edit permission.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunkbasesetting(trunk_base_settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trunk_base_settings_id: Trunk Base ID (required)
        :param bool ignore_hidden: Set this to true to not receive trunk properties that are meant to be hidden or for internal system usage only.
        :return: TrunkBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trunk_base_settings_id', 'ignore_hidden']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunkbasesetting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trunk_base_settings_id' is set
        if ('trunk_base_settings_id' not in params) or (params['trunk_base_settings_id'] is None):
            raise ValueError("Missing the required parameter `trunk_base_settings_id` when calling `get_telephony_providers_edges_trunkbasesetting`")


        resource_path = '/api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'trunk_base_settings_id' in params:
            path_params['trunkBaseSettingsId'] = params['trunk_base_settings_id']

        query_params = {}
        if 'ignore_hidden' in params:
            query_params['ignoreHidden'] = params['ignore_hidden']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunkbasesettings(self, **kwargs):
        """
        Get Trunk Base Settings listing
        Managed properties will not be returned unless the user is assigned the internal:trunk:edit permission.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunkbasesettings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Value by which to sort
        :param str sort_order: Sort order
        :param bool recording_enabled: Filter trunks by recording enabled
        :param bool ignore_hidden: Set this to true to not receive trunk properties that are meant to be hidden or for internal system usage only.
        :param bool managed: Filter by managed
        :param list[str] expand: Fields to expand in the response, comma-separated
        :param str name: Name of the TrunkBase to filter by
        :return: TrunkBaseEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'recording_enabled', 'ignore_hidden', 'managed', 'expand', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunkbasesettings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/trunkbasesettings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'recording_enabled' in params:
            query_params['recordingEnabled'] = params['recording_enabled']
        if 'ignore_hidden' in params:
            query_params['ignoreHidden'] = params['ignore_hidden']
        if 'managed' in params:
            query_params['managed'] = params['managed']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkBaseEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunkbasesettings_availablemetabases(self, **kwargs):
        """
        Get a list of available makes and models to create a new Trunk Base Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunkbasesettings_availablemetabases(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type: 
        :param int page_size: 
        :param int page_number: 
        :return: TrunkMetabaseEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunkbasesettings_availablemetabases" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/trunkbasesettings/availablemetabases'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkMetabaseEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunkbasesettings_template(self, trunk_metabase_id, **kwargs):
        """
        Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunkbasesettings_template(trunk_metabase_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trunk_metabase_id: The id of a metabase object upon which to base this Trunk Base Settings (required)
        :return: TrunkBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trunk_metabase_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunkbasesettings_template" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trunk_metabase_id' is set
        if ('trunk_metabase_id' not in params) or (params['trunk_metabase_id'] is None):
            raise ValueError("Missing the required parameter `trunk_metabase_id` when calling `get_telephony_providers_edges_trunkbasesettings_template`")


        resource_path = '/api/v2/telephony/providers/edges/trunkbasesettings/template'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'trunk_metabase_id' in params:
            query_params['trunkMetabaseId'] = params['trunk_metabase_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunks(self, **kwargs):
        """
        Get the list of available trunks.
        Trunks are created by assigning trunk base settings to an Edge or Edge Group.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunks(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Value by which to sort
        :param str sort_order: Sort order
        :param str edge_id: Filter by Edge Ids
        :param str trunk_base_id: Filter by Trunk Base Ids
        :param str trunk_type: Filter by a Trunk type
        :return: TrunkEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'edge_id', 'trunk_base_id', 'trunk_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunks" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/trunks'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'edge_id' in params:
            query_params['edge.id'] = params['edge_id']
        if 'trunk_base_id' in params:
            query_params['trunkBase.id'] = params['trunk_base_id']
        if 'trunk_type' in params:
            query_params['trunkType'] = params['trunk_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunks_metrics(self, trunk_ids, **kwargs):
        """
        Get the metrics for a list of trunks.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunks_metrics(trunk_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trunk_ids: Comma separated list of Trunk Id's (required)
        :return: list[TrunkMetrics]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trunk_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunks_metrics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trunk_ids' is set
        if ('trunk_ids' not in params) or (params['trunk_ids'] is None):
            raise ValueError("Missing the required parameter `trunk_ids` when calling `get_telephony_providers_edges_trunks_metrics`")


        resource_path = '/api/v2/telephony/providers/edges/trunks/metrics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'trunk_ids' in params:
            query_params['trunkIds'] = params['trunk_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[TrunkMetrics]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_telephony_providers_edges_trunkswithrecording(self, **kwargs):
        """
        Get Counts of trunks that have recording disabled or enabled
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_telephony_providers_edges_trunkswithrecording(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trunk_type: The type of this trunk base.
        :return: TrunkRecordingEnabledCount
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trunk_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telephony_providers_edges_trunkswithrecording" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/telephony/providers/edges/trunkswithrecording'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'trunk_type' in params:
            query_params['trunkType'] = params['trunk_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkRecordingEnabledCount',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edge_logicalinterfaces(self, edge_id, body, **kwargs):
        """
        Create an edge logical interface.
        Create

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edge_logicalinterfaces(edge_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param DomainLogicalInterface body: Logical interface (required)
        :return: DomainLogicalInterface
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edge_logicalinterfaces" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `post_telephony_providers_edge_logicalinterfaces`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edge_logicalinterfaces`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainLogicalInterface',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edge_logs_job_upload(self, edge_id, job_id, body, **kwargs):
        """
        Request that the specified fileIds be uploaded from the Edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edge_logs_job_upload(edge_id, job_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param str job_id: Job ID (required)
        :param EdgeLogsJobUploadRequest body: Log upload request (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'job_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edge_logs_job_upload" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `post_telephony_providers_edge_logs_job_upload`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `post_telephony_providers_edge_logs_job_upload`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edge_logs_job_upload`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId}/upload'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edge_logs_jobs(self, edge_id, body, **kwargs):
        """
        Create a job to upload a list of Edge logs.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edge_logs_jobs(edge_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param EdgeLogsJobRequest body: EdgeLogsJobRequest (required)
        :return: EdgeLogsJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edge_logs_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `post_telephony_providers_edge_logs_jobs`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edge_logs_jobs`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/logs/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeLogsJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edge_reboot(self, edge_id, **kwargs):
        """
        Reboot an Edge
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edge_reboot(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param EdgeRebootParameters body: Parameters for the edge reboot
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edge_reboot" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `post_telephony_providers_edge_reboot`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/reboot'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edge_softwareupdate(self, edge_id, body, **kwargs):
        """
        Starts a software update for this edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edge_softwareupdate(edge_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param DomainEdgeSoftwareUpdateDto body: Software update request (required)
        :return: DomainEdgeSoftwareUpdateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edge_softwareupdate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `post_telephony_providers_edge_softwareupdate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edge_softwareupdate`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/softwareupdate'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEdgeSoftwareUpdateDto',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edge_statuscode(self, edge_id, **kwargs):
        """
        Take an Edge in or out of service
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edge_statuscode(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param EdgeServiceStateRequest body: Edge Service State
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edge_statuscode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `post_telephony_providers_edge_statuscode`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/statuscode'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edge_unpair(self, edge_id, **kwargs):
        """
        Unpair an Edge
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edge_unpair(edge_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge Id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edge_unpair" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `post_telephony_providers_edge_unpair`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/unpair'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges(self, body, **kwargs):
        """
        Create an edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Edge body: Edge (required)
        :return: Edge
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges`")


        resource_path = '/api/v2/telephony/providers/edges'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Edge',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_addressvalidation(self, body, **kwargs):
        """
        Validates a street address
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_addressvalidation(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ValidateAddressRequest body: Address (required)
        :return: ValidateAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_addressvalidation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_addressvalidation`")


        resource_path = '/api/v2/telephony/providers/edges/addressvalidation'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ValidateAddressResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_certificateauthorities(self, body, **kwargs):
        """
        Create a certificate authority.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_certificateauthorities(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DomainCertificateAuthority body: CertificateAuthority (required)
        :return: DomainCertificateAuthority
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_certificateauthorities" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_certificateauthorities`")


        resource_path = '/api/v2/telephony/providers/edges/certificateauthorities'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainCertificateAuthority',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_didpools(self, body, **kwargs):
        """
        Create a new DID pool
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_didpools(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DIDPool body: DID pool (required)
        :return: DIDPool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_didpools" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_didpools`")


        resource_path = '/api/v2/telephony/providers/edges/didpools'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DIDPool',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_edgegroups(self, body, **kwargs):
        """
        Create an edge group.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_edgegroups(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EdgeGroup body: EdgeGroup (required)
        :return: EdgeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_edgegroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_edgegroups`")


        resource_path = '/api/v2/telephony/providers/edges/edgegroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_extensionpools(self, body, **kwargs):
        """
        Create a new extension pool
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_extensionpools(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExtensionPool body: ExtensionPool (required)
        :return: ExtensionPool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_extensionpools" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_extensionpools`")


        resource_path = '/api/v2/telephony/providers/edges/extensionpools'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExtensionPool',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_outboundroutes(self, body, **kwargs):
        """
        Create outbound rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_outboundroutes(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OutboundRoute body: OutboundRoute (required)
        :return: OutboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_outboundroutes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_outboundroutes`")


        resource_path = '/api/v2/telephony/providers/edges/outboundroutes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_phone_reboot(self, phone_id, **kwargs):
        """
        Reboot a Phone
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_phone_reboot(phone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_id: Phone Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_phone_reboot" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_id' is set
        if ('phone_id' not in params) or (params['phone_id'] is None):
            raise ValueError("Missing the required parameter `phone_id` when calling `post_telephony_providers_edges_phone_reboot`")


        resource_path = '/api/v2/telephony/providers/edges/phones/{phoneId}/reboot'.replace('{format}', 'json')
        path_params = {}
        if 'phone_id' in params:
            path_params['phoneId'] = params['phone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_phonebasesettings(self, body, **kwargs):
        """
        Create a new Phone Base Settings object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_phonebasesettings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PhoneBase body: Phone base settings (required)
        :return: PhoneBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_phonebasesettings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_phonebasesettings`")


        resource_path = '/api/v2/telephony/providers/edges/phonebasesettings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhoneBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_phones(self, body, **kwargs):
        """
        Create a new Phone
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_phones(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Phone body: Phone (required)
        :return: Phone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_phones" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_phones`")


        resource_path = '/api/v2/telephony/providers/edges/phones'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Phone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_phones_reboot(self, body, **kwargs):
        """
        Reboot Multiple Phones
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_phones_reboot(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PhonesReboot body: Phones (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_phones_reboot" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_phones_reboot`")


        resource_path = '/api/v2/telephony/providers/edges/phones/reboot'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_site_outboundroutes(self, site_id, body, **kwargs):
        """
        Create outbound route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_site_outboundroutes(site_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param OutboundRouteBase body: OutboundRoute (required)
        :return: OutboundRouteBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_site_outboundroutes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `post_telephony_providers_edges_site_outboundroutes`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_site_outboundroutes`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundRouteBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_site_rebalance(self, site_id, **kwargs):
        """
        Triggers the rebalance operation.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_site_rebalance(site_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_site_rebalance" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `post_telephony_providers_edges_site_rebalance`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/rebalance'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_sites(self, body, **kwargs):
        """
        Create a Site.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_sites(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Site body: Site (required)
        :return: Site
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_sites" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_sites`")


        resource_path = '/api/v2/telephony/providers/edges/sites'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Site',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_telephony_providers_edges_trunkbasesettings(self, body, **kwargs):
        """
        Create a Trunk Base Settings object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_telephony_providers_edges_trunkbasesettings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TrunkBase body: Trunk base settings (required)
        :return: TrunkBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telephony_providers_edges_trunkbasesettings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_telephony_providers_edges_trunkbasesettings`")


        resource_path = '/api/v2/telephony/providers/edges/trunkbasesettings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edge(self, edge_id, body, **kwargs):
        """
        Update a edge.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edge(edge_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param Edge body: Edge (required)
        :return: Edge
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edge" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `put_telephony_providers_edge`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edge`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Edge',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edge_line(self, edge_id, line_id, body, **kwargs):
        """
        Update a line.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edge_line(edge_id, line_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param str line_id: Line ID (required)
        :param EdgeLine body: Line (required)
        :return: EdgeLine
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'line_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edge_line" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `put_telephony_providers_edge_line`")
        # verify the required parameter 'line_id' is set
        if ('line_id' not in params) or (params['line_id'] is None):
            raise ValueError("Missing the required parameter `line_id` when calling `put_telephony_providers_edge_line`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edge_line`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/lines/{lineId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']
        if 'line_id' in params:
            path_params['lineId'] = params['line_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeLine',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edge_logicalinterface(self, edge_id, interface_id, body, **kwargs):
        """
        Update an edge logical interface.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edge_logicalinterface(edge_id, interface_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_id: Edge ID (required)
        :param str interface_id: Interface ID (required)
        :param DomainLogicalInterface body: Logical interface (required)
        :return: DomainLogicalInterface
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'interface_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edge_logicalinterface" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params) or (params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `put_telephony_providers_edge_logicalinterface`")
        # verify the required parameter 'interface_id' is set
        if ('interface_id' not in params) or (params['interface_id'] is None):
            raise ValueError("Missing the required parameter `interface_id` when calling `put_telephony_providers_edge_logicalinterface`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edge_logicalinterface`")


        resource_path = '/api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']
        if 'interface_id' in params:
            path_params['interfaceId'] = params['interface_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainLogicalInterface',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_certificateauthority(self, certificate_id, body, **kwargs):
        """
        Update a certificate authority.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_certificateauthority(certificate_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str certificate_id: Certificate ID (required)
        :param DomainCertificateAuthority body: Certificate authority (required)
        :return: DomainCertificateAuthority
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificate_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_certificateauthority" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'certificate_id' is set
        if ('certificate_id' not in params) or (params['certificate_id'] is None):
            raise ValueError("Missing the required parameter `certificate_id` when calling `put_telephony_providers_edges_certificateauthority`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_certificateauthority`")


        resource_path = '/api/v2/telephony/providers/edges/certificateauthorities/{certificateId}'.replace('{format}', 'json')
        path_params = {}
        if 'certificate_id' in params:
            path_params['certificateId'] = params['certificate_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainCertificateAuthority',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_did(self, did_id, body, **kwargs):
        """
        Update a DID by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_did(did_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str did_id: DID ID (required)
        :param DID body: DID (required)
        :return: DID
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['did_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_did" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'did_id' is set
        if ('did_id' not in params) or (params['did_id'] is None):
            raise ValueError("Missing the required parameter `did_id` when calling `put_telephony_providers_edges_did`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_did`")


        resource_path = '/api/v2/telephony/providers/edges/dids/{didId}'.replace('{format}', 'json')
        path_params = {}
        if 'did_id' in params:
            path_params['didId'] = params['did_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DID',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_didpool(self, did_pool_id, body, **kwargs):
        """
        Update a DID Pool by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_didpool(did_pool_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str did_pool_id: DID pool ID (required)
        :param DIDPool body: DID pool (required)
        :return: DIDPool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['did_pool_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_didpool" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'did_pool_id' is set
        if ('did_pool_id' not in params) or (params['did_pool_id'] is None):
            raise ValueError("Missing the required parameter `did_pool_id` when calling `put_telephony_providers_edges_didpool`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_didpool`")


        resource_path = '/api/v2/telephony/providers/edges/didpools/{didPoolId}'.replace('{format}', 'json')
        path_params = {}
        if 'did_pool_id' in params:
            path_params['didPoolId'] = params['did_pool_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DIDPool',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_edgegroup(self, edge_group_id, body, **kwargs):
        """
        Update an edge group.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_edgegroup(edge_group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edge_group_id: Edge group ID (required)
        :param EdgeGroup body: EdgeGroup (required)
        :return: EdgeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_edgegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edge_group_id' is set
        if ('edge_group_id' not in params) or (params['edge_group_id'] is None):
            raise ValueError("Missing the required parameter `edge_group_id` when calling `put_telephony_providers_edges_edgegroup`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_edgegroup`")


        resource_path = '/api/v2/telephony/providers/edges/edgegroups/{edgeGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'edge_group_id' in params:
            path_params['edgeGroupId'] = params['edge_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_edgegroup_edgetrunkbase(self, edgegroup_id, edgetrunkbase_id, body, **kwargs):
        """
        Update the edge trunk base associated with the edge group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_edgegroup_edgetrunkbase(edgegroup_id, edgetrunkbase_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str edgegroup_id: Edge Group ID (required)
        :param str edgetrunkbase_id: Edge Trunk Base ID (required)
        :param EdgeTrunkBase body: EdgeTrunkBase (required)
        :return: EdgeTrunkBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edgegroup_id', 'edgetrunkbase_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_edgegroup_edgetrunkbase" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'edgegroup_id' is set
        if ('edgegroup_id' not in params) or (params['edgegroup_id'] is None):
            raise ValueError("Missing the required parameter `edgegroup_id` when calling `put_telephony_providers_edges_edgegroup_edgetrunkbase`")
        # verify the required parameter 'edgetrunkbase_id' is set
        if ('edgetrunkbase_id' not in params) or (params['edgetrunkbase_id'] is None):
            raise ValueError("Missing the required parameter `edgetrunkbase_id` when calling `put_telephony_providers_edges_edgegroup_edgetrunkbase`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_edgegroup_edgetrunkbase`")


        resource_path = '/api/v2/telephony/providers/edges/edgegroups/{edgegroupId}/edgetrunkbases/{edgetrunkbaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'edgegroup_id' in params:
            path_params['edgegroupId'] = params['edgegroup_id']
        if 'edgetrunkbase_id' in params:
            path_params['edgetrunkbaseId'] = params['edgetrunkbase_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EdgeTrunkBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_extension(self, extension_id, body, **kwargs):
        """
        Update an extension by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_extension(extension_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str extension_id: Extension ID (required)
        :param Extension body: Extension (required)
        :return: Extension
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extension_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_extension" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'extension_id' is set
        if ('extension_id' not in params) or (params['extension_id'] is None):
            raise ValueError("Missing the required parameter `extension_id` when calling `put_telephony_providers_edges_extension`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_extension`")


        resource_path = '/api/v2/telephony/providers/edges/extensions/{extensionId}'.replace('{format}', 'json')
        path_params = {}
        if 'extension_id' in params:
            path_params['extensionId'] = params['extension_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Extension',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_extensionpool(self, extension_pool_id, body, **kwargs):
        """
        Update an extension pool by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_extensionpool(extension_pool_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str extension_pool_id: Extension pool ID (required)
        :param ExtensionPool body: ExtensionPool (required)
        :return: ExtensionPool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extension_pool_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_extensionpool" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'extension_pool_id' is set
        if ('extension_pool_id' not in params) or (params['extension_pool_id'] is None):
            raise ValueError("Missing the required parameter `extension_pool_id` when calling `put_telephony_providers_edges_extensionpool`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_extensionpool`")


        resource_path = '/api/v2/telephony/providers/edges/extensionpools/{extensionPoolId}'.replace('{format}', 'json')
        path_params = {}
        if 'extension_pool_id' in params:
            path_params['extensionPoolId'] = params['extension_pool_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExtensionPool',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_outboundroute(self, outbound_route_id, body, **kwargs):
        """
        Update outbound route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_outboundroute(outbound_route_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outbound_route_id: Outbound route ID (required)
        :param OutboundRoute body: OutboundRoute (required)
        :return: OutboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outbound_route_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_outboundroute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outbound_route_id' is set
        if ('outbound_route_id' not in params) or (params['outbound_route_id'] is None):
            raise ValueError("Missing the required parameter `outbound_route_id` when calling `put_telephony_providers_edges_outboundroute`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_outboundroute`")


        resource_path = '/api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId}'.replace('{format}', 'json')
        path_params = {}
        if 'outbound_route_id' in params:
            path_params['outboundRouteId'] = params['outbound_route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_phone(self, phone_id, body, **kwargs):
        """
        Update a Phone by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_phone(phone_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_id: Phone ID (required)
        :param Phone body: Phone (required)
        :return: Phone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_phone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_id' is set
        if ('phone_id' not in params) or (params['phone_id'] is None):
            raise ValueError("Missing the required parameter `phone_id` when calling `put_telephony_providers_edges_phone`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_phone`")


        resource_path = '/api/v2/telephony/providers/edges/phones/{phoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'phone_id' in params:
            path_params['phoneId'] = params['phone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Phone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_phonebasesetting(self, phone_base_id, body, **kwargs):
        """
        Update a Phone Base Settings by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_phonebasesetting(phone_base_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str phone_base_id: Phone base ID (required)
        :param PhoneBase body: Phone base settings (required)
        :return: PhoneBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phone_base_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_phonebasesetting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'phone_base_id' is set
        if ('phone_base_id' not in params) or (params['phone_base_id'] is None):
            raise ValueError("Missing the required parameter `phone_base_id` when calling `put_telephony_providers_edges_phonebasesetting`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_phonebasesetting`")


        resource_path = '/api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'phone_base_id' in params:
            path_params['phoneBaseId'] = params['phone_base_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PhoneBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_site(self, site_id, body, **kwargs):
        """
        Update a Site by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_site(site_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param Site body: Site (required)
        :return: Site
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_site" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `put_telephony_providers_edges_site`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_site`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Site',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_site_numberplans(self, site_id, body, **kwargs):
        """
        Update the list of Number Plans. A user can update maximum 200 number plans at a time.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_site_numberplans(site_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param list[NumberPlan] body: List of number plans (required)
        :return: list[NumberPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_site_numberplans" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `put_telephony_providers_edges_site_numberplans`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_site_numberplans`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/numberplans'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[NumberPlan]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_site_outboundroute(self, site_id, outbound_route_id, body, **kwargs):
        """
        Update outbound route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_site_outboundroute(site_id, outbound_route_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str site_id: Site ID (required)
        :param str outbound_route_id: Outbound route ID (required)
        :param OutboundRouteBase body: OutboundRoute (required)
        :return: OutboundRouteBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'outbound_route_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_site_outboundroute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'site_id' is set
        if ('site_id' not in params) or (params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `put_telephony_providers_edges_site_outboundroute`")
        # verify the required parameter 'outbound_route_id' is set
        if ('outbound_route_id' not in params) or (params['outbound_route_id'] is None):
            raise ValueError("Missing the required parameter `outbound_route_id` when calling `put_telephony_providers_edges_site_outboundroute`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_site_outboundroute`")


        resource_path = '/api/v2/telephony/providers/edges/sites/{siteId}/outboundroutes/{outboundRouteId}'.replace('{format}', 'json')
        path_params = {}
        if 'site_id' in params:
            path_params['siteId'] = params['site_id']
        if 'outbound_route_id' in params:
            path_params['outboundRouteId'] = params['outbound_route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundRouteBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_telephony_providers_edges_trunkbasesetting(self, trunk_base_settings_id, body, **kwargs):
        """
        Update a Trunk Base Settings object by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_telephony_providers_edges_trunkbasesetting(trunk_base_settings_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trunk_base_settings_id: Trunk Base ID (required)
        :param TrunkBase body: Trunk base settings (required)
        :return: TrunkBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trunk_base_settings_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_telephony_providers_edges_trunkbasesetting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trunk_base_settings_id' is set
        if ('trunk_base_settings_id' not in params) or (params['trunk_base_settings_id'] is None):
            raise ValueError("Missing the required parameter `trunk_base_settings_id` when calling `put_telephony_providers_edges_trunkbasesetting`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_telephony_providers_edges_trunkbasesetting`")


        resource_path = '/api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'trunk_base_settings_id' in params:
            path_params['trunkBaseSettingsId'] = params['trunk_base_settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrunkBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
