""" Migrations
"""
# Generated by Django 3.2 on 2021-12-08 21:37

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    """Migration"""

    initial = True

    dependencies = [
        ("core_main_app", "0001_initial"),
        ("core_parser_app", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="ExploreDataStructure",
            fields=[
                (
                    "datastructure_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core_parser_app.datastructure",
                    ),
                ),
                (
                    "selected_fields_html_tree",
                    models.TextField(blank=True, default=None, null=True),
                ),
            ],
            bases=("core_parser_app.datastructure",),
        ),
        migrations.CreateModel(
            name="ExploreExample",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "verbose_name": "core_explore_example_app",
                "permissions": (
                    ("access_explore_example", "Can access explore example"),
                    ("save_query", "Can save query"),
                    ("delete_query", "Can delete query"),
                    (
                        "access_explore_example_data_structure",
                        "Can access explore example data structure",
                    ),
                ),
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="SavedQuery",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("user_id", models.CharField(max_length=200)),
                ("query", models.TextField()),
                ("displayed_query", models.TextField()),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core_main_app.template",
                    ),
                ),
            ],
            options={
                "verbose_name": "Saved Query",
                "verbose_name_plural": "Saved Queries",
            },
        ),
        migrations.CreateModel(
            name="PersistentQueryExample",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("user_id", models.CharField(max_length=200)),
                ("content", models.TextField(blank=True, null=True)),
                ("data_sources", models.JSONField(blank=True, default=list)),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                (
                    "name",
                    models.CharField(
                        blank=True, max_length=200, null=True, unique=True
                    ),
                ),
                (
                    "templates",
                    models.ManyToManyField(
                        blank=True, default=[], to="core_main_app.Template"
                    ),
                ),
            ],
            options={
                "abstract": False,
                "verbose_name": "Persistent Query by Example",
                "verbose_name_plural": "Persistent Queries by Example",
            },
        ),
    ]
