"""
    Rollout API reference

    Service name    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

import nulltype  # noqa: F401

from pensando_dss.psm.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from pensando_dss.psm.model.labels_selector import LabelsSelector
    globals()['LabelsSelector'] = LabelsSelector


class RolloutRolloutSpec(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('strategy',): {
            'LINEAR': "linear",
            'EXPONENTIAL': "exponential",
        },
        ('upgrade_type',): {
            'GRACEFUL': "graceful",
            'ON-NEXT-REBOOT': "on-next-reboot",
            'DISRUPTIVE': "disruptive",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'dsc_must_match_constraint': (bool,),  # noqa: E501
            'dscs_only': (bool,),  # noqa: E501
            'max_nic_failures_before_abort': (int,),  # noqa: E501
            'max_parallel': (int,),  # noqa: E501
            'order_constraints': ([LabelsSelector],),  # noqa: E501
            'retry': (bool,),  # noqa: E501
            'scheduled_end_time': (datetime,),  # noqa: E501
            'scheduled_start_time': (datetime,),  # noqa: E501
            'strategy': (str,),  # noqa: E501
            'suspend': (bool,),  # noqa: E501
            'upgrade_type': (str,),  # noqa: E501
            'version': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'dsc_must_match_constraint': 'dsc-must-match-constraint',  # noqa: E501
        'dscs_only': 'dscs-only',  # noqa: E501
        'max_nic_failures_before_abort': 'max-nic-failures-before-abort',  # noqa: E501
        'max_parallel': 'max-parallel',  # noqa: E501
        'order_constraints': 'order-constraints',  # noqa: E501
        'retry': 'retry',  # noqa: E501
        'scheduled_end_time': 'scheduled-end-time',  # noqa: E501
        'scheduled_start_time': 'scheduled-start-time',  # noqa: E501
        'strategy': 'strategy',  # noqa: E501
        'suspend': 'suspend',  # noqa: E501
        'upgrade_type': 'upgrade-type',  # noqa: E501
        'version': 'version',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """RolloutRolloutSpec - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            dsc_must_match_constraint (bool): When DSCMustMatchConstraint is true, Any DSC which does not match OrderConstraints does not go through rollout.. [optional]  # noqa: E501
            dscs_only (bool): Dont upgrade Controller but only upgrade DistributedServiceCards.. [optional]  # noqa: E501
            max_nic_failures_before_abort (int): After these many failures are observed during DSC upgrade, the rollout process stops This setting applies to DSCs only. The controller nodes are rollout first and any failure there stops the rollout of DistributedServiceCards.. [optional]  # noqa: E501
            max_parallel (int): MaxParallel is the maximum number of nodes getting updated at any time This setting is applicable only to DistributedServiceCards. Controller nodes are always upgraded one after another.. [optional] if omitted the server will use the default value of 2  # noqa: E501
            order_constraints ([LabelsSelector]): If specified, this is the sequence in which the DistributedServiceCards are upgraded based on their labels. if a DistributedServiceCard matches multiple constraints, the first one is used. Any DistributedServiceCard which does not match the constraints is upgraded at the end. This order is mainly for the DSCs on Hosts Controller nodes are always rollout one after other.. [optional]  # noqa: E501
            retry (bool): If enabled, will retry rollout of failed naples within the maintenance window upto a max of 5 times.. [optional]  # noqa: E501
            scheduled_end_time (datetime): ScheduledEndTime, if specified, after which the rollout is supposed to stop, if not completed by that time Typically represents the end of Maintenance window. (example:\"2002-10-02T15:00:00.05Z\").. [optional]  # noqa: E501
            scheduled_start_time (datetime): Time, if specified, at which the rollout is supposed to start. (example:\"2002-10-02T15:00:00.05Z\").. [optional]  # noqa: E501
            strategy (str): [optional] if omitted the server will use the default value of "linear"  # noqa: E501
            suspend (bool): When Set to true, the current rollout is suspended. Existing Nodes/Services/DistributedServiceCards in the middle of rollout continue rollout execution but any Nodes/Services/DistributedServiceCards which has not started Rollout will not be scheduled one.. [optional]  # noqa: E501
            upgrade_type (str): [optional] if omitted the server will use the default value of "graceful"  # noqa: E501
            version (str): New Version of the image to rollout to.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
