"""
    Objstore API reference

       # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pensando_dss.psm.api_client import ApiClient, Endpoint as _Endpoint
from pensando_dss.psm.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
import pensando_dss.psm as psm
from pensando_dss.psm.model.api_status import ApiStatus
from pensando_dss.psm.model.objstore_auto_msg_object_watch_helper import ObjstoreAutoMsgObjectWatchHelper
from pensando_dss.psm.model.objstore_object import ObjstoreObject
from pensando_dss.psm.model.objstore_object_list import ObjstoreObjectList
from pensando_dss.psm.model.objstore_stream_chunk import ObjstoreStreamChunk


class ObjstoreV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_object(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Create Object object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_object(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (ObjstoreObject):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_object = _Endpoint(
            settings={
                'response_type': (ObjstoreObject,),
                'auth': [],
                'endpoint_path': '/objstore/v1/tenant/{O.Tenant}/{O.Namespace}/objects',
                'operation_id': 'add_object',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (ObjstoreObject,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_object
        )

        def __add_object1(
            self,
            o_namespace,
            body,
            **kwargs
        ):
            """Create Object object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_object1(o_namespace, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_namespace (str):
                body (ObjstoreObject):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_namespace'] = \
                o_namespace
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_object1 = _Endpoint(
            settings={
                'response_type': (ObjstoreObject,),
                'auth': [],
                'endpoint_path': '/objstore/v1/{O.Namespace}/objects',
                'operation_id': 'add_object1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_namespace',
                    'body',
                ],
                'required': [
                    'o_namespace',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_namespace':
                        (str,),
                    'body':
                        (ObjstoreObject,),
                },
                'attribute_map': {
                    'o_namespace': 'O.Namespace',
                },
                'location_map': {
                    'o_namespace': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_object1
        )

        def __delete_object(
            self,
            o_tenant,
            **kwargs
        ):
            """Delete Object object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_object(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.delete_object = _Endpoint(
            settings={
                'response_type': (ObjstoreObject,),
                'auth': [],
                'endpoint_path': '/objstore/v1/tenant/{O.Tenant}/{O.Namespace}/objects/{O.Name}',
                'operation_id': 'delete_object',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_object
        )

        def __delete_object1(
            self,
            o_namespace,
            **kwargs
        ):
            """Delete Object object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_object1(o_namespace, async_req=True)
            >>> result = thread.get()

            Args:
                o_namespace (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_namespace'] = \
                o_namespace
            return self.call_with_http_info(**kwargs)

        self.delete_object1 = _Endpoint(
            settings={
                'response_type': (ObjstoreObject,),
                'auth': [],
                'endpoint_path': '/objstore/v1/{O.Namespace}/objects/{O.Name}',
                'operation_id': 'delete_object1',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_namespace',
                ],
                'required': [
                    'o_namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_namespace':
                        (str,),
                },
                'attribute_map': {
                    'o_namespace': 'O.Namespace',
                },
                'location_map': {
                    'o_namespace': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_object1
        )

        def __get_download_file(
            self,
            o_tenant,
            **kwargs
        ):
            """Download file  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_download_file(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreStreamChunk
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.get_download_file = _Endpoint(
            settings={
                'response_type': (ObjstoreStreamChunk,),
                'auth': [],
                'endpoint_path': '/objstore/v1/downloads/tenant/{O.Tenant}/{O.Namespace}/{O.Name}',
                'operation_id': 'get_download_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    't_kind',
                    'meta_creation_time',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                },
                'location_map': {
                    'o_tenant': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_download_file
        )

        def __get_download_file1(
            self,
            o_namespace,
            **kwargs
        ):
            """Download file  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_download_file1(o_namespace, async_req=True)
            >>> result = thread.get()

            Args:
                o_namespace (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreStreamChunk
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_namespace'] = \
                o_namespace
            return self.call_with_http_info(**kwargs)

        self.get_download_file1 = _Endpoint(
            settings={
                'response_type': (ObjstoreStreamChunk,),
                'auth': [],
                'endpoint_path': '/objstore/v1/downloads/{O.Namespace}/{O.Name}',
                'operation_id': 'get_download_file1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_namespace',
                    't_kind',
                    'meta_creation_time',
                ],
                'required': [
                    'o_namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_namespace':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                },
                'attribute_map': {
                    'o_namespace': 'O.Namespace',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                },
                'location_map': {
                    'o_namespace': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_download_file1
        )

        def __get_download_file_by_prefix(
            self,
            o_tenant,
            **kwargs
        ):
            """Download file by prefix  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_download_file_by_prefix(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreStreamChunk
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.get_download_file_by_prefix = _Endpoint(
            settings={
                'response_type': (ObjstoreStreamChunk,),
                'auth': [],
                'endpoint_path': '/objstore/v1/downloads/all/tenant/{O.Tenant}/{O.Namespace}/{O.Name}',
                'operation_id': 'get_download_file_by_prefix',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    't_kind',
                    'meta_creation_time',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                },
                'location_map': {
                    'o_tenant': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_download_file_by_prefix
        )

        def __get_object(
            self,
            o_tenant,
            **kwargs
        ):
            """Get Object object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.get_object = _Endpoint(
            settings={
                'response_type': (ObjstoreObject,),
                'auth': [],
                'endpoint_path': '/objstore/v1/tenant/{O.Tenant}/{O.Namespace}/objects/{O.Name}',
                'operation_id': 'get_object',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    't_kind',
                    'meta_creation_time',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                },
                'location_map': {
                    'o_tenant': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object
        )

        def __get_object1(
            self,
            o_namespace,
            **kwargs
        ):
            """Get Object object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object1(o_namespace, async_req=True)
            >>> result = thread.get()

            Args:
                o_namespace (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_namespace'] = \
                o_namespace
            return self.call_with_http_info(**kwargs)

        self.get_object1 = _Endpoint(
            settings={
                'response_type': (ObjstoreObject,),
                'auth': [],
                'endpoint_path': '/objstore/v1/{O.Namespace}/objects/{O.Name}',
                'operation_id': 'get_object1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_namespace',
                    't_kind',
                    'meta_creation_time',
                ],
                'required': [
                    'o_namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_namespace':
                        (str,),
                    't_kind':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                },
                'attribute_map': {
                    'o_namespace': 'O.Namespace',
                    't_kind': 'T.kind',
                    'meta_creation_time': 'meta.creation-time',
                },
                'location_map': {
                    'o_namespace': 'path',
                    't_kind': 'query',
                    'meta_creation_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object1
        )

        def __list_object(
            self,
            o_tenant,
            **kwargs
        ):
            """List Object objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_object(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreObjectList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.list_object = _Endpoint(
            settings={
                'response_type': (ObjstoreObjectList,),
                'auth': [],
                'endpoint_path': '/objstore/v1/tenant/{O.Tenant}/{O.Namespace}/objects',
                'operation_id': 'list_object',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_creation_time',
                    'field_change_selector',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'field_change_selector':
                        ([str],),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_creation_time': 'O.creation-time',
                    'field_change_selector': 'field-change-selector',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_creation_time': 'query',
                    'field_change_selector': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_object
        )

        def __list_object1(
            self,
            o_namespace,
            **kwargs
        ):
            """List Object objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_object1(o_namespace, async_req=True)
            >>> result = thread.get()

            Args:
                o_namespace (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreObjectList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_namespace'] = \
                o_namespace
            return self.call_with_http_info(**kwargs)

        self.list_object1 = _Endpoint(
            settings={
                'response_type': (ObjstoreObjectList,),
                'auth': [],
                'endpoint_path': '/objstore/v1/{O.Namespace}/objects',
                'operation_id': 'list_object1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_namespace',
                    'o_name',
                    'o_creation_time',
                    'field_change_selector',
                ],
                'required': [
                    'o_namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_namespace':
                        (str,),
                    'o_name':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'field_change_selector':
                        ([str],),
                },
                'attribute_map': {
                    'o_namespace': 'O.Namespace',
                    'o_name': 'O.name',
                    'o_creation_time': 'O.creation-time',
                    'field_change_selector': 'field-change-selector',
                },
                'location_map': {
                    'o_namespace': 'path',
                    'o_name': 'query',
                    'o_creation_time': 'query',
                    'field_change_selector': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_object1
        )

        def __watch_object(
            self,
            o_tenant,
            **kwargs
        ):
            """Watch Object objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_object(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreAutoMsgObjectWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.watch_object = _Endpoint(
            settings={
                'response_type': (ObjstoreAutoMsgObjectWatchHelper,),
                'auth': [],
                'endpoint_path': '/objstore/v1/watch/tenant/{O.Tenant}/{O.Namespace}/objects',
                'operation_id': 'watch_object',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_creation_time',
                    'field_change_selector',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'field_change_selector':
                        ([str],),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_creation_time': 'O.creation-time',
                    'field_change_selector': 'field-change-selector',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_creation_time': 'query',
                    'field_change_selector': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_object
        )

        def __watch_object1(
            self,
            o_namespace,
            **kwargs
        ):
            """Watch Object objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_object1(o_namespace, async_req=True)
            >>> result = thread.get()

            Args:
                o_namespace (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjstoreAutoMsgObjectWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_namespace'] = \
                o_namespace
            return self.call_with_http_info(**kwargs)

        self.watch_object1 = _Endpoint(
            settings={
                'response_type': (ObjstoreAutoMsgObjectWatchHelper,),
                'auth': [],
                'endpoint_path': '/objstore/v1/watch/{O.Namespace}/objects',
                'operation_id': 'watch_object1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_namespace',
                    'o_name',
                    'o_creation_time',
                    'field_change_selector',
                ],
                'required': [
                    'o_namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_namespace':
                        (str,),
                    'o_name':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'field_change_selector':
                        ([str],),
                },
                'attribute_map': {
                    'o_namespace': 'O.Namespace',
                    'o_name': 'O.name',
                    'o_creation_time': 'O.creation-time',
                    'field_change_selector': 'field-change-selector',
                },
                'location_map': {
                    'o_namespace': 'path',
                    'o_name': 'query',
                    'o_creation_time': 'query',
                    'field_change_selector': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_object1
        )
