# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nautobot_meme_otd', 'nautobot_meme_otd.tests']

package_data = \
{'': ['*'], 'nautobot_meme_otd': ['templates/nautobot_meme_otd/*']}

install_requires = \
['importlib-metadata==4.13.0']

extras_require = \
{'nautobot': ['nautobot>=1.4.0,<2.0.0']}

setup_kwargs = {
    'name': 'nautobot-plugin-meme-otd',
    'version': '1.0.0',
    'description': 'Nautobot Meme Of The Day Plugin',
    'long_description': '# Nautobot Meme Of The Day Plugin\n\nA plugin for [Nautobot](https://github.com/nautobot/nautobot).\n\n## Installation\n\nThe plugin is available as a Python package in pypi and can be installed with pip\n\n```shell\npip install nautobot-plugin-meme-otd\n```\n\n> The plugin is compatible with Nautobot 1.4.0 and higher\n\nTo ensure Nautobot Meme Of The Day Plugin is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (alongside `requirements.txt`) and list the `nautobot-plugin-meme-otd` package:\n\n```no-highlight\n# echo nautobot-plugin-meme-otd >> local_requirements.txt\n```\n\nOnce installed, the plugin needs to be enabled in your `nautobot_config.py`\n\n```python\n# In your nautobot_config.py\nPLUGINS = ["nautobot_meme_otd"]\n\n# PLUGINS_CONFIG = {\n#   "nautobot_meme_otd": {\n#     ADD YOUR SETTINGS HERE\n#   }\n# }\n```\n\nThe plugin behavior can be controlled with the following list of settings\n\n- TODO\n\nDatabases supported:\n\n- Postgres\n- Mysql\n\n## Usage\n\n### API\n\nTODO\n\n## Contributing\n\nPull requests are welcomed and automatically built and tested against multiple version of Python and multiple version of Nautobot through TravisCI.\n\nThe project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.\n\nThe project is following Network to Code software development guideline and is leveraging:\n\n- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.\n- Django unit test to ensure the plugin is working properly.\n\n### Development Environment\n\nThe development environment can be used in 2 ways. First, with a local poetry environment if you wish to develop outside of Docker with the caveat of using external services provided by Docker for PostgresQL and Redis. Second, all services are spun up using Docker and a local mount so you can develop locally, but Nautobot is spun up within the Docker container.\n\nBelow is a quick start guide if you\'re already familiar with the development environment provided, but if you\'re not familiar, please read the [Getting Started Guide](GETTING_STARTED.md).\n\n#### Invoke\n\nThe [PyInvoke](http://www.pyinvoke.org/) library is used to provide some helper commands based on the environment. There are a few configuration parameters which can be passed to PyInvoke to override the default configuration:\n\n- `nautobot_ver`: the version of Nautobot to use as a base for any built docker containers (default: latest)\n- `project_name`: the default docker compose project name (default: nautobot_meme_otd)\n- `python_ver`: the version of Python to use as a base for any built docker containers (default: 3.7)\n- `local`: a boolean flag indicating if invoke tasks should be run on the host or inside the docker containers (default: False, commands will be run in docker containers)\n- `compose_dir`: the full path to a directory containing the project compose files\n- `compose_files`: a list of compose files applied in order (see [Multiple Compose files](https://docs.docker.com/compose/extends/#multiple-compose-files) for more information)\n\nUsing **PyInvoke** these configuration options can be overridden using [several methods](http://docs.pyinvoke.org/en/stable/concepts/configuration.html). Perhaps the simplest is simply setting an environment variable `INVOKE_NAUTOBOT_MEME_OTD_VARIABLE_NAME` where `VARIABLE_NAME` is the variable you are trying to override. The only exception is `compose_files`, because it is a list it must be overridden in a yaml file. There is an example `invoke.yml` (`invoke.example.yml`) in this directory which can be used as a starting point.\n\n#### Local Poetry Development Environment\n\n1. Copy `development/creds.example.env` to `development/creds.env` (This file will be ignored by Git and Docker)\n2. Uncomment the `NAUTOBOT_DB_HOST`, `NAUTOBOT_REDIS_HOST`, and `NAUTOBOT_CONFIG` variables in `development/creds.env`\n3. Create an `invoke.yml` file with the following contents at the root of the repo (you can also `cp invoke.example.yml invoke.yml` and edit as necessary):\n\n```yaml\n---\n{ { cookiecutter.plugin_name } }:\n  local: true\n  compose_files:\n    - "docker-compose.requirements.yml"\n```\n\n3. Run the following commands:\n\n```shell\npoetry shell\npoetry install --extras nautobot\nexport $(cat development/dev.env | xargs)\nexport $(cat development/creds.env | xargs)\ninvoke start && sleep 5\nnautobot-server migrate\n```\n\n> If you want to develop on the latest develop branch of Nautobot, run the following command: `poetry add --optional git+https://github.com/nautobot/nautobot@develop`. After the `@` symbol must match either a branch or a tag.\n\n4. You can now run nautobot-server commands as you would from the [Nautobot documentation](https://nautobot.readthedocs.io/en/latest/) for example to start the development server:\n\n```shell\nnautobot-server runserver 0.0.0.0:8080 --insecure\n```\n\nNautobot server can now be accessed at [http://localhost:8080](http://localhost:8080).\n\nIt is typically recommended to launch the Nautobot **runserver** command in a separate shell so you can keep developing and manage the webserver separately.\n\n#### Docker Development Environment\n\nThis project is managed by [Python Poetry](https://python-poetry.org/) and has a few requirements to setup your development environment:\n\n1. Install Poetry, see the [Poetry Documentation](https://python-poetry.org/docs/#installation) for your operating system.\n2. Install Docker, see the [Docker documentation](https://docs.docker.com/get-docker/) for your operating system.\n\nOnce you have Poetry and Docker installed you can run the following commands to install all other development dependencies in an isolated python virtual environment:\n\n```shell\npoetry shell\npoetry install\ninvoke start\n```\n\nNautobot server can now be accessed at [http://localhost:8080](http://localhost:8080).\n\nTo either stop or destroy the development environment use the following options.\n\n- **invoke stop** - Stop the containers, but keep all underlying systems intact\n- **invoke destroy** - Stop and remove all containers, volumes, etc. (This results in data loss due to the volume being deleted)\n\n### CLI Helper Commands\n\nThe project is coming with a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`.\n\nEach command can be executed with `invoke <command>`. Environment variables `INVOKE_NAUTOBOT_MEME_OTD_PYTHON_VER` and `INVOKE_NAUTOBOT_MEME_OTD_NAUTOBOT_VER` may be specified to override the default versions. Each command also has its own help `invoke <command> --help`\n\n#### Docker dev environment\n\n```no-highlight\n  build            Build all docker images.\n  debug            Start Nautobot and its dependencies in debug mode.\n  destroy          Destroy all containers and volumes.\n  restart          Restart Nautobot and its dependencies.\n  start            Start Nautobot and its dependencies in detached mode.\n  stop             Stop Nautobot and its dependencies.\n```\n\n#### Utility\n\n```no-highlight\n  cli              Launch a bash shell inside the running Nautobot container.\n  create-user      Create a new user in django (default: admin), will prompt for password.\n  makemigrations   Run Make Migration in Django.\n  nbshell          Launch a nbshell session.\n  shell-plus       Launch a shell_plus session, which uses iPython and automatically imports all models.\n```\n\n#### Testing\n\n```no-highlight\n  bandit           Run bandit to validate basic static code security analysis.\n  black            Run black to check that Python files adhere to its style standards.\n  flake8           This will run flake8 for the specified name and Python version.\n  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  pylint           Run pylint code analysis.\n  tests            Run all tests for this plugin.\n  unittest         Run Django unit tests for the plugin.\n```\n\n### Project Documentation\n\nProject documentation is generated by [mkdocs](https://www.mkdocs.org/) from the documentation located in the docs folder. You can configure [readthedocs.io](https://readthedocs.io/) to point at this folder in your repo. A container hosting the docs will be started using the invoke commands on [http://localhost:8001](http://localhost:8001), as changes are saved the docs will be automatically reloaded.\n\n## Questions\n\nFor any questions or comments, please check the [FAQ](FAQ.md) first and feel free to swing by the [Network to Code slack channel](https://networktocode.slack.com/) (channel #networktocode).\nSign up [here](http://slack.networktocode.com/)\n\n## Screenshots\n\nTODO\n',
    'author': 'Jeremy White',
    'author_email': 'jeremy.white@networktocode.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/whitej6/nautobot-plugin-meme-otd',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
