import string

_gSC: str = "_"

gParamDict: dict = {
    "SeparatorChar": _gSC,
    "ASCLen": 3,
    "AlternateFlag": True,
    "HeadChars": string.ascii_letters + string.digits + string.punctuation,
    "BeReplacedCharDictionary": {
        "\r": _gSC,
        "\n": _gSC,
        "?": _gSC,
        ",": _gSC,
        "!": _gSC,
        ":": _gSC,
        "&": _gSC,
        "@": _gSC,
        "·": _gSC,  # at the middle height of row
        "\`": _gSC,
        "`": _gSC,
        "\\": _gSC,
        " ": _gSC,  # space
        "(": _gSC,
        ")": _gSC,
        "'": _gSC,
        "+": _gSC,
        "-": _gSC,
        "±": _gSC,
        "=": _gSC,
        "|": _gSC,
        "[": _gSC,
        "]": _gSC,
        "{": _gSC,
        "}": _gSC,
        "»": _gSC,
        "«": _gSC,
        "\"": _gSC,
        "*": _gSC,
        "#": _gSC,
        "®": _gSC,
        "™": _gSC,
        "…": _gSC,
        "“": _gSC,
        "”": _gSC,
        #     ".": _gSC,
        "•": _gSC,
        "，": _gSC,
        "。": _gSC,
        "–": _gSC,
        "—": _gSC,
        #     "一": _gSC,# It is a chinese number character, means one
        "、": _gSC,
        "（": _gSC,
        "）": _gSC,
        "《": _gSC,
        "》": _gSC,
        ">": _gSC,
        "【": _gSC,
        "】": _gSC,
        "「": _gSC,
        "」": _gSC,
        "｜": _gSC,
        "：": _gSC,
        "；": _gSC,
        "？": _gSC,
        "！": _gSC,
        "🚀": _gSC,
        "🚴": _gSC,
        "🌏": _gSC,
        "🐾": _gSC,
        "❤️": _gSC,
        "%2F": _gSC,
        # "____": _gSC,# This is a rougher way to deal with continuous
        # separator "___": _gSC,# character. "__": _gSC,# Now replaced by a
        # regex,so delete them
        "._": _gSC,
        "What’s": "What_is",
        "what’s": "what_is"
    },
    "TerminologyDictionary": {
        "apple": "Apple",
        "acid": "ACID",
        "asciinema": "asciinema",
        "api": "API",
        "atm": "ATM",
        "cmsis": "CMSIS",
        "cypress": "CYPRESS",
        "dji": "DJI",
        "google": "Google",
        "i2c": "I2C",
        "idata": "iData",
        "kicad": "KiCAD",
        "kriasoft": "Kriasoft",
        "mbed": "Mbed",
        "mosfet": "MOSFET",
        "mux": "MUX",
        "nltk": "NLTK",
        "nucleo": "NUCLEO",
        "pcb": "PCB",
        "pcie": "PCIe",
        "pdfminersix": "pdfminersix",
        "pep8": "PEP8",
        "psoc": "PSoC",
        "pyqt": "PyQt",
        "pyqt4": "PyQt4",
        "pyqt5": "PyQt5",
        "pyqt6": "PyQt6",
        "restructuredtext": "reStructuredText",
        "rohs": "ROHS",
        "spi": "SPI",
        "ssd": "SSD",
        "stm32": "STM32",
        "stmicroelectronics": "STMicroelectronics",
        "sudo": "sudo",
        "tkinter": "Tkinter",
        "ti": "TI",
        "usb": "USB",
        "urwid": "Urwid",
        "vishay": "VISHAY",
        "vim": "Vim",
    },
    "RemainUnchangedWordList":
        ["$*", "$@", "$#", "$?", "$-", "$$", "$!", "$0"],
    "IgnoredDirectoryKeyList": [".git", ".xcodeproj", ".cydsn", ".cywrk"]
}
