"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.29.128
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from velo_payments.api_client import ApiClient, Endpoint as _Endpoint
from velo_payments.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from velo_payments.model.get_fundings_response import GetFundingsResponse
from velo_payments.model.get_payments_for_payout_response_v3 import GetPaymentsForPayoutResponseV3
from velo_payments.model.get_payout_statistics import GetPayoutStatistics
from velo_payments.model.get_payouts_response_v3 import GetPayoutsResponseV3
from velo_payments.model.inline_response400 import InlineResponse400
from velo_payments.model.inline_response401 import InlineResponse401
from velo_payments.model.inline_response403 import InlineResponse403
from velo_payments.model.inline_response404 import InlineResponse404
from velo_payments.model.list_payments_response_v3 import ListPaymentsResponseV3
from velo_payments.model.payment_delta_response_v1 import PaymentDeltaResponseV1
from velo_payments.model.payment_response_v3 import PaymentResponseV3
from velo_payments.model.payor_aml_transaction_v3 import PayorAmlTransactionV3


class PaymentAuditServiceDeprecatedApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.export_transactions_csvv3_endpoint = _Endpoint(
            settings={
                'response_type': (PayorAmlTransactionV3,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/paymentaudit/transactions',
                'operation_id': 'export_transactions_csvv3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'start_date',
                    'end_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'payor_id': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/csv',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_fundings_v1_endpoint = _Endpoint(
            settings={
                'response_type': (GetFundingsResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/paymentaudit/fundings',
                'operation_id': 'get_fundings_v1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'page',
                    'page_size',
                    'sort',
                ],
                'required': [
                    'payor_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'payor_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payment_details_v3_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentResponseV3,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/paymentaudit/payments/{paymentId}',
                'operation_id': 'get_payment_details_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_id',
                    'sensitive',
                ],
                'required': [
                    'payment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_id':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'payment_id': 'paymentId',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'payment_id': 'path',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payments_for_payout_pav3_endpoint = _Endpoint(
            settings={
                'response_type': (GetPaymentsForPayoutResponseV3,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/paymentaudit/payouts/{payoutId}',
                'operation_id': 'get_payments_for_payout_pav3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payout_id',
                    'remote_id',
                    'status',
                    'source_amount_from',
                    'source_amount_to',
                    'payment_amount_from',
                    'payment_amount_to',
                    'submitted_date_from',
                    'submitted_date_to',
                    'page',
                    'page_size',
                    'sort',
                    'sensitive',
                ],
                'required': [
                    'payout_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "ACCEPTED": "ACCEPTED",
                        "AWAITING_FUNDS": "AWAITING_FUNDS",
                        "FUNDED": "FUNDED",
                        "UNFUNDED": "UNFUNDED",
                        "BANK_PAYMENT_REQUESTED": "BANK_PAYMENT_REQUESTED",
                        "REJECTED": "REJECTED",
                        "ACCEPTED_BY_RAILS": "ACCEPTED_BY_RAILS",
                        "CONFIRMED": "CONFIRMED",
                        "FAILED": "FAILED",
                        "RETURNED": "RETURNED",
                        "WITHDRAWN": "WITHDRAWN"
                    },
                },
                'openapi_types': {
                    'payout_id':
                        (str,),
                    'remote_id':
                        (str,),
                    'status':
                        (str,),
                    'source_amount_from':
                        (int,),
                    'source_amount_to':
                        (int,),
                    'payment_amount_from':
                        (int,),
                    'payment_amount_to':
                        (int,),
                    'submitted_date_from':
                        (date,),
                    'submitted_date_to':
                        (date,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'payout_id': 'payoutId',
                    'remote_id': 'remoteId',
                    'status': 'status',
                    'source_amount_from': 'sourceAmountFrom',
                    'source_amount_to': 'sourceAmountTo',
                    'payment_amount_from': 'paymentAmountFrom',
                    'payment_amount_to': 'paymentAmountTo',
                    'submitted_date_from': 'submittedDateFrom',
                    'submitted_date_to': 'submittedDateTo',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'payout_id': 'path',
                    'remote_id': 'query',
                    'status': 'query',
                    'source_amount_from': 'query',
                    'source_amount_to': 'query',
                    'payment_amount_from': 'query',
                    'payment_amount_to': 'query',
                    'submitted_date_from': 'query',
                    'submitted_date_to': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payout_stats_v1_endpoint = _Endpoint(
            settings={
                'response_type': (GetPayoutStatistics,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/paymentaudit/payoutStatistics',
                'operation_id': 'get_payout_stats_v1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                },
                'location_map': {
                    'payor_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payouts_for_payor_v3_endpoint = _Endpoint(
            settings={
                'response_type': (GetPayoutsResponseV3,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/paymentaudit/payouts',
                'operation_id': 'get_payouts_for_payor_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'payout_memo',
                    'status',
                    'submitted_date_from',
                    'submitted_date_to',
                    'page',
                    'page_size',
                    'sort',
                ],
                'required': [
                    'payor_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "ACCEPTED": "ACCEPTED",
                        "REJECTED": "REJECTED",
                        "SUBMITTED": "SUBMITTED",
                        "QUOTED": "QUOTED",
                        "INSTRUCTED": "INSTRUCTED",
                        "COMPLETED": "COMPLETED",
                        "INCOMPLETE": "INCOMPLETE",
                        "CONFIRMED": "CONFIRMED",
                        "WITHDRAWN": "WITHDRAWN"
                    },
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'payout_memo':
                        (str,),
                    'status':
                        (str,),
                    'submitted_date_from':
                        (date,),
                    'submitted_date_to':
                        (date,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'payout_memo': 'payoutMemo',
                    'status': 'status',
                    'submitted_date_from': 'submittedDateFrom',
                    'submitted_date_to': 'submittedDateTo',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'payor_id': 'query',
                    'payout_memo': 'query',
                    'status': 'query',
                    'submitted_date_from': 'query',
                    'submitted_date_to': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_payment_changes_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentDeltaResponseV1,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/deltas/payments',
                'operation_id': 'list_payment_changes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'updated_since',
                    'page',
                    'page_size',
                ],
                'required': [
                    'payor_id',
                    'updated_since',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'updated_since':
                        (datetime,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'updated_since': 'updatedSince',
                    'page': 'page',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'payor_id': 'query',
                    'updated_since': 'query',
                    'page': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_payments_audit_v3_endpoint = _Endpoint(
            settings={
                'response_type': (ListPaymentsResponseV3,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/paymentaudit/payments',
                'operation_id': 'list_payments_audit_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                    'payor_id',
                    'payor_name',
                    'remote_id',
                    'status',
                    'source_account_name',
                    'source_amount_from',
                    'source_amount_to',
                    'source_currency',
                    'payment_amount_from',
                    'payment_amount_to',
                    'payment_currency',
                    'submitted_date_from',
                    'submitted_date_to',
                    'payment_memo',
                    'page',
                    'page_size',
                    'sort',
                    'sensitive',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "ACCEPTED": "ACCEPTED",
                        "AWAITING_FUNDS": "AWAITING_FUNDS",
                        "FUNDED": "FUNDED",
                        "UNFUNDED": "UNFUNDED",
                        "BANK_PAYMENT_REQUESTED": "BANK_PAYMENT_REQUESTED",
                        "REJECTED": "REJECTED",
                        "ACCEPTED_BY_RAILS": "ACCEPTED_BY_RAILS",
                        "CONFIRMED": "CONFIRMED",
                        "FAILED": "FAILED",
                        "RETURNED": "RETURNED",
                        "WITHDRAWN": "WITHDRAWN"
                    },
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                    'payor_id':
                        (str,),
                    'payor_name':
                        (str,),
                    'remote_id':
                        (str,),
                    'status':
                        (str,),
                    'source_account_name':
                        (str,),
                    'source_amount_from':
                        (int,),
                    'source_amount_to':
                        (int,),
                    'source_currency':
                        (str,),
                    'payment_amount_from':
                        (int,),
                    'payment_amount_to':
                        (int,),
                    'payment_currency':
                        (str,),
                    'submitted_date_from':
                        (date,),
                    'submitted_date_to':
                        (date,),
                    'payment_memo':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                    'payor_id': 'payorId',
                    'payor_name': 'payorName',
                    'remote_id': 'remoteId',
                    'status': 'status',
                    'source_account_name': 'sourceAccountName',
                    'source_amount_from': 'sourceAmountFrom',
                    'source_amount_to': 'sourceAmountTo',
                    'source_currency': 'sourceCurrency',
                    'payment_amount_from': 'paymentAmountFrom',
                    'payment_amount_to': 'paymentAmountTo',
                    'payment_currency': 'paymentCurrency',
                    'submitted_date_from': 'submittedDateFrom',
                    'submitted_date_to': 'submittedDateTo',
                    'payment_memo': 'paymentMemo',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'payee_id': 'query',
                    'payor_id': 'query',
                    'payor_name': 'query',
                    'remote_id': 'query',
                    'status': 'query',
                    'source_account_name': 'query',
                    'source_amount_from': 'query',
                    'source_amount_to': 'query',
                    'source_currency': 'query',
                    'payment_amount_from': 'query',
                    'payment_amount_to': 'query',
                    'payment_currency': 'query',
                    'submitted_date_from': 'query',
                    'submitted_date_to': 'query',
                    'payment_memo': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def export_transactions_csvv3(
        self,
        **kwargs
    ):
        """V3 Export Transactions  # noqa: E501

        Deprecated (use /v4/paymentaudit/transactions instead)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_transactions_csvv3(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            payor_id (str): The Payor ID for whom you wish to run the report. For a Payor requesting the report, this could be their exact Payor, or it could be a child/descendant Payor. . [optional]
            start_date (date): Start date, inclusive. Format is YYYY-MM-DD. [optional]
            end_date (date): End date, inclusive. Format is YYYY-MM-DD. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PayorAmlTransactionV3
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.export_transactions_csvv3_endpoint.call_with_http_info(**kwargs)

    def get_fundings_v1(
        self,
        payor_id,
        **kwargs
    ):
        """V1 Get Fundings for Payor  # noqa: E501

        Deprecated (use /v4/paymentaudit/fundings)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fundings_v1(payor_id, async_req=True)
        >>> result = thread.get()

        Args:
            payor_id (str): The account owner Payor ID

        Keyword Args:
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields. Example: ```?sort=destinationCurrency:asc,destinationAmount:asc``` Default is no sort. The supported sort fields are: dateTime and amount. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetFundingsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payor_id'] = \
            payor_id
        return self.get_fundings_v1_endpoint.call_with_http_info(**kwargs)

    def get_payment_details_v3(
        self,
        payment_id,
        **kwargs
    ):
        """V3 Get Payment  # noqa: E501

        Deprecated (use /v4/paymentaudit/payments/<paymentId> instead)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payment_details_v3(payment_id, async_req=True)
        >>> result = thread.get()

        Args:
            payment_id (str): Payment Id

        Keyword Args:
            sensitive (bool): Optional. If omitted or set to false, any Personal Identifiable Information (PII) values are returned masked. If set to true, and you have permission, the PII values will be returned as their original unmasked values. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PaymentResponseV3
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payment_id'] = \
            payment_id
        return self.get_payment_details_v3_endpoint.call_with_http_info(**kwargs)

    def get_payments_for_payout_pav3(
        self,
        payout_id,
        **kwargs
    ):
        """V3 Get Payments for Payout  # noqa: E501

        Deprecated (use /v4/paymentaudit/payouts/<payoutId> instead)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payments_for_payout_pav3(payout_id, async_req=True)
        >>> result = thread.get()

        Args:
            payout_id (str): The id (UUID) of the payout.

        Keyword Args:
            remote_id (str): The remote id of the payees.. [optional]
            status (str): Payment Status. [optional]
            source_amount_from (int): The source amount from range filter. Filters for sourceAmount >= sourceAmountFrom. [optional]
            source_amount_to (int): The source amount to range filter. Filters for sourceAmount ⇐ sourceAmountTo. [optional]
            payment_amount_from (int): The payment amount from range filter. Filters for paymentAmount >= paymentAmountFrom. [optional]
            payment_amount_to (int): The payment amount to range filter. Filters for paymentAmount ⇐ paymentAmountTo. [optional]
            submitted_date_from (date): The submitted date from range filter. Format is yyyy-MM-dd.. [optional]
            submitted_date_to (date): The submitted date to range filter. Format is yyyy-MM-dd.. [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): <p>List of sort fields (e.g. ?sort=submittedDateTime:asc,status:asc). Default is sort by remoteId</p> <p>The supported sort fields are: sourceAmount, sourceCurrency, paymentAmount, paymentCurrency, routingNumber, accountNumber, remoteId, submittedDateTime and status</p> . [optional]
            sensitive (bool): Optional. If omitted or set to false, any Personal Identifiable Information (PII) values are returned masked. If set to true, and you have permission, the PII values will be returned as their original unmasked values. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetPaymentsForPayoutResponseV3
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payout_id'] = \
            payout_id
        return self.get_payments_for_payout_pav3_endpoint.call_with_http_info(**kwargs)

    def get_payout_stats_v1(
        self,
        **kwargs
    ):
        """V1 Get Payout Statistics  # noqa: E501

        Deprecated (Use /v4/paymentaudit/payoutStatistics)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payout_stats_v1(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            payor_id (str): The account owner Payor ID. Required for external users.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetPayoutStatistics
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_payout_stats_v1_endpoint.call_with_http_info(**kwargs)

    def get_payouts_for_payor_v3(
        self,
        payor_id,
        **kwargs
    ):
        """V3 Get Payouts for Payor  # noqa: E501

        Deprecated (use /v4/paymentaudit/payouts instead)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payouts_for_payor_v3(payor_id, async_req=True)
        >>> result = thread.get()

        Args:
            payor_id (str): The account owner Payor ID

        Keyword Args:
            payout_memo (str): Payout Memo filter - case insensitive sub-string match. [optional]
            status (str): Payout Status. [optional]
            submitted_date_from (date): The submitted date from range filter. Format is yyyy-MM-dd.. [optional]
            submitted_date_to (date): The submitted date to range filter. Format is yyyy-MM-dd.. [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields (e.g. ?sort=submittedDateTime:asc,instructedDateTime:asc,status:asc) Default is submittedDateTime:asc The supported sort fields are: submittedDateTime, instructedDateTime, status. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetPayoutsResponseV3
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payor_id'] = \
            payor_id
        return self.get_payouts_for_payor_v3_endpoint.call_with_http_info(**kwargs)

    def list_payment_changes(
        self,
        payor_id,
        updated_since,
        **kwargs
    ):
        """V1 List Payment Changes  # noqa: E501

        Deprecated (use /v4/payments/deltas instead)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payment_changes(payor_id, updated_since, async_req=True)
        >>> result = thread.get()

        Args:
            payor_id (str): The Payor ID to find associated Payments
            updated_since (datetime): The updatedSince filter in the format YYYY-MM-DDThh:mm:ss+hh:mm

        Keyword Args:
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 100
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PaymentDeltaResponseV1
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payor_id'] = \
            payor_id
        kwargs['updated_since'] = \
            updated_since
        return self.list_payment_changes_endpoint.call_with_http_info(**kwargs)

    def list_payments_audit_v3(
        self,
        **kwargs
    ):
        """V3 Get List of Payments  # noqa: E501

        Deprecated (use /v4/paymentaudit/payments instead)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payments_audit_v3(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            payee_id (str): The UUID of the payee.. [optional]
            payor_id (str): The account owner Payor Id. Required for external users.. [optional]
            payor_name (str): The payor’s name. This filters via a case insensitive substring match.. [optional]
            remote_id (str): The remote id of the payees.. [optional]
            status (str): Payment Status. [optional]
            source_account_name (str): The source account name filter. This filters via a case insensitive substring match.. [optional]
            source_amount_from (int): The source amount from range filter. Filters for sourceAmount >= sourceAmountFrom. [optional]
            source_amount_to (int): The source amount to range filter. Filters for sourceAmount ⇐ sourceAmountTo. [optional]
            source_currency (str): The source currency filter. Filters based on an exact match on the currency.. [optional]
            payment_amount_from (int): The payment amount from range filter. Filters for paymentAmount >= paymentAmountFrom. [optional]
            payment_amount_to (int): The payment amount to range filter. Filters for paymentAmount ⇐ paymentAmountTo. [optional]
            payment_currency (str): The payment currency filter. Filters based on an exact match on the currency.. [optional]
            submitted_date_from (date): The submitted date from range filter. Format is yyyy-MM-dd.. [optional]
            submitted_date_to (date): The submitted date to range filter. Format is yyyy-MM-dd.. [optional]
            payment_memo (str): The payment memo filter. This filters via a case insensitive substring match.. [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields (e.g. ?sort=submittedDateTime:asc,status:asc). Default is sort by remoteId The supported sort fields are: sourceAmount, sourceCurrency, paymentAmount, paymentCurrency, routingNumber, accountNumber, remoteId, submittedDateTime and status . [optional]
            sensitive (bool): Optional. If omitted or set to false, any Personal Identifiable Information (PII) values are returned masked. If set to true, and you have permission, the PII values will be returned as their original unmasked values. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListPaymentsResponseV3
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_payments_audit_v3_endpoint.call_with_http_info(**kwargs)

