"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.29.128
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from velo_payments.api_client import ApiClient, Endpoint as _Endpoint
from velo_payments.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from velo_payments.model.inline_response400 import InlineResponse400
from velo_payments.model.inline_response401 import InlineResponse401
from velo_payments.model.inline_response403 import InlineResponse403
from velo_payments.model.inline_response404 import InlineResponse404
from velo_payments.model.inline_response409 import InlineResponse409
from velo_payments.model.ofac_status import OfacStatus
from velo_payments.model.onboarded_status import OnboardedStatus
from velo_payments.model.paged_payee_response import PagedPayeeResponse
from velo_payments.model.paged_payee_response2 import PagedPayeeResponse2
from velo_payments.model.payee_delta_response import PayeeDeltaResponse
from velo_payments.model.payee_delta_response2 import PayeeDeltaResponse2
from velo_payments.model.payee_detail_response import PayeeDetailResponse
from velo_payments.model.payee_detail_response2 import PayeeDetailResponse2
from velo_payments.model.payee_type2 import PayeeType2
from velo_payments.model.update_payee_details_request import UpdatePayeeDetailsRequest
from velo_payments.model.update_payee_details_request2 import UpdatePayeeDetailsRequest2
from velo_payments.model.update_remote_id_request import UpdateRemoteIdRequest
from velo_payments.model.update_remote_id_request2 import UpdateRemoteIdRequest2
from velo_payments.model.watchlist_status import WatchlistStatus


class PayeesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.delete_payee_by_id_v3_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/payees/{payeeId}',
                'operation_id': 'delete_payee_by_id_v3',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                ],
                'required': [
                    'payee_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                },
                'location_map': {
                    'payee_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_payee_by_id_v4_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v4/payees/{payeeId}',
                'operation_id': 'delete_payee_by_id_v4',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                ],
                'required': [
                    'payee_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                },
                'location_map': {
                    'payee_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payee_by_id_v3_endpoint = _Endpoint(
            settings={
                'response_type': (PayeeDetailResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/payees/{payeeId}',
                'operation_id': 'get_payee_by_id_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                    'sensitive',
                ],
                'required': [
                    'payee_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'payee_id': 'path',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payee_by_id_v4_endpoint = _Endpoint(
            settings={
                'response_type': (PayeeDetailResponse2,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v4/payees/{payeeId}',
                'operation_id': 'get_payee_by_id_v4',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                    'sensitive',
                ],
                'required': [
                    'payee_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'payee_id': 'path',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_payee_changes_v3_endpoint = _Endpoint(
            settings={
                'response_type': (PayeeDeltaResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/payees/deltas',
                'operation_id': 'list_payee_changes_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'updated_since',
                    'page',
                    'page_size',
                ],
                'required': [
                    'payor_id',
                    'updated_since',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'updated_since':
                        (datetime,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'updated_since': 'updatedSince',
                    'page': 'page',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'payor_id': 'query',
                    'updated_since': 'query',
                    'page': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_payee_changes_v4_endpoint = _Endpoint(
            settings={
                'response_type': (PayeeDeltaResponse2,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v4/payees/deltas',
                'operation_id': 'list_payee_changes_v4',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'updated_since',
                    'page',
                    'page_size',
                ],
                'required': [
                    'payor_id',
                    'updated_since',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'updated_since':
                        (datetime,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'updated_since': 'updatedSince',
                    'page': 'page',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'payor_id': 'query',
                    'updated_since': 'query',
                    'page': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_payees_v3_endpoint = _Endpoint(
            settings={
                'response_type': (PagedPayeeResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/payees',
                'operation_id': 'list_payees_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'watchlist_status',
                    'disabled',
                    'onboarded_status',
                    'email',
                    'display_name',
                    'remote_id',
                    'payee_type',
                    'payee_country',
                    'page',
                    'page_size',
                    'sort',
                ],
                'required': [
                    'payor_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'regex': {
                            'pattern': r'[a-zA-Z]+[:desc|:asc]',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'watchlist_status':
                        (WatchlistStatus,),
                    'disabled':
                        (bool,),
                    'onboarded_status':
                        (OnboardedStatus,),
                    'email':
                        (str,),
                    'display_name':
                        (str,),
                    'remote_id':
                        (str,),
                    'payee_type':
                        (PayeeType2,),
                    'payee_country':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'watchlist_status': 'watchlistStatus',
                    'disabled': 'disabled',
                    'onboarded_status': 'onboardedStatus',
                    'email': 'email',
                    'display_name': 'displayName',
                    'remote_id': 'remoteId',
                    'payee_type': 'payeeType',
                    'payee_country': 'payeeCountry',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'payor_id': 'query',
                    'watchlist_status': 'query',
                    'disabled': 'query',
                    'onboarded_status': 'query',
                    'email': 'query',
                    'display_name': 'query',
                    'remote_id': 'query',
                    'payee_type': 'query',
                    'payee_country': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_payees_v4_endpoint = _Endpoint(
            settings={
                'response_type': (PagedPayeeResponse2,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v4/payees',
                'operation_id': 'list_payees_v4',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'watchlist_status',
                    'disabled',
                    'onboarded_status',
                    'email',
                    'display_name',
                    'remote_id',
                    'payee_type',
                    'payee_country',
                    'ofac_status',
                    'page',
                    'page_size',
                    'sort',
                ],
                'required': [
                    'payor_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'regex': {
                            'pattern': r'[a-zA-Z]+[:desc|:asc]',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'watchlist_status':
                        (WatchlistStatus,),
                    'disabled':
                        (bool,),
                    'onboarded_status':
                        (OnboardedStatus,),
                    'email':
                        (str,),
                    'display_name':
                        (str,),
                    'remote_id':
                        (str,),
                    'payee_type':
                        (PayeeType2,),
                    'payee_country':
                        (str,),
                    'ofac_status':
                        (OfacStatus,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'watchlist_status': 'watchlistStatus',
                    'disabled': 'disabled',
                    'onboarded_status': 'onboardedStatus',
                    'email': 'email',
                    'display_name': 'displayName',
                    'remote_id': 'remoteId',
                    'payee_type': 'payeeType',
                    'payee_country': 'payeeCountry',
                    'ofac_status': 'ofacStatus',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'payor_id': 'query',
                    'watchlist_status': 'query',
                    'disabled': 'query',
                    'onboarded_status': 'query',
                    'email': 'query',
                    'display_name': 'query',
                    'remote_id': 'query',
                    'payee_type': 'query',
                    'payee_country': 'query',
                    'ofac_status': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.payee_details_update_v3_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/payees/{payeeId}/payeeDetailsUpdate',
                'operation_id': 'payee_details_update_v3',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                    'update_payee_details_request',
                ],
                'required': [
                    'payee_id',
                    'update_payee_details_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                    'update_payee_details_request':
                        (UpdatePayeeDetailsRequest,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                },
                'location_map': {
                    'payee_id': 'path',
                    'update_payee_details_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.payee_details_update_v4_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v4/payees/{payeeId}/payeeDetailsUpdate',
                'operation_id': 'payee_details_update_v4',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                    'update_payee_details_request2',
                ],
                'required': [
                    'payee_id',
                    'update_payee_details_request2',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                    'update_payee_details_request2':
                        (UpdatePayeeDetailsRequest2,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                },
                'location_map': {
                    'payee_id': 'path',
                    'update_payee_details_request2': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v3_payees_payee_id_remote_id_update_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/payees/{payeeId}/remoteIdUpdate',
                'operation_id': 'v3_payees_payee_id_remote_id_update_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                    'update_remote_id_request',
                ],
                'required': [
                    'payee_id',
                    'update_remote_id_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                    'update_remote_id_request':
                        (UpdateRemoteIdRequest,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                },
                'location_map': {
                    'payee_id': 'path',
                    'update_remote_id_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v4_payees_payee_id_remote_id_update_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v4/payees/{payeeId}/remoteIdUpdate',
                'operation_id': 'v4_payees_payee_id_remote_id_update_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payee_id',
                    'update_remote_id_request2',
                ],
                'required': [
                    'payee_id',
                    'update_remote_id_request2',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payee_id':
                        (str,),
                    'update_remote_id_request2':
                        (UpdateRemoteIdRequest2,),
                },
                'attribute_map': {
                    'payee_id': 'payeeId',
                },
                'location_map': {
                    'payee_id': 'path',
                    'update_remote_id_request2': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def delete_payee_by_id_v3(
        self,
        payee_id,
        **kwargs
    ):
        """Delete Payee by Id  # noqa: E501

        <p>Use v4 instead</p> <p>This API will delete Payee by Id (UUID). Deletion by ID is not allowed if:</p> <p>* Payee ID is not found</p> <p>* If Payee has not been on-boarded</p> <p>* If Payee is in grace period</p> <p>* If Payee has existing payments</p>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_payee_by_id_v3(payee_id, async_req=True)
        >>> result = thread.get()

        Args:
            payee_id (str): The UUID of the payee.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payee_id'] = \
            payee_id
        return self.delete_payee_by_id_v3_endpoint.call_with_http_info(**kwargs)

    def delete_payee_by_id_v4(
        self,
        payee_id,
        **kwargs
    ):
        """Delete Payee by Id  # noqa: E501

        <p>This API will delete Payee by Id (UUID). Deletion by ID is not allowed if:</p> <p>* Payee ID is not found</p> <p>* If Payee has not been on-boarded</p> <p>* If Payee is in grace period</p> <p>* If Payee has existing payments</p>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_payee_by_id_v4(payee_id, async_req=True)
        >>> result = thread.get()

        Args:
            payee_id (str): The UUID of the payee.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payee_id'] = \
            payee_id
        return self.delete_payee_by_id_v4_endpoint.call_with_http_info(**kwargs)

    def get_payee_by_id_v3(
        self,
        payee_id,
        **kwargs
    ):
        """Get Payee by Id  # noqa: E501

        <p>Use v4 instead</p> <p>Get Payee by Id</p>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payee_by_id_v3(payee_id, async_req=True)
        >>> result = thread.get()

        Args:
            payee_id (str): The UUID of the payee.

        Keyword Args:
            sensitive (bool): Optional. If omitted or set to false, any Personal Identifiable Information (PII) values are returned masked. If set to true, and you have permission, the PII values will be returned as their original unmasked values. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PayeeDetailResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payee_id'] = \
            payee_id
        return self.get_payee_by_id_v3_endpoint.call_with_http_info(**kwargs)

    def get_payee_by_id_v4(
        self,
        payee_id,
        **kwargs
    ):
        """Get Payee by Id  # noqa: E501

        Get Payee by Id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payee_by_id_v4(payee_id, async_req=True)
        >>> result = thread.get()

        Args:
            payee_id (str): The UUID of the payee.

        Keyword Args:
            sensitive (bool): Optional. If omitted or set to false, any Personal Identifiable Information (PII) values are returned masked. If set to true, and you have permission, the PII values will be returned as their original unmasked values. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PayeeDetailResponse2
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payee_id'] = \
            payee_id
        return self.get_payee_by_id_v4_endpoint.call_with_http_info(**kwargs)

    def list_payee_changes_v3(
        self,
        payor_id,
        updated_since,
        **kwargs
    ):
        """List Payee Changes  # noqa: E501

        <p>Use v4 instead</p> <p>Get a paginated response listing payee changes.</p>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payee_changes_v3(payor_id, updated_since, async_req=True)
        >>> result = thread.get()

        Args:
            payor_id (str): The Payor ID to find associated Payees
            updated_since (datetime): The updatedSince filter in the format YYYY-MM-DDThh:mm:ss+hh:mm

        Keyword Args:
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): Page size. Default is 100. Max allowable is 1000.. [optional] if omitted the server will use the default value of 100
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PayeeDeltaResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payor_id'] = \
            payor_id
        kwargs['updated_since'] = \
            updated_since
        return self.list_payee_changes_v3_endpoint.call_with_http_info(**kwargs)

    def list_payee_changes_v4(
        self,
        payor_id,
        updated_since,
        **kwargs
    ):
        """List Payee Changes  # noqa: E501

        Get a paginated response listing payee changes (updated since a particular time) to a limited set of fields: - dbaName - displayName - email - onboardedStatus - payeeCountry - payeeId - remoteId   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payee_changes_v4(payor_id, updated_since, async_req=True)
        >>> result = thread.get()

        Args:
            payor_id (str): The Payor ID to find associated Payees
            updated_since (datetime): The updatedSince filter in the format YYYY-MM-DDThh:mm:ss+hh:mm

        Keyword Args:
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): Page size. Default is 100. Max allowable is 1000.. [optional] if omitted the server will use the default value of 100
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PayeeDeltaResponse2
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payor_id'] = \
            payor_id
        kwargs['updated_since'] = \
            updated_since
        return self.list_payee_changes_v4_endpoint.call_with_http_info(**kwargs)

    def list_payees_v3(
        self,
        payor_id,
        **kwargs
    ):
        """List Payees  # noqa: E501

        <p>Use v4 instead</p> Get a paginated response listing the payees for a payor.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payees_v3(payor_id, async_req=True)
        >>> result = thread.get()

        Args:
            payor_id (str): The account owner Payor ID

        Keyword Args:
            watchlist_status (WatchlistStatus): The watchlistStatus of the payees.. [optional]
            disabled (bool): Payee disabled. [optional]
            onboarded_status (OnboardedStatus): The onboarded status of the payees.. [optional]
            email (str): Email address. [optional]
            display_name (str): The display name of the payees.. [optional]
            remote_id (str): The remote id of the payees.. [optional]
            payee_type (PayeeType2): The onboarded status of the payees.. [optional]
            payee_country (str): The country of the payee - 2 letter ISO 3166-1 country code (upper case). [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): Page size. Default is 25. Max allowable is 100.. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields (e.g. ?sort=onboardedStatus:asc,name:asc) Default is name:asc 'name' is treated as company name for companies - last name + ',' + firstName for individuals The supported sort fields are - payeeId, displayName, payoutStatus, onboardedStatus. . [optional] if omitted the server will use the default value of "displayName:asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PagedPayeeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payor_id'] = \
            payor_id
        return self.list_payees_v3_endpoint.call_with_http_info(**kwargs)

    def list_payees_v4(
        self,
        payor_id,
        **kwargs
    ):
        """List Payees  # noqa: E501

        Get a paginated response listing the payees for a payor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payees_v4(payor_id, async_req=True)
        >>> result = thread.get()

        Args:
            payor_id (str): The account owner Payor ID

        Keyword Args:
            watchlist_status (WatchlistStatus): The watchlistStatus of the payees.. [optional]
            disabled (bool): Payee disabled. [optional]
            onboarded_status (OnboardedStatus): The onboarded status of the payees.. [optional]
            email (str): Email address. [optional]
            display_name (str): The display name of the payees.. [optional]
            remote_id (str): The remote id of the payees.. [optional]
            payee_type (PayeeType2): The onboarded status of the payees.. [optional]
            payee_country (str): The country of the payee - 2 letter ISO 3166-1 country code (upper case). [optional]
            ofac_status (OfacStatus): The ofacStatus of the payees.. [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): Page size. Default is 25. Max allowable is 100.. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields (e.g. ?sort=onboardedStatus:asc,name:asc) Default is name:asc 'name' is treated as company name for companies - last name + ',' + firstName for individuals The supported sort fields are - payeeId, displayName, payoutStatus, onboardedStatus. . [optional] if omitted the server will use the default value of "displayName:asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PagedPayeeResponse2
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payor_id'] = \
            payor_id
        return self.list_payees_v4_endpoint.call_with_http_info(**kwargs)

    def payee_details_update_v3(
        self,
        payee_id,
        update_payee_details_request,
        **kwargs
    ):
        """Update Payee Details  # noqa: E501

        <p>Use v4 instead</p> <p>Update payee details for the given Payee Id.<p>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.payee_details_update_v3(payee_id, update_payee_details_request, async_req=True)
        >>> result = thread.get()

        Args:
            payee_id (str): The UUID of the payee.
            update_payee_details_request (UpdatePayeeDetailsRequest): Request to update payee details

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payee_id'] = \
            payee_id
        kwargs['update_payee_details_request'] = \
            update_payee_details_request
        return self.payee_details_update_v3_endpoint.call_with_http_info(**kwargs)

    def payee_details_update_v4(
        self,
        payee_id,
        update_payee_details_request2,
        **kwargs
    ):
        """Update Payee Details  # noqa: E501

        <p>Update payee details for the given Payee Id.</p> <p>Payors may only update the payee details if the payee has not yet onboarded</p>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.payee_details_update_v4(payee_id, update_payee_details_request2, async_req=True)
        >>> result = thread.get()

        Args:
            payee_id (str): The UUID of the payee.
            update_payee_details_request2 (UpdatePayeeDetailsRequest2): Request to update payee details

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payee_id'] = \
            payee_id
        kwargs['update_payee_details_request2'] = \
            update_payee_details_request2
        return self.payee_details_update_v4_endpoint.call_with_http_info(**kwargs)

    def v3_payees_payee_id_remote_id_update_post(
        self,
        payee_id,
        update_remote_id_request,
        **kwargs
    ):
        """Update Payee Remote Id  # noqa: E501

        <p>Use v4 instead</p> <p>Update the remote Id for the given Payee Id.</p>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v3_payees_payee_id_remote_id_update_post(payee_id, update_remote_id_request, async_req=True)
        >>> result = thread.get()

        Args:
            payee_id (str): The UUID of the payee.
            update_remote_id_request (UpdateRemoteIdRequest): Request to update payee remote id v3

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payee_id'] = \
            payee_id
        kwargs['update_remote_id_request'] = \
            update_remote_id_request
        return self.v3_payees_payee_id_remote_id_update_post_endpoint.call_with_http_info(**kwargs)

    def v4_payees_payee_id_remote_id_update_post(
        self,
        payee_id,
        update_remote_id_request2,
        **kwargs
    ):
        """Update Payee Remote Id  # noqa: E501

        <p>Update the remote Id for the given Payee Id.</p>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v4_payees_payee_id_remote_id_update_post(payee_id, update_remote_id_request2, async_req=True)
        >>> result = thread.get()

        Args:
            payee_id (str): The UUID of the payee.
            update_remote_id_request2 (UpdateRemoteIdRequest2): Request to update payee remote id v4

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payee_id'] = \
            payee_id
        kwargs['update_remote_id_request2'] = \
            update_remote_id_request2
        return self.v4_payees_payee_id_remote_id_update_post_endpoint.call_with_http_info(**kwargs)

