"""
    Velo Payments APIs

    ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response.   # noqa: E501

    The version of the OpenAPI document: 2.29.128
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from velo_payments.api_client import ApiClient, Endpoint as _Endpoint
from velo_payments.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from velo_payments.model.funding_account_response import FundingAccountResponse
from velo_payments.model.funding_account_response2 import FundingAccountResponse2
from velo_payments.model.funding_account_type import FundingAccountType
from velo_payments.model.funding_request_v1 import FundingRequestV1
from velo_payments.model.funding_request_v2 import FundingRequestV2
from velo_payments.model.funding_request_v3 import FundingRequestV3
from velo_payments.model.inline_response400 import InlineResponse400
from velo_payments.model.inline_response401 import InlineResponse401
from velo_payments.model.inline_response403 import InlineResponse403
from velo_payments.model.inline_response404 import InlineResponse404
from velo_payments.model.list_funding_accounts_response import ListFundingAccountsResponse
from velo_payments.model.list_funding_accounts_response2 import ListFundingAccountsResponse2
from velo_payments.model.list_source_account_response import ListSourceAccountResponse
from velo_payments.model.list_source_account_response_v2 import ListSourceAccountResponseV2
from velo_payments.model.list_source_account_response_v3 import ListSourceAccountResponseV3
from velo_payments.model.page_resource_funding_payor_status_audit_response_funding_payor_status_audit_response import PageResourceFundingPayorStatusAuditResponseFundingPayorStatusAuditResponse
from velo_payments.model.set_notifications_request import SetNotificationsRequest
from velo_payments.model.source_account_response import SourceAccountResponse
from velo_payments.model.source_account_response_v2 import SourceAccountResponseV2
from velo_payments.model.source_account_response_v3 import SourceAccountResponseV3
from velo_payments.model.source_account_type import SourceAccountType
from velo_payments.model.transfer_request import TransferRequest
from velo_payments.model.transfer_request2 import TransferRequest2


class FundingManagerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_ach_funding_request_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/sourceAccounts/{sourceAccountId}/achFundingRequest',
                'operation_id': 'create_ach_funding_request',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                    'funding_request_v1',
                ],
                'required': [
                    'source_account_id',
                    'funding_request_v1',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                    'funding_request_v1':
                        (FundingRequestV1,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                    'funding_request_v1': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_funding_request_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v2/sourceAccounts/{sourceAccountId}/fundingRequest',
                'operation_id': 'create_funding_request',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                    'funding_request_v2',
                ],
                'required': [
                    'source_account_id',
                    'funding_request_v2',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                    'funding_request_v2':
                        (FundingRequestV2,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                    'funding_request_v2': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_funding_request_v3_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/sourceAccounts/{sourceAccountId}/fundingRequest',
                'operation_id': 'create_funding_request_v3',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                    'funding_request_v3',
                ],
                'required': [
                    'source_account_id',
                    'funding_request_v3',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                    'funding_request_v3':
                        (FundingRequestV3,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                    'funding_request_v3': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_funding_account_endpoint = _Endpoint(
            settings={
                'response_type': (FundingAccountResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/fundingAccounts/{fundingAccountId}',
                'operation_id': 'get_funding_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'funding_account_id',
                    'sensitive',
                ],
                'required': [
                    'funding_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'funding_account_id':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'funding_account_id': 'fundingAccountId',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'funding_account_id': 'path',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_funding_account_v2_endpoint = _Endpoint(
            settings={
                'response_type': (FundingAccountResponse2,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v2/fundingAccounts/{fundingAccountId}',
                'operation_id': 'get_funding_account_v2',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'funding_account_id',
                    'sensitive',
                ],
                'required': [
                    'funding_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'funding_account_id':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'funding_account_id': 'fundingAccountId',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'funding_account_id': 'path',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_funding_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (ListFundingAccountsResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/fundingAccounts',
                'operation_id': 'get_funding_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'source_account_id',
                    'page',
                    'page_size',
                    'sort',
                    'sensitive',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {

                        'regex': {
                            'pattern': r'[a-zA-Z]+[:desc|:asc]',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'source_account_id':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'source_account_id': 'sourceAccountId',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'payor_id': 'query',
                    'source_account_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_funding_accounts_v2_endpoint = _Endpoint(
            settings={
                'response_type': (ListFundingAccountsResponse2,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v2/fundingAccounts',
                'operation_id': 'get_funding_accounts_v2',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'name',
                    'country',
                    'currency',
                    'type',
                    'page',
                    'page_size',
                    'sort',
                    'sensitive',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {

                        'regex': {
                            'pattern': r'[a-zA-Z]+[:desc|:asc]',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'name':
                        (str,),
                    'country':
                        (str,),
                    'currency':
                        (str,),
                    'type':
                        (FundingAccountType,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                    'sensitive':
                        (bool,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'name': 'name',
                    'country': 'country',
                    'currency': 'currency',
                    'type': 'type',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                    'sensitive': 'sensitive',
                },
                'location_map': {
                    'payor_id': 'query',
                    'name': 'query',
                    'country': 'query',
                    'currency': 'query',
                    'type': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                    'sensitive': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_source_account_endpoint = _Endpoint(
            settings={
                'response_type': (SourceAccountResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/sourceAccounts/{sourceAccountId}',
                'operation_id': 'get_source_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                ],
                'required': [
                    'source_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_source_account_v2_endpoint = _Endpoint(
            settings={
                'response_type': (SourceAccountResponseV2,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v2/sourceAccounts/{sourceAccountId}',
                'operation_id': 'get_source_account_v2',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                ],
                'required': [
                    'source_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_source_account_v3_endpoint = _Endpoint(
            settings={
                'response_type': (SourceAccountResponseV3,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/sourceAccounts/{sourceAccountId}',
                'operation_id': 'get_source_account_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                ],
                'required': [
                    'source_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_source_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (ListSourceAccountResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/sourceAccounts',
                'operation_id': 'get_source_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'physical_account_name',
                    'payor_id',
                    'page',
                    'page_size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {

                        'regex': {
                            'pattern': r'[fundingRef]+[:desc|:asc]',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'physical_account_name':
                        (str,),
                    'payor_id':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'physical_account_name': 'physicalAccountName',
                    'payor_id': 'payorId',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'physical_account_name': 'query',
                    'payor_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_source_accounts_v2_endpoint = _Endpoint(
            settings={
                'response_type': (ListSourceAccountResponseV2,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v2/sourceAccounts',
                'operation_id': 'get_source_accounts_v2',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'physical_account_name',
                    'physical_account_id',
                    'payor_id',
                    'funding_account_id',
                    'page',
                    'page_size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {

                        'regex': {
                            'pattern': r'[fundingRef|name|balance]+[:desc|:asc]',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'physical_account_name':
                        (str,),
                    'physical_account_id':
                        (str,),
                    'payor_id':
                        (str,),
                    'funding_account_id':
                        (str,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'physical_account_name': 'physicalAccountName',
                    'physical_account_id': 'physicalAccountId',
                    'payor_id': 'payorId',
                    'funding_account_id': 'fundingAccountId',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'physical_account_name': 'query',
                    'physical_account_id': 'query',
                    'payor_id': 'query',
                    'funding_account_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_source_accounts_v3_endpoint = _Endpoint(
            settings={
                'response_type': (ListSourceAccountResponseV3,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/sourceAccounts',
                'operation_id': 'get_source_accounts_v3',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'physical_account_name',
                    'physical_account_id',
                    'payor_id',
                    'funding_account_id',
                    'include_user_deleted',
                    'type',
                    'page',
                    'page_size',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('sort',): {

                        'regex': {
                            'pattern': r'[fundingRef|name|balance]+[:desc|:asc]',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'physical_account_name':
                        (str,),
                    'physical_account_id':
                        (str,),
                    'payor_id':
                        (str,),
                    'funding_account_id':
                        (str,),
                    'include_user_deleted':
                        (bool,),
                    'type':
                        (SourceAccountType,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'physical_account_name': 'physicalAccountName',
                    'physical_account_id': 'physicalAccountId',
                    'payor_id': 'payorId',
                    'funding_account_id': 'fundingAccountId',
                    'include_user_deleted': 'includeUserDeleted',
                    'type': 'type',
                    'page': 'page',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'physical_account_name': 'query',
                    'physical_account_id': 'query',
                    'payor_id': 'query',
                    'funding_account_id': 'query',
                    'include_user_deleted': 'query',
                    'type': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_funding_audit_deltas_endpoint = _Endpoint(
            settings={
                'response_type': (PageResourceFundingPayorStatusAuditResponseFundingPayorStatusAuditResponse,),
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/deltas/fundings',
                'operation_id': 'list_funding_audit_deltas',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'payor_id',
                    'updated_since',
                    'page',
                    'page_size',
                ],
                'required': [
                    'payor_id',
                    'updated_since',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payor_id':
                        (str,),
                    'updated_since':
                        (datetime,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'payor_id': 'payorId',
                    'updated_since': 'updatedSince',
                    'page': 'page',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'payor_id': 'query',
                    'updated_since': 'query',
                    'page': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.set_notifications_request_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v1/sourceAccounts/{sourceAccountId}/notifications',
                'operation_id': 'set_notifications_request',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                    'set_notifications_request',
                ],
                'required': [
                    'source_account_id',
                    'set_notifications_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                    'set_notifications_request':
                        (SetNotificationsRequest,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                    'set_notifications_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.transfer_funds_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v2/sourceAccounts/{sourceAccountId}/transfers',
                'operation_id': 'transfer_funds',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                    'transfer_request',
                ],
                'required': [
                    'source_account_id',
                    'transfer_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                    'transfer_request':
                        (TransferRequest,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                    'transfer_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.transfer_funds_v3_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2'
                ],
                'endpoint_path': '/v3/sourceAccounts/{sourceAccountId}/transfers',
                'operation_id': 'transfer_funds_v3',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_account_id',
                    'transfer_request2',
                ],
                'required': [
                    'source_account_id',
                    'transfer_request2',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_account_id':
                        (str,),
                    'transfer_request2':
                        (TransferRequest2,),
                },
                'attribute_map': {
                    'source_account_id': 'sourceAccountId',
                },
                'location_map': {
                    'source_account_id': 'path',
                    'transfer_request2': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_ach_funding_request(
        self,
        source_account_id,
        funding_request_v1,
        **kwargs
    ):
        """Create Funding Request  # noqa: E501

        Instruct a funding request to transfer funds from the payor’s funding bank to the payor’s balance held within Velo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ach_funding_request(source_account_id, funding_request_v1, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): Source account id
            funding_request_v1 (FundingRequestV1): Body to included amount to be funded

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        kwargs['funding_request_v1'] = \
            funding_request_v1
        return self.create_ach_funding_request_endpoint.call_with_http_info(**kwargs)

    def create_funding_request(
        self,
        source_account_id,
        funding_request_v2,
        **kwargs
    ):
        """Create Funding Request  # noqa: E501

        Instruct a funding request to transfer funds from the payor’s funding bank to the payor’s balance held within Velo  (202 - accepted, 400 - invalid request body, 404 - source account not found).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_funding_request(source_account_id, funding_request_v2, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): Source account id
            funding_request_v2 (FundingRequestV2): Body to included amount to be funded

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        kwargs['funding_request_v2'] = \
            funding_request_v2
        return self.create_funding_request_endpoint.call_with_http_info(**kwargs)

    def create_funding_request_v3(
        self,
        source_account_id,
        funding_request_v3,
        **kwargs
    ):
        """Create Funding Request  # noqa: E501

        Instruct a funding request to transfer funds from the payor’s funding bank to the payor’s balance held within Velo  (202 - accepted, 400 - invalid request body, 404 - source account not found).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_funding_request_v3(source_account_id, funding_request_v3, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): Source account id
            funding_request_v3 (FundingRequestV3): Body to included amount to be funded

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        kwargs['funding_request_v3'] = \
            funding_request_v3
        return self.create_funding_request_v3_endpoint.call_with_http_info(**kwargs)

    def get_funding_account(
        self,
        funding_account_id,
        **kwargs
    ):
        """Get Funding Account  # noqa: E501

        Get Funding Account by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_funding_account(funding_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            funding_account_id (str):

        Keyword Args:
            sensitive (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FundingAccountResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['funding_account_id'] = \
            funding_account_id
        return self.get_funding_account_endpoint.call_with_http_info(**kwargs)

    def get_funding_account_v2(
        self,
        funding_account_id,
        **kwargs
    ):
        """Get Funding Account  # noqa: E501

        Get Funding Account by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_funding_account_v2(funding_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            funding_account_id (str):

        Keyword Args:
            sensitive (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FundingAccountResponse2
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['funding_account_id'] = \
            funding_account_id
        return self.get_funding_account_v2_endpoint.call_with_http_info(**kwargs)

    def get_funding_accounts(
        self,
        **kwargs
    ):
        """Get Funding Accounts  # noqa: E501

        Get the funding accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_funding_accounts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            payor_id (str): [optional]
            source_account_id (str): [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields (e.g. ?sort=accountName:asc,name:asc) Default is accountName:asc The supported sort fields are - accountName, name and currency.. [optional] if omitted the server will use the default value of "accountName:asc"
            sensitive (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListFundingAccountsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_funding_accounts_endpoint.call_with_http_info(**kwargs)

    def get_funding_accounts_v2(
        self,
        **kwargs
    ):
        """Get Funding Accounts  # noqa: E501

        Get the funding accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_funding_accounts_v2(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            payor_id (str): [optional]
            name (str): The descriptive funding account name. [optional]
            country (str): The 2 letter ISO 3166-1 country code (upper case). [optional]
            currency (str): The ISO 4217 currency code. [optional]
            type (FundingAccountType): The type of funding account.. [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields (e.g. ?sort=accountName:asc,name:asc) Default is accountName:asc The supported sort fields are - accountName, name.. [optional] if omitted the server will use the default value of "accountName:asc"
            sensitive (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListFundingAccountsResponse2
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_funding_accounts_v2_endpoint.call_with_http_info(**kwargs)

    def get_source_account(
        self,
        source_account_id,
        **kwargs
    ):
        """Get details about given source account.  # noqa: E501

        Get details about given source account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_source_account(source_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): Source account id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SourceAccountResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        return self.get_source_account_endpoint.call_with_http_info(**kwargs)

    def get_source_account_v2(
        self,
        source_account_id,
        **kwargs
    ):
        """Get details about given source account.  # noqa: E501

        Get details about given source account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_source_account_v2(source_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): Source account id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SourceAccountResponseV2
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        return self.get_source_account_v2_endpoint.call_with_http_info(**kwargs)

    def get_source_account_v3(
        self,
        source_account_id,
        **kwargs
    ):
        """Get details about given source account.  # noqa: E501

        Get details about given source account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_source_account_v3(source_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): Source account id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SourceAccountResponseV3
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        return self.get_source_account_v3_endpoint.call_with_http_info(**kwargs)

    def get_source_accounts(
        self,
        **kwargs
    ):
        """Get list of source accounts  # noqa: E501

        List source accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_source_accounts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            physical_account_name (str): Physical Account Name. [optional]
            payor_id (str): The account owner Payor ID. [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields e.g. ?sort=name:asc Default is name:asc The supported sort fields are - fundingRef . [optional] if omitted the server will use the default value of "fundingRef:asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListSourceAccountResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_source_accounts_endpoint.call_with_http_info(**kwargs)

    def get_source_accounts_v2(
        self,
        **kwargs
    ):
        """Get list of source accounts  # noqa: E501

        List source accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_source_accounts_v2(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            physical_account_name (str): Physical Account Name. [optional]
            physical_account_id (str): The physical account ID. [optional]
            payor_id (str): The account owner Payor ID. [optional]
            funding_account_id (str): The funding account ID. [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields e.g. ?sort=name:asc Default is name:asc The supported sort fields are - fundingRef, name, balance . [optional] if omitted the server will use the default value of "fundingRef:asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListSourceAccountResponseV2
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_source_accounts_v2_endpoint.call_with_http_info(**kwargs)

    def get_source_accounts_v3(
        self,
        **kwargs
    ):
        """Get list of source accounts  # noqa: E501

        List source accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_source_accounts_v3(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            physical_account_name (str): Physical Account Name. [optional]
            physical_account_id (str): The physical account ID. [optional]
            payor_id (str): The account owner Payor ID. [optional]
            funding_account_id (str): The funding account ID. [optional]
            include_user_deleted (bool): A filter for retrieving both active accounts and user deleted ones. [optional]
            type (SourceAccountType): The type of source account.. [optional]
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            sort (str): List of sort fields e.g. ?sort=name:asc Default is name:asc The supported sort fields are - fundingRef, name, balance . [optional] if omitted the server will use the default value of "fundingRef:asc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListSourceAccountResponseV3
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_source_accounts_v3_endpoint.call_with_http_info(**kwargs)

    def list_funding_audit_deltas(
        self,
        payor_id,
        updated_since,
        **kwargs
    ):
        """Get Funding Audit Delta  # noqa: E501

        Get funding audit deltas for a payor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_funding_audit_deltas(payor_id, updated_since, async_req=True)
        >>> result = thread.get()

        Args:
            payor_id (str):
            updated_since (datetime):

        Keyword Args:
            page (int): Page number. Default is 1.. [optional] if omitted the server will use the default value of 1
            page_size (int): The number of results to return in a page. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PageResourceFundingPayorStatusAuditResponseFundingPayorStatusAuditResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['payor_id'] = \
            payor_id
        kwargs['updated_since'] = \
            updated_since
        return self.list_funding_audit_deltas_endpoint.call_with_http_info(**kwargs)

    def set_notifications_request(
        self,
        source_account_id,
        set_notifications_request,
        **kwargs
    ):
        """Set notifications  # noqa: E501

        Set notifications for a given source account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_notifications_request(source_account_id, set_notifications_request, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): Source account id
            set_notifications_request (SetNotificationsRequest): Body to included minimum balance to set

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        kwargs['set_notifications_request'] = \
            set_notifications_request
        return self.set_notifications_request_endpoint.call_with_http_info(**kwargs)

    def transfer_funds(
        self,
        source_account_id,
        transfer_request,
        **kwargs
    ):
        """Transfer Funds between source accounts  # noqa: E501

        Transfer funds between source accounts for a Payor. The 'from' source account is identified in the URL, and is the account which will be debited. The 'to' (destination) source account is in the body, and is the account which will be credited. Both source accounts must belong to the same Payor. There must be sufficient balance in the 'from' source account, otherwise the transfer attempt will fail.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transfer_funds(source_account_id, transfer_request, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): The 'from' source account id, which will be debited
            transfer_request (TransferRequest): Body

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        kwargs['transfer_request'] = \
            transfer_request
        return self.transfer_funds_endpoint.call_with_http_info(**kwargs)

    def transfer_funds_v3(
        self,
        source_account_id,
        transfer_request2,
        **kwargs
    ):
        """Transfer Funds between source accounts  # noqa: E501

        Transfer funds between source accounts for a Payor. The 'from' source account is identified in the URL, and is the account which will be debited. The 'to' (destination) source account is in the body, and is the account which will be credited. Both source accounts must belong to the same Payor. There must be sufficient balance in the 'from' source account, otherwise the transfer attempt will fail.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transfer_funds_v3(source_account_id, transfer_request2, async_req=True)
        >>> result = thread.get()

        Args:
            source_account_id (str): The 'from' source account id, which will be debited
            transfer_request2 (TransferRequest2): Body

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_account_id'] = \
            source_account_id
        kwargs['transfer_request2'] = \
            transfer_request2
        return self.transfer_funds_v3_endpoint.call_with_http_info(**kwargs)

