import * as cloudmap from '@aws-cdk/aws-servicediscovery';
import * as cdk from '@aws-cdk/core';
import { CfnVirtualNode } from './appmesh.generated';
/**
 * (experimental) Represents the properties needed to define CloudMap Service Discovery.
 *
 * @experimental
 */
export interface CloudMapServiceDiscoveryOptions {
    /**
     * (experimental) The AWS Cloud Map Service to use for service discovery.
     *
     * @experimental
     */
    readonly service: cloudmap.IService;
    /**
     * (experimental) A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
     *
     * Only instances that match all of the specified
     * key/value pairs will be returned.
     *
     * @default - no instance attributes
     * @experimental
     */
    readonly instanceAttributes?: {
        [key: string]: string;
    };
}
/**
 * (experimental) Properties for VirtualNode Service Discovery.
 *
 * @experimental
 */
export interface ServiceDiscoveryConfig {
    /**
     * (experimental) DNS based Service Discovery.
     *
     * @default - no DNS based service discovery
     * @experimental
     */
    readonly dns?: CfnVirtualNode.DnsServiceDiscoveryProperty;
    /**
     * (experimental) Cloud Map based Service Discovery.
     *
     * @default - no Cloud Map based service discovery
     * @experimental
     */
    readonly cloudmap?: CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty;
}
/**
 * (experimental) Provides the Service Discovery method a VirtualNode uses.
 *
 * @experimental
 */
export declare abstract class ServiceDiscovery {
    /**
     * (experimental) Returns DNS based service discovery.
     *
     * @experimental
     */
    static dns(hostname: string): ServiceDiscovery;
    /**
     * (experimental) Returns Cloud Map based service discovery.
     *
     * @experimental
     */
    static cloudMap(options: CloudMapServiceDiscoveryOptions): ServiceDiscovery;
    /**
     * (experimental) Binds the current object when adding Service Discovery to a VirtualNode.
     *
     * @experimental
     */
    abstract bind(scope: cdk.Construct): ServiceDiscoveryConfig;
}
