# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['bootstrap_datepicker_plus']

package_data = \
{'': ['*'],
 'bootstrap_datepicker_plus': ['static/bootstrap_datepicker_plus/css/*',
                               'static/bootstrap_datepicker_plus/js/*',
                               'templates/bootstrap_datepicker_plus/*']}

install_requires = \
['Django>=2,<5', 'pydantic', 'typing-extensions']

setup_kwargs = {
    'name': 'django-bootstrap-datepicker-plus',
    'version': '5.0.1',
    'description': 'Bootstrap3/Bootstrap4/Bootstrap5 DatePickerInput, TimePickerInput, DateTimePickerInput, MonthPickerInput, YearPickerInput',
    'long_description': '########################################\ndjango-bootstrap-datepicker-plus\n########################################\n\nThis django widget contains Bootstrap 3, Bootstrap 4 and Bootstrap 5\nDate-Picker, Time-Picker, DateTime-Picker, Month-Picker and Year-Picker input\nwith date-range-picker functionality for django version >= 2.0.\nThe widget implements `bootstrap-datetimepicker v4 <https://getdatepicker.com/4/>`_\nto show bootstrap-datepicker in django model forms and custom forms\nwhich can be configured easily for date-range selection.\n\nIf you are not using Bootstrap use `django-flatpickr <https://github.com/monim67/django-flatpickr>`_ instead.\n\n|  |build-status| |docs-status| |coverage|\n|  |pyversions| |djversions| |license|\n\n|  |date-picker-image| |datetime-picker-image| |time-picker-image|\n\n\n\n********************\nDemo\n********************\n\n- `With Bootstrap 3 <https://monim67.github.io/django-bootstrap-datepicker-plus/demo/bootstrap3/>`_\n- `With Bootstrap 4 <https://monim67.github.io/django-bootstrap-datepicker-plus/demo/bootstrap4/>`_\n- `With Bootstrap 5 <https://monim67.github.io/django-bootstrap-datepicker-plus/demo/bootstrap5/>`_\n\n\n\n********************\nGetting Started\n********************\n\n- Follow the `Getting Started doc <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/Getting_Started.html>`_.\n- Head over to `Usage <#usage>`_ section to see how to use it in forms and views.\n- Read detailed `Documentation on ReadTheDocs <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/>`_\n- Looks complex to get started? Follow a `Quick Walkthrough Tutorial <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/Walkthrough.html>`_\n- Getting errors? See `Troubleshoot instructions <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/Troubleshooting.html>`_\n\n\n\n********************\nUsage\n********************\n\n\n++++++++++++++++++++++++++++++\nUsage in Generic View\n++++++++++++++++++++++++++++++\n\n.. code:: python\n\n    # File: views.py\n    from bootstrap_datepicker_plus.widgets import DateTimePickerInput\n    from django.views import generic\n    from .models import Question\n\n    class CreateView(generic.edit.CreateView):\n        model = Question\n        fields = ["question_text", "pub_date"]\n        def get_form(self):\n            form = super().get_form()\n            form.fields["pub_date"].widget = DateTimePickerInput()\n            return form\n\n\n++++++++++++++++++++++++++++++\nAdvanced Usage\n++++++++++++++++++++++++++++++\n\n- `Usage in Custom Form <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/Usage.html#custom-form-usage>`_\n- `Usage in Model Form <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/Usage.html#model-form-usage>`_\n- `Usage doc <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/Usage.html>`_\n\n\n++++++++++++++++++++++++++++++\nTypes of DatePickers\n++++++++++++++++++++++++++++++\n\nThe widget contains all types of date-picker you may ever need.\n\n.. code:: python\n\n    # File: forms.py\n    from bootstrap_datepicker_plus.widgets import DatePickerInput, TimePickerInput, DateTimePickerInput, MonthPickerInput, YearPickerInput\n    from django import forms\n\n    class EventForm(forms.ModelForm):\n        class Meta:\n            model = Event\n            fields = ["start_date", "start_time", "start_datetime", "start_month", "start_year"]\n            widgets = {\n                "start_date": DatePickerInput(),\n                "start_time": TimePickerInput(),\n                "start_datetime": DateTimePickerInput(),\n                "start_month": MonthPickerInput(),\n                "start_year": YearPickerInput(),\n            }\n\n\n++++++++++++++++++++++++++++++\nImplement date-range-picker\n++++++++++++++++++++++++++++++\n\nDatePickers can be linked to select a date-range or time-range.\n\n.. code:: python\n\n    # File: forms.py\n    from bootstrap_datepicker_plus.widgets import DatePickerInput, TimePickerInput\n    from django import forms\n\n    class EventForm(forms.ModelForm):\n        class Meta:\n            model = Event\n            fields = ["name", "start_date", "end_date", "start_time", "end_time"]\n            widgets = {\n                "start_date": DatePickerInput(),\n                "end_date": DatePickerInput(range_from="start_date"),\n                "start_time": TimePickerInput(),\n                "end_time": TimePickerInput(range_from="start_time"),\n            }\n\n\n++++++++++++++++++++++++++++++\nCustomization\n++++++++++++++++++++++++++++++\n\n- `Customize date format, language <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/customization.html>`_\n- `Use custom template for widget input <https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/Template_Customizing.html>`_\n\n\n********************\nContributing\n********************\n\n- `CONTRIBUTING.md <https://github.com/monim67/django-bootstrap-datepicker-plus/blob/master/.github/CONTRIBUTING.md>`_.\n- `CODE_OF_CONDUCT.md <https://github.com/monim67/django-bootstrap-datepicker-plus/blob/master/.github/CODE_OF_CONDUCT.md>`_.\n\n********************\nLicense\n********************\n\nThis project is licensed under `MIT LICENSE <https://github.com/monim67/django-bootstrap-datepicker-plus/blob/master/LICENSE>`_ file for details.\n\n********************\nAcknowledgments\n********************\n\nThis project implements `Eonasdan/bootstrap-datetimepicker <https://github.com/Eonasdan/bootstrap-datetimepicker>`_ to display date-pickers.\nThe project was initially forked from `pbucher/django-bootstrap-datepicker <https://github.com/pbucher/django-bootstrap-datepicker>`_ and\nlater reworked completely under MIT Licence.\n\n\n|buymeacoffee|\n\n\n.. |date-picker-image| image:: https://raw.githubusercontent.com/monim67/django-bootstrap-datepicker-plus/26d89a744d403a895422313a48c02885c4718251/images/date-picker.png\n    :alt: Date-picker\n    :width: 218px\n    :height: 280px\n\n.. |datetime-picker-image| image:: https://raw.githubusercontent.com/monim67/django-bootstrap-datepicker-plus/26d89a744d403a895422313a48c02885c4718251/images/datetime-picker.png\n    :alt: Datetime-picker\n    :width: 218px\n    :height: 280px\n\n.. |time-picker-image| image:: https://raw.githubusercontent.com/monim67/django-bootstrap-datepicker-plus/26d89a744d403a895422313a48c02885c4718251/images/time-picker.png\n    :alt: Time-picker\n    :width: 218px\n    :height: 280px\n\n.. |build-status| image:: https://github.com/monim67/django-bootstrap-datepicker-plus/actions/workflows/build.yml/badge.svg?event=push\n    :target: https://github.com/monim67/django-bootstrap-datepicker-plus/actions/workflows/build.yml\n    :alt: Build Status\n    :height: 20px\n\n.. |docs-status| image:: https://readthedocs.org/projects/django-bootstrap-datepicker-plus/badge/?version=latest\n    :target: https://django-bootstrap-datepicker-plus.readthedocs.io/en/latest/?badge=latest\n    :alt: Documentation Status\n    :height: 20px\n\n.. |coverage| image:: https://coveralls.io/repos/github/monim67/django-bootstrap-datepicker-plus/badge.svg?branch=master\n    :target: https://coveralls.io/github/monim67/django-bootstrap-datepicker-plus?branch=master\n    :alt: Coverage Status\n    :height: 20px\n\n.. |pyversions| image:: https://img.shields.io/pypi/pyversions/django-bootstrap-datepicker-plus.svg\n    :target: https://pypi.python.org/pypi/django-bootstrap-datepicker-plus\n    :alt: Python Versions\n    :height: 20px\n\n.. |djversions| image:: https://img.shields.io/pypi/djversions/django-bootstrap-datepicker-plus.svg\n    :target: https://pypi.python.org/pypi/django-bootstrap-datepicker-plus\n    :alt: DJango Versions\n    :height: 20px\n\n.. |license| image:: https://img.shields.io/pypi/l/django-bootstrap-datepicker-plus.svg\n    :target: https://pypi.python.org/pypi/django-bootstrap-datepicker-plus\n    :alt: Licence\n    :height: 20px\n\n.. |buymeacoffee| image:: https://cdn.buymeacoffee.com/buttons/v2/default-orange.png\n   :target: https://www.buymeacoffee.com/monim67\n   :alt: Buy Me A Coffee\n   :height: 48px\n',
    'author': 'Munim Munna',
    'author_email': '6266677+monim67@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/monim67/django-bootstrap-datepicker-plus',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
