import os
from setuptools import setup, Command


class CleanCommand(Command):
    """Custom clean command to tidy up the project root."""

    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        os.system("rm -vrf ./build ./dist ./*.pyc ./*.tgz ./*.egg-info")


# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))


README = open(os.path.join(os.path.dirname(__file__), "README.rst")).read()
CHANGELOG = open(os.path.join(os.path.dirname(__file__), "CHANGELOG.rst")).read()


setup(
    name="pyapns_client3",
    version="3.0.2",
    packages=["pyapns_client"],
    include_package_data=True,
    license="MIT License",
    description="Simple, flexible and fast Apple Push Notifications on iOS, OSX and Safari using the HTTP/2 Push provider API with async support.",
    long_description="\n\n".join([README, CHANGELOG]),
    keywords="apns apple ios osx safari push notifications",
    url="https://github.com/capcom6/pyapns_client",
    author="Jakub Kleň",
    author_email="kukosk@gmail.com",
    maintainer="Aleksandr Soloshenko",
    maintainer_email="capcom2me@gmail.com",
    platforms="any",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "License :: OSI Approved :: MIT License",
        "Topic :: Communications",
        "Topic :: Internet",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Utilities",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
    ],
    cmdclass={
        "clean": CleanCommand,
    },
    install_requires=[
        "httpx[http2]",
        "PyJWT>=2",
        "cryptography",
        "pytz",
    ],
)
