# openapi-client
Welcome to the Gr4vy API reference documentation. Our API is still very much a work in product and subject to change.

The `openapi_client` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.0-beta
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://gr4vy.com](https://gr4vy.com)

## Requirements.

Python >= 3.6

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3
* python-dateutil

## Getting Started

In your own code, to use this library to connect and interact with openapi-client,
you can run the following:

```python

import time
import openapi_client
from pprint import pprint
from openapi_client.api import buyers_api
from openapi_client.model.buyer import Buyer
from openapi_client.model.buyer_request import BuyerRequest
from openapi_client.model.buyer_update import BuyerUpdate
from openapi_client.model.buyers import Buyers
from openapi_client.model.error401_unauthorized import Error401Unauthorized
from openapi_client.model.error404_not_found import Error404NotFound
from openapi_client.model.error409_duplicate_record import Error409DuplicateRecord
from openapi_client.model.error_generic import ErrorGeneric
# Defining the host is optional and defaults to https://api.plantly.gr4vy.app
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.plantly.gr4vy.app"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): BearerAuth
configuration = openapi_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = buyers_api.BuyersApi(api_client)
    buyer_request = BuyerRequest(
        external_identifier="user-789123",
        display_name="John L.",
        billing_details=,
    ) # BuyerRequest |  (optional)

    try:
        # New buyer
        api_response = api_instance.add_buyer(buyer_request=buyer_request)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling BuyersApi->add_buyer: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.plantly.gr4vy.app*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BuyersApi* | [**add_buyer**](openapi_client/docs/BuyersApi.md#add_buyer) | **POST** /buyers | New buyer
*BuyersApi* | [**delete_buyer**](openapi_client/docs/BuyersApi.md#delete_buyer) | **DELETE** /buyers/{buyer_id} | Delete buyer
*BuyersApi* | [**get_buyer**](openapi_client/docs/BuyersApi.md#get_buyer) | **GET** /buyers/{buyer_id} | Get buyer
*BuyersApi* | [**list_buyers**](openapi_client/docs/BuyersApi.md#list_buyers) | **GET** /buyers | List buyers
*BuyersApi* | [**update_buyer**](openapi_client/docs/BuyersApi.md#update_buyer) | **PUT** /buyers/{buyer_id} | Update buyer
*DigitalWalletsApi* | [**deregister_digital_wallet**](openapi_client/docs/DigitalWalletsApi.md#deregister_digital_wallet) | **DELETE** /digital-wallets/{digital_wallet_id} | De-register digital wallet
*DigitalWalletsApi* | [**get_digital_wallet**](openapi_client/docs/DigitalWalletsApi.md#get_digital_wallet) | **GET** /digital-wallets/{digital_wallet_id} | Get digital wallet
*DigitalWalletsApi* | [**list_digital_wallets**](openapi_client/docs/DigitalWalletsApi.md#list_digital_wallets) | **GET** /digital-wallets | List digital wallets
*DigitalWalletsApi* | [**register_digital_wallet**](openapi_client/docs/DigitalWalletsApi.md#register_digital_wallet) | **POST** /digital-wallets | Register digital wallet
*DigitalWalletsApi* | [**update_digital_wallet**](openapi_client/docs/DigitalWalletsApi.md#update_digital_wallet) | **PUT** /digital-wallets/{digital_wallet_id} | Update digital wallet
*PaymentMethodTokensApi* | [**list_payment_method_tokens**](openapi_client/docs/PaymentMethodTokensApi.md#list_payment_method_tokens) | **GET** /payment-methods/{payment_method_id}/tokens | List payment method tokens
*PaymentMethodsApi* | [**delete_payment_method**](openapi_client/docs/PaymentMethodsApi.md#delete_payment_method) | **DELETE** /payment-methods/{payment_method_id} | Delete payment method
*PaymentMethodsApi* | [**get_payment_method**](openapi_client/docs/PaymentMethodsApi.md#get_payment_method) | **GET** /payment-methods/{payment_method_id} | Get stored payment method
*PaymentMethodsApi* | [**list_buyer_payment_methods**](openapi_client/docs/PaymentMethodsApi.md#list_buyer_payment_methods) | **GET** /buyers/payment-methods | List stored payment methods for a buyer
*PaymentMethodsApi* | [**list_payment_methods**](openapi_client/docs/PaymentMethodsApi.md#list_payment_methods) | **GET** /payment-methods | List payment methods
*PaymentMethodsApi* | [**store_payment_method**](openapi_client/docs/PaymentMethodsApi.md#store_payment_method) | **POST** /payment-methods | New payment method
*PaymentOptionsApi* | [**list_payment_options**](openapi_client/docs/PaymentOptionsApi.md#list_payment_options) | **GET** /payment-options | List payment options
*PaymentServiceDefinitionsApi* | [**get_payment_service_definition**](openapi_client/docs/PaymentServiceDefinitionsApi.md#get_payment_service_definition) | **GET** /payment-service-definitions/{payment_service_definition_id} | Get payment service definition
*PaymentServiceDefinitionsApi* | [**list_payment_service_definitions**](openapi_client/docs/PaymentServiceDefinitionsApi.md#list_payment_service_definitions) | **GET** /payment-service-definitions | List payment service definitions
*PaymentServicesApi* | [**add_payment_service**](openapi_client/docs/PaymentServicesApi.md#add_payment_service) | **POST** /payment-services | New payment service
*PaymentServicesApi* | [**delete_payment_service**](openapi_client/docs/PaymentServicesApi.md#delete_payment_service) | **DELETE** /payment-services/{payment_service_id} | Delete payment service
*PaymentServicesApi* | [**get_payment_service**](openapi_client/docs/PaymentServicesApi.md#get_payment_service) | **GET** /payment-services/{payment_service_id} | Get payment service
*PaymentServicesApi* | [**list_payment_services**](openapi_client/docs/PaymentServicesApi.md#list_payment_services) | **GET** /payment-services | List payment services
*PaymentServicesApi* | [**update_payment_service**](openapi_client/docs/PaymentServicesApi.md#update_payment_service) | **PUT** /payment-services/{payment_service_id} | Update payment service
*TransactionsApi* | [**authorize_new_transaction**](openapi_client/docs/TransactionsApi.md#authorize_new_transaction) | **POST** /transactions | New transaction
*TransactionsApi* | [**capture_transaction**](openapi_client/docs/TransactionsApi.md#capture_transaction) | **POST** /transactions/{transaction_id}/capture | Capture transaction
*TransactionsApi* | [**get_transaction**](openapi_client/docs/TransactionsApi.md#get_transaction) | **GET** /transactions/{transaction_id} | Get transaction
*TransactionsApi* | [**list_transactions**](openapi_client/docs/TransactionsApi.md#list_transactions) | **GET** /transactions | List transactions
*TransactionsApi* | [**refund_transaction**](openapi_client/docs/TransactionsApi.md#refund_transaction) | **POST** /transactions/{transaction_id}/refund | Refund or void transactions


## Documentation For Models

 - [Address](openapi_client/docs/Address.md)
 - [AddressUpdate](openapi_client/docs/AddressUpdate.md)
 - [ApplePayRequest](openapi_client/docs/ApplePayRequest.md)
 - [ApplePaySessionRequest](openapi_client/docs/ApplePaySessionRequest.md)
 - [BillingDetails](openapi_client/docs/BillingDetails.md)
 - [BillingDetailsUpdateRequest](openapi_client/docs/BillingDetailsUpdateRequest.md)
 - [Buyer](openapi_client/docs/Buyer.md)
 - [BuyerRequest](openapi_client/docs/BuyerRequest.md)
 - [BuyerSnapshot](openapi_client/docs/BuyerSnapshot.md)
 - [BuyerUpdate](openapi_client/docs/BuyerUpdate.md)
 - [Buyers](openapi_client/docs/Buyers.md)
 - [CardRequest](openapi_client/docs/CardRequest.md)
 - [DigitalWallet](openapi_client/docs/DigitalWallet.md)
 - [DigitalWalletRequest](openapi_client/docs/DigitalWalletRequest.md)
 - [DigitalWalletUpdate](openapi_client/docs/DigitalWalletUpdate.md)
 - [DigitalWallets](openapi_client/docs/DigitalWallets.md)
 - [Error400BadRequest](openapi_client/docs/Error400BadRequest.md)
 - [Error400IncorrectJson](openapi_client/docs/Error400IncorrectJson.md)
 - [Error401Unauthorized](openapi_client/docs/Error401Unauthorized.md)
 - [Error403Forbidden](openapi_client/docs/Error403Forbidden.md)
 - [Error404NotFound](openapi_client/docs/Error404NotFound.md)
 - [Error404PendingCreation](openapi_client/docs/Error404PendingCreation.md)
 - [Error409DuplicateRecord](openapi_client/docs/Error409DuplicateRecord.md)
 - [ErrorDetail](openapi_client/docs/ErrorDetail.md)
 - [ErrorGeneric](openapi_client/docs/ErrorGeneric.md)
 - [PaymentMethod](openapi_client/docs/PaymentMethod.md)
 - [PaymentMethodRequest](openapi_client/docs/PaymentMethodRequest.md)
 - [PaymentMethodSnapshot](openapi_client/docs/PaymentMethodSnapshot.md)
 - [PaymentMethodToken](openapi_client/docs/PaymentMethodToken.md)
 - [PaymentMethodTokenized](openapi_client/docs/PaymentMethodTokenized.md)
 - [PaymentMethodTokens](openapi_client/docs/PaymentMethodTokens.md)
 - [PaymentMethods](openapi_client/docs/PaymentMethods.md)
 - [PaymentMethodsTokenized](openapi_client/docs/PaymentMethodsTokenized.md)
 - [PaymentOption](openapi_client/docs/PaymentOption.md)
 - [PaymentOptionContext](openapi_client/docs/PaymentOptionContext.md)
 - [PaymentOptions](openapi_client/docs/PaymentOptions.md)
 - [PaymentService](openapi_client/docs/PaymentService.md)
 - [PaymentServiceDefinition](openapi_client/docs/PaymentServiceDefinition.md)
 - [PaymentServiceDefinitionFields](openapi_client/docs/PaymentServiceDefinitionFields.md)
 - [PaymentServiceDefinitionSupportedFeatures](openapi_client/docs/PaymentServiceDefinitionSupportedFeatures.md)
 - [PaymentServiceDefinitions](openapi_client/docs/PaymentServiceDefinitions.md)
 - [PaymentServiceRequest](openapi_client/docs/PaymentServiceRequest.md)
 - [PaymentServiceRequestAllOf](openapi_client/docs/PaymentServiceRequestAllOf.md)
 - [PaymentServiceSnapshot](openapi_client/docs/PaymentServiceSnapshot.md)
 - [PaymentServiceUpdate](openapi_client/docs/PaymentServiceUpdate.md)
 - [PaymentServiceUpdateFields](openapi_client/docs/PaymentServiceUpdateFields.md)
 - [PaymentServices](openapi_client/docs/PaymentServices.md)
 - [RedirectRequest](openapi_client/docs/RedirectRequest.md)
 - [ResetPasswordRequest](openapi_client/docs/ResetPasswordRequest.md)
 - [SetPasswordRequest](openapi_client/docs/SetPasswordRequest.md)
 - [TaxId](openapi_client/docs/TaxId.md)
 - [ThreeDSecureData](openapi_client/docs/ThreeDSecureData.md)
 - [ThreeDSecureDataV1](openapi_client/docs/ThreeDSecureDataV1.md)
 - [ThreeDSecureDataV1AllOf](openapi_client/docs/ThreeDSecureDataV1AllOf.md)
 - [ThreeDSecureDataV1V2](openapi_client/docs/ThreeDSecureDataV1V2.md)
 - [ThreeDSecureDataV2](openapi_client/docs/ThreeDSecureDataV2.md)
 - [ThreeDSecureDataV2AllOf](openapi_client/docs/ThreeDSecureDataV2AllOf.md)
 - [TokenizedRequest](openapi_client/docs/TokenizedRequest.md)
 - [Transaction](openapi_client/docs/Transaction.md)
 - [TransactionCaptureRequest](openapi_client/docs/TransactionCaptureRequest.md)
 - [TransactionPaymentMethodRequest](openapi_client/docs/TransactionPaymentMethodRequest.md)
 - [TransactionRefundRequest](openapi_client/docs/TransactionRefundRequest.md)
 - [TransactionRequest](openapi_client/docs/TransactionRequest.md)
 - [TransactionSummary](openapi_client/docs/TransactionSummary.md)
 - [Transactions](openapi_client/docs/Transactions.md)
 - [TransactionsBatchCaptureRequest](openapi_client/docs/TransactionsBatchCaptureRequest.md)
 - [UserRequest](openapi_client/docs/UserRequest.md)


## Documentation For Authorization


## BearerAuth

- **Type**: Bearer authentication (JWT)


## Author

code@gr4vy.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in openapi_client.apis and openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from openapi_client.api.default_api import DefaultApi`
- `from openapi_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import openapi_client
from openapi_client.apis import *
from openapi_client.models import *
```

