"""
    Gr4vy API

    Welcome to the Gr4vy API reference documentation. Our API is still very much a work in product and subject to change.  # noqa: E501

    The version of the OpenAPI document: 1.1.0-beta
    Contact: code@gr4vy.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gr4vy.gr4vy_api.openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from gr4vy.gr4vy_api.openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gr4vy.gr4vy_api.openapi_client.model.error401_unauthorized import Error401Unauthorized
from gr4vy.gr4vy_api.openapi_client.model.error_generic import ErrorGeneric
from gr4vy.gr4vy_api.openapi_client.model.transaction import Transaction
from gr4vy.gr4vy_api.openapi_client.model.transaction_capture_request import TransactionCaptureRequest
from gr4vy.gr4vy_api.openapi_client.model.transaction_refund_request import TransactionRefundRequest
from gr4vy.gr4vy_api.openapi_client.model.transaction_request import TransactionRequest
from gr4vy.gr4vy_api.openapi_client.model.transactions import Transactions


class TransactionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __authorize_new_transaction(
            self,
            **kwargs
        ):
            """New transaction  # noqa: E501

            Attempts to create an authorization for a payment method. In some cases it is not possible to create the authorization without redirecting the user for their authorization. In these cases the status is set to `buyer_approval_pending` and an `approval_url` is returned.  Additionally, this endpoint accepts a few additional fields that allow for simultaneous capturing and storage of the payment method.  * `store` - Use this field to store the payment method for future use. Not all payment methods support this feature. * `capture` - Use this method to also perform a capture of the transaction after it has been authorized.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.authorize_new_transaction(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                transaction_request (TransactionRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Transaction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.authorize_new_transaction = _Endpoint(
            settings={
                'response_type': (Transaction,),
                'auth': [
                    'BearerAuth'
                ],
                'endpoint_path': '/transactions',
                'operation_id': 'authorize_new_transaction',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_request':
                        (TransactionRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'transaction_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__authorize_new_transaction
        )

        def __capture_transaction(
            self,
            transaction_id,
            **kwargs
        ):
            """Capture transaction  # noqa: E501

            Captures a previously authorized transaction.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.capture_transaction(transaction_id, async_req=True)
            >>> result = thread.get()

            Args:
                transaction_id (str): The ID for the transaction to get the information for.

            Keyword Args:
                transaction_capture_request (TransactionCaptureRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Transaction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transaction_id'] = \
                transaction_id
            return self.call_with_http_info(**kwargs)

        self.capture_transaction = _Endpoint(
            settings={
                'response_type': (Transaction,),
                'auth': [
                    'BearerAuth'
                ],
                'endpoint_path': '/transactions/{transaction_id}/capture',
                'operation_id': 'capture_transaction',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_id',
                    'transaction_capture_request',
                ],
                'required': [
                    'transaction_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_id':
                        (str,),
                    'transaction_capture_request':
                        (TransactionCaptureRequest,),
                },
                'attribute_map': {
                    'transaction_id': 'transaction_id',
                },
                'location_map': {
                    'transaction_id': 'path',
                    'transaction_capture_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__capture_transaction
        )

        def __get_transaction(
            self,
            transaction_id,
            **kwargs
        ):
            """Get transaction  # noqa: E501

            Get information about a transaction.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_transaction(transaction_id, async_req=True)
            >>> result = thread.get()

            Args:
                transaction_id (str): The ID for the transaction to get the information for.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Transaction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transaction_id'] = \
                transaction_id
            return self.call_with_http_info(**kwargs)

        self.get_transaction = _Endpoint(
            settings={
                'response_type': (Transaction,),
                'auth': [
                    'BearerAuth'
                ],
                'endpoint_path': '/transactions/{transaction_id}',
                'operation_id': 'get_transaction',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_id',
                ],
                'required': [
                    'transaction_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_id':
                        (str,),
                },
                'attribute_map': {
                    'transaction_id': 'transaction_id',
                },
                'location_map': {
                    'transaction_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_transaction
        )

        def __list_transactions(
            self,
            **kwargs
        ):
            """List transactions  # noqa: E501

            Lists all transactions for an account. Sorted by last `updated_at` status.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_transactions(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                search (str): Filters the transactions to only the items for which the `id` or `external_identifier` matches this value. This field allows for a partial match, matching any transaction for which either of the fields partially or completely matches.. [optional]
                transaction_status (str): Filters the results to only the transactions for which the `status` matches this value.. [optional]
                buyer_id (str): Filters the results to only the items for which the `buyer` has an `id` that matches this value.. [optional]
                buyer_external_identifier (str): Filters the results to only the items for which the `buyer` has an `external_identifier` that matches this value.. [optional]
                before_created_at (str): Filters the results to only transactions created before this ISO date-time string.. [optional]
                after_created_at (str): Filters the results to only transactions created after this ISO date-time string.. [optional]
                before_updated_at (str): Filters the results to only transactions last updated before this ISO date-time string.. [optional]
                after_updated_at (str): Filters the results to only transactions last updated after this ISO date-time string.. [optional]
                limit (int): Defines the maximum number of items to return for this request.. [optional] if omitted the server will use the default value of 20
                cursor (str): A cursor that identifies the page of results to return. This is used to paginate the results of this API.  For the first page of results, this parameter can be left out. For additional pages, use the value returned by the API in the `next_cursor` field. Similarly the `previous_cursor` can be used to reverse backwards in the list.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Transactions
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_transactions = _Endpoint(
            settings={
                'response_type': (Transactions,),
                'auth': [
                    'BearerAuth'
                ],
                'endpoint_path': '/transactions',
                'operation_id': 'list_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'search',
                    'transaction_status',
                    'buyer_id',
                    'buyer_external_identifier',
                    'before_created_at',
                    'after_created_at',
                    'before_updated_at',
                    'after_updated_at',
                    'limit',
                    'cursor',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'transaction_status',
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 500,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('transaction_status',): {

                        "PROCESSING": "processing",
                        "PROCESSING_FAILED": "processing_failed",
                        "CAPTURE_SUCCEEDED": "capture_succeeded",
                        "CAPTURE_PENDING": "capture_pending",
                        "CAPTURE_DECLINED": "capture_declined",
                        "CAPTURE_FAILED": "capture_failed",
                        "AUTHORIZATION_SUCCEEDED": "authorization_succeeded",
                        "AUTHORIZATION_PENDING": "authorization_pending",
                        "AUTHORIZATION_DECLINED": "authorization_declined",
                        "AUTHORIZATION_FAILED": "authorization_failed",
                        "AUTHORIZATION_EXPIRED": "authorization_expired",
                        "AUTHORIZATION_VOIDED": "authorization_voided",
                        "REFUND_SUCCEEDED": "refund_succeeded",
                        "REFUND_PENDING": "refund_pending",
                        "REFUND_DECLINED": "refund_declined",
                        "REFUND_FAILED": "refund_failed",
                        "BUYER_APPROVAL_SUCCEEDED": "buyer_approval_succeeded",
                        "BUYER_APPROVAL_PENDING": "buyer_approval_pending",
                        "BUYER_APPROVAL_DECLINED": "buyer_approval_declined",
                        "BUYER_APPROVAL_FAILED": "buyer_approval_failed",
                        "BUYER_APPROVAL_TIMEDOUT": "buyer_approval_timedout"
                    },
                },
                'openapi_types': {
                    'search':
                        (str,),
                    'transaction_status':
                        (str,),
                    'buyer_id':
                        (str,),
                    'buyer_external_identifier':
                        (str,),
                    'before_created_at':
                        (str,),
                    'after_created_at':
                        (str,),
                    'before_updated_at':
                        (str,),
                    'after_updated_at':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                },
                'attribute_map': {
                    'search': 'search',
                    'transaction_status': 'transaction_status',
                    'buyer_id': 'buyer_id',
                    'buyer_external_identifier': 'buyer_external_identifier',
                    'before_created_at': 'before_created_at',
                    'after_created_at': 'after_created_at',
                    'before_updated_at': 'before_updated_at',
                    'after_updated_at': 'after_updated_at',
                    'limit': 'limit',
                    'cursor': 'cursor',
                },
                'location_map': {
                    'search': 'query',
                    'transaction_status': 'query',
                    'buyer_id': 'query',
                    'buyer_external_identifier': 'query',
                    'before_created_at': 'query',
                    'after_created_at': 'query',
                    'before_updated_at': 'query',
                    'after_updated_at': 'query',
                    'limit': 'query',
                    'cursor': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_transactions
        )

        def __refund_transaction(
            self,
            transaction_id,
            **kwargs
        ):
            """Refund or void transactions  # noqa: E501

            Refunds or voids transaction. If this transaction was already captured, it will issue a refund. If the transaction was not yet captured the authorization will instead be voided.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refund_transaction(transaction_id, async_req=True)
            >>> result = thread.get()

            Args:
                transaction_id (str): The ID for the transaction to get the information for.

            Keyword Args:
                transaction_refund_request (TransactionRefundRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Transaction
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transaction_id'] = \
                transaction_id
            return self.call_with_http_info(**kwargs)

        self.refund_transaction = _Endpoint(
            settings={
                'response_type': (Transaction,),
                'auth': [
                    'BearerAuth'
                ],
                'endpoint_path': '/transactions/{transaction_id}/refund',
                'operation_id': 'refund_transaction',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_id',
                    'transaction_refund_request',
                ],
                'required': [
                    'transaction_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_id':
                        (str,),
                    'transaction_refund_request':
                        (TransactionRefundRequest,),
                },
                'attribute_map': {
                    'transaction_id': 'transaction_id',
                },
                'location_map': {
                    'transaction_id': 'path',
                    'transaction_refund_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__refund_transaction
        )
