# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['daml_dit_if', 'daml_dit_if.api', 'daml_dit_if.main']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp', 'dacite', 'daml-dit-api==0.3.2', 'dazl>=7', 'pyyaml>=5,<6']

setup_kwargs = {
    'name': 'daml-dit-if',
    'version': '0.3.3',
    'description': 'DABL Integration Framework',
    'long_description': 'daml-dit-api\n====\n\nAPI definitions for integrations and other sorts of packages to be\nhosted by DABL. This contains the following:\n\n* [The definition for the package metadata format](daml_dit_api/package_metadata.py)\n* [The call API for integration bots](daml_dit_api/integration_api.py)\n* [A framework for simplifying the implementation of integrations](daml_dit_api/main)\n\n# Package Metadata\n\nAt their core, DIT files are [ZIP archives](https://en.wikipedia.org/wiki/Zip_(file_format))\nthat follow a specific set of conventions regarding their content. The\nmost important of these conventions is the presence of a YAML metadata\nfile at the root of the archive and named `dabl-meta.yaml`. This\nmetadata file contains catalog information describing the contents of\nthe DIT, as well as any packaging details needed to successfully\ndeploy a DIT file into DABL. An example of a deployment instruction is\na _subdeployment_. A subdeployment instructs DABL to deploy a specific\nsubfile within the DIT file. A DIT file that contains an embedded DAR\nfile could use a subdeployment to ensure that the embedded DAR file is\ndeployed to the ledger when the DIT is deployed. In this way, a DIT\nfile composed of multiple artifacts (DARs, Bots, UI\'s, etc.) can be\nconstructed to deploy a set of artifacts to a single ledger in a\nsingle action.\n\n# Integrations\n\nIntegrations are a special case of DIT file that are augmented with\nthe ability to run as an executable within a DABL cluster. This is\ndone by packaging Python [DAZL bot](https://github.com/DACH-NY/dazl)\ncode into an [executable ZIP](https://docs.python.org/3/library/zipapp.html)\nusing [PEX](https://github.com/pantsbuild/pex) and augmenting tha\nresulting file with the metadata and other resources needed to make it\na correctly formed DIT file.\n\nLogically speaking, DABL integrations are DAZL bots packaged with\ninformation needed to fit them into the DABL runtime and user\ninterface. The major functional contrast between a DABL integration\nand a Python Bot is that the integration has the external network\naccess needed to connect to an outside system and the Python Bot does\nnot. Due to the security implications of running within DABL with\nexternal network access, integrations can only be deployed with the\napproval of DA staff.\n\n## Developing Integrations\n\nThe easiest way to develop an integration for DABL is to use the\n[framework library](daml_dit_api/main) bundled within this API\npackage. The integration framework presents a Python API closely\nrelated to the DAZL bot api and ensures that integrations follow the\nconventions required to integrate into DABL. The framework parses\nledger connection arguments, translates configuration metadata into a\ndomain object specific to the integration, and exposes the appropriate\nhealth check endpoints required to populate the DABL integration user\ninterface.\n\n_Unless you know exactly what you are doing and why you are doing it,\nuse the framework._\n\n### Locally Running an integration DIT.\n\nBecause they can be directly executed by a Python interpreter,\nintegration DIT files can be run directly on a development machine\nlike any other standalone executable. By convention, integrations\naccept a number of environment variables that specify key paramaters.\nIntegrations built with the framework use defaults for these variables\nthat connect to a default locally configured sandbox instance.\n\nAvailable variables include the following:\n\n| Variable | Default | Purpose |\n|----------|---------|---------|\n| `DABL_HEALTH_PORT` | 8089 | Port for Health/Status HTTP endpoint |\n| `DABL_INTEGRATION_METADATA_PATH` | \'int_args.yaml\' | Path to local metadata file |\n| `DABL_INTEGRATION_TYPE_ID` | | Type ID for the specific integration within the DIT to run |\n| `DABL_LEDGER_ID` | \'cloudbox\' | Ledger ID for local ledger |\n| `DABL_LEDGER_URL` | `http://localhost:6865` | Address of local ledger gRPC API |\n\nSeveral of these are specifically of note for local development scenarios:\n\n* `DABL_INTEGRATION_INTEGRATION_ID` - This is the ID of the\n  integration that would normally come from DABL itself. This needs to\n  be provided, but the specific value doesn\'t matter.\n* `DABL_INTEGRATION_TYPE_ID` - DIT files can contain definitions for\n  multiple types of integrations. Each integration type is described\n  in a `IntegrationTypeInfo` block in the `dabl-meta.yaml` file and\n  identified with an `id`. This ID needs to be specified with\n  `DABL_INTEGRATION_TYPE_ID`, to launch the appropriate integration\n  type within the DIT.\n* `DABL_INTEGRATION_METADATA_PATH` - Integration configuration\n  parameters specified to the integration from the console are\n  communicated to the integration at runtime via a metadata file. By\n  convention, this metadata file is named `int_args.yaml` and must be\n  located in the working directory where the integration is being run.\n* `DABL_HEALTH_PORT` - Each integration exposes health and status over\n  a `healthz` HTTP resource. <http://localhost:8089/healthz> is the\n  default, and the port can be adjusted, if necessary. (This will be\n  the case in scenarios where multiple integrations are being run\n  locally.) Inbound webhook resources defined with webhook handlers\n  will also be exposed on this HTTP endpoint.\n\n### Integration Configuration Arguments\n\nIntegrations accept their runtime configuration parameters through the\nmetadata block of a configuration YAML file. This file is distinct\nfrom `dabl_meta.yaml`, usually named `int_args.yaml` and by default\nshould be located in the working directory of the integration. A file\nand path can be explicitly specified using the\n`DABL_INTEGRATION_METADATA_PATH` environment variable.\n\nThe format of the file is a single string/string map located under the\n`metadata` key. The keys of the metadata map are the are defined by\nthe `field`s specified for the integration in the DIT file\'s\n`dabl-meta.yaml` and the values are the the configuration paramaters\nfor the integration.\n\n```yaml\n"metadata":\n  "interval": "1"\n  "runAs": "ledger-party-f18044e5-6157-47bd-8ba6-7641b54b87ff"\n  "targetTemplate": "9b0a268f4d5c93831e6b3b6d675a5416a8e94015c9bde7263b6ab450e10ae11b:Utility.Sequence:Sequence"\n  "templateChoice": "Sequence_Next"\n```\n',
    'author': 'Mike Schaeffer',
    'author_email': 'mike.schaeffer@digitalasset.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/digital-asset/daml-dit-integration-framework',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
