# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['chiff']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0,<9.0',
 'pillow>=9.2.0,<10.0.0',
 'pykeepass>=4.0,<5.0',
 'pynacl>=1.4,<2.0',
 'python-daemon>=2.3.0,<3.0.0',
 'qrcode>=7.3.1,<8.0.0',
 'requests>=2.2,<3.0',
 'tabulate>=0.8.7,<0.9.0',
 'tldextract>=3.3.1,<4.0.0']

entry_points = \
{'console_scripts': ['chiff = chiff.main:main', 'chiffd = chiff.socket:main']}

setup_kwargs = {
    'name': 'chiff',
    'version': '0.2.1',
    'description': 'Chiff command-line client.',
    'long_description': '# Chiff CLI\n\n![Current version](https://img.shields.io/github/v/tag/chiff-app/chiff-cli?sort=semver) ![PyPI](https://img.shields.io/pypi/v/chiff) [![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black) [![Python](https://github.com/chiff-app/chiff-cli/actions/workflows/test.yml/badge.svg)](https://github.com/chiff-app/chiff-cli/actions/workflows/test.yml) ![Twitter Follow](https://img.shields.io/twitter/follow/Chiff_App?style=social)\n\n![Chiff logo](https://chiff.app/assets/images/logo.svg)\n\nChiff is a tool that allows you to store secrets in the secure storage of your phone and retrieve them when you need them by authorizing a request.\nYou can pair the app with multiple clients (browser extension or shell).\n\n## Motivation\n\nSSH keys are stored in plaintext on your computer by default, unless you choose a passphrase. However, it can be cumbersome to retype your password every time you need to decrypt your keys. The same applies to credentials for various CLIs. For example, [official AWS CLI documentation](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-files.html) recommends to store your credentials in `~/.aws/credentials`.\n\nWith Chiff, you can leverage the biometric capabilities and secure storage of your phone to authenticate to services on your computer. You can pair with multiple shells to be able to retrieve credentials there.\n\n## Security model\n\nAll sensitive data is stored encrypted on your phone. When needed, it is decrypted (by authenticating to your phone with biometrics) and sent to the browser/cli, where it is filled in the website. An end-to-end encrypted channel is established between browser/cli by scanning a QR-code. This means confidentiality is ensured, even though the server (mainly serving as message broker and backup storage) is modelled as an untrusted entity.\n\n## Related projects\n\nThis is the repository for the _CLI_.  \nFor the _Android app_, see [chiff-android](https://github.com/chiff-app/chiff-android) (_Coming soon_).  \nFor the _Browser extension_, see [chiff-browser](https://github.com/chiff-app/chiff-browser) (_Coming soon_).  \nFor the _iOS app_, see [chiff-ios](https://github.com/chiff-app/chiff-ios).\nFor the _iOS app core_, see [chiff-ios](https://github.com/chiff-app/chiff-ios-core).\n\n## Installation\n\nPackage is available on PyPi.\nThe easiest way is to use [pipx](https://github.com/pypa/pipx): `pipx install chiff`. This should install `chiff` and `chiffd` to your shell.\n\n## Installation from source\n\nAfter cloning the project, you can build it using [poetry](https://python-poetry.org).\nRun `poetry build` to build the source package and wheel binary. Install the script with `pipx install ./`. This should install `chiff` and `chiffd` to your shell.\n\n## Set-up\n\nTo set up the ssh-agent, you can run `chiff init`. This sets up `chiffd` as a background script and adds the following to your `~/.ssh/config`:\n\n```\nHost *\n   IdentityAgent "~/Library/Application Support/Chiff/chiff-socket.ssh"\n```\n\nYou can also set this up manually. For example, if you only want to use Chiff for specific hosts you can set\n\n`IdentityAgent "~/Library/Application Support/Chiff/chiff-socket.ssh"`\n\nfor hosts that should use Chiff.\n\n### Get the Chiff app\n\nGet the Chiff app on App Store or Play Store:\n\n[<img src="https://chiff.app/assets/images/app-store.svg" />](https://apps.apple.com/app/id1361749715)\n[<img src="https://chiff.app/assets/images/play-store.svg" height="40" />](https://play.google.com/store/apps/details?id=io.keyn.keyn)\n\nFollow the onboarding instructions in the app. When the app asks you to pair with your browser, you can pair with this CLI instead (see [Pairing](#pairing)).\n\n## Usage\n\n### Pairing\n\nThe first thing you should do is pair with your phone with `chiff pair`. This generates a QR-code that you can scan with\nthe Chiff app. After pairing, you can see your accounts with `chiff status`.\nYou can pair with one app at the same time, so if you want to pair with another phone, run `chiff unpair` to delete the\nsession.\n\n### Generating an SSH key\n\nYou can generate an SSH key on your phone with `chiff ssh-keygen -n <name>`. This sends a request to your phone to generate the key.\nChiff can generate two types of keys:\n\n1. **Ed25519**: This is the default algorithm. The key is backed up on your chiff seed and can be restored. _The key is not generated in the Secure Enclave_.\n2. **ECDSA256**: This key can be generated with the `-e` flag and is generated in the Secure Enclave (iOS only). This is more secure, _but the key won\'t be restored with your backup_.\n\nPick whatever suits your needs. Generating the key will directly print out the ssh public key, but you can always find this by running `chiff status`.\n\n### Logging in with ssh\n\nMake sure `chiffd` is running and the `IdentityAgent` is set up in your `~/.ssh/config` and the host has a public set in `~/.ssh/authorized_keys`. Then just log in with `ssh user@host` and you should get a push message on your phone. If the key is not present in Chiff, the request is being forwarded to the original `ssh-agent`.\n\n### Retrieving passwords\n\nThe Chiff CLI allows you to get passwords and notes from your accounts with `chiff get`. It takes the following arguments:\n\n```bash\n  -i, --id TEXT      The id of the account you want the data for  [required]\n  -n, --notes        Return the notes of the account\n  -j, --format-json  Return account in JSON format ({ "username": "example",\n                     "password": "secret", "notes": "important note" |\n                     undefined })\n```\n\nBy default, it just return the password without any extra output, so it can be easily used in scripts.\nThe account id is required and can be found by checking the overview with `chiff status`.\n\n### Adding accounts\n\nAdd new accounts with `chiff add`. It takes the following arguments:\n\n```bash\n  -u, --username TEXT  The username of the account you want to add  [required]\n  -l, --url TEXT       The URL of the account you want to add  [required]\n  -s, --name TEXT      The name of the account you want to add  [required]\n  -p, --password TEXT  The password of the account you want to add. Will be\n                       prompted for if not provided\n  -n, --notes TEXT     The notes of the account you want to add\n```\n\nThis will send a request to your phone, where you can authorize the account.\n\n### Updating accounts\n\nSimilarly, you can update existing accounts with `chiff update`.\n\n```bash\n  -i, --id TEXT        The id of the account you want the data for  [required]\n  -u, --username TEXT  The username of the account you want to update\n  -l, --url TEXT       The URL of the account you want to update\n  -s, --name TEXT      The name of the account you want to update\n  -p, --password TEXT  The password of the account you want to update. Will be\n                       prompted for if argument is not provided\n  -n, --notes TEXT     The notes of the account you want to update\n```\n\nThe account id is required and can be found by checking the overview with `chiff status`.\n\n### Importing\n\nYou can import accounts from a CSV, JSON or kdbx file with `chiff import`.\n\n```bash\n  -f, --format [csv|json|kdbx]  The input format. If data is written to a\n                                .kdbx database, the path to anexisting .kdbx\n                                database file needs to be provided with -p.\n                                [required]\n  -p, --path PATH               The path to where the file should be read\n                                from.  [required]\n  -s, --skip                    Whether the first row should be skipped. Only\n                                relevant when format is CSV.\n```\n\n#### Importing from CSV\n\nImport from a csv file with `chiff import -f csv -p <path>`. You can skip the first row with the `-s` flag. The data is expected to be separated with commas, for example:\n\n```\n"title", "url", "username", "password", "notes"\n"Google", "https://google.com", "john_doe@gmail.com", "p@ssword", "important note"\n```\n\n#### Importing from JSON\n\nImport from a json file with `chiff import -f json -p <path>`. The data is expected to be formatted as follows:\n\n```json\n[\n  {\n    "title": "Google",\n    "url": "https://google.com",\n    "username": "john_doe@gmail.com",\n    "password": "p@ssword",\n    "notes": "important note"\n  }\n]\n```\n\n#### Importing from kdbx\n\nImport from a json file with `chiff import -f kdbx -p <path>`. You will have to enter your password. Note that Chiff relies on the URL being present and correct, so it\'s necessary to make sure each account has the URL set, as well as the title, username and password. Notes are optional.\n\n## FAQ\n\n### I\'d like to forward requests to another SSH agent\n\nBy default, Chiff forwards the requests to the ssh-agent that is present in the `SSH_AUTH_SOCK`, environment variable. If you have changed this in `~/.bashrc` or equivalent, it may not be available to the background process. You can adjust the LaunchAgent plist or systemd service manually to set. For example, if you would like to use Chiff in combination with [secretive](https://github.com/maxgoedjen/secretive), you add the following to `~/Library/LaunchAgents/co.chiff.chiffd.plist`:\n\n```xml\n<key>EnvironmentVariables</key>\n<dict>\n    <key>SSH_AUTH_SOCK</key>\n    <string>/Users/username/Library/Containers/com.maxgoedjen.Secretive.SecretAgent/Data/socket.ssh</string>\n</dict>\n```\n\nThen reload it with `launchctl load -w ~/Library/LaunchAgents/co.chiff.chiffd.plist`. If the key is present in Chiff, they request will be handled by Chiff. If not, it will be forwarded to the secretive ssh agent.\n\n## Contributing\n\nTo contribute, follow these steps:\n\n1. Fork this repository.\n2. Create a branch from the `main` branch: `git checkout -b <branch_name>`.\n3. Make your changes and commit them: `git commit -m \'<commit_message>\'`\n4. Push to the original branch: `git push origin <project_name>/<location>`\n5. Create the pull request to the `main` branch.\n\nAlternatively see the GitHub documentation on [creating a pull request](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request).\n\n## License\n\nThis project is licensed under the terms of the GNU GPLv3.\n',
    'author': 'bas-d',
    'author_email': '7903735+bas-d@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://chiff.app',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
