# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2018-06-14 12:29
import django.db.models.deletion
import django_extensions.db.fields
import mptt.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Category",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50)),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        overwrite=True,
                        populate_from="name",
                    ),
                ),
                ("path", models.CharField(max_length=255)),
                ("value", models.CharField(max_length=255)),
                ("lft", models.PositiveIntegerField(db_index=True, editable=False)),
                ("rght", models.PositiveIntegerField(db_index=True, editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(db_index=True, editable=False)),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="core_main_registry_app.Category",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Refinement",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50)),
                ("xsd_name", models.CharField(max_length=50)),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        overwrite=True,
                        populate_from="name",
                    ),
                ),
                ("template_hash", models.CharField(max_length=255)),
            ],
        ),
        migrations.AddField(
            model_name="category",
            name="refinement",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="core_main_registry_app.Refinement",
            ),
        ),
    ]
