---
description: 当前项目的架构设计说明
---

背景：

当前大模型的厂商（provider）/版本(3.5/4.0/4)/型号(flash/mini/o)混乱不堪
不同厂商，不同版本，不同型号其能力又不尽相同

比如以智谱AI的GLM-4V来讲，它支持视觉多模态，但其接口中传入的视频有如下要求：
GLM-4V-Plus视频大小限制为20M以内，视频时长不超过 30s。
GLM-4V-Plus-0111视频大小限制为 200M 以内。
图片有如下要求：
图片url或者base64编码。
图像大小上传限制为每张图像 5M以下，且像素不超过 6000*6000。
支持jpg、png、jpeg格式。
说明： GLM-4V-Flash 不支持base64编码

这些要求非常细碎，开发者将非常难以处理这些“变态”的要求。一个不小心就会触发警告，同时如果开发者有适配多个模型的需求，这些不同厂商API之间的要求将是恶梦。

当前的项目目标是完成以下要求：

1. 仅需要一个字符串即可完成这个模型配置的初始化。
2. 初始化完成后，可以自动匹配到厂商/版本/型号，同时可以基于同一厂商下的不同版本/型号进行大小比较，支持运算符比较。
3. 初始化完成后，提供其能力范围说明，初期能力范围主要着重「是否支持thinking（reasoning）模式, 是否支持图片，是否支持音频，是否支持视频，是否支持PDF」
4. 针对具体的模型，提供一个对请求参数进行validate的可选实现，用于解决像GLM-4V-Plus这样的变态参数要求自动整改。这个实现会基于我们vrl-python库，使用VRL脚本语言实现。（使用 uv add vrl-python即可添加）

---

当前项目使用uv管理依赖
使用ruff进行格式检查
使用mypy进行类型检查
使用bump-my-version管理版本

测试的时候注意使用 uv run pytest 激活虚拟环境进行测试

---

已经实现的功能：

1. 相同provider提供的相同版本的模型，会有型号的不同，比如GPT系列有 base turbo omni等，一般来讲，我们需要添加 gpt-4-turbo < gpt-4 < gpt-4o的判断能力。也就是不同的型号也有高低之分，因为这一般意味着每百万Token的价格区别。因此元数据需要有一个类似的字段，而且这个字段需要参数大小比较，同时每个模型家族这个字段的大小比较方法需要能自定义，建议使用tuple从左向右越来越大
2. 当前只有Provider字段的时候我发现一个问题，同一个模型，比如Deepseek，可能是原厂提供，也可能由Tencent提供，不同的Provider其能力可能不一样。因此我们需要添加一个「模型家族」的字段和Provider区分开，同一个模型家族，可能有多个Provider，同时其Capibility可能不同。某个模型家族有默认的Provider，但同时，可以在模型名称前通过 Provider::ModelName 的形式来指定Provider。
3. 模型家族，模型版本，模型型号一般不会轻易改变，但需要注意，多数模型会有一个日期，代表其小更新的发布，日期也需要参数比较。因此添加日期相关能力，参与比较时在版本，型号相同的情况下比较日期

需要继续实现的功能：

4. 因为不同公司的模型多如牛毛，我们无法一一添加，我们需要提供一个auto_register的方式，实现以下能力：
    a. 用户初始化一个ModelVersion如果使用一个不存在的名称时，触发自动注册。
    b. 仅仅需要提供一个模型名（可以选择带上Provider，不带则使用默认）。然后根据其归属的模型家族来初始化能力
    c.  如果当前家族无任何可用的参考，用户又未指定能力，则抛出异常，告知用户添加失败，无法自动补充能力，需要用户手动注册添加。