# coding: utf-8

"""
    HubSpot Events API

    API for accessing CRM object events.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.events.api_client import ApiClient
from hubspot.events.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class EventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_page(self, **kwargs):  # noqa: E501
        """Returns a collection of events matching a query.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_page(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime occurred_after: The starting time as an ISO 8601 timestamp.
        :param datetime occurred_before: The ending time as an ISO 8601 timestamp.
        :param str object_type: The type of object being selected. Valid values are hubspot named object types (e.g. `contact`).
        :param int object_id: The id of the selected object. If not present, then the `objectProperty` parameter is required.
        :param str event_type: Limits the response to the specified event type.  For example `&eventType=e_visited_page` returns only `e_visited_page` events.  If not present all event types are returned.
        :param str after: An additional parameter that may be used to get the next `limit` set of results.
        :param str before:
        :param int limit: The maximum number of events to return, defaults to 20.
        :param list[str] sort: Selects the sort field and order. Defaults to ascending, prefix with `-` for descending order. `occurredAt` is the only field supported for sorting.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseExternalUnifiedEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_page_with_http_info(**kwargs)  # noqa: E501

    def get_page_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a collection of events matching a query.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_page_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime occurred_after: The starting time as an ISO 8601 timestamp.
        :param datetime occurred_before: The ending time as an ISO 8601 timestamp.
        :param str object_type: The type of object being selected. Valid values are hubspot named object types (e.g. `contact`).
        :param int object_id: The id of the selected object. If not present, then the `objectProperty` parameter is required.
        :param str event_type: Limits the response to the specified event type.  For example `&eventType=e_visited_page` returns only `e_visited_page` events.  If not present all event types are returned.
        :param str after: An additional parameter that may be used to get the next `limit` set of results.
        :param str before:
        :param int limit: The maximum number of events to return, defaults to 20.
        :param list[str] sort: Selects the sort field and order. Defaults to ascending, prefix with `-` for descending order. `occurredAt` is the only field supported for sorting.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseExternalUnifiedEvent, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "occurred_after",
            "occurred_before",
            "object_type",
            "object_id",
            "event_type",
            "after",
            "before",
            "limit",
            "sort",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "occurred_after" in local_var_params
            and local_var_params["occurred_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("occurredAfter", local_var_params["occurred_after"])
            )  # noqa: E501
        if (
            "occurred_before" in local_var_params
            and local_var_params["occurred_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("occurredBefore", local_var_params["occurred_before"])
            )  # noqa: E501
        if (
            "object_type" in local_var_params
            and local_var_params["object_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("objectType", local_var_params["object_type"])
            )  # noqa: E501
        if (
            "object_id" in local_var_params
            and local_var_params["object_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("objectId", local_var_params["object_id"])
            )  # noqa: E501
        if (
            "event_type" in local_var_params
            and local_var_params["event_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("eventType", local_var_params["event_type"])
            )  # noqa: E501
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "before" in local_var_params and local_var_params["before"] is not None
        ):  # noqa: E501
            query_params.append(("before", local_var_params["before"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/events/v3/events",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseExternalUnifiedEvent",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
