# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1


@dataclass
class AggregationRule(DataclassDictMixIn):
    """AggregationRule describes how to locate ClusterRoles to aggregate into the
      ClusterRole

      **parameters**

      * **clusterRoleSelectors** ``List[meta_v1.LabelSelector]`` - *(optional)* ClusterRoleSelectors holds a list of selectors which will be used to find
        ClusterRoles and create the rules. If any of the selectors match, then the
        ClusterRole's permissions will be added
    """
    clusterRoleSelectors: 'List[meta_v1.LabelSelector]' = None


@dataclass
class ClusterRole(DataclassDictMixIn):
    """ClusterRole is a cluster level, logical grouping of PolicyRules that can be
      referenced as a unit by a RoleBinding or ClusterRoleBinding.

      **parameters**

      * **aggregationRule** ``AggregationRule`` - *(optional)* AggregationRule is an optional field that describes how to build the Rules for
        this ClusterRole. If AggregationRule is set, then the Rules are controller
        managed and direct changes to Rules will be stomped by the controller.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata.
      * **rules** ``List[PolicyRule]`` - *(optional)* Rules holds all the PolicyRules for this ClusterRole
    """
    aggregationRule: 'AggregationRule' = None
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    rules: 'List[PolicyRule]' = None


@dataclass
class ClusterRoleBinding(DataclassDictMixIn):
    """ClusterRoleBinding references a ClusterRole, but not contain it.  It can
      reference a ClusterRole in the global namespace, and adds who information via
      Subject.

      **parameters**

      * **roleRef** ``RoleRef`` - RoleRef can only reference a ClusterRole in the global namespace. If the
        RoleRef cannot be resolved, the Authorizer must return an error.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata.
      * **subjects** ``List[Subject]`` - *(optional)* Subjects holds references to the objects the role applies to.
    """
    roleRef: 'RoleRef'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    subjects: 'List[Subject]' = None


@dataclass
class ClusterRoleBindingList(DataclassDictMixIn):
    """ClusterRoleBindingList is a collection of ClusterRoleBindings

      **parameters**

      * **items** ``List[ClusterRoleBinding]`` - Items is a list of ClusterRoleBindings
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard object's metadata.
    """
    items: 'List[ClusterRoleBinding]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ClusterRoleList(DataclassDictMixIn):
    """ClusterRoleList is a collection of ClusterRoles

      **parameters**

      * **items** ``List[ClusterRole]`` - Items is a list of ClusterRoles
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard object's metadata.
    """
    items: 'List[ClusterRole]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class PolicyRule(DataclassDictMixIn):
    """PolicyRule holds information that describes a policy rule, but does not
      contain information about who the rule applies to or which namespace the rule
      applies to.

      **parameters**

      * **verbs** ``List[str]`` - Verbs is a list of Verbs that apply to ALL the ResourceKinds contained in this
        rule. '*' represents all verbs.
      * **apiGroups** ``List[str]`` - *(optional)* APIGroups is the name of the APIGroup that contains the resources.  If
        multiple API groups are specified, any action requested against one of the
        enumerated resources in any API group will be allowed. "" represents the core
        API group and "*" represents all API groups.
      * **nonResourceURLs** ``List[str]`` - *(optional)* NonResourceURLs is a set of partial urls that a user should have access to.
        *s are allowed, but only as the full, final step in the path Since
        non-resource URLs are not namespaced, this field is only applicable for
        ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to
        API resources (such as "pods" or "secrets") or non-resource URL paths (such as
        "/api"),  but not both.
      * **resourceNames** ``List[str]`` - *(optional)* ResourceNames is an optional white list of names that the rule applies to.  An
        empty set means that everything is allowed.
      * **resources** ``List[str]`` - *(optional)* Resources is a list of resources this rule applies to. '*' represents all
        resources.
    """
    verbs: 'List[str]'
    apiGroups: 'List[str]' = None
    nonResourceURLs: 'List[str]' = None
    resourceNames: 'List[str]' = None
    resources: 'List[str]' = None


@dataclass
class Role(DataclassDictMixIn):
    """Role is a namespaced, logical grouping of PolicyRules that can be referenced
      as a unit by a RoleBinding.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata.
      * **rules** ``List[PolicyRule]`` - *(optional)* Rules holds all the PolicyRules for this Role
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    rules: 'List[PolicyRule]' = None


@dataclass
class RoleBinding(DataclassDictMixIn):
    """RoleBinding references a role, but does not contain it.  It can reference a
      Role in the same namespace or a ClusterRole in the global namespace. It adds
      who information via Subjects and namespace information by which namespace it
      exists in.  RoleBindings in a given namespace only have effect in that
      namespace.

      **parameters**

      * **roleRef** ``RoleRef`` - RoleRef can reference a Role in the current namespace or a ClusterRole in the
        global namespace. If the RoleRef cannot be resolved, the Authorizer must
        return an error.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata.
      * **subjects** ``List[Subject]`` - *(optional)* Subjects holds references to the objects the role applies to.
    """
    roleRef: 'RoleRef'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    subjects: 'List[Subject]' = None


@dataclass
class RoleBindingList(DataclassDictMixIn):
    """RoleBindingList is a collection of RoleBindings

      **parameters**

      * **items** ``List[RoleBinding]`` - Items is a list of RoleBindings
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard object's metadata.
    """
    items: 'List[RoleBinding]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class RoleList(DataclassDictMixIn):
    """RoleList is a collection of Roles

      **parameters**

      * **items** ``List[Role]`` - Items is a list of Roles
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard object's metadata.
    """
    items: 'List[Role]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class RoleRef(DataclassDictMixIn):
    """RoleRef contains information that points to the role being used

      **parameters**

      * **apiGroup** ``str`` - APIGroup is the group for the resource being referenced
      * **kind** ``str`` - Kind is the type of resource being referenced
      * **name** ``str`` - Name is the name of resource being referenced
    """
    apiGroup: 'str'
    kind: 'str'
    name: 'str'


@dataclass
class Subject(DataclassDictMixIn):
    """Subject contains a reference to the object or user identities a role binding
      applies to.  This can either hold a direct API object reference, or a value
      for non-objects such as user and group names.

      **parameters**

      * **kind** ``str`` - Kind of object being referenced. Values defined by this API group are "User",
        "Group", and "ServiceAccount". If the Authorizer does not recognized the kind
        value, the Authorizer should report an error.
      * **name** ``str`` - Name of the object being referenced.
      * **apiGroup** ``str`` - *(optional)* APIGroup holds the API group of the referenced subject. Defaults to "" for
        ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and
        Group subjects.
      * **namespace** ``str`` - *(optional)* Namespace of the referenced object.  If the object kind is non-namespace, such
        as "User" or "Group", and this value is not empty the Authorizer should report
        an error.
    """
    kind: 'str'
    name: 'str'
    apiGroup: 'str' = None
    namespace: 'str' = None


