# Generated by Django 4.0.6 on 2022-10-23 13:24

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Field',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('label', models.CharField(max_length=100, verbose_name='Label')),
                ('name', models.CharField(blank=True, max_length=100, unique=True, verbose_name='Name')),
                ('genre', models.CharField(choices=[('text_input', 'Text input'), ('text_area', 'Text area'), ('number', 'Number'), ('dropdown', 'Dropdown'), ('date', 'Date'), ('time', 'Time'), ('datetime', 'Datetime'), ('email', 'E-Mail'), ('password', 'Password'), ('checkbox', 'Checkbox'), ('multi_checkbox', 'Multi checkbox'), ('radio', 'Radio'), ('hidden', 'Hidden'), ('captcha', 'Captcha'), ('upload_file', 'Upload file')], max_length=80, verbose_name='Genre')),
                ('is_required', models.BooleanField(default=True, verbose_name='Is Required')),
                ('placeholder', models.CharField(blank=True, max_length=100, null=True, verbose_name='Placeholder')),
                ('default', models.CharField(blank=True, max_length=255, null=True, verbose_name='Default Value')),
                ('help_text', models.CharField(blank=True, max_length=200, null=True, verbose_name='Help Text')),
                ('regex_pattern', models.CharField(blank=True, max_length=500, null=True, verbose_name='Regex Pattern')),
                ('error_message', models.CharField(blank=True, max_length=200, null=True, verbose_name='Error Message')),
                ('is_active', models.BooleanField(verbose_name='Is Active')),
                ('file_types', models.CharField(blank=True, help_text='example: jpg,png', max_length=100, null=True, verbose_name='Allow File Types')),
                ('file_size', models.IntegerField(blank=True, help_text='Default value will be set to 50 MB', null=True, verbose_name='File Size')),
                ('object_id', models.BigIntegerField(blank=True, null=True, verbose_name='Depends on Object ID')),
            ],
            options={
                'verbose_name': 'Field',
                'verbose_name_plural': 'Fields',
            },
        ),
        migrations.CreateModel(
            name='FieldCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('title', models.CharField(max_length=200, unique=True, verbose_name='Title')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('weight', models.PositiveIntegerField(verbose_name='Weight')),
            ],
            options={
                'verbose_name': 'FieldCategory',
                'verbose_name_plural': 'FieldCategories',
                'ordering': ('weight',),
            },
        ),
        migrations.CreateModel(
            name='FieldValueThrough',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('weight', models.PositiveIntegerField(verbose_name='Weight')),
            ],
            options={
                'ordering': ('weight',),
            },
        ),
        migrations.CreateModel(
            name='Form',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('title', models.CharField(max_length=200, verbose_name='Title')),
                ('slug', models.SlugField(allow_unicode=True, unique=True, verbose_name='Slug')),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('pending', 'Pending'), ('publish', 'Publish'), ('suspend', 'Suspend')], default='draft', max_length=50, verbose_name='Status')),
                ('submit_text', models.CharField(default='Submit', max_length=100, verbose_name='Submit Text')),
                ('redirect_url', models.URLField(blank=True, null=True, verbose_name='Redirect URL')),
                ('success_message', models.CharField(blank=True, max_length=255, null=True, verbose_name='Success Message')),
                ('theme', models.CharField(blank=True, help_text='If choose dynamic_fields.html the order of fields depends on position of Field.', max_length=300, null=True, verbose_name='Theme')),
                ('direction', models.CharField(choices=[('ltr', 'LTR'), ('rtl', 'RTL')], default='ltr', max_length=3, verbose_name='Direction')),
                ('limit_to', models.PositiveIntegerField(blank=True, null=True, verbose_name='Limit Submiting Form')),
                ('valid_from', models.DateTimeField(blank=True, null=True, verbose_name='Valid From')),
                ('valid_to', models.DateTimeField(blank=True, null=True, verbose_name='Valid To')),
                ('is_editable', models.BooleanField(default=False, verbose_name='Is Editable')),
            ],
            options={
                'verbose_name': 'Form',
                'verbose_name_plural': 'Forms',
            },
        ),
        migrations.CreateModel(
            name='FormAPIManager',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('title', models.CharField(max_length=200, verbose_name='Title')),
                ('url', models.URLField(verbose_name='URL')),
                ('headers', models.JSONField(blank=True, null=True, verbose_name='Headers')),
                ('method', models.CharField(choices=[('get', 'GET'), ('post', 'POST'), ('put', 'PUT'), ('patch', 'PATCH'), ('delete', 'DELETE'), ('option', 'OPTION')], max_length=50, verbose_name='Method')),
                ('body', models.TextField(blank=True, null=True, verbose_name='Body')),
                ('execute_time', models.CharField(choices=[('pre_load', 'Pre load'), ('post_load', 'Post load')], max_length=50, verbose_name='Execute Time')),
                ('response', models.TextField(blank=True, null=True, verbose_name='Response')),
                ('is_active', models.BooleanField(verbose_name='Is Active')),
            ],
            options={
                'verbose_name': 'FormAPIManager',
                'verbose_name_plural': 'FormAPIManagers',
            },
        ),
        migrations.CreateModel(
            name='FormAPIThrough',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('weight', models.PositiveIntegerField(verbose_name='Weight')),
            ],
            options={
                'ordering': ('weight',),
            },
        ),
        migrations.CreateModel(
            name='FormFieldThrough',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.CharField(choices=[('inline', 'In-line'), ('inorder', 'In-Order'), ('break', 'Break')], default='break', max_length=100, verbose_name='Position')),
                ('weight', models.PositiveIntegerField(verbose_name='Weight')),
            ],
            options={
                'ordering': ('weight',),
            },
        ),
        migrations.CreateModel(
            name='FormResponse',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('unique_id', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='Unique ID')),
                ('data', models.JSONField(verbose_name='Data')),
                ('api_response', models.JSONField(blank=True, null=True, verbose_name='Api Respons')),
                ('user_ip', models.GenericIPAddressField(blank=True, null=True, verbose_name='IP Address')),
            ],
            options={
                'verbose_name': 'Form Response',
                'verbose_name_plural': 'Form Responses',
            },
        ),
        migrations.CreateModel(
            name='Value',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
            ],
            options={
                'verbose_name': 'Value',
                'verbose_name_plural': 'Values',
            },
        ),
        migrations.AddIndex(
            model_name='value',
            index=models.Index(fields=['name'], name='f_g_value_name'),
        ),
        migrations.AddField(
            model_name='formresponse',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='%(class)s_responses', to='django_form_generator.form', verbose_name='Form'),
        ),
        migrations.AddField(
            model_name='formfieldthrough',
            name='category',
            field=models.ForeignKey(blank=True, limit_choices_to={'is_active': True}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='form_field_through', to='django_form_generator.fieldcategory', verbose_name='Category'),
        ),
        migrations.AddField(
            model_name='formfieldthrough',
            name='field',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_field_through', to='django_form_generator.field', verbose_name='Field'),
        ),
        migrations.AddField(
            model_name='formfieldthrough',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_field_through', to='django_form_generator.form', verbose_name='Form'),
        ),
        migrations.AddField(
            model_name='formapithrough',
            name='api',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_apis', to='django_form_generator.formapimanager', verbose_name='API'),
        ),
        migrations.AddField(
            model_name='formapithrough',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_apis', to='django_form_generator.form', verbose_name='Form'),
        ),
        migrations.AddIndex(
            model_name='formapimanager',
            index=models.Index(fields=['title'], name='f_g_formapimanager_title'),
        ),
        migrations.AddIndex(
            model_name='formapimanager',
            index=models.Index(fields=['method'], name='f_g_formapimanager_method'),
        ),
        migrations.AddIndex(
            model_name='formapimanager',
            index=models.Index(fields=['is_active'], name='f_g_formapimanager_active'),
        ),
        migrations.AddField(
            model_name='form',
            name='apis',
            field=models.ManyToManyField(related_name='forms', through='django_form_generator.FormAPIThrough', to='django_form_generator.formapimanager', verbose_name='Apis'),
        ),
        migrations.AddField(
            model_name='form',
            name='fields',
            field=models.ManyToManyField(related_name='forms', through='django_form_generator.FormFieldThrough', to='django_form_generator.field', verbose_name='Fields'),
        ),
        migrations.AddField(
            model_name='fieldvaluethrough',
            name='field',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='field_values', to='django_form_generator.field', verbose_name='Field'),
        ),
        migrations.AddField(
            model_name='fieldvaluethrough',
            name='value',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='field_values', to='django_form_generator.value', verbose_name='Value'),
        ),
        migrations.AddField(
            model_name='fieldcategory',
            name='parent',
            field=models.ForeignKey(blank=True, limit_choices_to={'is_active': True}, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='django_form_generator.fieldcategory', verbose_name='Parent Category'),
        ),
        migrations.AddField(
            model_name='field',
            name='content_type',
            field=models.ForeignKey(blank=True, limit_choices_to=models.Q(models.Q(('app_label', 'django_form_generator'), ('model', 'field')), models.Q(('app_label', 'django_form_generator'), ('model', 'value')), _connector='OR'), null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='fields', to='contenttypes.contenttype', verbose_name='Depends On Object'),
        ),
        migrations.AddField(
            model_name='field',
            name='values',
            field=models.ManyToManyField(help_text='Only for multi value fields like Dropdown, Radio, Checkbox, etc...', related_name='fields', through='django_form_generator.FieldValueThrough', to='django_form_generator.value', verbose_name='Values'),
        ),
        migrations.AddIndex(
            model_name='formresponse',
            index=models.Index(fields=['user_ip'], name='f_g_formresponse_user'),
        ),
        migrations.AddIndex(
            model_name='formresponse',
            index=models.Index(fields=['unique_id'], name='f_g_formresponse_unique_id'),
        ),
        migrations.AddIndex(
            model_name='formfieldthrough',
            index=models.Index(fields=['weight'], name='f_g_formfieldthrough_weight'),
        ),
        migrations.AddIndex(
            model_name='formapithrough',
            index=models.Index(fields=['weight'], name='f_g_formapithrough_weight'),
        ),
        migrations.AddIndex(
            model_name='form',
            index=models.Index(fields=['title'], name='f_g_form_title'),
        ),
        migrations.AddIndex(
            model_name='form',
            index=models.Index(fields=['slug'], name='f_g_form_slug'),
        ),
        migrations.AddIndex(
            model_name='form',
            index=models.Index(fields=['status'], name='f_g_form_status'),
        ),
        migrations.AddIndex(
            model_name='fieldvaluethrough',
            index=models.Index(fields=['weight'], name='f_g_fieldvaluethrough_weight'),
        ),
        migrations.AddIndex(
            model_name='fieldcategory',
            index=models.Index(fields=['title'], name='f_g_fieldcategory_title'),
        ),
        migrations.AddIndex(
            model_name='fieldcategory',
            index=models.Index(fields=['is_active'], name='f_g_fieldcategory_active'),
        ),
        migrations.AddIndex(
            model_name='fieldcategory',
            index=models.Index(fields=['weight'], name='f_g_fieldcategory_weight'),
        ),
        migrations.AddIndex(
            model_name='field',
            index=models.Index(fields=['label'], name='f_g_field_label'),
        ),
        migrations.AddIndex(
            model_name='field',
            index=models.Index(fields=['name'], name='f_g_field_name'),
        ),
        migrations.AddIndex(
            model_name='field',
            index=models.Index(fields=['genre'], name='f_g_field_genre'),
        ),
    ]