# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['coltrane',
 'coltrane.config',
 'coltrane.management',
 'coltrane.management.commands',
 'coltrane.templatetags']

package_data = \
{'': ['*'], 'coltrane': ['templates/coltrane/*']}

install_requires = \
['Django>3.0',
 'click>=8.0.0,<9.0.0',
 'dateparser>=1.1.0,<2.0.0',
 'django-browser-reload>=1.3.0,<2.0.0',
 'django-fastdev>=1.3.0,<2.0.0',
 'halo>=0.0.31,<0.0.32',
 'markdown2>=2.4.2,<3.0.0',
 'python-dotenv>0.17',
 'rich-click>=0.2.0,<0.3.0']

extras_require = \
{'deploy': ['gunicorn>=20.1.0,<21.0.0', 'whitenoise>=5.3.0,<6.0.0'],
 'docs': ['Sphinx>=4.3.2,<5.0.0',
          'linkify-it-py>=1.0.3,<2.0.0',
          'myst-parser>=0.16.1,<0.17.0',
          'furo>=2021.11.23,<2022.0.0',
          'sphinx-copybutton>=0.4.0,<0.5.0',
          'sphinx-autobuild>=2021.3.14,<2022.0.0',
          'toml',
          'attrs>=21.4.0,<22.0.0']}

entry_points = \
{'console_scripts': ['coltrane = coltrane.console:cli']}

setup_kwargs = {
    'name': 'coltrane-web',
    'version': '0.18.4',
    'description': 'A simple content site framework that harnesses the power of Django without the hassle.',
    'long_description': '<p align="center">\n  <a href="https://coltrane.readthedocs.io"><h1 align="center">coltrane</h1></a>\n</p>\n<p align="center">A simple content site framework that harnesses the power of Django without the hassle 🎵</p>\n\n`coltrane-web` has been renamed to [coltrane](https://pypi.org/project/coltrane/).\n',
    'author': 'adamghill',
    'author_email': 'adam@adamghill.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/adamghill/coltrane/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
