#!/usr/bin/env python
#-*- coding: utf-8 -*-
#
# Copyright 2013-2019 European Commission (JRC);
# Licensed under the EUPL (the 'Licence');
# You may not use this work except in compliance with the Licence.
# You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

def cycle_data():
    """
    The NEDC cycle and related-data.
    """
    data = {
        'parts': [[0, 780], [781, 1179]],
        'cycle': [
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    3.75      ,
              7.5       ,   11.25      ,   15.        ,   15.        ,   15.        ,   15.        ,
             15.        ,   15.        ,   15.        ,   15.        ,   15.        ,   12.5       ,
             10.        ,    6.66666985,    3.33299995,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    3.        ,    6.        ,    9.        ,   12.        ,   15.        ,
             15.        ,   15.        ,   18.39999962,   21.79999924,   25.20000076,   28.60000038,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   29.25      ,   26.5       ,   23.75      ,   21.        ,   18.25      ,
             15.5       ,   12.75      ,   10.        ,    6.66666698,    3.33333325,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    3.        ,    6.        ,    9.        ,
             12.        ,   15.        ,   15.        ,   15.        ,   17.22220039,   19.44440079,
             21.66659927,   23.88879967,   26.11100006,   28.33320045,   30.55540085,   32.77759933,
             35.        ,   35.        ,   35.        ,   36.875     ,   38.75      ,   40.625     ,
             42.5       ,   44.375     ,   46.25      ,   48.125     ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   48.125     ,
             46.25      ,   44.375     ,   42.5       ,   40.625     ,   38.75      ,   36.875     ,
             35.        ,   35.        ,   35.        ,   35.        ,   35.        ,   35.        ,
             35.        ,   35.        ,   35.        ,   35.        ,   35.        ,   35.        ,
             35.        ,   35.        ,   33.5       ,   32.        ,   28.8571434 ,   25.7142849 ,
             22.5714283 ,   19.4285717 ,   16.2857151 ,   13.14285755,   10.        ,    6.66666651,
              3.33333325,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    3.75      ,    7.5       ,   11.25      ,   15.        ,
             15.        ,   15.        ,   15.        ,   15.        ,   15.        ,   15.        ,
             15.        ,   15.        ,   12.5       ,   10.        ,    6.66666985,    3.33299995,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    3.        ,    6.        ,
              9.        ,   12.        ,   15.        ,   15.        ,   15.        ,   18.39999962,
             21.79999924,   25.20000076,   28.60000038,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   29.25      ,   26.5       ,
             23.75      ,   21.        ,   18.25      ,   15.5       ,   12.75      ,   10.        ,
              6.66666698,    3.33333325,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              3.        ,    6.        ,    9.        ,   12.        ,   15.        ,   15.        ,
             15.        ,   17.22220039,   19.44440079,   21.66659927,   23.88879967,   26.11100006,
             28.33320045,   30.55540085,   32.77759933,   35.        ,   35.        ,   35.        ,
             36.875     ,   38.75      ,   40.625     ,   42.5       ,   44.375     ,   46.25      ,
             48.125     ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   48.125     ,   46.25      ,   44.375     ,   42.5       ,
             40.625     ,   38.75      ,   36.875     ,   35.        ,   35.        ,   35.        ,
             35.        ,   35.        ,   35.        ,   35.        ,   35.        ,   35.        ,
             35.        ,   35.        ,   35.        ,   35.        ,   35.        ,   33.5       ,
             32.        ,   28.8571434 ,   25.7142849 ,   22.5714283 ,   19.4285717 ,   16.2857151 ,
             13.14285755,   10.        ,    6.66666651,    3.33333325,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    3.75      ,
              7.5       ,   11.25      ,   15.        ,   15.        ,   15.        ,   15.        ,
             15.        ,   15.        ,   15.        ,   15.        ,   15.        ,   12.5       ,
             10.        ,    6.66666985,    3.33299995,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    3.        ,    6.        ,    9.        ,   12.        ,   15.        ,
             15.        ,   15.        ,   18.39999962,   21.79999924,   25.20000076,   28.60000038,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   29.25      ,   26.5       ,   23.75      ,   21.        ,   18.25      ,
             15.5       ,   12.75      ,   10.        ,    6.66666698,    3.33333325,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    3.        ,    6.        ,    9.        ,
             12.        ,   15.        ,   15.        ,   15.        ,   17.22220039,   19.44440079,
             21.66659927,   23.88879967,   26.11100006,   28.33320045,   30.55540085,   32.77759933,
             35.        ,   35.        ,   35.        ,   36.875     ,   38.75      ,   40.625     ,
             42.5       ,   44.375     ,   46.25      ,   48.125     ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   48.125     ,
             46.25      ,   44.375     ,   42.5       ,   40.625     ,   38.75      ,   36.875     ,
             35.        ,   35.        ,   35.        ,   35.        ,   35.        ,   35.        ,
             35.        ,   35.        ,   35.        ,   35.        ,   35.        ,   35.        ,
             35.        ,   35.        ,   33.5       ,   32.        ,   28.8571434 ,   25.7142849 ,
             22.5714283 ,   19.4285717 ,   16.2857151 ,   13.14285755,   10.        ,    6.66666651,
              3.33333325,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    3.75      ,    7.5       ,   11.25      ,   15.        ,
             15.        ,   15.        ,   15.        ,   15.        ,   15.        ,   15.        ,
             15.        ,   15.        ,   12.5       ,   10.        ,    6.66666985,    3.33299995,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    3.        ,    6.        ,
              9.        ,   12.        ,   15.        ,   15.        ,   15.        ,   18.39999962,
             21.79999924,   25.20000076,   28.60000038,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   32.        ,   32.        ,
             32.        ,   32.        ,   32.        ,   32.        ,   29.25      ,   26.5       ,
             23.75      ,   21.        ,   18.25      ,   15.5       ,   12.75      ,   10.        ,
              6.66666698,    3.33333325,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              3.        ,    6.        ,    9.        ,   12.        ,   15.        ,   15.        ,
             15.        ,   17.22220039,   19.44440079,   21.66659927,   23.88879967,   26.11100006,
             28.33320045,   30.55540085,   32.77759933,   35.        ,   35.        ,   35.        ,
             36.875     ,   38.75      ,   40.625     ,   42.5       ,   44.375     ,   46.25      ,
             48.125     ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   48.125     ,   46.25      ,   44.375     ,   42.5       ,
             40.625     ,   38.75      ,   36.875     ,   35.        ,   35.        ,   35.        ,
             35.        ,   35.        ,   35.        ,   35.        ,   35.        ,   35.        ,
             35.        ,   35.        ,   35.        ,   35.        ,   35.        ,   33.5       ,
             32.        ,   28.8571434 ,   25.7142849 ,   22.5714283 ,   19.4285717 ,   16.2857151 ,
             13.14285755,   10.        ,    6.66666651,    3.33333325,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    3.        ,    6.        ,    9.        ,   12.        ,
             15.        ,   15.        ,   15.        ,   17.22222137,   19.44444466,   21.66666603,
             23.88888931,   26.11111069,   28.33333397,   30.55555534,   32.77777863,   35.        ,
             35.        ,   35.        ,   36.875     ,   38.75      ,   40.625     ,   42.5       ,
             44.375     ,   46.25      ,   48.125     ,   50.        ,   50.        ,   50.        ,
             51.53845978,   53.07691956,   54.61537933,   56.15383911,   57.69229889,   59.23075867,
             60.76921844,   62.30767822,   63.84614182,   65.38459778,   66.92305756,   68.46151733,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   67.5       ,   65.        ,   62.5       ,
             60.        ,   57.5       ,   55.        ,   52.5       ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   50.        ,   50.        ,   50.        ,   50.        ,
             50.        ,   50.        ,   51.53845978,   53.07691956,   54.61537933,   56.15383911,
             57.69229889,   59.23075867,   60.76921844,   62.30767822,   63.84614182,   65.38459778,
             66.92305756,   68.46151733,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.        ,
             70.        ,   70.        ,   70.        ,   70.        ,   70.        ,   70.85713959,
             71.71427917,   72.57141876,   73.42855835,   74.28569794,   75.14283752,   75.99997711,
             76.8571167 ,   77.71425629,   78.5714035 ,   79.42854309,   80.28568268,   81.14282227,
             81.99996185,   82.85710144,   83.71424103,   84.57138062,   85.4285202 ,   86.28565979,
             87.14279938,   87.99993896,   88.85707855,   89.71421814,   90.57135773,   91.42849731,
             92.2856369 ,   93.14277649,   93.99992371,   94.85706329,   95.71420288,   96.57134247,
             97.42848206,   98.28562164,   99.14276123,  100.        ,  100.        ,  100.        ,
            100.        ,  100.        ,  100.        ,  100.        ,  100.        ,  100.        ,
            100.        ,  100.        ,  100.        ,  100.        ,  100.        ,  100.        ,
            100.        ,  100.        ,  100.        ,  100.        ,  100.        ,  100.        ,
            100.        ,  100.        ,  100.        ,  100.        ,  100.        ,  100.        ,
            100.        ,  100.        ,  100.        ,  100.        ,  101.        ,  102.        ,
            103.        ,  104.        ,  105.        ,  106.        ,  107.        ,  108.        ,
            109.        ,  110.        ,  111.        ,  112.        ,  113.        ,  114.        ,
            115.        ,  116.        ,  117.        ,  118.        ,  119.        ,  120.        ,
            120.        ,  120.        ,  120.        ,  120.        ,  120.        ,  120.        ,
            120.        ,  120.        ,  120.        ,  120.        ,  117.5       ,  115.        ,
            112.5       ,  110.        ,  107.5       ,  105.        ,  102.5       ,  100.        ,
             97.5       ,   95.        ,   92.5       ,   90.        ,   87.5       ,   85.        ,
             82.5       ,   80.        ,   76.25      ,   72.5       ,   68.75      ,   65.        ,
             61.25      ,   57.5       ,   53.75      ,   50.        ,   45.        ,   40.        ,
             35.        ,   30.        ,   25.        ,   20.        ,   15.        ,   10.        ,
              5.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.        ,    0.        ,    0.        ,
              0.        ,    0.        ,    0.        ,    0.
        ],
        'gears': [
            0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
            3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
            1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
            3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3,
            3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
            3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
            3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0,
            0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
            4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
            5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4,
            4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
            4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
            4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
            5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
            5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
            6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
            6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
            6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5,
            5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0
        ],
        'clutch': [
            0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0
       ]
       }

    return data
