# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, email=None, id=None, is_admin=None, login=None, name=None, user_id=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_admin and not isinstance(is_admin, bool):
            raise TypeError("Expected argument 'is_admin' to be a bool")
        pulumi.set(__self__, "is_admin", is_admin)
        if login and not isinstance(login, str):
            raise TypeError("Expected argument 'login' to be a str")
        pulumi.set(__self__, "login", login)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if user_id and not isinstance(user_id, int):
            raise TypeError("Expected argument 'user_id' to be a int")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email address of the Grafana user. Defaults to ``.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Whether the user is an admin.
        """
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter
    def login(self) -> Optional[str]:
        """
        The username for the Grafana user. Defaults to ``.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The display name for the Grafana user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[int]:
        """
        The numerical ID of the Grafana user. Defaults to `-1`.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            email=self.email,
            id=self.id,
            is_admin=self.is_admin,
            login=self.login,
            name=self.name,
            user_id=self.user_id)


def get_user(email: Optional[str] = None,
             login: Optional[str] = None,
             user_id: Optional[int] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    * [Official documentation](https://grafana.com/docs/grafana/latest/administration/manage-users-and-permissions/manage-server-users/)
    * [HTTP API](https://grafana.com/docs/grafana/latest/http_api/user/)

    This data source uses Grafana's admin APIs for reading users which
    does not currently work with API Tokens. You must use basic auth.

    ## Example Usage

    ```python
    import pulumi
    import lbrlabs_pulumi_grafana as grafana
    import pulumi_grafana as grafana

    test = grafana.User("test",
        email="test.datasource@example.com",
        login="test-datasource",
        password="my-password",
        is_admin=True)
    from_id = grafana.get_user_output(user_id=test.user_id)
    from_email = grafana.get_user_output(email=test.email)
    from_login = test.login.apply(lambda login: grafana.get_user_output(login=login))
    ```


    :param str email: The email address of the Grafana user. Defaults to ``.
    :param str login: The username for the Grafana user. Defaults to ``.
    :param int user_id: The numerical ID of the Grafana user. Defaults to `-1`.
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['login'] = login
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        email=__ret__.email,
        id=__ret__.id,
        is_admin=__ret__.is_admin,
        login=__ret__.login,
        name=__ret__.name,
        user_id=__ret__.user_id)


@_utilities.lift_output_func(get_user)
def get_user_output(email: Optional[pulumi.Input[Optional[str]]] = None,
                    login: Optional[pulumi.Input[Optional[str]]] = None,
                    user_id: Optional[pulumi.Input[Optional[int]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    * [Official documentation](https://grafana.com/docs/grafana/latest/administration/manage-users-and-permissions/manage-server-users/)
    * [HTTP API](https://grafana.com/docs/grafana/latest/http_api/user/)

    This data source uses Grafana's admin APIs for reading users which
    does not currently work with API Tokens. You must use basic auth.

    ## Example Usage

    ```python
    import pulumi
    import lbrlabs_pulumi_grafana as grafana
    import pulumi_grafana as grafana

    test = grafana.User("test",
        email="test.datasource@example.com",
        login="test-datasource",
        password="my-password",
        is_admin=True)
    from_id = grafana.get_user_output(user_id=test.user_id)
    from_email = grafana.get_user_output(email=test.email)
    from_login = test.login.apply(lambda login: grafana.get_user_output(login=login))
    ```


    :param str email: The email address of the Grafana user. Defaults to ``.
    :param str login: The username for the Grafana user. Defaults to ``.
    :param int user_id: The numerical ID of the Grafana user. Defaults to `-1`.
    """
    ...
