# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['compose_viz', 'compose_viz.models', 'compose_viz.spec']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'graphviz>=0.20,<0.21',
 'pydantic-yaml>=0.6.3,<0.7.0',
 'ruamel.yaml>=0.17.21,<0.18.0',
 'typer>=0.4.1,<0.5.0']

entry_points = \
{'console_scripts': ['cpv = compose_viz.cli:start_cli']}

setup_kwargs = {
    'name': 'compose-viz',
    'version': '0.2.2',
    'description': 'A compose file visualization tool that supports compose-spec and allows you to gernerate graph in several formats.',
    'long_description': '<div id="top"></div>\n\n<!-- PROJECT SHIELDS -->\n\n[<div align="center"> ![Contributors][contributors-shield]][contributors-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![MIT License][license-shield]][license-url]\n[![Issues][issues-shield]][issues-url]\n[![Issues Closed][issues-closed-shield]</div>][issues-closed-url]\n\n<br />\n\n<!-- PROJECT LOGO -->\n\n![compose-viz](https://socialify.git.ci/compose-viz/compose-viz/image?description=1&font=KoHo&name=1&owner=1&pattern=Circuit%20Board&theme=Light)\n\n<br />\n<div align="center">\n<p align="center">\n    <a href="https://github.com/compose-viz/compose-viz#usage"><strong>Explore Usage »</strong></a>\n    <br />\n    <br />\n    <a href="https://github.com/compose-viz/compose-viz/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/compose-viz/compose-viz/issues">Request Feature</a>\n  </p>\n</div>\n\n<!-- TABLE OF CONTENTS -->\n\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#prerequisities">Prerequisities</a></li>\n        <li><a href="#installation">Installation</a></li>\n        <li><a href="#example">Example</a></li>\n        <li><a href="#usage">Usage</a></li>\n        <li><a href="#options">Options</a></li>\n      </ul>\n    </li>\n    <li><a href="#roadmap">Roadmap</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n  </ol>\n</details>\n\n<!-- ABOUT THE PROJECT -->\n\n## About The Project\n\n`compose-viz` is a compose file visualization tool that follows [compose-spec](https://github.com/compose-spec/compose-spec/blob/master/spec.md) and allows you to gernerate graph in several formats.\n\nIf you are looking for a compose file vizualization tool, and you are using one of the [compose-spec](https://github.com/compose-spec/compose-spec/blob/master/spec.md) implementations (e.g. [docker-compose](https://github.com/docker/compose)/[podman-compose](https://github.com/containers/podman-compose)), then `compose-viz` is a great choice for you. \n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- GETTING STARTED -->\n\n## Getting Started\n\n### Prerequisities\n\n#### Graphviz\n\nYou need to install [Graphviz](https://graphviz.org/download/) to generate graphs.\n\n### Installation\n\n#### Using `pip`\n\n`pip install compose-viz`\n\n#### Using `.whl`\n\nSee [releases](https://github.com/compose-viz/compose-viz/releases).\n\n#### Docker Image\n\nSee [wst24365888/compose-viz](https://hub.docker.com/r/wst24365888/compose-viz/tags).\n\n### Example\n\nThis example yml is from [docker compose beginner tutorial](https://github.com/docker/labs/blob/master/beginner/chapters/votingapp.md).\n\n```bash\ncd examples/voting-app/\n\n# using python script\ncpv -m svg docker-compose.yml\n\n# using docker image\ndocker run --rm -it -v $(pwd):/in wst24365888/compose-viz -m svg docker-compose.yml\n\n# using docker image in powershell\ndocker run --rm -it -v ${pwd}:/in wst24365888/compose-viz -m svg docker-compose.yml\n```\n\nAnd this is what the result looks like:\n\n![compose-viz.svg](https://github.com/compose-viz/compose-viz/blob/main/examples/voting-app/compose-viz.svg)\n\nCheck out the result [here](https://github.com/compose-viz/compose-viz/blob/main/examples/voting-app).\n\n### Usage\n\n`cpv [OPTIONS] INPUT_PATH`\n\n### Options\n\n| Option                  | Description                                                                                                                                                                         |\n| ----------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| `-o, --output-filename` | Output filename for the generated visualization file. [default: compose-viz]                                                                                                        |\n| `-m, --format`          | Output format for the generated visualization file. See [supported formats](https://github.com/compose-viz/compose-viz/blob/main/compose_viz/models/viz_formats.py). [default: png] |\n| `-v, --version`         | Show the version of compose-viz.                                                                                                                                                    |\n| `--help`                | Show help and exit.                                                                                                                                                                 |\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- ROADMAP -->\n\n## Roadmap\n\n- [ ] Support more vizualization components.\n\nSee the [open issues](https://github.com/compose-viz/compose-viz/issues)\nfor a full list of proposed features (and known issues).\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- CONTRIBUTING -->\n\n## Contributing\n\nContributions are what make the open source community such an amazing place to\nlearn, inspire, and create. Any contributions you make are **greatly\nappreciated**.\n\nIf you have a suggestion that would make this better, please fork the repo and\ncreate a pull request. You can also simply open an issue with the tag\n"enhancement". Don\'t forget to give the project a star! Thanks again!\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feat/amazing-feature`)\n3. Commit your Changes with\n   [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/)\n4. Push to the Branch (`git push origin feat/amazing-feature`)\n5. Open a Pull Request\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- LICENSE -->\n\n## License\n\nDistributed under the MIT License. See\n[LICENSE](https://github.com/compose-viz/compose-viz/blob/main/LICENSE)\nfor more information.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- CONTACT -->\n\n## Contact\n\n### Author\n\n- HSING-HAN, WU (Xyphuz)\n  - Mail me: xyphuzwu@gmail.com\n  - About me: <https://about.xyphuz.com>\n  - GitHub: <https://github.com/wst24365888>\n\n### Project Link\n\n- <https://github.com/compose-viz/compose-viz>\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n[contributors-shield]: https://img.shields.io/github/contributors/compose-viz/compose-viz.svg?style=for-the-badge\n[contributors-url]: https://github.com/compose-viz/compose-viz/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/compose-viz/compose-viz.svg?style=for-the-badge\n[forks-url]: https://github.com/compose-viz/compose-viz/network/members\n[stars-shield]: https://img.shields.io/github/stars/compose-viz/compose-viz.svg?style=for-the-badge\n[stars-url]: https://github.com/compose-viz/compose-viz/stargazers\n[issues-shield]: https://img.shields.io/github/issues/compose-viz/compose-viz.svg?style=for-the-badge\n[issues-url]: https://github.com/compose-viz/compose-viz/issues\n[issues-closed-shield]: https://img.shields.io/github/issues-closed/compose-viz/compose-viz.svg?style=for-the-badge\n[issues-closed-url]: https://github.com/compose-viz/compose-viz/issues?q=is%3Aissue+is%3Aclosed\n[license-shield]: https://img.shields.io/github/license/compose-viz/compose-viz.svg?style=for-the-badge\n[license-url]: https://github.com/compose-viz/compose-viz/blob/main/LICENSE',
    'author': 'Xyphuz Wu',
    'author_email': 'xyphuzwu@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/compose-viz/compose-viz',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
