# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class TransferInitiate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'source': 'str',
        'amount': 'str',
        'recipient': 'str',
        'reason': 'str',
        'currency': 'str',
        'reference': 'str'
    }

    attribute_map = {
        'source': 'source',
        'amount': 'amount',
        'recipient': 'recipient',
        'reason': 'reason',
        'currency': 'currency',
        'reference': 'reference'
    }

    def __init__(self, source=None, amount=None, recipient=None, reason=None, currency=None, reference=None, local_vars_configuration=None):  # noqa: E501
        """TransferInitiate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._source = None
        self._amount = None
        self._recipient = None
        self._reason = None
        self._currency = None
        self._reference = None
        self.discriminator = None

        self.source = source
        self.amount = amount
        self.recipient = recipient
        if reason is not None:
            self.reason = reason
        if currency is not None:
            self.currency = currency
        if reference is not None:
            self.reference = reference

    @property
    def source(self):
        """Gets the source of this TransferInitiate.  # noqa: E501

        Where should we transfer from? Only balance is allowed for now  # noqa: E501

        :return: The source of this TransferInitiate.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this TransferInitiate.

        Where should we transfer from? Only balance is allowed for now  # noqa: E501

        :param source: The source of this TransferInitiate.  # noqa: E501
        :type source: str
        """
        if self.local_vars_configuration.client_side_validation and source is None:  # noqa: E501
            raise ValueError("Invalid value for `source`, must not be `None`")  # noqa: E501

        self._source = source

    @property
    def amount(self):
        """Gets the amount of this TransferInitiate.  # noqa: E501

        Amount to transfer in kobo if currency is NGN and pesewas if currency is GHS.  # noqa: E501

        :return: The amount of this TransferInitiate.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this TransferInitiate.

        Amount to transfer in kobo if currency is NGN and pesewas if currency is GHS.  # noqa: E501

        :param amount: The amount of this TransferInitiate.  # noqa: E501
        :type amount: str
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def recipient(self):
        """Gets the recipient of this TransferInitiate.  # noqa: E501

        The transfer recipient's code  # noqa: E501

        :return: The recipient of this TransferInitiate.  # noqa: E501
        :rtype: str
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """Sets the recipient of this TransferInitiate.

        The transfer recipient's code  # noqa: E501

        :param recipient: The recipient of this TransferInitiate.  # noqa: E501
        :type recipient: str
        """
        if self.local_vars_configuration.client_side_validation and recipient is None:  # noqa: E501
            raise ValueError("Invalid value for `recipient`, must not be `None`")  # noqa: E501

        self._recipient = recipient

    @property
    def reason(self):
        """Gets the reason of this TransferInitiate.  # noqa: E501

        The reason or narration for the transfer.  # noqa: E501

        :return: The reason of this TransferInitiate.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this TransferInitiate.

        The reason or narration for the transfer.  # noqa: E501

        :param reason: The reason of this TransferInitiate.  # noqa: E501
        :type reason: str
        """

        self._reason = reason

    @property
    def currency(self):
        """Gets the currency of this TransferInitiate.  # noqa: E501

        Specify the currency of the transfer. Defaults to NGN.  # noqa: E501

        :return: The currency of this TransferInitiate.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this TransferInitiate.

        Specify the currency of the transfer. Defaults to NGN.  # noqa: E501

        :param currency: The currency of this TransferInitiate.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    @property
    def reference(self):
        """Gets the reference of this TransferInitiate.  # noqa: E501

        If specified, the field should be a unique identifier (in lowercase) for the object.  Only -,_ and alphanumeric characters are allowed.  # noqa: E501

        :return: The reference of this TransferInitiate.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this TransferInitiate.

        If specified, the field should be a unique identifier (in lowercase) for the object.  Only -,_ and alphanumeric characters are allowed.  # noqa: E501

        :param reference: The reference of this TransferInitiate.  # noqa: E501
        :type reference: str
        """

        self._reference = reference

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransferInitiate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TransferInitiate):
            return True

        return self.to_dict() != other.to_dict()
