# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class PlanCreate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'amount': 'int',
        'interval': 'str',
        'description': 'bool',
        'send_invoices': 'bool',
        'send_sms': 'bool',
        'currency': 'str',
        'invoice_limit': 'int'
    }

    attribute_map = {
        'name': 'name',
        'amount': 'amount',
        'interval': 'interval',
        'description': 'description',
        'send_invoices': 'send_invoices',
        'send_sms': 'send_sms',
        'currency': 'currency',
        'invoice_limit': 'invoice_limit'
    }

    def __init__(self, name=None, amount=None, interval=None, description=None, send_invoices=None, send_sms=None, currency=None, invoice_limit=None, local_vars_configuration=None):  # noqa: E501
        """PlanCreate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._amount = None
        self._interval = None
        self._description = None
        self._send_invoices = None
        self._send_sms = None
        self._currency = None
        self._invoice_limit = None
        self.discriminator = None

        self.name = name
        self.amount = amount
        self.interval = interval
        if description is not None:
            self.description = description
        if send_invoices is not None:
            self.send_invoices = send_invoices
        if send_sms is not None:
            self.send_sms = send_sms
        if currency is not None:
            self.currency = currency
        if invoice_limit is not None:
            self.invoice_limit = invoice_limit

    @property
    def name(self):
        """Gets the name of this PlanCreate.  # noqa: E501

        Name of plan  # noqa: E501

        :return: The name of this PlanCreate.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PlanCreate.

        Name of plan  # noqa: E501

        :param name: The name of this PlanCreate.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def amount(self):
        """Gets the amount of this PlanCreate.  # noqa: E501

        Amount should be in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :return: The amount of this PlanCreate.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this PlanCreate.

        Amount should be in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :param amount: The amount of this PlanCreate.  # noqa: E501
        :type amount: int
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def interval(self):
        """Gets the interval of this PlanCreate.  # noqa: E501

        Interval in words. Valid intervals are daily, weekly, monthly,biannually, annually  # noqa: E501

        :return: The interval of this PlanCreate.  # noqa: E501
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this PlanCreate.

        Interval in words. Valid intervals are daily, weekly, monthly,biannually, annually  # noqa: E501

        :param interval: The interval of this PlanCreate.  # noqa: E501
        :type interval: str
        """
        if self.local_vars_configuration.client_side_validation and interval is None:  # noqa: E501
            raise ValueError("Invalid value for `interval`, must not be `None`")  # noqa: E501

        self._interval = interval

    @property
    def description(self):
        """Gets the description of this PlanCreate.  # noqa: E501

        A description for this plan  # noqa: E501

        :return: The description of this PlanCreate.  # noqa: E501
        :rtype: bool
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this PlanCreate.

        A description for this plan  # noqa: E501

        :param description: The description of this PlanCreate.  # noqa: E501
        :type description: bool
        """

        self._description = description

    @property
    def send_invoices(self):
        """Gets the send_invoices of this PlanCreate.  # noqa: E501

        Set to false if you don't want invoices to be sent to your customers  # noqa: E501

        :return: The send_invoices of this PlanCreate.  # noqa: E501
        :rtype: bool
        """
        return self._send_invoices

    @send_invoices.setter
    def send_invoices(self, send_invoices):
        """Sets the send_invoices of this PlanCreate.

        Set to false if you don't want invoices to be sent to your customers  # noqa: E501

        :param send_invoices: The send_invoices of this PlanCreate.  # noqa: E501
        :type send_invoices: bool
        """

        self._send_invoices = send_invoices

    @property
    def send_sms(self):
        """Gets the send_sms of this PlanCreate.  # noqa: E501

        Set to false if you don't want text messages to be sent to your customers  # noqa: E501

        :return: The send_sms of this PlanCreate.  # noqa: E501
        :rtype: bool
        """
        return self._send_sms

    @send_sms.setter
    def send_sms(self, send_sms):
        """Sets the send_sms of this PlanCreate.

        Set to false if you don't want text messages to be sent to your customers  # noqa: E501

        :param send_sms: The send_sms of this PlanCreate.  # noqa: E501
        :type send_sms: bool
        """

        self._send_sms = send_sms

    @property
    def currency(self):
        """Gets the currency of this PlanCreate.  # noqa: E501

        Currency in which amount is set. Allowed values are NGN, GHS, ZAR or USD  # noqa: E501

        :return: The currency of this PlanCreate.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this PlanCreate.

        Currency in which amount is set. Allowed values are NGN, GHS, ZAR or USD  # noqa: E501

        :param currency: The currency of this PlanCreate.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    @property
    def invoice_limit(self):
        """Gets the invoice_limit of this PlanCreate.  # noqa: E501

        Number of invoices to raise during subscription to this plan.  Can be overridden by specifying an invoice_limit while subscribing.  # noqa: E501

        :return: The invoice_limit of this PlanCreate.  # noqa: E501
        :rtype: int
        """
        return self._invoice_limit

    @invoice_limit.setter
    def invoice_limit(self, invoice_limit):
        """Sets the invoice_limit of this PlanCreate.

        Number of invoices to raise during subscription to this plan.  Can be overridden by specifying an invoice_limit while subscribing.  # noqa: E501

        :param invoice_limit: The invoice_limit of this PlanCreate.  # noqa: E501
        :type invoice_limit: int
        """

        self._invoice_limit = invoice_limit

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlanCreate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PlanCreate):
            return True

        return self.to_dict() != other.to_dict()
