# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class PageCreate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'amount': 'int',
        'slug': 'str',
        'metadata': 'str',
        'redirect_url': 'str',
        'custom_fields': 'list[object]'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'amount': 'amount',
        'slug': 'slug',
        'metadata': 'metadata',
        'redirect_url': 'redirect_url',
        'custom_fields': 'custom_fields'
    }

    def __init__(self, name=None, description=None, amount=None, slug=None, metadata=None, redirect_url=None, custom_fields=None, local_vars_configuration=None):  # noqa: E501
        """PageCreate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._amount = None
        self._slug = None
        self._metadata = None
        self._redirect_url = None
        self._custom_fields = None
        self.discriminator = None

        self.name = name
        if description is not None:
            self.description = description
        if amount is not None:
            self.amount = amount
        if slug is not None:
            self.slug = slug
        if metadata is not None:
            self.metadata = metadata
        if redirect_url is not None:
            self.redirect_url = redirect_url
        if custom_fields is not None:
            self.custom_fields = custom_fields

    @property
    def name(self):
        """Gets the name of this PageCreate.  # noqa: E501

        Name of page  # noqa: E501

        :return: The name of this PageCreate.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PageCreate.

        Name of page  # noqa: E501

        :param name: The name of this PageCreate.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this PageCreate.  # noqa: E501

        The description of the page  # noqa: E501

        :return: The description of this PageCreate.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this PageCreate.

        The description of the page  # noqa: E501

        :param description: The description of this PageCreate.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def amount(self):
        """Gets the amount of this PageCreate.  # noqa: E501

        Amount should be in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :return: The amount of this PageCreate.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this PageCreate.

        Amount should be in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :param amount: The amount of this PageCreate.  # noqa: E501
        :type amount: int
        """

        self._amount = amount

    @property
    def slug(self):
        """Gets the slug of this PageCreate.  # noqa: E501

        URL slug you would like to be associated with this page. Page will be accessible at https://paystack.com/pay/[slug]  # noqa: E501

        :return: The slug of this PageCreate.  # noqa: E501
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this PageCreate.

        URL slug you would like to be associated with this page. Page will be accessible at https://paystack.com/pay/[slug]  # noqa: E501

        :param slug: The slug of this PageCreate.  # noqa: E501
        :type slug: str
        """

        self._slug = slug

    @property
    def metadata(self):
        """Gets the metadata of this PageCreate.  # noqa: E501

        Stringified JSON object of custom data  # noqa: E501

        :return: The metadata of this PageCreate.  # noqa: E501
        :rtype: str
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this PageCreate.

        Stringified JSON object of custom data  # noqa: E501

        :param metadata: The metadata of this PageCreate.  # noqa: E501
        :type metadata: str
        """

        self._metadata = metadata

    @property
    def redirect_url(self):
        """Gets the redirect_url of this PageCreate.  # noqa: E501

        If you would like Paystack to redirect to a URL upon successful payment, specify the URL here.  # noqa: E501

        :return: The redirect_url of this PageCreate.  # noqa: E501
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """Sets the redirect_url of this PageCreate.

        If you would like Paystack to redirect to a URL upon successful payment, specify the URL here.  # noqa: E501

        :param redirect_url: The redirect_url of this PageCreate.  # noqa: E501
        :type redirect_url: str
        """

        self._redirect_url = redirect_url

    @property
    def custom_fields(self):
        """Gets the custom_fields of this PageCreate.  # noqa: E501

        If you would like to accept custom fields, specify them here.  # noqa: E501

        :return: The custom_fields of this PageCreate.  # noqa: E501
        :rtype: list[object]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this PageCreate.

        If you would like to accept custom fields, specify them here.  # noqa: E501

        :param custom_fields: The custom_fields of this PageCreate.  # noqa: E501
        :type custom_fields: list[object]
        """

        self._custom_fields = custom_fields

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PageCreate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PageCreate):
            return True

        return self.to_dict() != other.to_dict()
