# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class DisputeEvidence(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'customer_email': 'str',
        'customer_name': 'str',
        'customer_phone': 'str',
        'service_details': 'str',
        'delivery_address': 'str',
        'delivery_date': 'datetime'
    }

    attribute_map = {
        'customer_email': 'customer_email',
        'customer_name': 'customer_name',
        'customer_phone': 'customer_phone',
        'service_details': 'service_details',
        'delivery_address': 'delivery_address',
        'delivery_date': 'delivery_date'
    }

    def __init__(self, customer_email=None, customer_name=None, customer_phone=None, service_details=None, delivery_address=None, delivery_date=None, local_vars_configuration=None):  # noqa: E501
        """DisputeEvidence - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._customer_email = None
        self._customer_name = None
        self._customer_phone = None
        self._service_details = None
        self._delivery_address = None
        self._delivery_date = None
        self.discriminator = None

        self.customer_email = customer_email
        self.customer_name = customer_name
        self.customer_phone = customer_phone
        self.service_details = service_details
        if delivery_address is not None:
            self.delivery_address = delivery_address
        if delivery_date is not None:
            self.delivery_date = delivery_date

    @property
    def customer_email(self):
        """Gets the customer_email of this DisputeEvidence.  # noqa: E501

        Customer email  # noqa: E501

        :return: The customer_email of this DisputeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._customer_email

    @customer_email.setter
    def customer_email(self, customer_email):
        """Sets the customer_email of this DisputeEvidence.

        Customer email  # noqa: E501

        :param customer_email: The customer_email of this DisputeEvidence.  # noqa: E501
        :type customer_email: str
        """
        if self.local_vars_configuration.client_side_validation and customer_email is None:  # noqa: E501
            raise ValueError("Invalid value for `customer_email`, must not be `None`")  # noqa: E501

        self._customer_email = customer_email

    @property
    def customer_name(self):
        """Gets the customer_name of this DisputeEvidence.  # noqa: E501

        Customer name  # noqa: E501

        :return: The customer_name of this DisputeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._customer_name

    @customer_name.setter
    def customer_name(self, customer_name):
        """Sets the customer_name of this DisputeEvidence.

        Customer name  # noqa: E501

        :param customer_name: The customer_name of this DisputeEvidence.  # noqa: E501
        :type customer_name: str
        """
        if self.local_vars_configuration.client_side_validation and customer_name is None:  # noqa: E501
            raise ValueError("Invalid value for `customer_name`, must not be `None`")  # noqa: E501

        self._customer_name = customer_name

    @property
    def customer_phone(self):
        """Gets the customer_phone of this DisputeEvidence.  # noqa: E501

        Customer mobile number  # noqa: E501

        :return: The customer_phone of this DisputeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._customer_phone

    @customer_phone.setter
    def customer_phone(self, customer_phone):
        """Sets the customer_phone of this DisputeEvidence.

        Customer mobile number  # noqa: E501

        :param customer_phone: The customer_phone of this DisputeEvidence.  # noqa: E501
        :type customer_phone: str
        """
        if self.local_vars_configuration.client_side_validation and customer_phone is None:  # noqa: E501
            raise ValueError("Invalid value for `customer_phone`, must not be `None`")  # noqa: E501

        self._customer_phone = customer_phone

    @property
    def service_details(self):
        """Gets the service_details of this DisputeEvidence.  # noqa: E501

        Details of service offered  # noqa: E501

        :return: The service_details of this DisputeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._service_details

    @service_details.setter
    def service_details(self, service_details):
        """Sets the service_details of this DisputeEvidence.

        Details of service offered  # noqa: E501

        :param service_details: The service_details of this DisputeEvidence.  # noqa: E501
        :type service_details: str
        """
        if self.local_vars_configuration.client_side_validation and service_details is None:  # noqa: E501
            raise ValueError("Invalid value for `service_details`, must not be `None`")  # noqa: E501

        self._service_details = service_details

    @property
    def delivery_address(self):
        """Gets the delivery_address of this DisputeEvidence.  # noqa: E501

        Delivery address  # noqa: E501

        :return: The delivery_address of this DisputeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._delivery_address

    @delivery_address.setter
    def delivery_address(self, delivery_address):
        """Sets the delivery_address of this DisputeEvidence.

        Delivery address  # noqa: E501

        :param delivery_address: The delivery_address of this DisputeEvidence.  # noqa: E501
        :type delivery_address: str
        """

        self._delivery_address = delivery_address

    @property
    def delivery_date(self):
        """Gets the delivery_date of this DisputeEvidence.  # noqa: E501

        ISO 8601 representation of delivery date (YYYY-MM-DD)  # noqa: E501

        :return: The delivery_date of this DisputeEvidence.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_date

    @delivery_date.setter
    def delivery_date(self, delivery_date):
        """Sets the delivery_date of this DisputeEvidence.

        ISO 8601 representation of delivery date (YYYY-MM-DD)  # noqa: E501

        :param delivery_date: The delivery_date of this DisputeEvidence.  # noqa: E501
        :type delivery_date: datetime
        """

        self._delivery_date = delivery_date

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DisputeEvidence):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DisputeEvidence):
            return True

        return self.to_dict() != other.to_dict()
