# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class CustomerValidation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'first_name': 'str',
        'last_name': 'str',
        'type': 'str',
        'country': 'str',
        'bvn': 'str',
        'bank_code': 'str',
        'account_number': 'str',
        'value': 'str'
    }

    attribute_map = {
        'first_name': 'first_name',
        'last_name': 'last_name',
        'type': 'type',
        'country': 'country',
        'bvn': 'bvn',
        'bank_code': 'bank_code',
        'account_number': 'account_number',
        'value': 'value'
    }

    def __init__(self, first_name=None, last_name=None, type=None, country=None, bvn=None, bank_code=None, account_number=None, value=None, local_vars_configuration=None):  # noqa: E501
        """CustomerValidation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._first_name = None
        self._last_name = None
        self._type = None
        self._country = None
        self._bvn = None
        self._bank_code = None
        self._account_number = None
        self._value = None
        self.discriminator = None

        self.first_name = first_name
        self.last_name = last_name
        self.type = type
        self.country = country
        self.bvn = bvn
        self.bank_code = bank_code
        self.account_number = account_number
        if value is not None:
            self.value = value

    @property
    def first_name(self):
        """Gets the first_name of this CustomerValidation.  # noqa: E501

        Customer's first name  # noqa: E501

        :return: The first_name of this CustomerValidation.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this CustomerValidation.

        Customer's first name  # noqa: E501

        :param first_name: The first_name of this CustomerValidation.  # noqa: E501
        :type first_name: str
        """
        if self.local_vars_configuration.client_side_validation and first_name is None:  # noqa: E501
            raise ValueError("Invalid value for `first_name`, must not be `None`")  # noqa: E501

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this CustomerValidation.  # noqa: E501

        Customer's last name  # noqa: E501

        :return: The last_name of this CustomerValidation.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this CustomerValidation.

        Customer's last name  # noqa: E501

        :param last_name: The last_name of this CustomerValidation.  # noqa: E501
        :type last_name: str
        """
        if self.local_vars_configuration.client_side_validation and last_name is None:  # noqa: E501
            raise ValueError("Invalid value for `last_name`, must not be `None`")  # noqa: E501

        self._last_name = last_name

    @property
    def type(self):
        """Gets the type of this CustomerValidation.  # noqa: E501

        Predefined types of identification.  # noqa: E501

        :return: The type of this CustomerValidation.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CustomerValidation.

        Predefined types of identification.  # noqa: E501

        :param type: The type of this CustomerValidation.  # noqa: E501
        :type type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def country(self):
        """Gets the country of this CustomerValidation.  # noqa: E501

        Two-letter country code of identification issuer  # noqa: E501

        :return: The country of this CustomerValidation.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this CustomerValidation.

        Two-letter country code of identification issuer  # noqa: E501

        :param country: The country of this CustomerValidation.  # noqa: E501
        :type country: str
        """
        if self.local_vars_configuration.client_side_validation and country is None:  # noqa: E501
            raise ValueError("Invalid value for `country`, must not be `None`")  # noqa: E501

        self._country = country

    @property
    def bvn(self):
        """Gets the bvn of this CustomerValidation.  # noqa: E501

        Customer's Bank Verification Number  # noqa: E501

        :return: The bvn of this CustomerValidation.  # noqa: E501
        :rtype: str
        """
        return self._bvn

    @bvn.setter
    def bvn(self, bvn):
        """Sets the bvn of this CustomerValidation.

        Customer's Bank Verification Number  # noqa: E501

        :param bvn: The bvn of this CustomerValidation.  # noqa: E501
        :type bvn: str
        """
        if self.local_vars_configuration.client_side_validation and bvn is None:  # noqa: E501
            raise ValueError("Invalid value for `bvn`, must not be `None`")  # noqa: E501

        self._bvn = bvn

    @property
    def bank_code(self):
        """Gets the bank_code of this CustomerValidation.  # noqa: E501

        You can get the list of bank codes by calling the List Banks endpoint (https://api.paystack.co/bank).  # noqa: E501

        :return: The bank_code of this CustomerValidation.  # noqa: E501
        :rtype: str
        """
        return self._bank_code

    @bank_code.setter
    def bank_code(self, bank_code):
        """Sets the bank_code of this CustomerValidation.

        You can get the list of bank codes by calling the List Banks endpoint (https://api.paystack.co/bank).  # noqa: E501

        :param bank_code: The bank_code of this CustomerValidation.  # noqa: E501
        :type bank_code: str
        """
        if self.local_vars_configuration.client_side_validation and bank_code is None:  # noqa: E501
            raise ValueError("Invalid value for `bank_code`, must not be `None`")  # noqa: E501

        self._bank_code = bank_code

    @property
    def account_number(self):
        """Gets the account_number of this CustomerValidation.  # noqa: E501

        Customer's bank account number.  # noqa: E501

        :return: The account_number of this CustomerValidation.  # noqa: E501
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """Sets the account_number of this CustomerValidation.

        Customer's bank account number.  # noqa: E501

        :param account_number: The account_number of this CustomerValidation.  # noqa: E501
        :type account_number: str
        """
        if self.local_vars_configuration.client_side_validation and account_number is None:  # noqa: E501
            raise ValueError("Invalid value for `account_number`, must not be `None`")  # noqa: E501

        self._account_number = account_number

    @property
    def value(self):
        """Gets the value of this CustomerValidation.  # noqa: E501

        Customer's identification number. Required if type is bvn  # noqa: E501

        :return: The value of this CustomerValidation.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this CustomerValidation.

        Customer's identification number. Required if type is bvn  # noqa: E501

        :param value: The value of this CustomerValidation.  # noqa: E501
        :type value: str
        """

        self._value = value

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CustomerValidation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CustomerValidation):
            return True

        return self.to_dict() != other.to_dict()
