# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class ChargeSubmitAddress(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'address': 'str',
        'city': 'str',
        'state': 'str',
        'zipcode': 'str',
        'reference': 'str'
    }

    attribute_map = {
        'address': 'address',
        'city': 'city',
        'state': 'state',
        'zipcode': 'zipcode',
        'reference': 'reference'
    }

    def __init__(self, address=None, city=None, state=None, zipcode=None, reference=None, local_vars_configuration=None):  # noqa: E501
        """ChargeSubmitAddress - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._address = None
        self._city = None
        self._state = None
        self._zipcode = None
        self._reference = None
        self.discriminator = None

        self.address = address
        self.city = city
        self.state = state
        self.zipcode = zipcode
        self.reference = reference

    @property
    def address(self):
        """Gets the address of this ChargeSubmitAddress.  # noqa: E501

        Customer's address  # noqa: E501

        :return: The address of this ChargeSubmitAddress.  # noqa: E501
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this ChargeSubmitAddress.

        Customer's address  # noqa: E501

        :param address: The address of this ChargeSubmitAddress.  # noqa: E501
        :type address: str
        """
        if self.local_vars_configuration.client_side_validation and address is None:  # noqa: E501
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501

        self._address = address

    @property
    def city(self):
        """Gets the city of this ChargeSubmitAddress.  # noqa: E501

        Customer's city  # noqa: E501

        :return: The city of this ChargeSubmitAddress.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this ChargeSubmitAddress.

        Customer's city  # noqa: E501

        :param city: The city of this ChargeSubmitAddress.  # noqa: E501
        :type city: str
        """
        if self.local_vars_configuration.client_side_validation and city is None:  # noqa: E501
            raise ValueError("Invalid value for `city`, must not be `None`")  # noqa: E501

        self._city = city

    @property
    def state(self):
        """Gets the state of this ChargeSubmitAddress.  # noqa: E501

        Customer's state  # noqa: E501

        :return: The state of this ChargeSubmitAddress.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ChargeSubmitAddress.

        Customer's state  # noqa: E501

        :param state: The state of this ChargeSubmitAddress.  # noqa: E501
        :type state: str
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def zipcode(self):
        """Gets the zipcode of this ChargeSubmitAddress.  # noqa: E501

        Customer's zipcode  # noqa: E501

        :return: The zipcode of this ChargeSubmitAddress.  # noqa: E501
        :rtype: str
        """
        return self._zipcode

    @zipcode.setter
    def zipcode(self, zipcode):
        """Sets the zipcode of this ChargeSubmitAddress.

        Customer's zipcode  # noqa: E501

        :param zipcode: The zipcode of this ChargeSubmitAddress.  # noqa: E501
        :type zipcode: str
        """
        if self.local_vars_configuration.client_side_validation and zipcode is None:  # noqa: E501
            raise ValueError("Invalid value for `zipcode`, must not be `None`")  # noqa: E501

        self._zipcode = zipcode

    @property
    def reference(self):
        """Gets the reference of this ChargeSubmitAddress.  # noqa: E501

        The reference of the ongoing transaction  # noqa: E501

        :return: The reference of this ChargeSubmitAddress.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this ChargeSubmitAddress.

        The reference of the ongoing transaction  # noqa: E501

        :param reference: The reference of this ChargeSubmitAddress.  # noqa: E501
        :type reference: str
        """
        if self.local_vars_configuration.client_side_validation and reference is None:  # noqa: E501
            raise ValueError("Invalid value for `reference`, must not be `None`")  # noqa: E501

        self._reference = reference

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChargeSubmitAddress):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChargeSubmitAddress):
            return True

        return self.to_dict() != other.to_dict()
