# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class BulkChargeInitiate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'authorization': 'str',
        'amount': 'str'
    }

    attribute_map = {
        'authorization': 'authorization',
        'amount': 'amount'
    }

    def __init__(self, authorization=None, amount=None, local_vars_configuration=None):  # noqa: E501
        """BulkChargeInitiate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._authorization = None
        self._amount = None
        self.discriminator = None

        self.authorization = authorization
        self.amount = amount

    @property
    def authorization(self):
        """Gets the authorization of this BulkChargeInitiate.  # noqa: E501

        Customer's card authorization code  # noqa: E501

        :return: The authorization of this BulkChargeInitiate.  # noqa: E501
        :rtype: str
        """
        return self._authorization

    @authorization.setter
    def authorization(self, authorization):
        """Sets the authorization of this BulkChargeInitiate.

        Customer's card authorization code  # noqa: E501

        :param authorization: The authorization of this BulkChargeInitiate.  # noqa: E501
        :type authorization: str
        """
        if self.local_vars_configuration.client_side_validation and authorization is None:  # noqa: E501
            raise ValueError("Invalid value for `authorization`, must not be `None`")  # noqa: E501

        self._authorization = authorization

    @property
    def amount(self):
        """Gets the amount of this BulkChargeInitiate.  # noqa: E501

        Amount to charge on the authorization  # noqa: E501

        :return: The amount of this BulkChargeInitiate.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this BulkChargeInitiate.

        Amount to charge on the authorization  # noqa: E501

        :param amount: The amount of this BulkChargeInitiate.  # noqa: E501
        :type amount: str
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BulkChargeInitiate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BulkChargeInitiate):
            return True

        return self.to_dict() != other.to_dict()
