#coding:utf-8
from . import PdfFileReader, PdfFileWriter

import sys
import io

import requests




def fileBuffer_to_PDfReader(body):
    try:
        pdfreader = PdfFileReader(io.BytesIO(body),strict=False)
        return pdfreader
    except IOError:
        sys.stderr.write("Problem in reading file.")



def del_waterMark_interface(stream ,fun_para_dict):
    '''不调试的时候，把try...except放开'''
    if 1:
        # try:
        pdfreader = fileBuffer_to_PDfReader(stream)

        pdfwriter = PdfFileWriter()

        for index in range(pdfreader.numPages):  #
            pageObj = pdfreader.getPage(index)
            pdfwriter.addPage(pageObj)
        # except:
        #     print("PDF format error !!!")
        #     return None, -1
    #try:
    if 1:
        file_content = io.BytesIO()
        for fun,paras in fun_para_dict.items():
            for para in paras:
                del_waterMark_fun=getattr(pdfwriter,fun)
                flag = del_waterMark_fun(*para)
                pdfwriter.write(file_content)

        new_steam = file_content.getvalue()
        file_content.close()
    #except:
        # print("removeWaterMark error!!: %s" % filePath)
        # return None, -2
    return new_steam, flag

def del_waterMark_cnki_flow_1(stream):
    ##cnki样例1
    para = (
    b'/BZ1-0 1 Tf\r0 Tr\r10.285715 0 0 10.285715 0 -8.742857 Tm\r5.5 73.869811 TD\r(!) Tj\r0.660377 0 TD\r(") Tj\r0.660377 0 TD\r(#) Tj\r/BZ0-0 1 Tf\r0 Tr\r10.285715 0 0 10.285715 0 -8.742857 Tm\r7.179245 73.869811 TD\r(") Tj\r/BZ1-0 1 Tf\r0 Tr\r10.285715 0 0 10.285715 0 -8.742857 Tm\r7.660378 73.869811 TD\r($) Tj\r0.5 0 TD\r(%) Tj\r0.528302 0 TD\r(&) Tj\r0.283018 0 TD\r($) Tj\r0.5 0 TD\r(\') Tj\r0.5 0 TD\r(\\() Tj\r0.5 0 TD\r(\\)) Tj\r0.500001 0 TD\r(%) Tj\r0.650943 0 TD\r(*) Tj\r0.386793 0 TD\r(+) Tj\r0.301888 0 TD\r(&) Tj\r0.311321 0 TD\r(,) Tj\r0.443396 0 TD\r(-) Tj\r0.5 0 TD\r(.) Tj\r0.500001 0 TD\r(/) Tj\r0.301887 0 TD\r(&) Tj\r0.311321 0 TD\r(0) Tj\r0.500001 0 TD\r(1) Tj\r0.499999 0 TD\r(2) Tj\r0.273584 0 TD\r(+) Tj\r0.273585 0 TD\r(3) Tj\r0.405661 0 TD\r(&) Tj\r0.283018 0 TD\r(\\() Tj\r0.5 0 TD\r(%) Tj\r0.5 0 TD\r(\\() Tj\r0.500002 0 TD\r($) Tj\r0.528301 0 TD\r(&) Tj\r0.283018 0 TD\r(%) Tj\r0.5 0 TD\r(4) Tj\r0.528303 0 TD\r(&) Tj\r0.283018 0 TD\r(%) Tj\r0.5 0 TD\r(%) Tj\r0.5 0 TD\r([) Tj\r/BZ3-0 1 Tf\r0 Tr\r10.285715 0 0 10.285715 0 -8.742857 Tm\r5.5 7.690567 TD\r(!) Tj\r0.509434 0 TD\r(A) Tj\r0.509434 0 TD\r(C) Tj\r/BZ6-0 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.94717 Tm\r9.208792 8.793407 TD\r[(b)-21(`)-21(c)] TJ\r/BZ6-1 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.94717 Tm\r12.274726 8.793407 TD\r[(6)-21(7)-21(Q)] TJ\r/BZ1-0 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.50566 Tm\r15.571429 8.793407 TD\r(4) Tj\r0.494506 0 TD\r([) Tj\r/BZ6-1 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.94717 Tm\r16.835165 8.793407 TD\r[(R)-21(Q)] TJ\r/BZ1-0 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.50566 Tm\r19.109892 8.793407 TD\r(4) Tj\r/BZ6-1 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.94717 Tm\r19.879124 8.793407 TD\r(S) Tj\r/BZ1-0 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.50566 Tm\r55.7033 8.793407 TD\r(\\() Tj\r0.494503 0 TD\r(%) Tj\r0.494511 0 TD\r(\\() Tj\r0.494503 0 TD\r($) Tj\r/BZ6-0 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.94717 Tm\r57.956051 8.793407 TD\r(") Tj\r/BZ1-0 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.50566 Tm\r59.208794 8.793407 TD\r(4) Tj\r/BZ6-1 1 Tf\r0 Tr\r8.830189 0 0 8.830189 0 -7.94717 Tm\r59.978027 8.793407 TD\r(T) Tj\r0 Tw\rET\r1 i \r0.327493 w \r56.599998 105.5 m\r286.899994 105.5 l\rS\rBT\r'
    ,b'')
    new_steam, flag = del_waterMark_interface(stream, {'removeCurve_xcc':[para]})
    return new_steam, flag


def del_waterMark_cnki_flow_2(stream):
    ##cnki样例2
    para1 = (
        b'(ht)6(t)6(ps)3(:)6(/)6(/)6(kns)9(.)2(c)4(n)6(ki)12(.)2(ne)4(t)6(/)6(kc)4(m)15(s)3(/)6(de)4(t)6(a)4(il)6(/)6(1)36(1.)8(3)6(67)6(6.)2(T)9(D.)8(2)6(02)6(1)42(1)42(1)42(12)6(.)2(1)6(9)6(30)6(.)8(00)6(6.)8(ht)6(m)15(l)'
        , b'')
    para2={(180,180)}
    para3={(166,43)}

    new_steam, flag = del_waterMark_interface(stream, { 'removeCurve_xcc':[para1],'removeImages_xcc':[para2,para3]})
    return new_steam, flag


def del_waterMark_cnki_flow_3( stream):
    para1= (
     b'BT\n17 831.79 Td\n/F0 8.96886 Tf\n<01>Tj\n5 0 Td\n<02>Tj\n6 0 Td\n<03>Tj\n4 0 Td\n<04>Tj\n6 0 Td\n<05>Tj\n3 0 Td\n<06>Tj\n5 0 Td\n<07>Tj\n4 0 Td\n<05>Tj\n3 0 Td\n<08>Tj\n4 0 Td\n<09>Tj\n3 0 Td\n<0A>Tj\n4 0 Td\n<0B>Tj\n7 0 Td\n<0C>Tj\n2 0 Td\n<0D>Tj\n4 0 Td\n<07>Tj\n4 0 Td\n<0E>Tj\n4 0 Td\n<0F>Tj\n3 0 Td\n<10>Tj\n3 0 Td\n<11>Tj\n5 0 Td\n<07>Tj\n4 0 Td\n<0E>Tj\n4 0 Td\n<0F>Tj\n4 0 Td\n<05>Tj\n3 0 Td\n<05>Tj\n7 0 Td\n<12>Tj\n3 0 Td\n<13>Tj\n4 0 Td\n<09>Tj\n3 0 Td\n<14>Tj\n4 0 Td\n<05>Tj\n7 0 Td\n<0C>Tj\n2 0 Td\n<15>Tj\n3 0 Td\n<0F>Tj\n5 0 Td\n<07>Tj\n4 0 Td\n<16>Tj\n3 0 Td\n<06>Tj\n4 0 Td\n<05>Tj\n3 0 Td\n<17>Tj\n5 0 Td\n<07>Tj\n4 0 Td\n<16>Tj\n4 0 Td\n<06>Tj\n4 0 Td\n<07>Tj\n4 0 Td\n<05>Tj\n4 0 Td\n<08>Tj\n3 0 Td\n<16>Tj\nET\n'
    ,b'')
    para2=(
     b'''0.7 G\rn\r436.1 27.4 m\r433.6 19.9 l\r433.1 19.9 l\r435.7 27.4 l\rh\rf*\rn\r29.9 27.2 m\r30.1 24.8 l\r29.9 24.8 l\r29.7 25.5 29.4 26.1 29.0 26.4 c\r28.6 26.7 28.1 26.9 27.6 26.9 c\r27.1 26.9 26.7 26.7 26.3 26.5 c\r26.0 26.3 25.7 25.9 25.5 25.4 c\r25.2 24.8 25.1 24.2 25.1 23.4 c\r25.1 22.8 25.2 22.2 25.4 21.8 c\r25.6 21.3 25.9 21.0 26.4 20.7 c\r26.8 20.5 27.2 20.3 27.7 20.3 c\r28.2 20.3 28.6 20.4 28.9 20.6 c\r29.3 20.8 29.7 21.2 30.1 21.7 c\r30.3 21.7 l\r29.9 21.0 29.5 20.6 29.0 20.3 c\r28.6 20.0 28.0 19.9 27.4 19.9 c\r26.2 19.9 25.3 20.3 24.6 21.2 c\r24.2 21.8 23.9 22.6 23.9 23.4 c\r23.9 24.1 24.1 24.8 24.4 25.3 c\r24.7 25.9 25.2 26.4 25.7 26.7 c\r26.3 27.0 26.9 27.2 27.5 27.2 c\r28.0 27.2 28.5 27.1 29.0 26.9 c\r29.2 26.8 29.3 26.8 29.4 26.8 c\r29.4 26.8 29.5 26.8 29.6 26.9 c\r29.7 26.9 29.8 27.1 29.8 27.2 c\rh\rf*\rn\r258.5 27.4 m\r258.6 27.4 258.7 27.3 258.8 27.2 c\r258.9 27.1 259.0 27.0 259.0 26.9 c\r259.0 26.7 258.9 26.6 258.8 26.5 c\r258.7 26.4 258.6 26.3 258.5 26.3 c\r258.3 26.3 258.2 26.4 258.1 26.5 c\r258.0 26.6 257.9 26.7 257.9 26.9 c\r257.9 27.0 258.0 27.1 258.1 27.2 c\r258.2 27.3 258.3 27.4 258.5 27.4 c\r258.9 24.9 m\r258.9 21.1 l\r258.9 20.8 259.0 20.5 259.0 20.4 c\r259.0 20.3 259.1 20.3 259.2 20.2 c\r259.3 20.2 259.4 20.1 259.7 20.1 c\r259.7 20.0 l\r257.3 20.0 l\r257.3 20.1 l\r257.6 20.1 257.7 20.2 257.8 20.2 c\r257.9 20.3 257.9 20.3 258.0 20.4 c\r258.0 20.5 258.1 20.8 258.1 21.1 c\r258.1 22.9 l\r258.1 23.5 258.0 23.8 258.0 24.0 c\r258.0 24.1 258.0 24.2 257.9 24.2 c\r257.9 24.2 257.8 24.3 257.7 24.3 c\r257.6 24.3 257.5 24.2 257.3 24.2 c\r257.3 24.3 l\r258.7 24.9 l\rh\rf*\rn\r35.5 26.4 m\r37.2 27.2 l\r37.3 27.2 l\r37.3 21.3 l\r37.3 20.8 37.3 20.6 37.4 20.5 c\r37.4 20.4 37.5 20.3 37.6 20.2 c\r37.7 20.2 37.9 20.1 38.2 20.1 c\r38.2 20.0 l\r35.6 20.0 l\r35.6 20.1 l\r35.9 20.1 36.1 20.2 36.2 20.2 c\r36.3 20.3 36.4 20.4 36.4 20.4 c\r36.4 20.5 36.5 20.8 36.5 21.3 c\r36.5 25.1 l\r36.5 25.6 36.4 26.0 36.4 26.1 c\r36.4 26.2 36.3 26.3 36.3 26.3 c\r36.2 26.4 36.1 26.4 36.1 26.4 c\r35.9 26.4 35.8 26.4 35.5 26.3 c\rh\rf*\rn\r132.1 20.6 m\r131.9 20.3 131.7 20.1 131.5 20.0 c\r131.2 19.9 131.0 19.9 130.7 19.9 c\r130.2 19.9 129.8 20.1 129.4 20.5 c\r129.0 21.0 128.8 21.5 128.8 22.2 c\r128.8 22.9 129.0 23.5 129.4 24.1 c\r129.9 24.6 130.4 24.9 131.1 24.9 c\r131.5 24.9 131.9 24.8 132.1 24.5 c\r132.1 25.4 l\r132.1 25.9 132.1 26.3 132.1 26.4 c\r132.1 26.5 132.0 26.6 132.0 26.7 c\r131.9 26.7 131.9 26.7 131.8 26.7 c\r131.7 26.7 131.6 26.7 131.5 26.7 c\r131.4 26.8 l\r132.8 27.4 l\r133.0 27.4 l\r133.0 21.9 l\r133.0 21.3 133.0 21.0 133.0 20.8 c\r133.1 20.7 133.1 20.6 133.1 20.6 c\r133.2 20.5 133.3 20.5 133.3 20.5 c\r133.4 20.5 133.5 20.5 133.7 20.6 c\r133.7 20.5 l\r132.4 19.9 l\r132.1 19.9 l\rh\r132.1 21.0 m\r132.1 23.3 l\r132.1 23.6 132.0 23.8 131.9 24.0 c\r131.8 24.2 131.7 24.3 131.5 24.4 c\r131.4 24.5 131.2 24.6 131.1 24.6 c\r130.8 24.6 130.5 24.5 130.3 24.2 c\r130.0 23.8 129.8 23.3 129.8 22.6 c\r129.8 21.9 129.9 21.4 130.2 21.0 c\r130.5 20.7 130.9 20.5 131.2 20.5 c\r131.5 20.5 131.8 20.6 132.1 21.0 c\rf*\rn\r45.4 19.9 m\r45.4 20.0 l\r45.9 20.0 46.3 20.1 46.7 20.3 c\r47.1 20.5 47.4 20.9 47.8 21.4 c\r48.2 21.9 48.4 22.5 48.6 23.1 c\r48.0 22.8 47.5 22.6 47.1 22.6 c\r46.6 22.6 46.2 22.8 45.8 23.2 c\r45.4 23.5 45.3 24.1 45.3 24.7 c\r45.3 25.3 45.4 25.8 45.8 26.3 c\r46.2 26.9 46.8 27.2 47.5 27.2 c\r48.1 27.2 48.6 27.0 49.0 26.5 c\r49.5 25.9 49.7 25.2 49.7 24.3 c\r49.7 23.5 49.5 22.8 49.1 22.1 c\r48.8 21.4 48.2 20.9 47.5 20.4 c\r47.0 20.0 46.4 19.9 45.7 19.9 c\rh\r48.7 23.5 m\r48.7 23.9 48.7 24.3 48.7 24.6 c\r48.7 24.9 48.7 25.3 48.6 25.7 c\r48.4 26.0 48.3 26.3 48.1 26.5 c\r47.9 26.8 47.7 26.9 47.4 26.9 c\r47.1 26.9 46.8 26.7 46.6 26.4 c\r46.4 26.2 46.3 25.8 46.3 25.2 c\r46.3 24.5 46.4 23.9 46.7 23.5 c\r46.9 23.2 47.2 23.1 47.5 23.1 c\r47.7 23.1 47.9 23.1 48.1 23.2 c\r48.3 23.3 48.5 23.4 48.7 23.5 c\rf*\rn\r347.9 27.4 m\r347.9 24.0 l\r348.3 24.4 348.6 24.6 348.9 24.8 c\r349.1 24.9 349.3 24.9 349.5 24.9 c\r349.8 24.9 350.1 24.9 350.3 24.7 c\r350.5 24.5 350.6 24.3 350.7 24.0 c\r350.8 23.8 350.8 23.4 350.8 22.8 c\r350.8 21.1 l\r350.8 20.7 350.8 20.5 350.9 20.4 c\r350.9 20.3 351.0 20.3 351.1 20.2 c\r351.1 20.2 351.3 20.1 351.5 20.1 c\r351.5 20.0 l\r349.2 20.0 l\r349.2 20.1 l\r349.3 20.1 l\r349.5 20.1 349.7 20.2 349.7 20.2 c\r349.8 20.3 349.9 20.4 349.9 20.6 c\r349.9 20.6 349.9 20.8 349.9 21.1 c\r349.9 22.8 l\r349.9 23.3 349.9 23.7 349.8 23.8 c\r349.8 24.0 349.7 24.1 349.6 24.2 c\r349.5 24.3 349.3 24.3 349.1 24.3 c\r349.0 24.3 348.8 24.3 348.6 24.2 c\r348.4 24.1 348.2 23.9 347.9 23.6 c\r347.9 21.1 l\r347.9 20.7 347.9 20.5 348.0 20.4 c\r348.0 20.3 348.1 20.3 348.2 20.2 c\r348.3 20.2 348.4 20.1 348.7 20.1 c\r348.7 20.0 l\r346.3 20.0 l\r346.3 20.1 l\r346.5 20.1 346.7 20.2 346.8 20.2 c\r346.9 20.3 347.0 20.3 347.0 20.4 c\r347.0 20.5 347.1 20.8 347.1 21.1 c\r347.1 25.4 l\r347.1 25.9 347.1 26.3 347.0 26.4 c\r347.0 26.5 347.0 26.6 346.9 26.7 c\r346.9 26.7 346.8 26.7 346.7 26.7 c\r346.6 26.7 346.5 26.7 346.3 26.7 c\r346.3 26.8 l\r347.7 27.4 l\rh\rf*\rn\r327.9 27.4 m\r327.9 21.1 l\r327.9 20.8 328.0 20.5 328.0 20.4 c\r328.0 20.3 328.1 20.3 328.2 20.2 c\r328.3 20.2 328.4 20.1 328.7 20.1 c\r328.7 20.0 l\r326.3 20.0 l\r326.3 20.1 l\r326.6 20.1 326.7 20.2 326.8 20.2 c\r326.9 20.3 326.9 20.3 327.0 20.4 c\r327.0 20.5 327.1 20.8 327.1 21.1 c\r327.1 25.4 l\r327.1 25.9 327.1 26.3 327.0 26.4 c\r327.0 26.5 327.0 26.6 326.9 26.7 c\r326.9 26.7 326.8 26.7 326.7 26.7 c\r326.6 26.7 326.5 26.7 326.4 26.7 c\r326.3 26.8 l\r327.7 27.4 l\rh\rf*\rn\r63.9 21.4 m\r63.4 20.0 l\r59.3 20.0 l\r59.3 20.2 l\r60.5 21.3 61.4 22.2 61.9 22.9 c\r62.4 23.6 62.7 24.3 62.7 24.9 c\r62.7 25.3 62.5 25.7 62.2 26.0 c\r61.9 26.2 61.6 26.4 61.2 26.4 c\r60.8 26.4 60.5 26.3 60.2 26.1 c\r59.9 25.9 59.7 25.6 59.6 25.2 c\r59.4 25.2 l\r59.5 25.8 59.7 26.3 60.1 26.7 c\r60.5 27.0 60.9 27.2 61.5 27.2 c\r62.1 27.2 62.5 27.0 62.9 26.6 c\r63.3 26.3 63.5 25.8 63.5 25.3 c\r63.5 25.0 63.4 24.6 63.3 24.3 c\r63.0 23.7 62.6 23.1 62.0 22.5 c\r61.1 21.6 60.6 21.0 60.3 20.8 c\r62.2 20.8 l\r62.6 20.8 62.8 20.8 63.0 20.8 c\r63.1 20.9 63.3 20.9 63.4 21.0 c\r63.5 21.1 63.6 21.2 63.7 21.4 c\rh\rf*\rn\r64.8 23.5 m\r64.8 24.3 64.9 25.0 65.2 25.6 c\r65.4 26.1 65.7 26.6 66.1 26.9 c\r66.4 27.1 66.7 27.2 67.0 27.2 c\r67.6 27.2 68.1 26.9 68.5 26.4 c\r69.0 25.7 69.3 24.8 69.3 23.6 c\r69.3 22.8 69.1 22.1 68.9 21.5 c\r68.7 20.9 68.4 20.5 68.0 20.3 c\r67.7 20.0 67.3 19.9 67.0 19.9 c\r66.3 19.9 65.8 20.3 65.4 21.1 c\r65.0 21.7 64.8 22.5 64.8 23.5 c\r65.8 23.4 m\r65.8 22.4 65.9 21.6 66.1 21.0 c\r66.3 20.5 66.6 20.2 67.0 20.2 c\r67.2 20.2 67.4 20.3 67.6 20.5 c\r67.8 20.6 67.9 20.9 68.0 21.3 c\r68.2 21.9 68.3 22.7 68.3 23.8 c\r68.3 24.6 68.2 25.3 68.0 25.8 c\r67.9 26.2 67.7 26.5 67.5 26.7 c\r67.4 26.8 67.2 26.9 67.0 26.9 c\r66.8 26.9 66.6 26.8 66.4 26.5 c\r66.2 26.3 66.0 25.8 65.9 25.2 c\r65.8 24.6 65.8 24.0 65.8 23.4 c\rf*\rn\r71.0 26.4 m\r72.7 27.2 l\r72.9 27.2 l\r72.9 21.3 l\r72.9 20.8 72.9 20.6 72.9 20.5 c\r72.9 20.4 73.0 20.3 73.1 20.2 c\r73.2 20.2 73.4 20.1 73.7 20.1 c\r73.7 20.0 l\r71.1 20.0 l\r71.1 20.1 l\r71.4 20.1 71.7 20.2 71.7 20.2 c\r71.8 20.3 71.9 20.4 71.9 20.4 c\r72.0 20.5 72.0 20.8 72.0 21.3 c\r72.0 25.1 l\r72.0 25.6 72.0 26.0 71.9 26.1 c\r71.9 26.2 71.9 26.3 71.8 26.3 c\r71.8 26.4 71.7 26.4 71.6 26.4 c\r71.5 26.4 71.3 26.4 71.1 26.3 c\rh\rf*\rn\r256.0 27.4 m\r256.0 21.1 l\r256.0 20.8 256.0 20.5 256.1 20.4 c\r256.1 20.3 256.2 20.3 256.2 20.2 c\r256.3 20.2 256.5 20.1 256.7 20.1 c\r256.7 20.0 l\r254.4 20.0 l\r254.4 20.1 l\r254.6 20.1 254.8 20.2 254.9 20.2 c\r254.9 20.3 255.0 20.3 255.1 20.4 c\r255.1 20.5 255.1 20.8 255.1 21.1 c\r255.1 25.4 l\r255.1 25.9 255.1 26.3 255.1 26.4 c\r255.1 26.5 255.0 26.6 255.0 26.7 c\r254.9 26.7 254.9 26.7 254.8 26.7 c\r254.7 26.7 254.6 26.7 254.5 26.7 c\r254.4 26.8 l\r255.8 27.4 l\rh\rf*\rn\rf*\rn\r89.5 27.2 m\r89.6 24.8 l\r89.5 24.8 l\r89.2 25.5 88.9 26.1 88.5 26.4 c\r88.2 26.7 87.7 26.9 87.1 26.9 c\r86.7 26.9 86.2 26.7 85.9 26.5 c\r85.5 26.3 85.2 25.9 85.0 25.4 c\r84.8 24.8 84.7 24.2 84.7 23.4 c\r84.7 22.8 84.8 22.2 85.0 21.8 c\r85.2 21.3 85.5 21.0 85.9 20.7 c\r86.3 20.5 86.8 20.3 87.3 20.3 c\r87.7 20.3 88.1 20.4 88.5 20.6 c\r88.8 20.8 89.2 21.2 89.6 21.7 c\r89.8 21.7 l\r89.4 21.0 89.0 20.6 88.6 20.3 c\r88.1 20.0 87.5 19.9 86.9 19.9 c\r85.7 19.9 84.8 20.3 84.2 21.2 c\r83.7 21.8 83.5 22.6 83.5 23.4 c\r83.5 24.1 83.6 24.8 83.9 25.3 c\r84.3 25.9 84.7 26.4 85.2 26.7 c\r85.8 27.0 86.4 27.2 87.1 27.2 c\r87.6 27.2 88.1 27.1 88.6 26.9 c\r88.7 26.8 88.8 26.8 88.9 26.8 c\r89.0 26.8 89.1 26.8 89.1 26.9 c\r89.2 26.9 89.3 27.1 89.3 27.2 c\rh\rf*\rn\r473.7 27.4 m\r473.7 22.7 l\r474.9 23.8 l\r475.2 24.0 475.4 24.2 475.4 24.3 c\r475.4 24.3 475.4 24.3 475.4 24.4 c\r475.4 24.5 475.4 24.5 475.4 24.6 c\r475.3 24.6 475.2 24.7 475.1 24.7 c\r475.1 24.8 l\r477.1 24.8 l\r477.1 24.7 l\r476.8 24.7 476.6 24.6 476.4 24.5 c\r476.2 24.4 476.0 24.3 475.8 24.1 c\r474.5 23.0 l\r475.8 21.4 l\r476.2 21.0 476.4 20.7 476.5 20.6 c\r476.6 20.4 476.8 20.3 476.9 20.3 c\r477.0 20.3 477.1 20.3 477.3 20.3 c\r477.3 20.0 l\r475.1 20.0 l\r475.1 20.1 l\r475.2 20.1 475.3 20.2 475.3 20.2 c\r475.4 20.2 475.4 20.3 475.4 20.4 c\r475.4 20.5 475.3 20.6 475.2 20.8 c\r473.7 22.7 l\r473.7 21.1 l\r473.7 20.7 473.7 20.5 473.7 20.4 c\r473.8 20.3 473.8 20.2 473.9 20.2 c\r474.0 20.2 474.1 20.1 474.4 20.1 c\r474.4 20.0 l\r472.1 20.0 l\r472.1 20.1 l\r472.3 20.1 472.5 20.2 472.6 20.2 c\r472.6 20.3 472.7 20.3 472.7 20.4 c\r472.8 20.5 472.8 20.8 472.8 21.1 c\r472.8 25.4 l\r472.8 26.0 472.8 26.3 472.8 26.4 c\r472.7 26.5 472.7 26.6 472.7 26.7 c\r472.6 26.7 472.5 26.7 472.5 26.7 c\r472.4 26.7 472.3 26.7 472.1 26.7 c\r472.1 26.8 l\r473.4 27.4 l\rh\rf*\rn\r97.1 27.4 m\r97.2 27.4 97.3 27.3 97.4 27.2 c\r97.5 27.1 97.6 27.0 97.6 26.9 c\r97.6 26.7 97.5 26.6 97.4 26.5 c\r97.3 26.4 97.2 26.3 97.1 26.3 c\r96.9 26.3 96.8 26.4 96.7 26.5 c\r96.6 26.6 96.5 26.7 96.5 26.9 c\r96.5 27.0 96.6 27.1 96.7 27.2 c\r96.8 27.3 96.9 27.4 97.1 27.4 c\r97.5 24.9 m\r97.5 21.1 l\r97.5 20.8 97.6 20.5 97.6 20.4 c\r97.6 20.3 97.7 20.3 97.8 20.2 c\r97.9 20.2 98.0 20.1 98.3 20.1 c\r98.3 20.0 l\r95.9 20.0 l\r95.9 20.1 l\r96.2 20.1 96.3 20.2 96.4 20.2 c\r96.5 20.3 96.5 20.3 96.6 20.4 c\r96.6 20.5 96.7 20.8 96.7 21.1 c\r96.7 22.9 l\r96.7 23.5 96.6 23.8 96.6 24.0 c\r96.6 24.1 96.6 24.2 96.5 24.2 c\r96.5 24.2 96.4 24.3 96.3 24.3 c\r96.2 24.3 96.1 24.2 95.9 24.2 c\r95.9 24.3 l\r97.3 24.9 l\rh\rf*\rn\r100.1 24.0 m\r100.7 24.6 101.2 24.9 101.7 24.9 c\r102.0 24.9 102.2 24.9 102.4 24.7 c\r102.6 24.6 102.8 24.4 102.9 24.1 c\r103.0 23.9 103.0 23.5 103.0 23.1 c\r103.0 21.1 l\r103.0 20.7 103.0 20.5 103.1 20.4 c\r103.1 20.3 103.2 20.3 103.3 20.2 c\r103.3 20.2 103.5 20.1 103.7 20.1 c\r103.7 20.0 l\r101.4 20.0 l\r101.4 20.1 l\r101.5 20.1 l\r101.7 20.1 101.8 20.2 101.9 20.2 c\r102.0 20.3 102.1 20.4 102.1 20.6 c\r102.1 20.6 102.1 20.8 102.1 21.1 c\r102.1 23.1 l\r102.1 23.5 102.1 23.8 102.0 24.0 c\r101.8 24.2 101.7 24.3 101.4 24.3 c\r101.0 24.3 100.5 24.1 100.1 23.6 c\r100.1 21.1 l\r100.1 20.7 100.1 20.5 100.2 20.4 c\r100.2 20.3 100.3 20.3 100.4 20.2 c\r100.5 20.2 100.6 20.1 100.9 20.1 c\r100.9 20.0 l\r98.5 20.0 l\r98.5 20.1 l\r98.6 20.1 l\r98.9 20.1 99.1 20.2 99.1 20.3 c\r99.2 20.5 99.3 20.7 99.3 21.1 c\r99.3 22.9 l\r99.3 23.5 99.3 23.8 99.2 24.0 c\r99.2 24.1 99.2 24.2 99.1 24.2 c\r99.1 24.2 99.0 24.3 98.9 24.3 c\r98.8 24.3 98.7 24.2 98.5 24.2 c\r98.5 24.3 l\r99.9 24.9 l\r100.1 24.9 l\rh\rf*\rn\r106.9 20.6 m\r106.4 20.3 106.1 20.1 106.0 20.0 c\r105.8 19.9 105.6 19.9 105.4 19.9 c\r105.0 19.9 104.7 20.0 104.5 20.2 c\r104.3 20.4 104.2 20.7 104.2 21.1 c\r104.2 21.3 104.3 21.5 104.4 21.7 c\r104.5 21.9 104.8 22.2 105.1 22.4 c\r105.5 22.6 106.1 22.8 106.9 23.1 c\r106.9 23.3 l\r106.9 23.8 106.8 24.1 106.7 24.3 c\r106.5 24.5 106.3 24.6 106.0 24.6 c\r105.8 24.6 105.6 24.5 105.5 24.4 c\r105.3 24.3 105.3 24.2 105.3 24.0 c\r105.3 23.7 l\r105.3 23.5 105.2 23.4 105.1 23.3 c\r105.1 23.2 105.0 23.2 104.8 23.2 c\r104.7 23.2 104.6 23.2 104.5 23.3 c\r104.4 23.4 104.4 23.6 104.4 23.7 c\r104.4 24.0 104.6 24.3 104.9 24.5 c\r105.2 24.8 105.6 24.9 106.2 24.9 c\r106.6 24.9 107.0 24.9 107.2 24.7 c\r107.4 24.6 107.6 24.4 107.7 24.2 c\r107.8 24.0 107.8 23.7 107.8 23.2 c\r107.8 21.6 l\r107.8 21.1 107.8 20.8 107.8 20.7 c\r107.8 20.6 107.9 20.6 107.9 20.5 c\r107.9 20.5 108.0 20.5 108.0 20.5 c\r108.1 20.5 108.1 20.5 108.2 20.5 c\r108.3 20.5 108.4 20.6 108.6 20.8 c\r108.6 20.6 l\r108.2 20.1 107.8 19.9 107.5 19.9 c\r107.3 19.9 107.2 19.9 107.1 20.0 c\r107.0 20.2 106.9 20.4 106.9 20.6 c\r106.9 21.0 m\r106.9 22.8 l\r106.4 22.6 106.0 22.4 105.9 22.4 c\r105.6 22.2 105.4 22.0 105.2 21.9 c\r105.1 21.7 105.1 21.5 105.1 21.3 c\r105.1 21.1 105.1 20.9 105.3 20.7 c\r105.5 20.5 105.6 20.5 105.8 20.5 c\r106.1 20.5 106.5 20.6 106.9 21.0 c\rf*\rn\r395.8 20.6 m\r395.6 20.3 395.3 20.1 395.1 20.0 c\r394.9 19.9 394.7 19.9 394.4 19.9 c\r393.9 19.9 393.4 20.1 393.0 20.5 c\r392.7 21.0 392.5 21.5 392.5 22.2 c\r392.5 22.9 392.7 23.5 393.1 24.1 c\r393.5 24.6 394.1 24.9 394.8 24.9 c\r395.2 24.9 395.5 24.8 395.8 24.5 c\r395.8 25.4 l\r395.8 25.9 395.8 26.3 395.8 26.4 c\r395.7 26.5 395.7 26.6 395.6 26.7 c\r395.6 26.7 395.5 26.7 395.5 26.7 c\r395.4 26.7 395.3 26.7 395.1 26.7 c\r395.1 26.8 l\r396.4 27.4 l\r396.7 27.4 l\r396.7 21.9 l\r396.7 21.3 396.7 21.0 396.7 20.8 c\r396.7 20.7 396.8 20.6 396.8 20.6 c\r396.9 20.5 396.9 20.5 397.0 20.5 c\r397.1 20.5 397.2 20.5 397.3 20.6 c\r397.4 20.5 l\r396.0 19.9 l\r395.8 19.9 l\rh\r395.8 21.0 m\r395.8 23.3 l\r395.8 23.6 395.7 23.8 395.6 24.0 c\r395.5 24.2 395.4 24.3 395.2 24.4 c\r395.0 24.5 394.9 24.6 394.7 24.6 c\r394.4 24.6 394.2 24.5 393.9 24.2 c\r393.6 23.8 393.5 23.3 393.5 22.6 c\r393.5 21.9 393.6 21.4 393.9 21.0 c\r394.2 20.7 394.5 20.5 394.9 20.5 c\r395.2 20.5 395.5 20.6 395.8 21.0 c\rf*\rn\r116.1 22.3 m\r113.3 22.3 l\r112.8 21.2 l\r112.7 21.0 112.6 20.7 112.6 20.6 c\r112.6 20.5 112.7 20.4 112.8 20.3 c\r112.9 20.2 113.1 20.2 113.4 20.1 c\r113.4 20.0 l\r111.2 20.0 l\r111.2 20.1 l\r111.5 20.2 111.7 20.3 111.8 20.4 c\r112.0 20.5 112.2 20.9 112.4 21.4 c\r115.0 27.2 l\r115.2 27.2 l\r117.5 21.3 l\r117.7 20.9 117.9 20.5 118.1 20.4 c\r118.2 20.2 118.4 20.2 118.7 20.1 c\r118.7 20.0 l\r115.9 20.0 l\r115.9 20.1 l\r116.2 20.1 116.4 20.2 116.5 20.3 c\r116.6 20.4 116.6 20.5 116.6 20.6 c\r116.6 20.8 116.6 21.0 116.4 21.4 c\rh\r115.9 22.7 m\r114.8 25.5 l\r113.4 22.7 l\rh\rf*\rn\r126.8 20.6 m\r126.3 20.3 126.0 20.1 125.8 20.0 c\r125.7 19.9 125.5 19.9 125.2 19.9 c\r124.9 19.9 124.6 20.0 124.4 20.2 c\r124.2 20.4 124.1 20.7 124.1 21.1 c\r124.1 21.3 124.1 21.5 124.2 21.7 c\r124.4 21.9 124.6 22.2 125.0 22.4 c\r125.4 22.6 126.0 22.8 126.8 23.1 c\r126.8 23.3 l\r126.8 23.8 126.7 24.1 126.6 24.3 c\r126.4 24.5 126.2 24.6 125.9 24.6 c\r125.6 24.6 125.5 24.5 125.3 24.4 c\r125.2 24.3 125.1 24.2 125.1 24.0 c\r125.1 23.7 l\r125.1 23.5 125.1 23.4 125.0 23.3 c\r124.9 23.2 124.8 23.2 124.7 23.2 c\r124.6 23.2 124.5 23.2 124.4 23.3 c\r124.3 23.4 124.3 23.6 124.3 23.7 c\r124.3 24.0 124.4 24.3 124.7 24.5 c\r125.0 24.8 125.5 24.9 126.0 24.9 c\r126.5 24.9 126.8 24.9 127.1 24.7 c\r127.3 24.6 127.5 24.4 127.6 24.2 c\r127.6 24.0 127.7 23.7 127.7 23.2 c\r127.7 21.6 l\r127.7 21.1 127.7 20.8 127.7 20.7 c\r127.7 20.6 127.7 20.6 127.8 20.5 c\r127.8 20.5 127.9 20.5 127.9 20.5 c\r128.0 20.5 128.0 20.5 128.0 20.5 c\r128.1 20.5 128.3 20.6 128.5 20.8 c\r128.5 20.6 l\r128.1 20.1 127.7 19.9 127.4 19.9 c\r127.2 19.9 127.1 19.9 127.0 20.0 c\r126.9 20.2 126.8 20.4 126.8 20.6 c\r126.8 21.0 m\r126.8 22.8 l\r126.2 22.6 125.9 22.4 125.7 22.4 c\r125.4 22.2 125.2 22.0 125.1 21.9 c\r125.0 21.7 124.9 21.5 124.9 21.3 c\r124.9 21.1 125.0 20.9 125.2 20.7 c\r125.3 20.5 125.5 20.5 125.7 20.5 c\r126.0 20.5 126.3 20.6 126.8 21.0 c\rf*\rn\r443.8 24.8 m\r445.9 24.8 l\r445.9 24.7 l\r445.7 24.6 445.6 24.6 445.5 24.6 c\r445.5 24.5 445.4 24.4 445.4 24.3 c\r445.4 24.2 445.5 24.1 445.5 23.9 c\r446.6 21.2 l\r447.7 23.5 l\r447.5 24.1 l\r447.4 24.3 447.3 24.5 447.1 24.6 c\r447.1 24.6 446.9 24.6 446.7 24.7 c\r446.7 24.8 l\r448.8 24.8 l\r448.8 24.7 l\r448.6 24.6 448.5 24.6 448.4 24.5 c\r448.4 24.4 448.3 24.3 448.3 24.2 c\r448.3 24.1 448.4 24.1 448.4 24.0 c\r449.5 21.3 l\r450.4 23.9 l\r450.5 24.1 450.6 24.3 450.6 24.4 c\r450.6 24.4 450.5 24.5 450.5 24.6 c\r450.4 24.6 450.2 24.7 450.0 24.7 c\r450.0 24.8 l\r451.4 24.8 l\r451.4 24.7 l\r451.1 24.6 450.9 24.4 450.8 24.0 c\r449.4 19.9 l\r449.1 19.9 l\r447.9 23.1 l\r446.3 19.9 l\r446.2 19.9 l\r444.6 23.9 l\r444.5 24.2 444.4 24.3 444.3 24.4 c\r444.2 24.5 444.1 24.6 443.8 24.7 c\rh\rf*\rn\r40.1 19.9 m\r40.1 20.0 l\r40.5 20.0 40.9 20.1 41.3 20.3 c\r41.7 20.5 42.1 20.9 42.5 21.4 c\r42.8 21.9 43.1 22.5 43.2 23.1 c\r42.7 22.8 42.2 22.6 41.8 22.6 c\r41.3 22.6 40.8 22.8 40.5 23.2 c\r40.1 23.5 39.9 24.1 39.9 24.7 c\r39.9 25.3 40.1 25.8 40.5 26.3 c\r40.9 26.9 41.5 27.2 42.1 27.2 c\r42.7 27.2 43.2 27.0 43.6 26.5 c\r44.1 25.9 44.4 25.2 44.4 24.3 c\r44.4 23.5 44.2 22.8 43.8 22.1 c\r43.4 21.4 42.9 20.9 42.2 20.4 c\r41.6 20.0 41.0 19.9 40.4 19.9 c\rh\r43.3 23.5 m\r43.4 23.9 43.4 24.3 43.4 24.6 c\r43.4 24.9 43.3 25.3 43.2 25.7 c\r43.1 26.0 43.0 26.3 42.8 26.5 c\r42.6 26.8 42.3 26.9 42.1 26.9 c\r41.8 26.9 41.5 26.7 41.3 26.4 c\r41.0 26.2 40.9 25.8 40.9 25.2 c\r40.9 24.5 41.1 23.9 41.4 23.5 c\r41.6 23.2 41.9 23.1 42.2 23.1 c\r42.4 23.1 42.5 23.1 42.8 23.2 c\r43.0 23.3 43.2 23.4 43.3 23.5 c\rf*\rn\r239.5 23.3 m\r239.5 21.3 l\r239.5 20.8 239.6 20.5 239.7 20.4 c\r239.8 20.2 240.0 20.1 240.3 20.1 c\r240.5 20.1 l\r240.5 20.0 l\r237.5 20.0 l\r237.5 20.1 l\r237.8 20.1 l\r238.1 20.1 238.3 20.2 238.4 20.4 c\r238.5 20.6 238.5 20.8 238.5 21.3 c\r238.5 25.8 l\r238.5 26.3 238.5 26.6 238.4 26.7 c\r238.3 26.8 238.1 26.9 237.8 26.9 c\r237.5 26.9 l\r237.5 27.1 l\r240.1 27.1 l\r240.8 27.1 241.3 27.0 241.6 26.9 c\r242.0 26.7 242.3 26.5 242.5 26.2 c\r242.8 25.9 242.9 25.5 242.9 25.1 c\r242.9 24.6 242.7 24.1 242.4 23.7 c\r242.0 23.4 241.4 23.2 240.7 23.2 c\r240.6 23.2 240.4 23.2 240.2 23.2 c\r240.0 23.3 239.8 23.3 239.5 23.3 c\r239.5 23.6 m\r239.7 23.6 239.9 23.6 240.0 23.6 c\r240.2 23.5 240.3 23.5 240.4 23.5 c\r240.8 23.5 241.1 23.7 241.3 24.0 c\r241.6 24.2 241.7 24.6 241.7 25.1 c\r241.7 25.4 241.7 25.7 241.5 25.9 c\r241.4 26.2 241.2 26.4 241.0 26.5 c\r240.8 26.7 240.5 26.7 240.2 26.7 c\r240.0 26.7 239.8 26.7 239.5 26.6 c\rh\rf*\rn\r91.9 27.4 m\r91.9 24.0 l\r92.3 24.4 92.6 24.6 92.8 24.8 c\r93.0 24.9 93.3 24.9 93.5 24.9 c\r93.8 24.9 94.0 24.9 94.2 24.7 c\r94.4 24.5 94.5 24.3 94.6 24.0 c\r94.7 23.8 94.7 23.4 94.7 22.8 c\r94.7 21.1 l\r94.7 20.7 94.8 20.5 94.8 20.4 c\r94.8 20.3 94.9 20.3 95.0 20.2 c\r95.1 20.2 95.2 20.1 95.5 20.1 c\r95.5 20.0 l\r93.1 20.0 l\r93.1 20.1 l\r93.2 20.1 l\r93.4 20.1 93.6 20.2 93.7 20.2 c\r93.8 20.3 93.8 20.4 93.8 20.6 c\r93.9 20.6 93.9 20.8 93.9 21.1 c\r93.9 22.8 l\r93.9 23.3 93.8 23.7 93.8 23.8 c\r93.7 24.0 93.6 24.1 93.5 24.2 c\r93.4 24.3 93.2 24.3 93.1 24.3 c\r92.9 24.3 92.7 24.3 92.5 24.2 c\r92.4 24.1 92.1 23.9 91.9 23.6 c\r91.9 21.1 l\r91.9 20.7 91.9 20.5 91.9 20.4 c\r92.0 20.3 92.0 20.3 92.1 20.2 c\r92.2 20.2 92.4 20.1 92.6 20.1 c\r92.6 20.0 l\r90.3 20.0 l\r90.3 20.1 l\r90.5 20.1 90.6 20.2 90.8 20.2 c\r90.8 20.3 90.9 20.3 90.9 20.4 c\r91.0 20.5 91.0 20.8 91.0 21.1 c\r91.0 25.4 l\r91.0 25.9 91.0 26.3 91.0 26.4 c\r90.9 26.5 90.9 26.6 90.8 26.7 c\r90.8 26.7 90.7 26.7 90.6 26.7 c\r90.6 26.7 90.4 26.7 90.3 26.7 c\r90.2 26.8 l\r91.6 27.4 l\rh\rf*\rn\rf*\rn\r154.1 21.9 m\r153.9 21.2 153.7 20.7 153.3 20.4 c\r152.9 20.0 152.5 19.9 152.0 19.9 c\r151.5 19.9 151.0 20.1 150.6 20.5 c\r150.2 21.0 150.0 21.6 150.0 22.4 c\r150.0 23.1 150.2 23.8 150.7 24.2 c\r151.1 24.7 151.6 24.9 152.3 24.9 c\r152.7 24.9 153.1 24.8 153.4 24.6 c\r153.7 24.3 153.9 24.0 153.9 23.8 c\r153.9 23.6 153.8 23.5 153.7 23.5 c\r153.7 23.4 153.5 23.3 153.4 23.3 c\r153.2 23.3 153.0 23.4 153.0 23.5 c\r152.9 23.6 152.8 23.7 152.8 24.0 c\r152.8 24.2 152.7 24.3 152.6 24.4 c\r152.5 24.5 152.3 24.6 152.1 24.6 c\r151.8 24.6 151.5 24.5 151.3 24.2 c\r151.0 23.9 150.9 23.4 150.9 22.9 c\r150.9 22.3 151.0 21.8 151.3 21.4 c\r151.6 20.9 152.0 20.7 152.4 20.7 c\r152.8 20.7 153.1 20.8 153.4 21.0 c\r153.6 21.2 153.7 21.5 153.9 21.9 c\rh\rf*\rn\rf*\rn\r158.0 26.9 m\r158.0 27.1 l\r161.0 27.1 l\r161.0 26.9 l\r160.7 26.9 l\r160.5 26.9 160.2 26.8 160.1 26.6 c\r160.0 26.5 160.0 26.2 160.0 25.8 c\r160.0 22.4 l\r160.0 21.8 159.9 21.4 159.8 21.1 c\r159.7 20.8 159.5 20.5 159.2 20.2 c\r159.0 20.0 158.6 19.9 158.2 19.9 c\r157.9 19.9 157.7 19.9 157.5 20.1 c\r157.3 20.3 157.2 20.4 157.2 20.7 c\r157.2 20.8 157.2 21.0 157.3 21.0 c\r157.4 21.1 157.6 21.2 157.7 21.2 c\r157.8 21.2 157.9 21.2 158.0 21.1 c\r158.1 21.0 158.2 20.8 158.3 20.5 c\r158.4 20.3 158.5 20.2 158.6 20.2 c\r158.7 20.2 158.8 20.3 158.9 20.4 c\r159.0 20.5 159.0 20.7 159.0 21.0 c\r159.0 25.8 l\r159.0 26.2 159.0 26.4 158.9 26.5 c\r158.9 26.6 158.8 26.7 158.7 26.8 c\r158.6 26.9 158.4 26.9 158.2 26.9 c\rh\rf*\rn\r163.8 24.9 m\r164.6 24.9 165.1 24.7 165.6 24.1 c\r165.9 23.6 166.1 23.1 166.1 22.5 c\r166.1 22.1 166.0 21.6 165.8 21.2 c\r165.6 20.8 165.3 20.4 165.0 20.2 c\r164.6 20.0 164.2 19.9 163.8 19.9 c\r163.1 19.9 162.5 20.2 162.1 20.7 c\r161.7 21.2 161.5 21.8 161.5 22.4 c\r161.5 22.8 161.6 23.2 161.9 23.7 c\r162.1 24.1 162.4 24.4 162.7 24.6 c\r163.1 24.8 163.4 24.9 163.8 24.9 c\r163.7 24.6 m\r163.5 24.6 163.3 24.5 163.1 24.4 c\r163.0 24.3 162.8 24.1 162.7 23.8 c\r162.6 23.6 162.5 23.2 162.5 22.8 c\r162.5 22.1 162.7 21.5 162.9 21.0 c\r163.2 20.5 163.6 20.2 164.0 20.2 c\r164.3 20.2 164.6 20.3 164.8 20.6 c\r165.0 20.9 165.1 21.4 165.1 22.1 c\r165.1 22.9 164.9 23.6 164.6 24.1 c\r164.4 24.4 164.0 24.6 163.7 24.6 c\rf*\rn\rf*\rn\r173.5 24.9 m\r173.5 23.9 l\r173.9 24.6 174.3 24.9 174.7 24.9 c\r174.9 24.9 175.0 24.9 175.1 24.8 c\r175.3 24.6 175.3 24.5 175.3 24.3 c\r175.3 24.2 175.3 24.1 175.2 24.0 c\r175.1 23.9 175.0 23.9 174.9 23.9 c\r174.8 23.9 174.7 23.9 174.5 24.0 c\r174.4 24.1 174.2 24.2 174.2 24.2 c\r174.1 24.2 174.0 24.2 174.0 24.1 c\r173.8 24.0 173.6 23.7 173.5 23.4 c\r173.5 21.1 l\r173.5 20.8 173.5 20.6 173.6 20.5 c\r173.6 20.4 173.7 20.3 173.8 20.3 c\r173.9 20.2 174.1 20.1 174.3 20.1 c\r174.3 20.0 l\r171.9 20.0 l\r171.9 20.1 l\r172.1 20.1 172.3 20.2 172.4 20.3 c\r172.5 20.3 172.5 20.4 172.6 20.5 c\r172.6 20.6 172.6 20.8 172.6 21.1 c\r172.6 22.9 l\r172.6 23.5 172.6 23.8 172.6 24.0 c\r172.5 24.1 172.5 24.1 172.4 24.2 c\r172.4 24.2 172.3 24.3 172.2 24.3 c\r172.1 24.3 172.0 24.2 171.9 24.2 c\r171.8 24.3 l\r173.2 24.9 l\rh\rf*\rn\rf*\rn\r183.8 20.6 m\r183.3 20.3 183.0 20.1 182.8 20.0 c\r182.7 19.9 182.5 19.9 182.2 19.9 c\r181.9 19.9 181.6 20.0 181.4 20.2 c\r181.2 20.4 181.1 20.7 181.1 21.1 c\r181.1 21.3 181.1 21.5 181.2 21.7 c\r181.4 21.9 181.6 22.2 182.0 22.4 c\r182.4 22.6 183.0 22.8 183.8 23.1 c\r183.8 23.3 l\r183.8 23.8 183.7 24.1 183.6 24.3 c\r183.4 24.5 183.2 24.6 182.9 24.6 c\r182.6 24.6 182.5 24.5 182.3 24.4 c\r182.2 24.3 182.1 24.2 182.1 24.0 c\r182.1 23.7 l\r182.1 23.5 182.1 23.4 182.0 23.3 c\r181.9 23.2 181.8 23.2 181.7 23.2 c\r181.6 23.2 181.5 23.2 181.4 23.3 c\r181.3 23.4 181.3 23.6 181.3 23.7 c\r181.3 24.0 181.4 24.3 181.7 24.5 c\r182.0 24.8 182.5 24.9 183.0 24.9 c\r183.5 24.9 183.8 24.9 184.1 24.7 c\r184.3 24.6 184.5 24.4 184.6 24.2 c\r184.6 24.0 184.7 23.7 184.7 23.2 c\r184.7 21.6 l\r184.7 21.1 184.7 20.8 184.7 20.7 c\r184.7 20.6 184.7 20.6 184.8 20.5 c\r184.8 20.5 184.9 20.5 184.9 20.5 c\r185.0 20.5 185.0 20.5 185.0 20.5 c\r185.1 20.5 185.3 20.6 185.5 20.8 c\r185.5 20.6 l\r185.1 20.1 184.7 19.9 184.4 19.9 c\r184.2 19.9 184.1 19.9 184.0 20.0 c\r183.9 20.2 183.8 20.4 183.8 20.6 c\r183.8 21.0 m\r183.8 22.8 l\r183.2 22.6 182.9 22.4 182.7 22.4 c\r182.4 22.2 182.2 22.0 182.1 21.9 c\r182.0 21.7 181.9 21.5 181.9 21.3 c\r181.9 21.1 182.0 20.9 182.2 20.7 c\r182.3 20.5 182.5 20.5 182.7 20.5 c\r183.0 20.5 183.3 20.6 183.8 21.0 c\rf*\rn\r187.4 27.4 m\r187.4 21.1 l\r187.4 20.8 187.4 20.5 187.5 20.4 c\r187.5 20.3 187.6 20.3 187.6 20.2 c\r187.7 20.2 187.9 20.1 188.1 20.1 c\r188.1 20.0 l\r185.8 20.0 l\r185.8 20.1 l\r186.0 20.1 186.2 20.2 186.3 20.2 c\r186.3 20.3 186.4 20.3 186.5 20.4 c\r186.5 20.5 186.5 20.8 186.5 21.1 c\r186.5 25.4 l\r186.5 25.9 186.5 26.3 186.5 26.4 c\r186.5 26.5 186.4 26.6 186.4 26.7 c\r186.3 26.7 186.3 26.7 186.2 26.7 c\r186.1 26.7 186.0 26.7 185.9 26.7 c\r185.8 26.8 l\r187.2 27.4 l\rh\rf*\rn\rf*\rn\r460.6 21.1 m\r460.8 21.1 460.9 21.0 461.0 20.9 c\r461.1 20.8 461.2 20.6 461.2 20.5 c\r461.2 20.3 461.1 20.2 461.0 20.0 c\r460.9 19.9 460.8 19.9 460.6 19.9 c\r460.4 19.9 460.3 19.9 460.2 20.0 c\r460.1 20.2 460.0 20.3 460.0 20.5 c\r460.0 20.6 460.1 20.8 460.2 20.9 c\r460.3 21.0 460.4 21.1 460.6 21.1 c\rf*\rn\r199.5 27.4 m\r199.5 21.1 l\r199.5 20.8 199.6 20.5 199.6 20.4 c\r199.6 20.3 199.7 20.3 199.8 20.2 c\r199.9 20.2 200.0 20.1 200.3 20.1 c\r200.3 20.0 l\r197.9 20.0 l\r197.9 20.1 l\r198.2 20.1 198.3 20.2 198.4 20.2 c\r198.5 20.3 198.5 20.3 198.6 20.4 c\r198.6 20.5 198.7 20.8 198.7 21.1 c\r198.7 25.4 l\r198.7 25.9 198.7 26.3 198.6 26.4 c\r198.6 26.5 198.6 26.6 198.5 26.7 c\r198.5 26.7 198.4 26.7 198.3 26.7 c\r198.2 26.7 198.1 26.7 198.0 26.7 c\r197.9 26.8 l\r199.3 27.4 l\rh\rf*\rn\r201.6 23.0 m\r201.6 22.3 201.8 21.7 202.1 21.3 c\r202.5 20.9 202.9 20.7 203.4 20.7 c\r203.7 20.7 204.0 20.8 204.2 21.0 c\r204.4 21.1 204.6 21.4 204.8 21.9 c\r204.9 21.8 l\r204.9 21.3 204.6 20.8 204.3 20.4 c\r203.9 20.1 203.5 19.9 203.0 19.9 c\r202.4 19.9 201.9 20.1 201.5 20.5 c\r201.1 21.0 200.9 21.6 200.9 22.3 c\r200.9 23.1 201.1 23.8 201.5 24.2 c\r201.9 24.7 202.4 24.9 203.1 24.9 c\r203.6 24.9 204.1 24.8 204.4 24.4 c\r204.8 24.1 204.9 23.6 204.9 23.0 c\rh\r201.6 23.3 m\r203.9 23.3 l\r203.8 23.6 203.8 23.8 203.7 24.0 c\r203.7 24.2 203.5 24.3 203.4 24.4 c\r203.2 24.5 203.0 24.6 202.8 24.6 c\r202.5 24.6 202.2 24.5 202.0 24.3 c\r201.8 24.0 201.6 23.7 201.6 23.3 c\rf*\rn\r209.7 21.9 m\r209.5 21.2 209.3 20.7 208.9 20.4 c\r208.5 20.0 208.1 19.9 207.6 19.9 c\r207.1 19.9 206.6 20.1 206.2 20.5 c\r205.8 21.0 205.6 21.6 205.6 22.4 c\r205.6 23.1 205.8 23.8 206.3 24.2 c\r206.7 24.7 207.2 24.9 207.9 24.9 c\r208.3 24.9 208.7 24.8 209.0 24.6 c\r209.3 24.3 209.5 24.0 209.5 23.8 c\r209.5 23.6 209.4 23.5 209.3 23.5 c\r209.3 23.4 209.1 23.3 209.0 23.3 c\r208.8 23.3 208.6 23.4 208.6 23.5 c\r208.5 23.6 208.4 23.7 208.4 24.0 c\r208.4 24.2 208.3 24.3 208.2 24.4 c\r208.1 24.5 207.9 24.6 207.7 24.6 c\r207.4 24.6 207.1 24.5 206.9 24.2 c\r206.6 23.9 206.5 23.4 206.5 22.9 c\r206.5 22.3 206.6 21.8 206.9 21.4 c\r207.2 20.9 207.6 20.7 208.0 20.7 c\r208.4 20.7 208.7 20.8 209.0 21.0 c\r209.2 21.2 209.3 21.5 209.5 21.9 c\rh\rf*\rn\rf*\rn\r214.5 24.9 m\r214.5 23.9 l\r214.9 24.6 215.3 24.9 215.7 24.9 c\r215.9 24.9 216.1 24.9 216.2 24.8 c\r216.3 24.6 216.4 24.5 216.4 24.3 c\r216.4 24.2 216.4 24.1 216.3 24.0 c\r216.2 23.9 216.1 23.9 216.0 23.9 c\r215.9 23.9 215.7 23.9 215.6 24.0 c\r215.4 24.1 215.3 24.2 215.2 24.2 c\r215.2 24.2 215.1 24.2 215.0 24.1 c\r214.9 24.0 214.7 23.7 214.5 23.4 c\r214.5 21.1 l\r214.5 20.8 214.6 20.6 214.6 20.5 c\r214.7 20.4 214.8 20.3 214.9 20.3 c\r215.0 20.2 215.2 20.1 215.4 20.1 c\r215.4 20.0 l\r212.9 20.0 l\r212.9 20.1 l\r213.2 20.1 213.3 20.2 213.5 20.3 c\r213.5 20.3 213.6 20.4 213.6 20.5 c\r213.7 20.6 213.7 20.8 213.7 21.1 c\r213.7 22.9 l\r213.7 23.5 213.7 23.8 213.6 24.0 c\r213.6 24.1 213.6 24.1 213.5 24.2 c\r213.4 24.2 213.4 24.3 213.3 24.3 c\r213.2 24.3 213.1 24.2 212.9 24.2 c\r212.9 24.3 l\r214.3 24.9 l\rh\rf*\rn\r219.1 24.9 m\r219.8 24.9 220.4 24.7 220.8 24.1 c\r221.2 23.6 221.4 23.1 221.4 22.5 c\r221.4 22.1 221.3 21.6 221.1 21.2 c\r220.9 20.8 220.6 20.4 220.2 20.2 c\r219.9 20.0 219.5 19.9 219.0 19.9 c\r218.3 19.9 217.8 20.2 217.3 20.7 c\r217.0 21.2 216.8 21.8 216.8 22.4 c\r216.8 22.8 216.9 23.2 217.1 23.7 c\r217.3 24.1 217.6 24.4 218.0 24.6 c\r218.3 24.8 218.7 24.9 219.1 24.9 c\r218.9 24.6 m\r218.8 24.6 218.6 24.5 218.4 24.4 c\r218.2 24.3 218.1 24.1 218.0 23.8 c\r217.9 23.6 217.8 23.2 217.8 22.8 c\r217.8 22.1 217.9 21.5 218.2 21.0 c\r218.5 20.5 218.8 20.2 219.3 20.2 c\r219.6 20.2 219.9 20.3 220.1 20.6 c\r220.3 20.9 220.4 21.4 220.4 22.1 c\r220.4 22.9 220.2 23.6 219.9 24.1 c\r219.6 24.4 219.3 24.6 218.9 24.6 c\rf*\rn\r307.4 24.9 m\r307.4 23.3 l\r307.3 23.3 l\r307.1 23.8 307.0 24.2 306.7 24.3 c\r306.5 24.5 306.3 24.6 306.0 24.6 c\r305.7 24.6 305.5 24.5 305.4 24.4 c\r305.2 24.3 305.1 24.1 305.1 24.0 c\r305.1 23.8 305.2 23.6 305.3 23.5 c\r305.4 23.3 305.6 23.2 306.0 23.0 c\r306.7 22.7 l\r307.4 22.3 307.8 21.9 307.8 21.3 c\r307.8 20.9 307.6 20.5 307.3 20.3 c\r307.0 20.0 306.6 19.9 306.2 19.9 c\r305.9 19.9 305.5 19.9 305.1 20.0 c\r305.0 20.0 304.9 20.1 304.9 20.1 c\r304.8 20.1 304.7 20.0 304.7 19.9 c\r304.5 19.9 l\r304.5 21.5 l\r304.7 21.5 l\r304.8 21.0 305.0 20.7 305.2 20.5 c\r305.5 20.3 305.8 20.2 306.2 20.2 c\r306.4 20.2 306.6 20.3 306.8 20.4 c\r306.9 20.6 307.0 20.7 307.0 20.9 c\r307.0 21.2 306.9 21.4 306.8 21.6 c\r306.6 21.7 306.3 21.9 305.8 22.2 c\r305.3 22.4 304.9 22.6 304.8 22.8 c\r304.6 23.0 304.5 23.3 304.5 23.6 c\r304.5 24.0 304.7 24.3 304.9 24.5 c\r305.2 24.8 305.6 24.9 306.0 24.9 c\r306.2 24.9 306.4 24.9 306.7 24.8 c\r306.8 24.8 307.0 24.7 307.0 24.7 c\r307.1 24.7 307.1 24.7 307.2 24.8 c\r307.2 24.8 307.2 24.8 307.3 24.9 c\rh\rf*\rn\r228.6 27.4 m\r228.7 27.4 228.9 27.3 229.0 27.2 c\r229.1 27.1 229.1 27.0 229.1 26.9 c\r229.1 26.7 229.1 26.6 229.0 26.5 c\r228.9 26.4 228.7 26.3 228.6 26.3 c\r228.5 26.3 228.3 26.4 228.2 26.5 c\r228.1 26.6 228.1 26.7 228.1 26.9 c\r228.1 27.0 228.1 27.1 228.2 27.2 c\r228.3 27.3 228.5 27.4 228.6 27.4 c\r229.1 24.9 m\r229.1 21.1 l\r229.1 20.8 229.1 20.5 229.1 20.4 c\r229.2 20.3 229.2 20.3 229.3 20.2 c\r229.4 20.2 229.6 20.1 229.8 20.1 c\r229.8 20.0 l\r227.5 20.0 l\r227.5 20.1 l\r227.7 20.1 227.9 20.2 227.9 20.2 c\r228.0 20.3 228.1 20.3 228.1 20.4 c\r228.2 20.5 228.2 20.8 228.2 21.1 c\r228.2 22.9 l\r228.2 23.5 228.2 23.8 228.2 24.0 c\r228.1 24.1 228.1 24.2 228.0 24.2 c\r228.0 24.2 227.9 24.3 227.8 24.3 c\r227.7 24.3 227.6 24.2 227.5 24.2 c\r227.4 24.3 l\r228.8 24.9 l\rh\rf*\rn\r388.5 23.0 m\r388.5 22.3 388.6 21.7 389.0 21.3 c\r389.3 20.9 389.8 20.7 390.2 20.7 c\r390.6 20.7 390.8 20.8 391.1 21.0 c\r391.3 21.1 391.5 21.4 391.7 21.9 c\r391.8 21.8 l\r391.7 21.3 391.5 20.8 391.2 20.4 c\r390.8 20.1 390.4 19.9 389.8 19.9 c\r389.3 19.9 388.8 20.1 388.3 20.5 c\r387.9 21.0 387.7 21.6 387.7 22.3 c\r387.7 23.1 387.9 23.8 388.4 24.2 c\r388.8 24.7 389.3 24.9 389.9 24.9 c\r390.5 24.9 390.9 24.8 391.3 24.4 c\r391.6 24.1 391.8 23.6 391.8 23.0 c\rh\r388.5 23.3 m\r390.7 23.3 l\r390.7 23.6 390.7 23.8 390.6 24.0 c\r390.5 24.2 390.4 24.3 390.2 24.4 c\r390.0 24.5 389.9 24.6 389.7 24.6 c\r389.4 24.6 389.1 24.5 388.9 24.3 c\r388.6 24.0 388.5 23.7 388.5 23.3 c\rf*\rn\r481.6 21.1 m\r481.8 21.1 481.9 21.0 482.0 20.9 c\r482.1 20.8 482.2 20.6 482.2 20.5 c\r482.2 20.3 482.1 20.2 482.0 20.0 c\r481.9 19.9 481.8 19.9 481.6 19.9 c\r481.4 19.9 481.3 19.9 481.2 20.0 c\r481.1 20.2 481.0 20.3 481.0 20.5 c\r481.0 20.6 481.1 20.8 481.2 20.9 c\r481.3 21.0 481.4 21.1 481.6 21.1 c\rf*\rn\r134.9 23.0 m\r134.9 22.3 135.0 21.7 135.4 21.3 c\r135.7 20.9 136.2 20.7 136.6 20.7 c\r137.0 20.7 137.2 20.8 137.5 21.0 c\r137.7 21.1 137.9 21.4 138.1 21.9 c\r138.2 21.8 l\r138.1 21.3 137.9 20.8 137.6 20.4 c\r137.2 20.1 136.8 19.9 136.2 19.9 c\r135.7 19.9 135.2 20.1 134.7 20.5 c\r134.3 21.0 134.1 21.6 134.1 22.3 c\r134.1 23.1 134.3 23.8 134.8 24.2 c\r135.2 24.7 135.7 24.9 136.3 24.9 c\r136.9 24.9 137.3 24.8 137.7 24.4 c\r138.0 24.1 138.2 23.6 138.2 23.0 c\rh\r134.9 23.3 m\r137.1 23.3 l\r137.1 23.6 137.1 23.8 137.0 24.0 c\r136.9 24.2 136.8 24.3 136.6 24.4 c\r136.4 24.5 136.3 24.6 136.1 24.6 c\r135.8 24.6 135.5 24.5 135.3 24.3 c\r135.0 24.0 134.9 23.7 134.9 23.3 c\rf*\rn\r247.9 24.8 m\r247.9 21.9 l\r247.9 21.3 247.9 21.0 247.9 20.8 c\r247.9 20.7 248.0 20.6 248.0 20.6 c\r248.1 20.5 248.1 20.5 248.2 20.5 c\r248.3 20.5 248.5 20.5 248.6 20.6 c\r248.7 20.5 l\r247.2 19.9 l\r247.0 19.9 l\r247.0 20.8 l\r246.6 20.4 246.3 20.1 246.0 20.0 c\r245.8 19.9 245.6 19.9 245.4 19.9 c\r245.1 19.9 244.9 19.9 244.7 20.1 c\r244.5 20.3 244.3 20.5 244.2 20.7 c\r244.2 20.9 244.1 21.3 244.1 21.7 c\r244.1 23.9 l\r244.1 24.1 244.1 24.3 244.1 24.4 c\r244.0 24.5 243.9 24.5 243.8 24.6 c\r243.8 24.6 243.6 24.7 243.3 24.7 c\r243.3 24.8 l\r245.0 24.8 l\r245.0 21.6 l\r245.0 21.1 245.1 20.8 245.2 20.7 c\r245.4 20.5 245.6 20.5 245.8 20.5 c\r245.9 20.5 246.1 20.5 246.3 20.6 c\r246.5 20.7 246.7 20.9 247.0 21.2 c\r247.0 23.9 l\r247.0 24.2 246.9 24.4 246.9 24.5 c\r246.8 24.6 246.6 24.7 246.3 24.7 c\r246.3 24.8 l\rh\rf*\rn\r250.3 24.0 m\r250.8 24.6 251.3 24.9 251.8 24.9 c\r252.3 24.9 252.7 24.7 253.1 24.3 c\r253.5 23.9 253.7 23.3 253.7 22.6 c\r253.7 21.7 253.4 21.1 252.8 20.5 c\r252.3 20.1 251.8 19.9 251.2 19.9 c\r250.9 19.9 250.6 19.9 250.3 20.0 c\r250.1 20.1 249.8 20.2 249.5 20.4 c\r249.5 25.4 l\r249.5 25.9 249.5 26.3 249.4 26.4 c\r249.4 26.5 249.4 26.6 249.3 26.7 c\r249.3 26.7 249.2 26.7 249.1 26.7 c\r249.0 26.7 248.9 26.7 248.7 26.7 c\r248.7 26.8 l\r250.1 27.4 l\r250.3 27.4 l\rh\r250.3 23.6 m\r250.3 20.7 l\r250.5 20.6 250.7 20.4 250.9 20.3 c\r251.1 20.2 251.3 20.2 251.5 20.2 c\r251.8 20.2 252.1 20.4 252.4 20.7 c\r252.7 21.1 252.8 21.6 252.8 22.3 c\r252.8 22.9 252.7 23.4 252.4 23.7 c\r252.1 24.0 251.8 24.2 251.4 24.2 c\r251.2 24.2 251.1 24.1 250.9 24.1 c\r250.7 24.0 250.5 23.8 250.3 23.6 c\rf*\rn\r75.6 19.9 m\r75.6 20.0 l\r76.1 20.0 76.5 20.1 76.9 20.3 c\r77.3 20.5 77.6 20.9 78.0 21.4 c\r78.4 21.9 78.6 22.5 78.8 23.1 c\r78.2 22.8 77.7 22.6 77.3 22.6 c\r76.8 22.6 76.4 22.8 76.0 23.2 c\r75.6 23.5 75.5 24.1 75.5 24.7 c\r75.5 25.3 75.6 25.8 76.0 26.3 c\r76.4 26.9 77.0 27.2 77.7 27.2 c\r78.3 27.2 78.8 27.0 79.2 26.5 c\r79.7 25.9 79.9 25.2 79.9 24.3 c\r79.9 23.5 79.7 22.8 79.3 22.1 c\r79.0 21.4 78.4 20.9 77.7 20.4 c\r77.2 20.0 76.6 19.9 75.9 19.9 c\rh\r78.9 23.5 m\r78.9 23.9 78.9 24.3 78.9 24.6 c\r78.9 24.9 78.9 25.3 78.8 25.7 c\r78.6 26.0 78.5 26.3 78.3 26.5 c\r78.1 26.8 77.9 26.9 77.6 26.9 c\r77.3 26.9 77.0 26.7 76.8 26.4 c\r76.6 26.2 76.5 25.8 76.5 25.2 c\r76.5 24.5 76.6 23.9 76.9 23.5 c\r77.1 23.2 77.4 23.1 77.7 23.1 c\r77.9 23.1 78.1 23.1 78.3 23.2 c\r78.5 23.3 78.7 23.4 78.9 23.5 c\rf*\rn\r30.9 27.1 m\r30.9 27.3 l\r31.5 27.1 31.9 26.8 32.2 26.4 c\r32.7 25.9 33.1 25.3 33.4 24.6 c\r33.7 24.0 33.8 23.3 33.8 22.5 c\r33.8 21.5 33.5 20.5 33.0 19.6 c\r32.5 18.7 31.8 18.1 30.9 17.7 c\r30.9 17.9 l\r31.4 18.2 31.7 18.5 32.0 18.9 c\r32.3 19.3 32.5 19.8 32.6 20.4 c\r32.7 21.1 32.8 21.7 32.8 22.4 c\r32.8 23.1 32.7 23.8 32.6 24.4 c\r32.5 24.9 32.4 25.3 32.3 25.5 c\r32.2 25.8 32.0 26.1 31.8 26.4 c\r31.6 26.6 31.3 26.9 30.9 27.1 c\rf*\rn\r263.3 24.9 m\r263.3 23.3 l\r263.1 23.3 l\r263.0 23.8 262.8 24.2 262.6 24.3 c\r262.4 24.5 262.1 24.6 261.8 24.6 c\r261.6 24.6 261.4 24.5 261.2 24.4 c\r261.1 24.3 261.0 24.1 261.0 24.0 c\r261.0 23.8 261.1 23.6 261.2 23.5 c\r261.3 23.3 261.5 23.2 261.8 23.0 c\r262.6 22.7 l\r263.3 22.3 263.7 21.9 263.7 21.3 c\r263.7 20.9 263.5 20.5 263.2 20.3 c\r262.8 20.0 262.4 19.9 262.0 19.9 c\r261.7 19.9 261.4 19.9 261.0 20.0 c\r260.9 20.0 260.8 20.1 260.7 20.1 c\r260.6 20.1 260.6 20.0 260.5 19.9 c\r260.4 19.9 l\r260.4 21.5 l\r260.5 21.5 l\r260.6 21.0 260.8 20.7 261.1 20.5 c\r261.4 20.3 261.7 20.2 262.0 20.2 c\r262.3 20.2 262.5 20.3 262.6 20.4 c\r262.8 20.6 262.9 20.7 262.9 20.9 c\r262.9 21.2 262.8 21.4 262.6 21.6 c\r262.5 21.7 262.2 21.9 261.7 22.2 c\r261.1 22.4 260.8 22.6 260.6 22.8 c\r260.5 23.0 260.4 23.3 260.4 23.6 c\r260.4 24.0 260.5 24.3 260.8 24.5 c\r261.1 24.8 261.4 24.9 261.9 24.9 c\r262.0 24.9 262.3 24.9 262.5 24.8 c\r262.7 24.8 262.8 24.7 262.9 24.7 c\r262.9 24.7 263.0 24.7 263.0 24.8 c\r263.1 24.8 263.1 24.8 263.1 24.9 c\rh\rf*\rn\r211.6 26.4 m\r211.6 24.8 l\r212.7 24.8 l\r212.7 24.5 l\r211.6 24.5 l\r211.6 21.3 l\r211.6 21.0 211.6 20.7 211.7 20.6 c\r211.8 20.5 211.9 20.5 212.0 20.5 c\r212.2 20.5 212.3 20.5 212.4 20.6 c\r212.5 20.6 212.5 20.7 212.6 20.8 c\r212.9 20.8 l\r212.7 20.5 212.6 20.3 212.3 20.1 c\r212.1 19.9 211.9 19.9 211.7 19.9 c\r211.5 19.9 211.3 19.9 211.2 20.0 c\r211.0 20.1 210.9 20.2 210.8 20.4 c\r210.8 20.6 210.7 20.8 210.7 21.2 c\r210.7 24.5 l\r209.9 24.5 l\r209.9 24.6 l\r210.1 24.7 210.3 24.8 210.6 25.0 c\r210.8 25.2 211.0 25.4 211.1 25.7 c\r211.2 25.8 211.3 26.0 211.5 26.4 c\rh\rf*\rn\r270.9 27.4 m\r271.0 27.4 271.1 27.3 271.2 27.2 c\r271.3 27.1 271.4 27.0 271.4 26.9 c\r271.4 26.7 271.3 26.6 271.2 26.5 c\r271.1 26.4 271.0 26.3 270.9 26.3 c\r270.7 26.3 270.6 26.4 270.5 26.5 c\r270.4 26.6 270.3 26.7 270.3 26.9 c\r270.3 27.0 270.4 27.1 270.5 27.2 c\r270.6 27.3 270.7 27.4 270.9 27.4 c\r271.3 24.9 m\r271.3 21.1 l\r271.3 20.8 271.4 20.5 271.4 20.4 c\r271.4 20.3 271.5 20.3 271.6 20.2 c\r271.7 20.2 271.8 20.1 272.1 20.1 c\r272.1 20.0 l\r269.7 20.0 l\r269.7 20.1 l\r270.0 20.1 270.1 20.2 270.2 20.2 c\r270.3 20.3 270.3 20.3 270.4 20.4 c\r270.4 20.5 270.5 20.8 270.5 21.1 c\r270.5 22.9 l\r270.5 23.5 270.4 23.8 270.4 24.0 c\r270.4 24.1 270.4 24.2 270.3 24.2 c\r270.3 24.2 270.2 24.3 270.1 24.3 c\r270.0 24.3 269.9 24.2 269.7 24.2 c\r269.7 24.3 l\r271.1 24.9 l\rh\rf*\rn\r296.0 24.9 m\r296.8 24.9 297.3 24.7 297.8 24.1 c\r298.1 23.6 298.3 23.1 298.3 22.5 c\r298.3 22.1 298.2 21.6 298.0 21.2 c\r297.8 20.8 297.5 20.4 297.2 20.2 c\r296.8 20.0 296.4 19.9 296.0 19.9 c\r295.3 19.9 294.7 20.2 294.3 20.7 c\r293.9 21.2 293.7 21.8 293.7 22.4 c\r293.7 22.8 293.8 23.2 294.1 23.7 c\r294.3 24.1 294.6 24.4 294.9 24.6 c\r295.3 24.8 295.6 24.9 296.0 24.9 c\r295.9 24.6 m\r295.7 24.6 295.5 24.5 295.3 24.4 c\r295.2 24.3 295.0 24.1 294.9 23.8 c\r294.8 23.6 294.7 23.2 294.7 22.8 c\r294.7 22.1 294.9 21.5 295.1 21.0 c\r295.4 20.5 295.8 20.2 296.2 20.2 c\r296.5 20.2 296.8 20.3 297.0 20.6 c\r297.2 20.9 297.3 21.4 297.3 22.1 c\r297.3 22.9 297.1 23.6 296.8 24.1 c\r296.6 24.4 296.2 24.6 295.9 24.6 c\rf*\rn\r412.4 27.4 m\r412.4 24.0 l\r412.8 24.4 413.1 24.6 413.3 24.8 c\r413.6 24.9 413.8 24.9 414.0 24.9 c\r414.3 24.9 414.5 24.9 414.7 24.7 c\r414.9 24.5 415.1 24.3 415.2 24.0 c\r415.2 23.8 415.3 23.4 415.3 22.8 c\r415.3 21.1 l\r415.3 20.7 415.3 20.5 415.3 20.4 c\r415.4 20.3 415.4 20.3 415.5 20.2 c\r415.6 20.2 415.8 20.1 416.0 20.1 c\r416.0 20.0 l\r413.7 20.0 l\r413.7 20.1 l\r413.8 20.1 l\r414.0 20.1 414.1 20.2 414.2 20.2 c\r414.3 20.3 414.3 20.4 414.4 20.6 c\r414.4 20.6 414.4 20.8 414.4 21.1 c\r414.4 22.8 l\r414.4 23.3 414.4 23.7 414.3 23.8 c\r414.3 24.0 414.2 24.1 414.0 24.2 c\r413.9 24.3 413.8 24.3 413.6 24.3 c\r413.4 24.3 413.3 24.3 413.1 24.2 c\r412.9 24.1 412.7 23.9 412.4 23.6 c\r412.4 21.1 l\r412.4 20.7 412.4 20.5 412.4 20.4 c\r412.5 20.3 412.5 20.3 412.6 20.2 c\r412.7 20.2 412.9 20.1 413.1 20.1 c\r413.1 20.0 l\r410.8 20.0 l\r410.8 20.1 l\r411.0 20.1 411.2 20.2 411.3 20.2 c\r411.4 20.3 411.4 20.3 411.5 20.4 c\r411.5 20.5 411.5 20.8 411.5 21.1 c\r411.5 25.4 l\r411.5 25.9 411.5 26.3 411.5 26.4 c\r411.5 26.5 411.4 26.6 411.4 26.7 c\r411.3 26.7 411.2 26.7 411.2 26.7 c\r411.1 26.7 411.0 26.7 410.8 26.7 c\r410.7 26.8 l\r412.2 27.4 l\rh\rf*\rn\r494.7 26.4 m\r494.7 24.8 l\r495.8 24.8 l\r495.8 24.5 l\r494.7 24.5 l\r494.7 21.3 l\r494.7 21.0 494.7 20.7 494.8 20.6 c\r494.9 20.5 495.0 20.5 495.1 20.5 c\r495.2 20.5 495.3 20.5 495.4 20.6 c\r495.5 20.6 495.6 20.7 495.7 20.8 c\r495.9 20.8 l\r495.8 20.5 495.6 20.3 495.4 20.1 c\r495.2 19.9 495.0 19.9 494.7 19.9 c\r494.6 19.9 494.4 19.9 494.2 20.0 c\r494.1 20.1 494.0 20.2 493.9 20.4 c\r493.8 20.6 493.8 20.8 493.8 21.2 c\r493.8 24.5 l\r493.0 24.5 l\r493.0 24.6 l\r493.2 24.7 493.4 24.8 493.6 25.0 c\r493.8 25.2 494.0 25.4 494.2 25.7 c\r494.3 25.8 494.4 26.0 494.5 26.4 c\rh\rf*\rn\r287.7 23.7 m\r291.1 23.7 l\r291.1 25.8 l\r291.1 26.2 291.1 26.4 291.1 26.6 c\r291.0 26.6 291.0 26.7 290.8 26.8 c\r290.7 26.9 290.5 26.9 290.4 26.9 c\r290.1 26.9 l\r290.1 27.1 l\r293.1 27.1 l\r293.1 26.9 l\r292.9 26.9 l\r292.7 26.9 292.6 26.9 292.4 26.8 c\r292.3 26.7 292.2 26.6 292.2 26.5 c\r292.1 26.4 292.1 26.2 292.1 25.8 c\r292.1 21.3 l\r292.1 20.9 292.1 20.6 292.2 20.5 c\r292.2 20.4 292.3 20.3 292.4 20.3 c\r292.6 20.2 292.7 20.1 292.9 20.1 c\r293.1 20.1 l\r293.1 20.0 l\r290.1 20.0 l\r290.1 20.1 l\r290.4 20.1 l\r290.7 20.1 290.9 20.2 291.0 20.4 c\r291.1 20.5 291.1 20.8 291.1 21.3 c\r291.1 23.4 l\r287.7 23.4 l\r287.7 21.3 l\r287.7 20.9 287.8 20.6 287.8 20.5 c\r287.8 20.4 287.9 20.3 288.0 20.3 c\r288.2 20.2 288.3 20.1 288.5 20.1 c\r288.7 20.1 l\r288.7 20.0 l\r285.7 20.0 l\r285.7 20.1 l\r286.0 20.1 l\r286.3 20.1 286.5 20.2 286.6 20.4 c\r286.7 20.5 286.7 20.8 286.7 21.3 c\r286.7 25.8 l\r286.7 26.2 286.7 26.4 286.7 26.6 c\r286.6 26.6 286.6 26.7 286.5 26.8 c\r286.3 26.9 286.1 26.9 286.0 26.9 c\r285.7 26.9 l\r285.7 27.1 l\r288.7 27.1 l\r288.7 26.9 l\r288.5 26.9 l\r288.3 26.9 288.2 26.9 288.0 26.8 c\r287.9 26.7 287.8 26.6 287.8 26.5 c\r287.8 26.4 287.7 26.2 287.7 25.8 c\rh\rf*\rn\r171.0 24.8 m\r171.0 21.9 l\r171.0 21.3 171.0 21.0 171.0 20.8 c\r171.1 20.7 171.1 20.6 171.2 20.6 c\r171.2 20.5 171.3 20.5 171.4 20.5 c\r171.5 20.5 171.6 20.5 171.7 20.6 c\r171.8 20.5 l\r170.4 19.9 l\r170.1 19.9 l\r170.1 20.8 l\r169.7 20.4 169.4 20.1 169.2 20.0 c\r169.0 19.9 168.7 19.9 168.5 19.9 c\r168.2 19.9 168.0 19.9 167.8 20.1 c\r167.6 20.3 167.5 20.5 167.4 20.7 c\r167.3 20.9 167.3 21.3 167.3 21.7 c\r167.3 23.9 l\r167.3 24.1 167.2 24.3 167.2 24.4 c\r167.1 24.5 167.1 24.5 167.0 24.6 c\r166.9 24.6 166.7 24.7 166.5 24.7 c\r166.5 24.8 l\r168.1 24.8 l\r168.1 21.6 l\r168.1 21.1 168.2 20.8 168.4 20.7 c\r168.5 20.5 168.7 20.5 168.9 20.5 c\r169.1 20.5 169.3 20.5 169.4 20.6 c\r169.6 20.7 169.9 20.9 170.1 21.2 c\r170.1 23.9 l\r170.1 24.2 170.1 24.4 170.0 24.5 c\r169.9 24.6 169.7 24.7 169.4 24.7 c\r169.4 24.8 l\rh\rf*\rn\r303.2 24.8 m\r303.2 21.9 l\r303.2 21.3 303.2 21.0 303.2 20.8 c\r303.3 20.7 303.3 20.6 303.4 20.6 c\r303.4 20.5 303.5 20.5 303.6 20.5 c\r303.7 20.5 303.8 20.5 303.9 20.6 c\r304.0 20.5 l\r302.6 19.9 l\r302.3 19.9 l\r302.3 20.8 l\r301.9 20.4 301.6 20.1 301.4 20.0 c\r301.2 19.9 300.9 19.9 300.7 19.9 c\r300.4 19.9 300.2 19.9 300.0 20.1 c\r299.8 20.3 299.7 20.5 299.6 20.7 c\r299.5 20.9 299.5 21.3 299.5 21.7 c\r299.5 23.9 l\r299.5 24.1 299.4 24.3 299.4 24.4 c\r299.3 24.5 299.3 24.5 299.2 24.6 c\r299.1 24.6 298.9 24.7 298.7 24.7 c\r298.7 24.8 l\r300.3 24.8 l\r300.3 21.6 l\r300.3 21.1 300.4 20.8 300.6 20.7 c\r300.7 20.5 300.9 20.5 301.1 20.5 c\r301.3 20.5 301.5 20.5 301.6 20.6 c\r301.8 20.7 302.1 20.9 302.3 21.2 c\r302.3 23.9 l\r302.3 24.2 302.3 24.4 302.2 24.5 c\r302.1 24.6 301.9 24.7 301.6 24.7 c\r301.6 24.8 l\rh\rf*\rn\r323.1 22.3 m\r320.3 22.3 l\r319.8 21.2 l\r319.7 21.0 319.6 20.7 319.6 20.6 c\r319.6 20.5 319.7 20.4 319.8 20.3 c\r319.9 20.2 320.1 20.2 320.4 20.1 c\r320.4 20.0 l\r318.2 20.0 l\r318.2 20.1 l\r318.5 20.2 318.7 20.3 318.8 20.4 c\r319.0 20.5 319.2 20.9 319.4 21.4 c\r322.0 27.2 l\r322.2 27.2 l\r324.5 21.3 l\r324.7 20.9 324.9 20.5 325.1 20.4 c\r325.2 20.2 325.4 20.2 325.7 20.1 c\r325.7 20.0 l\r322.9 20.0 l\r322.9 20.1 l\r323.2 20.1 323.4 20.2 323.5 20.3 c\r323.6 20.4 323.6 20.5 323.6 20.6 c\r323.6 20.8 323.6 21.0 323.4 21.4 c\rh\r322.9 22.7 m\r321.8 25.5 l\r320.4 22.7 l\rh\rf*\rn\r177.0 24.0 m\r177.6 24.6 178.1 24.9 178.6 24.9 c\r178.9 24.9 179.1 24.9 179.3 24.7 c\r179.5 24.6 179.6 24.4 179.7 24.1 c\r179.8 23.9 179.9 23.5 179.9 23.1 c\r179.9 21.1 l\r179.9 20.7 179.9 20.5 179.9 20.4 c\r180.0 20.3 180.0 20.3 180.1 20.2 c\r180.2 20.2 180.4 20.1 180.6 20.1 c\r180.6 20.0 l\r178.3 20.0 l\r178.3 20.1 l\r178.4 20.1 l\r178.6 20.1 178.7 20.2 178.8 20.2 c\r178.9 20.3 178.9 20.4 179.0 20.6 c\r179.0 20.6 179.0 20.8 179.0 21.1 c\r179.0 23.1 l\r179.0 23.5 178.9 23.8 178.8 24.0 c\r178.7 24.2 178.5 24.3 178.2 24.3 c\r177.8 24.3 177.4 24.1 177.0 23.6 c\r177.0 21.1 l\r177.0 20.7 177.0 20.5 177.1 20.4 c\r177.1 20.3 177.2 20.3 177.2 20.2 c\r177.3 20.2 177.5 20.1 177.7 20.1 c\r177.7 20.0 l\r175.4 20.0 l\r175.4 20.1 l\r175.5 20.1 l\r175.8 20.1 175.9 20.2 176.0 20.3 c\r176.1 20.5 176.1 20.7 176.1 21.1 c\r176.1 22.9 l\r176.1 23.5 176.1 23.8 176.1 24.0 c\r176.1 24.1 176.0 24.2 176.0 24.2 c\r175.9 24.2 175.8 24.3 175.8 24.3 c\r175.7 24.3 175.5 24.2 175.4 24.2 c\r175.3 24.3 l\r176.8 24.9 l\r177.0 24.9 l\rh\rf*\rn\r314.2 21.1 m\r314.4 21.1 314.5 21.0 314.6 20.9 c\r314.7 20.8 314.8 20.6 314.8 20.5 c\r314.8 20.3 314.7 20.2 314.6 20.0 c\r314.5 19.9 314.4 19.9 314.2 19.9 c\r314.0 19.9 313.9 19.9 313.8 20.0 c\r313.7 20.2 313.6 20.3 313.6 20.5 c\r313.6 20.6 313.7 20.8 313.8 20.9 c\r313.9 21.0 314.0 21.1 314.2 21.1 c\rf*\rn\r374.9 23.0 m\r374.9 22.3 375.0 21.7 375.4 21.3 c\r375.7 20.9 376.2 20.7 376.6 20.7 c\r377.0 20.7 377.2 20.8 377.5 21.0 c\r377.7 21.1 377.9 21.4 378.1 21.9 c\r378.2 21.8 l\r378.1 21.3 377.9 20.8 377.6 20.4 c\r377.2 20.1 376.8 19.9 376.2 19.9 c\r375.7 19.9 375.2 20.1 374.7 20.5 c\r374.3 21.0 374.1 21.6 374.1 22.3 c\r374.1 23.1 374.3 23.8 374.8 24.2 c\r375.2 24.7 375.7 24.9 376.3 24.9 c\r376.9 24.9 377.3 24.8 377.7 24.4 c\r378.0 24.1 378.2 23.6 378.2 23.0 c\rh\r374.9 23.3 m\r377.1 23.3 l\r377.1 23.6 377.1 23.8 377.0 24.0 c\r376.9 24.2 376.8 24.3 376.6 24.4 c\r376.4 24.5 376.3 24.6 376.1 24.6 c\r375.8 24.6 375.5 24.5 375.3 24.3 c\r375.0 24.0 374.9 23.7 374.9 23.3 c\rf*\rn\r223.4 24.0 m\r224.0 24.6 224.5 24.9 225.0 24.9 c\r225.3 24.9 225.5 24.9 225.7 24.7 c\r225.9 24.6 226.0 24.4 226.1 24.1 c\r226.2 23.9 226.3 23.5 226.3 23.1 c\r226.3 21.1 l\r226.3 20.7 226.3 20.5 226.3 20.4 c\r226.4 20.3 226.4 20.3 226.5 20.2 c\r226.6 20.2 226.8 20.1 227.0 20.1 c\r227.0 20.0 l\r224.7 20.0 l\r224.7 20.1 l\r224.8 20.1 l\r225.0 20.1 225.1 20.2 225.2 20.2 c\r225.3 20.3 225.3 20.4 225.4 20.6 c\r225.4 20.6 225.4 20.8 225.4 21.1 c\r225.4 23.1 l\r225.4 23.5 225.3 23.8 225.2 24.0 c\r225.1 24.2 224.9 24.3 224.6 24.3 c\r224.2 24.3 223.8 24.1 223.4 23.6 c\r223.4 21.1 l\r223.4 20.7 223.4 20.5 223.5 20.4 c\r223.5 20.3 223.6 20.3 223.6 20.2 c\r223.7 20.2 223.9 20.1 224.1 20.1 c\r224.1 20.0 l\r221.8 20.0 l\r221.8 20.1 l\r221.9 20.1 l\r222.2 20.1 222.3 20.2 222.4 20.3 c\r222.5 20.5 222.5 20.7 222.5 21.1 c\r222.5 22.9 l\r222.5 23.5 222.5 23.8 222.5 24.0 c\r222.5 24.1 222.4 24.2 222.4 24.2 c\r222.3 24.2 222.2 24.3 222.2 24.3 c\r222.1 24.3 221.9 24.2 221.8 24.2 c\r221.7 24.3 l\r223.2 24.9 l\r223.4 24.9 l\rh\rf*\rn\rf*\rn\r330.9 27.4 m\r330.9 21.1 l\r330.9 20.8 330.9 20.5 330.9 20.4 c\r331.0 20.3 331.0 20.3 331.1 20.2 c\r331.2 20.2 331.4 20.1 331.6 20.1 c\r331.6 20.0 l\r329.3 20.0 l\r329.3 20.1 l\r329.5 20.1 329.6 20.2 329.7 20.2 c\r329.8 20.3 329.9 20.3 329.9 20.4 c\r330.0 20.5 330.0 20.8 330.0 21.1 c\r330.0 25.4 l\r330.0 25.9 330.0 26.3 330.0 26.4 c\r329.9 26.5 329.9 26.6 329.9 26.7 c\r329.8 26.7 329.7 26.7 329.7 26.7 c\r329.6 26.7 329.5 26.7 329.3 26.7 c\r329.3 26.8 l\r330.6 27.4 l\rh\rf*\rn\rf*\rn\r428.8 24.9 m\r429.0 24.9 429.1 24.9 429.2 24.8 c\r429.3 24.6 429.4 24.5 429.4 24.3 c\r429.4 24.2 429.3 24.0 429.2 23.9 c\r429.1 23.8 429.0 23.7 428.8 23.7 c\r428.6 23.7 428.5 23.8 428.4 23.9 c\r428.3 24.0 428.2 24.2 428.2 24.3 c\r428.2 24.5 428.3 24.6 428.4 24.8 c\r428.5 24.9 428.6 24.9 428.8 24.9 c\r428.8 21.1 m\r429.0 21.1 429.1 21.0 429.2 20.9 c\r429.3 20.8 429.4 20.6 429.4 20.5 c\r429.4 20.3 429.3 20.2 429.2 20.0 c\r429.1 19.9 429.0 19.9 428.8 19.9 c\r428.6 19.9 428.5 19.9 428.4 20.0 c\r428.3 20.2 428.2 20.3 428.2 20.5 c\r428.2 20.6 428.3 20.8 428.4 20.9 c\r428.5 21.0 428.6 21.1 428.8 21.1 c\rf*\rn\rf*\rn\r265.7 27.4 m\r265.7 24.0 l\r266.1 24.4 266.4 24.6 266.6 24.8 c\r266.8 24.9 267.1 24.9 267.3 24.9 c\r267.6 24.9 267.8 24.9 268.0 24.7 c\r268.2 24.5 268.3 24.3 268.4 24.0 c\r268.5 23.8 268.5 23.4 268.5 22.8 c\r268.5 21.1 l\r268.5 20.7 268.6 20.5 268.6 20.4 c\r268.6 20.3 268.7 20.3 268.8 20.2 c\r268.9 20.2 269.0 20.1 269.3 20.1 c\r269.3 20.0 l\r266.9 20.0 l\r266.9 20.1 l\r267.0 20.1 l\r267.2 20.1 267.4 20.2 267.5 20.2 c\r267.6 20.3 267.6 20.4 267.6 20.6 c\r267.7 20.6 267.7 20.8 267.7 21.1 c\r267.7 22.8 l\r267.7 23.3 267.6 23.7 267.6 23.8 c\r267.5 24.0 267.4 24.1 267.3 24.2 c\r267.2 24.3 267.0 24.3 266.9 24.3 c\r266.7 24.3 266.5 24.3 266.3 24.2 c\r266.2 24.1 265.9 23.9 265.7 23.6 c\r265.7 21.1 l\r265.7 20.7 265.7 20.5 265.7 20.4 c\r265.8 20.3 265.8 20.3 265.9 20.2 c\r266.0 20.2 266.2 20.1 266.4 20.1 c\r266.4 20.0 l\r264.1 20.0 l\r264.1 20.1 l\r264.3 20.1 264.4 20.2 264.6 20.2 c\r264.6 20.3 264.7 20.3 264.7 20.4 c\r264.8 20.5 264.8 20.8 264.8 21.1 c\r264.8 25.4 l\r264.8 25.9 264.8 26.3 264.8 26.4 c\r264.7 26.5 264.7 26.6 264.6 26.7 c\r264.6 26.7 264.5 26.7 264.4 26.7 c\r264.4 26.7 264.2 26.7 264.1 26.7 c\r264.0 26.8 l\r265.4 27.4 l\rh\rf*\rn\r55.1 22.6 m\r55.1 21.9 l\r54.1 21.9 l\r54.1 20.0 l\r53.3 20.0 l\r53.3 21.9 l\r50.4 21.9 l\r50.4 22.5 l\r53.6 27.2 l\r54.1 27.2 l\r54.1 22.6 l\rh\r53.3 22.6 m\r53.3 26.2 l\r50.9 22.6 l\rh\rf*\rn\r353.3 26.4 m\r353.3 24.8 l\r354.4 24.8 l\r354.4 24.5 l\r353.3 24.5 l\r353.3 21.3 l\r353.3 21.0 353.3 20.7 353.4 20.6 c\r353.5 20.5 353.6 20.5 353.7 20.5 c\r353.8 20.5 353.9 20.5 354.0 20.6 c\r354.1 20.6 354.2 20.7 354.3 20.8 c\r354.5 20.8 l\r354.4 20.5 354.2 20.3 354.0 20.1 c\r353.8 19.9 353.6 19.9 353.3 19.9 c\r353.2 19.9 353.0 19.9 352.8 20.0 c\r352.7 20.1 352.6 20.2 352.5 20.4 c\r352.4 20.6 352.4 20.8 352.4 21.2 c\r352.4 24.5 l\r351.6 24.5 l\r351.6 24.6 l\r351.8 24.7 352.0 24.8 352.2 25.0 c\r352.4 25.2 352.6 25.4 352.8 25.7 c\r352.9 25.8 353.0 26.0 353.1 26.4 c\rh\rf*\rn\r357.9 24.9 m\r357.9 23.3 l\r357.8 23.3 l\r357.7 23.8 357.5 24.2 357.3 24.3 c\r357.1 24.5 356.8 24.6 356.5 24.6 c\r356.2 24.6 356.0 24.5 355.9 24.4 c\r355.7 24.3 355.7 24.1 355.7 24.0 c\r355.7 23.8 355.7 23.6 355.8 23.5 c\r356.0 23.3 356.2 23.2 356.5 23.0 c\r357.3 22.7 l\r358.0 22.3 358.3 21.9 358.3 21.3 c\r358.3 20.9 358.2 20.5 357.8 20.3 c\r357.5 20.0 357.1 19.9 356.7 19.9 c\r356.4 19.9 356.1 19.9 355.7 20.0 c\r355.6 20.0 355.5 20.1 355.4 20.1 c\r355.3 20.1 355.2 20.0 355.2 19.9 c\r355.1 19.9 l\r355.1 21.5 l\r355.2 21.5 l\r355.3 21.0 355.5 20.7 355.8 20.5 c\r356.0 20.3 356.4 20.2 356.7 20.2 c\r356.9 20.2 357.1 20.3 357.3 20.4 c\r357.5 20.6 357.5 20.7 357.5 20.9 c\r357.5 21.2 357.5 21.4 357.3 21.6 c\r357.2 21.7 356.8 21.9 356.3 22.2 c\r355.8 22.4 355.5 22.6 355.3 22.8 c\r355.1 23.0 355.1 23.3 355.1 23.6 c\r355.1 24.0 355.2 24.3 355.5 24.5 c\r355.7 24.8 356.1 24.9 356.5 24.9 c\r356.7 24.9 356.9 24.9 357.2 24.8 c\r357.4 24.8 357.5 24.7 357.6 24.7 c\r357.6 24.7 357.7 24.7 357.7 24.8 c\r357.7 24.8 357.8 24.8 357.8 24.9 c\rh\rf*\rn\r309.3 23.0 m\r309.3 22.3 309.4 21.7 309.8 21.3 c\r310.1 20.9 310.6 20.7 311.0 20.7 c\r311.4 20.7 311.6 20.8 311.9 21.0 c\r312.1 21.1 312.3 21.4 312.5 21.9 c\r312.6 21.8 l\r312.5 21.3 312.3 20.8 312.0 20.4 c\r311.6 20.1 311.2 19.9 310.6 19.9 c\r310.1 19.9 309.6 20.1 309.1 20.5 c\r308.7 21.0 308.5 21.6 308.5 22.3 c\r308.5 23.1 308.7 23.8 309.2 24.2 c\r309.6 24.7 310.1 24.9 310.7 24.9 c\r311.3 24.9 311.7 24.8 312.1 24.4 c\r312.4 24.1 312.6 23.6 312.6 23.0 c\rh\r309.3 23.3 m\r311.5 23.3 l\r311.5 23.6 311.5 23.8 311.4 24.0 c\r311.3 24.2 311.2 24.3 311.0 24.4 c\r310.8 24.5 310.7 24.6 310.5 24.6 c\r310.2 24.6 309.9 24.5 309.7 24.3 c\r309.4 24.0 309.3 23.7 309.3 23.3 c\rf*\rn\r140.1 23.9 m\r140.5 24.3 140.7 24.5 140.7 24.5 c\r140.9 24.6 141.1 24.7 141.2 24.8 c\r141.4 24.9 141.6 24.9 141.8 24.9 c\r142.1 24.9 142.3 24.8 142.5 24.7 c\r142.8 24.5 142.9 24.3 143.0 23.9 c\r143.3 24.3 143.6 24.6 143.9 24.7 c\r144.1 24.9 144.4 24.9 144.6 24.9 c\r144.9 24.9 145.1 24.9 145.3 24.7 c\r145.5 24.6 145.6 24.4 145.7 24.1 c\r145.8 23.9 145.9 23.6 145.9 23.1 c\r145.9 21.1 l\r145.9 20.8 145.9 20.5 145.9 20.4 c\r146.0 20.3 146.0 20.3 146.1 20.2 c\r146.2 20.2 146.4 20.1 146.6 20.1 c\r146.6 20.0 l\r144.3 20.0 l\r144.3 20.1 l\r144.4 20.1 l\r144.5 20.1 144.7 20.2 144.8 20.3 c\r144.9 20.3 144.9 20.4 145.0 20.5 c\r145.0 20.6 145.0 20.8 145.0 21.1 c\r145.0 23.2 l\r145.0 23.5 144.9 23.8 144.9 24.0 c\r144.7 24.2 144.5 24.3 144.2 24.3 c\r144.0 24.3 143.8 24.3 143.7 24.2 c\r143.5 24.1 143.3 23.9 143.0 23.7 c\r143.0 23.6 l\r143.0 23.4 l\r143.0 21.1 l\r143.0 20.7 143.0 20.5 143.0 20.4 c\r143.1 20.3 143.1 20.3 143.2 20.2 c\r143.3 20.2 143.5 20.1 143.7 20.1 c\r143.7 20.0 l\r141.4 20.0 l\r141.4 20.1 l\r141.6 20.1 141.8 20.2 141.9 20.2 c\r142.0 20.3 142.1 20.4 142.1 20.5 c\r142.1 20.6 142.1 20.8 142.1 21.1 c\r142.1 23.2 l\r142.1 23.6 142.1 23.8 142.0 24.0 c\r141.8 24.2 141.6 24.3 141.3 24.3 c\r141.1 24.3 141.0 24.3 140.8 24.2 c\r140.5 24.0 140.3 23.9 140.1 23.7 c\r140.1 21.1 l\r140.1 20.7 140.2 20.5 140.2 20.4 c\r140.2 20.3 140.3 20.3 140.4 20.2 c\r140.5 20.2 140.6 20.1 140.9 20.1 c\r140.9 20.0 l\r138.5 20.0 l\r138.5 20.1 l\r138.8 20.1 138.9 20.2 139.0 20.2 c\r139.1 20.3 139.2 20.3 139.2 20.4 c\r139.2 20.5 139.3 20.8 139.3 21.1 c\r139.3 22.9 l\r139.3 23.5 139.2 23.8 139.2 24.0 c\r139.2 24.1 139.2 24.2 139.1 24.2 c\r139.1 24.2 139.0 24.3 138.9 24.3 c\r138.8 24.3 138.7 24.2 138.5 24.2 c\r138.5 24.3 l\r139.9 24.9 l\r140.1 24.9 l\rh\rf*\rn\r366.0 23.0 m\r366.0 22.3 366.2 21.7 366.5 21.3 c\r366.9 20.9 367.3 20.7 367.8 20.7 c\r368.1 20.7 368.4 20.8 368.6 21.0 c\r368.8 21.1 369.0 21.4 369.2 21.9 c\r369.3 21.8 l\r369.3 21.3 369.0 20.8 368.7 20.4 c\r368.3 20.1 367.9 19.9 367.4 19.9 c\r366.8 19.9 366.3 20.1 365.9 20.5 c\r365.5 21.0 365.3 21.6 365.3 22.3 c\r365.3 23.1 365.5 23.8 365.9 24.2 c\r366.3 24.7 366.8 24.9 367.5 24.9 c\r368.0 24.9 368.5 24.8 368.8 24.4 c\r369.2 24.1 369.3 23.6 369.3 23.0 c\rh\r366.0 23.3 m\r368.3 23.3 l\r368.2 23.6 368.2 23.8 368.1 24.0 c\r368.1 24.2 367.9 24.3 367.8 24.4 c\r367.6 24.5 367.4 24.6 367.2 24.6 c\r366.9 24.6 366.6 24.5 366.4 24.3 c\r366.2 24.0 366.0 23.7 366.0 23.3 c\rf*\rn\r373.0 24.9 m\r373.0 23.3 l\r372.9 23.3 l\r372.7 23.8 372.6 24.2 372.3 24.3 c\r372.1 24.5 371.9 24.6 371.6 24.6 c\r371.3 24.6 371.1 24.5 371.0 24.4 c\r370.8 24.3 370.7 24.1 370.7 24.0 c\r370.7 23.8 370.8 23.6 370.9 23.5 c\r371.0 23.3 371.2 23.2 371.6 23.0 c\r372.3 22.7 l\r373.0 22.3 373.4 21.9 373.4 21.3 c\r373.4 20.9 373.2 20.5 372.9 20.3 c\r372.6 20.0 372.2 19.9 371.8 19.9 c\r371.5 19.9 371.1 19.9 370.7 20.0 c\r370.6 20.0 370.5 20.1 370.5 20.1 c\r370.4 20.1 370.3 20.0 370.3 19.9 c\r370.1 19.9 l\r370.1 21.5 l\r370.3 21.5 l\r370.4 21.0 370.6 20.7 370.8 20.5 c\r371.1 20.3 371.4 20.2 371.8 20.2 c\r372.0 20.2 372.2 20.3 372.4 20.4 c\r372.5 20.6 372.6 20.7 372.6 20.9 c\r372.6 21.2 372.5 21.4 372.4 21.6 c\r372.2 21.7 371.9 21.9 371.4 22.2 c\r370.9 22.4 370.5 22.6 370.4 22.8 c\r370.2 23.0 370.1 23.3 370.1 23.6 c\r370.1 24.0 370.3 24.3 370.5 24.5 c\r370.8 24.8 371.2 24.9 371.6 24.9 c\r371.8 24.9 372.0 24.9 372.3 24.8 c\r372.4 24.8 372.6 24.7 372.6 24.7 c\r372.7 24.7 372.7 24.7 372.8 24.8 c\r372.8 24.8 372.8 24.8 372.9 24.9 c\rh\rf*\rn\r273.9 24.0 m\r274.5 24.6 275.0 24.9 275.5 24.9 c\r275.8 24.9 276.0 24.9 276.2 24.7 c\r276.4 24.6 276.6 24.4 276.7 24.1 c\r276.8 23.9 276.8 23.5 276.8 23.1 c\r276.8 21.1 l\r276.8 20.7 276.8 20.5 276.9 20.4 c\r276.9 20.3 277.0 20.3 277.1 20.2 c\r277.1 20.2 277.3 20.1 277.5 20.1 c\r277.5 20.0 l\r275.2 20.0 l\r275.2 20.1 l\r275.3 20.1 l\r275.5 20.1 275.6 20.2 275.7 20.2 c\r275.8 20.3 275.9 20.4 275.9 20.6 c\r275.9 20.6 275.9 20.8 275.9 21.1 c\r275.9 23.1 l\r275.9 23.5 275.9 23.8 275.8 24.0 c\r275.6 24.2 275.5 24.3 275.2 24.3 c\r274.8 24.3 274.3 24.1 273.9 23.6 c\r273.9 21.1 l\r273.9 20.7 273.9 20.5 274.0 20.4 c\r274.0 20.3 274.1 20.3 274.2 20.2 c\r274.3 20.2 274.4 20.1 274.7 20.1 c\r274.7 20.0 l\r272.3 20.0 l\r272.3 20.1 l\r272.4 20.1 l\r272.7 20.1 272.9 20.2 272.9 20.3 c\r273.0 20.5 273.1 20.7 273.1 21.1 c\r273.1 22.9 l\r273.1 23.5 273.1 23.8 273.0 24.0 c\r273.0 24.1 273.0 24.2 272.9 24.2 c\r272.9 24.2 272.8 24.3 272.7 24.3 c\r272.6 24.3 272.5 24.2 272.3 24.2 c\r272.3 24.3 l\r273.7 24.9 l\r273.9 24.9 l\rh\rf*\rn\r380.1 24.9 m\r380.1 23.9 l\r380.5 24.6 380.9 24.9 381.3 24.9 c\r381.5 24.9 381.7 24.9 381.8 24.8 c\r381.9 24.6 382.0 24.5 382.0 24.3 c\r382.0 24.2 382.0 24.1 381.9 24.0 c\r381.8 23.9 381.7 23.9 381.6 23.9 c\r381.5 23.9 381.3 23.9 381.2 24.0 c\r381.0 24.1 380.9 24.2 380.8 24.2 c\r380.8 24.2 380.7 24.2 380.6 24.1 c\r380.5 24.0 380.3 23.7 380.1 23.4 c\r380.1 21.1 l\r380.1 20.8 380.2 20.6 380.2 20.5 c\r380.3 20.4 380.4 20.3 380.5 20.3 c\r380.6 20.2 380.8 20.1 381.0 20.1 c\r381.0 20.0 l\r378.5 20.0 l\r378.5 20.1 l\r378.8 20.1 378.9 20.2 379.1 20.3 c\r379.1 20.3 379.2 20.4 379.2 20.5 c\r379.3 20.6 379.3 20.8 379.3 21.1 c\r379.3 22.9 l\r379.3 23.5 379.3 23.8 379.2 24.0 c\r379.2 24.1 379.2 24.1 379.1 24.2 c\r379.0 24.2 379.0 24.3 378.9 24.3 c\r378.8 24.3 378.7 24.2 378.5 24.2 c\r378.5 24.3 l\r379.9 24.9 l\rh\rf*\rn\r421.9 24.3 m\r423.4 24.9 l\r423.6 24.9 l\r423.6 23.8 l\r423.8 24.2 424.1 24.5 424.3 24.7 c\r424.6 24.8 424.9 24.9 425.1 24.9 c\r425.6 24.9 426.0 24.7 426.3 24.4 c\r426.7 23.9 426.9 23.3 426.9 22.6 c\r426.9 21.7 426.7 21.1 426.2 20.5 c\r425.8 20.1 425.3 19.9 424.7 19.9 c\r424.5 19.9 424.3 19.9 424.1 20.0 c\r423.9 20.0 423.8 20.1 423.6 20.3 c\r423.6 18.8 l\r423.6 18.5 423.6 18.3 423.7 18.2 c\r423.7 18.1 423.8 18.0 423.9 18.0 c\r424.0 17.9 424.1 17.9 424.4 17.9 c\r424.4 17.7 l\r421.9 17.7 l\r421.9 17.9 l\r422.0 17.9 l\r422.2 17.9 422.4 17.9 422.5 18.0 c\r422.6 18.0 422.6 18.1 422.7 18.2 c\r422.7 18.2 422.7 18.5 422.7 18.8 c\r422.7 23.4 l\r422.7 23.7 422.7 23.9 422.7 24.0 c\r422.7 24.1 422.6 24.2 422.6 24.2 c\r422.5 24.2 422.4 24.3 422.3 24.3 c\r422.2 24.3 422.1 24.2 422.0 24.2 c\rh\r423.6 23.5 m\r423.6 21.7 l\r423.6 21.3 423.6 21.1 423.6 21.0 c\r423.7 20.8 423.8 20.6 424.0 20.4 c\r424.2 20.3 424.5 20.2 424.8 20.2 c\r425.1 20.2 425.4 20.3 425.6 20.6 c\r425.9 21.0 426.1 21.5 426.1 22.1 c\r426.1 22.8 425.9 23.4 425.6 23.8 c\r425.3 24.1 425.1 24.2 424.7 24.2 c\r424.6 24.2 424.4 24.2 424.2 24.1 c\r424.1 24.0 423.9 23.8 423.6 23.5 c\rf*\rn\r234.5 21.9 m\r234.3 21.2 234.1 20.7 233.7 20.4 c\r233.3 20.0 232.9 19.9 232.4 19.9 c\r231.9 19.9 231.4 20.1 231.0 20.5 c\r230.6 21.0 230.4 21.6 230.4 22.4 c\r230.4 23.1 230.6 23.8 231.1 24.2 c\r231.5 24.7 232.0 24.9 232.7 24.9 c\r233.1 24.9 233.5 24.8 233.8 24.6 c\r234.1 24.3 234.3 24.0 234.3 23.8 c\r234.3 23.6 234.2 23.5 234.1 23.5 c\r234.1 23.4 233.9 23.3 233.8 23.3 c\r233.6 23.3 233.4 23.4 233.4 23.5 c\r233.3 23.6 233.2 23.7 233.2 24.0 c\r233.2 24.2 233.1 24.3 233.0 24.4 c\r232.9 24.5 232.7 24.6 232.5 24.6 c\r232.2 24.6 231.9 24.5 231.7 24.2 c\r231.4 23.9 231.3 23.4 231.3 22.9 c\r231.3 22.3 231.4 21.8 231.7 21.4 c\r232.0 20.9 232.4 20.7 232.8 20.7 c\r233.2 20.7 233.5 20.8 233.8 21.0 c\r234.0 21.2 234.1 21.5 234.3 21.9 c\rh\rf*\rn\r55.9 22.9 m\r58.6 22.9 l\r58.6 22.0 l\r55.9 22.0 l\rh\rf*\rn\r398.7 21.1 m\r398.9 21.1 399.0 21.0 399.2 20.9 c\r399.3 20.8 399.3 20.6 399.3 20.5 c\r399.3 20.3 399.3 20.2 399.2 20.0 c\r399.0 19.9 398.9 19.9 398.7 19.9 c\r398.6 19.9 398.4 19.9 398.3 20.0 c\r398.2 20.2 398.1 20.3 398.1 20.5 c\r398.1 20.6 398.2 20.8 398.3 20.9 c\r398.4 21.0 398.6 21.1 398.7 21.1 c\rf*\rn\rf*\rn\r342.5 21.7 m\r342.2 21.9 342.0 22.1 341.8 22.3 c\r341.7 22.6 341.6 22.9 341.6 23.2 c\r341.6 23.7 341.8 24.1 342.1 24.4 c\r342.5 24.8 342.9 24.9 343.5 24.9 c\r343.9 24.9 344.3 24.8 344.7 24.6 c\r345.7 24.6 l\r345.8 24.6 345.9 24.6 345.9 24.6 c\r345.9 24.6 346.0 24.6 346.0 24.5 c\r346.0 24.5 346.0 24.4 346.0 24.4 c\r346.0 24.3 346.0 24.2 346.0 24.2 c\r346.0 24.2 345.9 24.2 345.9 24.1 c\r345.9 24.1 345.8 24.1 345.7 24.1 c\r345.0 24.1 l\r345.2 23.9 345.3 23.6 345.3 23.2 c\r345.3 22.7 345.2 22.3 344.8 22.0 c\r344.5 21.7 344.0 21.5 343.5 21.5 c\r343.2 21.5 343.0 21.6 342.7 21.6 c\r342.6 21.5 342.4 21.4 342.4 21.3 c\r342.3 21.2 342.3 21.1 342.3 21.0 c\r342.3 21.0 342.3 20.9 342.4 20.9 c\r342.4 20.8 342.5 20.8 342.7 20.7 c\r342.8 20.7 343.1 20.7 343.5 20.7 c\r344.2 20.7 344.7 20.7 344.9 20.7 c\r345.3 20.6 345.6 20.5 345.8 20.3 c\r346.0 20.1 346.1 19.9 346.1 19.6 c\r346.1 19.2 345.9 18.8 345.5 18.5 c\r345.0 18.0 344.2 17.7 343.4 17.7 c\r342.7 17.7 342.1 17.9 341.7 18.2 c\r341.4 18.4 341.3 18.5 341.3 18.7 c\r341.3 18.8 341.3 18.9 341.3 19.0 c\r341.4 19.1 341.5 19.3 341.7 19.5 c\r341.7 19.5 341.8 19.7 342.1 20.0 c\r341.9 20.1 341.8 20.2 341.7 20.3 c\r341.6 20.4 341.6 20.5 341.6 20.6 c\r341.6 20.7 341.7 20.9 341.8 21.0 c\r341.9 21.2 342.1 21.4 342.5 21.7 c\r343.4 24.7 m\r343.1 24.7 342.9 24.6 342.7 24.4 c\r342.6 24.1 342.5 23.8 342.5 23.4 c\r342.5 22.9 342.6 22.4 342.8 22.1 c\r343.0 21.9 343.2 21.8 343.5 21.8 c\r343.8 21.8 344.0 21.9 344.2 22.1 c\r344.4 22.3 344.5 22.6 344.5 23.0 c\r344.5 23.6 344.3 24.0 344.1 24.3 c\r343.9 24.5 343.7 24.7 343.4 24.7 c\r342.4 20.0 m\r342.3 19.8 342.1 19.7 342.1 19.5 c\r342.0 19.4 341.9 19.2 341.9 19.1 c\r341.9 18.9 342.0 18.8 342.2 18.7 c\r342.6 18.4 343.1 18.3 343.8 18.3 c\r344.5 18.3 345.0 18.4 345.3 18.7 c\r345.6 18.9 345.7 19.1 345.7 19.4 c\r345.7 19.6 345.6 19.7 345.4 19.8 c\r345.3 19.9 344.9 19.9 344.3 19.9 c\r343.5 19.9 342.9 20.0 342.4 20.0 c\rf*\rn\r148.2 27.4 m\r148.3 27.4 148.5 27.3 148.6 27.2 c\r148.7 27.1 148.7 27.0 148.7 26.9 c\r148.7 26.7 148.7 26.6 148.6 26.5 c\r148.5 26.4 148.3 26.3 148.2 26.3 c\r148.1 26.3 147.9 26.4 147.8 26.5 c\r147.7 26.6 147.7 26.7 147.7 26.9 c\r147.7 27.0 147.7 27.1 147.8 27.2 c\r147.9 27.3 148.1 27.4 148.2 27.4 c\r148.7 24.9 m\r148.7 21.1 l\r148.7 20.8 148.7 20.5 148.7 20.4 c\r148.8 20.3 148.8 20.3 148.9 20.2 c\r149.0 20.2 149.2 20.1 149.4 20.1 c\r149.4 20.0 l\r147.1 20.0 l\r147.1 20.1 l\r147.3 20.1 147.5 20.2 147.5 20.2 c\r147.6 20.3 147.7 20.3 147.7 20.4 c\r147.8 20.5 147.8 20.8 147.8 21.1 c\r147.8 22.9 l\r147.8 23.5 147.8 23.8 147.8 24.0 c\r147.7 24.1 147.7 24.2 147.6 24.2 c\r147.6 24.2 147.5 24.3 147.4 24.3 c\r147.3 24.3 147.2 24.2 147.1 24.2 c\r147.0 24.3 l\r148.4 24.9 l\rh\rf*\rn\rf*\rn\r279.2 21.7 m\r278.9 21.9 278.7 22.1 278.5 22.3 c\r278.3 22.6 278.3 22.9 278.3 23.2 c\r278.3 23.7 278.4 24.1 278.8 24.4 c\r279.1 24.8 279.6 24.9 280.1 24.9 c\r280.6 24.9 281.0 24.8 281.3 24.6 c\r282.3 24.6 l\r282.5 24.6 282.6 24.6 282.6 24.6 c\r282.6 24.6 282.6 24.6 282.6 24.5 c\r282.6 24.5 282.7 24.4 282.7 24.4 c\r282.7 24.3 282.7 24.2 282.6 24.2 c\r282.6 24.2 282.6 24.2 282.6 24.1 c\r282.6 24.1 282.5 24.1 282.3 24.1 c\r281.7 24.1 l\r281.9 23.9 282.0 23.6 282.0 23.2 c\r282.0 22.7 281.8 22.3 281.5 22.0 c\r281.2 21.7 280.7 21.5 280.1 21.5 c\r279.9 21.5 279.7 21.6 279.4 21.6 c\r279.2 21.5 279.1 21.4 279.0 21.3 c\r279.0 21.2 278.9 21.1 278.9 21.0 c\r278.9 21.0 279.0 20.9 279.0 20.9 c\r279.1 20.8 279.2 20.8 279.4 20.7 c\r279.5 20.7 279.7 20.7 280.1 20.7 c\r280.9 20.7 281.4 20.7 281.6 20.7 c\r281.9 20.6 282.2 20.5 282.4 20.3 c\r282.6 20.1 282.7 19.9 282.7 19.6 c\r282.7 19.2 282.5 18.8 282.2 18.5 c\r281.6 18.0 280.9 17.7 280.0 17.7 c\r279.4 17.7 278.8 17.9 278.3 18.2 c\r278.1 18.4 277.9 18.5 277.9 18.7 c\r277.9 18.8 278.0 18.9 278.0 19.0 c\r278.0 19.1 278.2 19.3 278.3 19.5 c\r278.3 19.5 278.5 19.7 278.8 20.0 c\r278.6 20.1 278.5 20.2 278.4 20.3 c\r278.3 20.4 278.3 20.5 278.3 20.6 c\r278.3 20.7 278.3 20.9 278.4 21.0 c\r278.5 21.2 278.8 21.4 279.2 21.7 c\r280.1 24.7 m\r279.8 24.7 279.6 24.6 279.4 24.4 c\r279.2 24.1 279.1 23.8 279.1 23.4 c\r279.1 22.9 279.3 22.4 279.5 22.1 c\r279.7 21.9 279.9 21.8 280.2 21.8 c\r280.5 21.8 280.7 21.9 280.9 22.1 c\r281.0 22.3 281.1 22.6 281.1 23.0 c\r281.1 23.6 281.0 24.0 280.8 24.3 c\r280.6 24.5 280.3 24.7 280.1 24.7 c\r279.1 20.0 m\r278.9 19.8 278.8 19.7 278.7 19.5 c\r278.6 19.4 278.6 19.2 278.6 19.1 c\r278.6 18.9 278.7 18.8 278.9 18.7 c\r279.3 18.4 279.8 18.3 280.5 18.3 c\r281.1 18.3 281.6 18.4 281.9 18.7 c\r282.2 18.9 282.4 19.1 282.4 19.4 c\r282.4 19.6 282.3 19.7 282.1 19.8 c\r281.9 19.9 281.5 19.9 281.0 19.9 c\r280.2 19.9 279.5 20.0 279.1 20.0 c\rf*\rn\r417.7 26.4 m\r417.7 24.8 l\r418.8 24.8 l\r418.8 24.5 l\r417.7 24.5 l\r417.7 21.3 l\r417.7 21.0 417.8 20.7 417.9 20.6 c\r417.9 20.5 418.0 20.5 418.2 20.5 c\r418.3 20.5 418.4 20.5 418.5 20.6 c\r418.6 20.6 418.7 20.7 418.7 20.8 c\r419.0 20.8 l\r418.9 20.5 418.7 20.3 418.5 20.1 c\r418.3 19.9 418.0 19.9 417.8 19.9 c\r417.6 19.9 417.5 19.9 417.3 20.0 c\r417.2 20.1 417.0 20.2 417.0 20.4 c\r416.9 20.6 416.9 20.8 416.9 21.2 c\r416.9 24.5 l\r416.1 24.5 l\r416.1 24.6 l\r416.3 24.7 416.5 24.8 416.7 25.0 c\r416.9 25.2 417.1 25.4 417.2 25.7 c\r417.3 25.8 417.4 26.0 417.6 26.4 c\rh\rf*\rn\r420.7 26.4 m\r420.7 24.8 l\r421.8 24.8 l\r421.8 24.5 l\r420.7 24.5 l\r420.7 21.3 l\r420.7 21.0 420.7 20.7 420.8 20.6 c\r420.9 20.5 421.0 20.5 421.1 20.5 c\r421.2 20.5 421.3 20.5 421.4 20.6 c\r421.5 20.6 421.6 20.7 421.7 20.8 c\r421.9 20.8 l\r421.8 20.5 421.6 20.3 421.4 20.1 c\r421.2 19.9 421.0 19.9 420.7 19.9 c\r420.6 19.9 420.4 19.9 420.2 20.0 c\r420.1 20.1 420.0 20.2 419.9 20.4 c\r419.8 20.6 419.8 20.8 419.8 21.2 c\r419.8 24.5 l\r419.0 24.5 l\r419.0 24.6 l\r419.2 24.7 419.4 24.8 419.6 25.0 c\r419.8 25.2 420.0 25.4 420.2 25.7 c\r420.3 25.8 420.4 26.0 420.5 26.4 c\rh\rf*\rn\r382.0 24.8 m\r384.3 24.8 l\r384.3 24.7 l\r384.2 24.7 l\r384.0 24.7 383.9 24.6 383.9 24.6 c\r383.8 24.5 383.8 24.4 383.8 24.3 c\r383.8 24.2 383.8 24.0 383.9 23.9 c\r385.0 21.2 l\r386.1 24.0 l\r386.1 24.2 386.2 24.3 386.2 24.4 c\r386.2 24.5 386.2 24.5 386.1 24.5 c\r386.1 24.6 386.1 24.6 386.0 24.6 c\r385.9 24.7 385.8 24.7 385.6 24.7 c\r385.6 24.8 l\r387.1 24.8 l\r387.1 24.7 l\r387.0 24.6 386.8 24.6 386.8 24.5 c\r386.6 24.4 386.5 24.2 386.4 23.9 c\r384.8 19.9 l\r384.6 19.9 l\r382.9 23.9 l\r382.8 24.1 382.7 24.3 382.7 24.3 c\r382.6 24.4 382.5 24.5 382.4 24.6 c\r382.3 24.6 382.2 24.6 382.0 24.7 c\rh\rf*\rn\r484.6 24.0 m\r485.2 24.6 485.7 24.9 486.2 24.9 c\r486.5 24.9 486.7 24.9 486.9 24.7 c\r487.1 24.6 487.2 24.4 487.3 24.1 c\r487.4 23.9 487.5 23.5 487.5 23.1 c\r487.5 21.1 l\r487.5 20.7 487.5 20.5 487.5 20.4 c\r487.6 20.3 487.6 20.3 487.7 20.2 c\r487.8 20.2 488.0 20.1 488.2 20.1 c\r488.2 20.0 l\r485.9 20.0 l\r485.9 20.1 l\r486.0 20.1 l\r486.2 20.1 486.3 20.2 486.4 20.2 c\r486.5 20.3 486.5 20.4 486.6 20.6 c\r486.6 20.6 486.6 20.8 486.6 21.1 c\r486.6 23.1 l\r486.6 23.5 486.5 23.8 486.4 24.0 c\r486.3 24.2 486.1 24.3 485.8 24.3 c\r485.4 24.3 485.0 24.1 484.6 23.6 c\r484.6 21.1 l\r484.6 20.7 484.6 20.5 484.7 20.4 c\r484.7 20.3 484.8 20.3 484.8 20.2 c\r484.9 20.2 485.1 20.1 485.3 20.1 c\r485.3 20.0 l\r483.0 20.0 l\r483.0 20.1 l\r483.1 20.1 l\r483.4 20.1 483.5 20.2 483.6 20.3 c\r483.7 20.5 483.7 20.7 483.7 21.1 c\r483.7 22.9 l\r483.7 23.5 483.7 23.8 483.7 24.0 c\r483.7 24.1 483.6 24.2 483.6 24.2 c\r483.5 24.2 483.4 24.3 483.4 24.3 c\r483.3 24.3 483.1 24.2 483.0 24.2 c\r482.9 24.3 l\r484.4 24.9 l\r484.6 24.9 l\rh\rf*\rn\r433.2 27.4 m\r430.6 19.9 l\r430.2 19.9 l\r432.8 27.4 l\rh\rf*\rn\r23.3 17.9 m\r23.3 17.7 l\r22.7 18.0 22.3 18.3 22.0 18.7 c\r21.5 19.2 21.1 19.7 20.8 20.4 c\r20.5 21.1 20.4 21.8 20.4 22.5 c\r20.4 23.6 20.7 24.6 21.2 25.4 c\r21.7 26.3 22.4 26.9 23.3 27.3 c\r23.3 27.1 l\r22.8 26.9 22.5 26.6 22.2 26.2 c\r21.9 25.8 21.7 25.2 21.6 24.6 c\r21.5 24.0 21.4 23.3 21.4 22.7 c\r21.4 21.9 21.5 21.3 21.6 20.7 c\r21.7 20.2 21.8 19.8 21.9 19.5 c\r22.0 19.2 22.2 19.0 22.4 18.7 c\r22.6 18.4 22.9 18.2 23.3 17.9 c\rf*\rn\r436.1 24.8 m\r438.1 24.8 l\r438.1 24.7 l\r438.0 24.6 437.8 24.6 437.8 24.6 c\r437.7 24.5 437.7 24.4 437.7 24.3 c\r437.7 24.2 437.7 24.1 437.8 23.9 c\r438.9 21.2 l\r440.0 23.5 l\r439.7 24.1 l\r439.6 24.3 439.5 24.5 439.4 24.6 c\r439.3 24.6 439.2 24.6 439.0 24.7 c\r439.0 24.8 l\r441.1 24.8 l\r441.1 24.7 l\r440.9 24.6 440.8 24.6 440.7 24.5 c\r440.6 24.4 440.6 24.3 440.6 24.2 c\r440.6 24.1 440.6 24.1 440.7 24.0 c\r441.8 21.3 l\r442.7 23.9 l\r442.8 24.1 442.9 24.3 442.9 24.4 c\r442.9 24.4 442.8 24.5 442.7 24.6 c\r442.7 24.6 442.5 24.7 442.3 24.7 c\r442.3 24.8 l\r443.7 24.8 l\r443.7 24.7 l\r443.4 24.6 443.2 24.4 443.0 24.0 c\r441.6 19.9 l\r441.4 19.9 l\r440.1 23.1 l\r438.6 19.9 l\r438.5 19.9 l\r436.9 23.9 l\r436.8 24.2 436.7 24.3 436.6 24.4 c\r436.5 24.5 436.3 24.6 436.1 24.7 c\rh\rf*\rn\r123.4 21.9 m\r123.3 21.2 123.0 20.7 122.6 20.4 c\r122.3 20.0 121.8 19.9 121.4 19.9 c\r120.8 19.9 120.3 20.1 119.9 20.5 c\r119.5 21.0 119.3 21.6 119.3 22.4 c\r119.3 23.1 119.6 23.8 120.0 24.2 c\r120.4 24.7 121.0 24.9 121.6 24.9 c\r122.1 24.9 122.4 24.8 122.7 24.6 c\r123.0 24.3 123.2 24.0 123.2 23.8 c\r123.2 23.6 123.2 23.5 123.1 23.5 c\r123.0 23.4 122.9 23.3 122.7 23.3 c\r122.5 23.3 122.4 23.4 122.3 23.5 c\r122.2 23.6 122.2 23.7 122.1 24.0 c\r122.1 24.2 122.1 24.3 121.9 24.4 c\r121.8 24.5 121.7 24.6 121.4 24.6 c\r121.1 24.6 120.8 24.5 120.6 24.2 c\r120.3 23.9 120.2 23.4 120.2 22.9 c\r120.2 22.3 120.3 21.8 120.6 21.4 c\r120.9 20.9 121.3 20.7 121.8 20.7 c\r122.1 20.7 122.4 20.8 122.7 21.0 c\r122.9 21.2 123.1 21.5 123.3 21.9 c\rh\rf*\rn\r451.6 24.8 m\r453.6 24.8 l\r453.6 24.7 l\r453.4 24.6 453.3 24.6 453.2 24.6 c\r453.2 24.5 453.2 24.4 453.2 24.3 c\r453.2 24.2 453.2 24.1 453.2 23.9 c\r454.3 21.2 l\r455.4 23.5 l\r455.2 24.1 l\r455.1 24.3 455.0 24.5 454.9 24.6 c\r454.8 24.6 454.6 24.6 454.4 24.7 c\r454.4 24.8 l\r456.5 24.8 l\r456.5 24.7 l\r456.4 24.6 456.2 24.6 456.2 24.5 c\r456.1 24.4 456.1 24.3 456.1 24.2 c\r456.1 24.1 456.1 24.1 456.1 24.0 c\r457.2 21.3 l\r458.1 23.9 l\r458.3 24.1 458.3 24.3 458.3 24.4 c\r458.3 24.4 458.3 24.5 458.2 24.6 c\r458.1 24.6 458.0 24.7 457.7 24.7 c\r457.7 24.8 l\r459.2 24.8 l\r459.2 24.7 l\r458.9 24.6 458.7 24.4 458.5 24.0 c\r457.1 19.9 l\r456.9 19.9 l\r455.6 23.1 l\r454.0 19.9 l\r453.9 19.9 l\r452.3 23.9 l\r452.2 24.2 452.1 24.3 452.0 24.4 c\r451.9 24.5 451.8 24.6 451.6 24.7 c\rh\rf*\rn\r193.2 26.7 m\r193.2 23.9 l\r194.7 23.9 l\r195.1 23.9 195.4 23.9 195.6 24.0 c\r195.7 24.2 195.8 24.5 195.9 24.9 c\r196.0 24.9 l\r196.0 22.5 l\r195.9 22.5 l\r195.8 22.9 195.8 23.1 195.7 23.2 c\r195.6 23.3 195.5 23.4 195.4 23.4 c\r195.3 23.5 195.0 23.5 194.7 23.5 c\r193.2 23.5 l\r193.2 21.1 l\r193.2 20.8 193.2 20.6 193.2 20.6 c\r193.3 20.5 193.3 20.4 193.4 20.4 c\r193.5 20.4 193.6 20.3 193.8 20.3 c\r195.0 20.3 l\r195.4 20.3 195.7 20.4 195.9 20.4 c\r196.0 20.5 196.2 20.6 196.4 20.8 c\r196.6 21.0 196.8 21.3 197.1 21.8 c\r197.3 21.8 l\r196.6 20.0 l\r191.2 20.0 l\r191.2 20.1 l\r191.4 20.1 l\r191.6 20.1 191.8 20.2 191.9 20.3 c\r192.0 20.3 192.1 20.4 192.1 20.5 c\r192.2 20.7 192.2 20.9 192.2 21.3 c\r192.2 25.8 l\r192.2 26.3 192.2 26.6 192.1 26.7 c\r191.9 26.8 191.7 26.9 191.4 26.9 c\r191.2 26.9 l\r191.2 27.1 l\r196.7 27.1 l\r196.7 25.5 l\r196.5 25.5 l\r196.5 25.9 196.4 26.2 196.3 26.3 c\r196.2 26.5 196.1 26.6 195.9 26.6 c\r195.7 26.7 195.5 26.7 195.1 26.7 c\rh\rf*\rn\r466.4 21.9 m\r466.3 21.2 466.0 20.7 465.6 20.4 c\r465.3 20.0 464.8 19.9 464.4 19.9 c\r463.8 19.9 463.3 20.1 462.9 20.5 c\r462.5 21.0 462.3 21.6 462.3 22.4 c\r462.3 23.1 462.6 23.8 463.0 24.2 c\r463.4 24.7 464.0 24.9 464.6 24.9 c\r465.1 24.9 465.4 24.8 465.7 24.6 c\r466.0 24.3 466.2 24.0 466.2 23.8 c\r466.2 23.6 466.2 23.5 466.1 23.5 c\r466.0 23.4 465.9 23.3 465.7 23.3 c\r465.5 23.3 465.4 23.4 465.3 23.5 c\r465.2 23.6 465.2 23.7 465.1 24.0 c\r465.1 24.2 465.1 24.3 464.9 24.4 c\r464.8 24.5 464.7 24.6 464.4 24.6 c\r464.1 24.6 463.8 24.5 463.6 24.2 c\r463.3 23.9 463.2 23.4 463.2 22.9 c\r463.2 22.3 463.3 21.8 463.6 21.4 c\r463.9 20.9 464.3 20.7 464.8 20.7 c\r465.1 20.7 465.4 20.8 465.7 21.0 c\r465.9 21.2 466.1 21.5 466.3 21.9 c\rh\rf*\rn\r468.3 24.0 m\r468.9 24.6 469.4 24.9 469.9 24.9 c\r470.2 24.9 470.4 24.9 470.6 24.7 c\r470.8 24.6 471.0 24.4 471.1 24.1 c\r471.2 23.9 471.2 23.5 471.2 23.1 c\r471.2 21.1 l\r471.2 20.7 471.2 20.5 471.3 20.4 c\r471.3 20.3 471.4 20.3 471.5 20.2 c\r471.5 20.2 471.7 20.1 471.9 20.1 c\r471.9 20.0 l\r469.6 20.0 l\r469.6 20.1 l\r469.7 20.1 l\r469.9 20.1 470.0 20.2 470.1 20.2 c\r470.2 20.3 470.3 20.4 470.3 20.6 c\r470.3 20.6 470.3 20.8 470.3 21.1 c\r470.3 23.1 l\r470.3 23.5 470.3 23.8 470.2 24.0 c\r470.0 24.2 469.9 24.3 469.6 24.3 c\r469.2 24.3 468.7 24.1 468.3 23.6 c\r468.3 21.1 l\r468.3 20.7 468.3 20.5 468.4 20.4 c\r468.4 20.3 468.5 20.3 468.6 20.2 c\r468.7 20.2 468.8 20.1 469.1 20.1 c\r469.1 20.0 l\r466.7 20.0 l\r466.7 20.1 l\r466.8 20.1 l\r467.1 20.1 467.3 20.2 467.3 20.3 c\r467.4 20.5 467.5 20.7 467.5 21.1 c\r467.5 22.9 l\r467.5 23.5 467.5 23.8 467.4 24.0 c\r467.4 24.1 467.4 24.2 467.3 24.2 c\r467.3 24.2 467.2 24.3 467.1 24.3 c\r467.0 24.3 466.9 24.2 466.7 24.2 c\r466.7 24.3 l\r468.1 24.9 l\r468.3 24.9 l\rh\rf*\rn\r363.0 24.9 m\r363.0 23.9 l\r363.4 24.6 363.8 24.9 364.2 24.9 c\r364.4 24.9 364.6 24.9 364.7 24.8 c\r364.8 24.6 364.9 24.5 364.9 24.3 c\r364.9 24.2 364.8 24.1 364.7 24.0 c\r364.7 23.9 364.6 23.9 364.4 23.9 c\r364.3 23.9 364.2 23.9 364.0 24.0 c\r363.9 24.1 363.8 24.2 363.7 24.2 c\r363.6 24.2 363.6 24.2 363.5 24.1 c\r363.3 24.0 363.2 23.7 363.0 23.4 c\r363.0 21.1 l\r363.0 20.8 363.0 20.6 363.1 20.5 c\r363.1 20.4 363.2 20.3 363.3 20.3 c\r363.5 20.2 363.6 20.1 363.9 20.1 c\r363.9 20.0 l\r361.4 20.0 l\r361.4 20.1 l\r361.6 20.1 361.8 20.2 361.9 20.3 c\r362.0 20.3 362.1 20.4 362.1 20.5 c\r362.1 20.6 362.1 20.8 362.1 21.1 c\r362.1 22.9 l\r362.1 23.5 362.1 23.8 362.1 24.0 c\r362.1 24.1 362.0 24.1 362.0 24.2 c\r361.9 24.2 361.8 24.3 361.7 24.3 c\r361.6 24.3 361.5 24.2 361.4 24.2 c\r361.3 24.3 l\r362.8 24.9 l\rh\rf*\rn\r478.9 27.4 m\r479.0 27.4 479.1 27.3 479.2 27.2 c\r479.3 27.1 479.4 27.0 479.4 26.9 c\r479.4 26.7 479.3 26.6 479.2 26.5 c\r479.1 26.4 479.0 26.3 478.9 26.3 c\r478.7 26.3 478.6 26.4 478.5 26.5 c\r478.4 26.6 478.3 26.7 478.3 26.9 c\r478.3 27.0 478.4 27.1 478.5 27.2 c\r478.6 27.3 478.7 27.4 478.9 27.4 c\r479.3 24.9 m\r479.3 21.1 l\r479.3 20.8 479.4 20.5 479.4 20.4 c\r479.4 20.3 479.5 20.3 479.6 20.2 c\r479.7 20.2 479.8 20.1 480.1 20.1 c\r480.1 20.0 l\r477.7 20.0 l\r477.7 20.1 l\r478.0 20.1 478.1 20.2 478.2 20.2 c\r478.3 20.3 478.3 20.3 478.4 20.4 c\r478.4 20.5 478.5 20.8 478.5 21.1 c\r478.5 22.9 l\r478.5 23.5 478.4 23.8 478.4 24.0 c\r478.4 24.1 478.4 24.2 478.3 24.2 c\r478.3 24.2 478.2 24.3 478.1 24.3 c\r478.0 24.3 477.9 24.2 477.7 24.2 c\r477.7 24.3 l\r479.1 24.9 l\rh\rf*\rn\rf*\rn\r336.1 24.9 m\r336.1 23.9 l\r336.5 24.6 336.9 24.9 337.3 24.9 c\r337.5 24.9 337.7 24.9 337.8 24.8 c\r337.9 24.6 338.0 24.5 338.0 24.3 c\r338.0 24.2 338.0 24.1 337.9 24.0 c\r337.8 23.9 337.7 23.9 337.6 23.9 c\r337.5 23.9 337.3 23.9 337.2 24.0 c\r337.0 24.1 336.9 24.2 336.8 24.2 c\r336.8 24.2 336.7 24.2 336.6 24.1 c\r336.5 24.0 336.3 23.7 336.1 23.4 c\r336.1 21.1 l\r336.1 20.8 336.2 20.6 336.2 20.5 c\r336.3 20.4 336.4 20.3 336.5 20.3 c\r336.6 20.2 336.8 20.1 337.0 20.1 c\r337.0 20.0 l\r334.5 20.0 l\r334.5 20.1 l\r334.8 20.1 334.9 20.2 335.1 20.3 c\r335.1 20.3 335.2 20.4 335.2 20.5 c\r335.3 20.6 335.3 20.8 335.3 21.1 c\r335.3 22.9 l\r335.3 23.5 335.3 23.8 335.2 24.0 c\r335.2 24.1 335.2 24.1 335.1 24.2 c\r335.0 24.2 335.0 24.3 334.9 24.3 c\r334.8 24.3 334.7 24.2 334.5 24.2 c\r334.5 24.3 l\r335.9 24.9 l\rh\rf*\rn\r489.4 23.0 m\r489.4 22.3 489.6 21.7 489.9 21.3 c\r490.3 20.9 490.7 20.7 491.2 20.7 c\r491.5 20.7 491.8 20.8 492.0 21.0 c\r492.2 21.1 492.4 21.4 492.6 21.9 c\r492.7 21.8 l\r492.7 21.3 492.4 20.8 492.1 20.4 c\r491.7 20.1 491.3 19.9 490.8 19.9 c\r490.2 19.9 489.7 20.1 489.3 20.5 c\r488.9 21.0 488.7 21.6 488.7 22.3 c\r488.7 23.1 488.9 23.8 489.3 24.2 c\r489.7 24.7 490.2 24.9 490.9 24.9 c\r491.4 24.9 491.9 24.8 492.2 24.4 c\r492.6 24.1 492.7 23.6 492.7 23.0 c\rh\r489.4 23.3 m\r491.7 23.3 l\r491.6 23.6 491.6 23.8 491.5 24.0 c\r491.5 24.2 491.3 24.3 491.2 24.4 c\r491.0 24.5 490.8 24.6 490.6 24.6 c\r490.3 24.6 490.0 24.5 489.8 24.3 c\r489.6 24.0 489.4 23.7 489.4 23.3 c\rf*\rn\r339.5 27.4 m\r339.7 27.4 339.8 27.3 339.9 27.2 c\r340.0 27.1 340.1 27.0 340.1 26.9 c\r340.1 26.7 340.0 26.6 339.9 26.5 c\r339.8 26.4 339.7 26.3 339.5 26.3 c\r339.4 26.3 339.3 26.4 339.2 26.5 c\r339.1 26.6 339.0 26.7 339.0 26.9 c\r339.0 27.0 339.1 27.1 339.2 27.2 c\r339.3 27.3 339.4 27.4 339.5 27.4 c\r340.0 24.9 m\r340.0 21.1 l\r340.0 20.8 340.0 20.5 340.1 20.4 c\r340.1 20.3 340.2 20.3 340.3 20.2 c\r340.3 20.2 340.5 20.1 340.7 20.1 c\r340.7 20.0 l\r338.4 20.0 l\r338.4 20.1 l\r338.6 20.1 338.8 20.2 338.9 20.2 c\r339.0 20.3 339.0 20.3 339.1 20.4 c\r339.1 20.5 339.1 20.8 339.1 21.1 c\r339.1 22.9 l\r339.1 23.5 339.1 23.8 339.1 24.0 c\r339.1 24.1 339.0 24.2 339.0 24.2 c\r338.9 24.2 338.8 24.3 338.8 24.3 c\r338.7 24.3 338.5 24.2 338.4 24.2 c\r338.3 24.3 l\r339.8 24.9 l\rh\rf*\rQ\x00'''
    ,b'')
    new_steam, flag = del_waterMark_interface(stream, {'removeCurve_xcc':[para1,para2]})
    return new_steam, flag

def del_cnki_waterMark(stream):
    stream, flag = del_waterMark_cnki_flow_1(stream)
    stream, flag = del_waterMark_cnki_flow_2(stream)
    stream, flag = del_waterMark_cnki_flow_3(stream)
    return stream



if __name__=="__main__":
    stream = requests.get("https://xcc2.oss-cn-shenzhen.aliyuncs.com/paper/Paper_pdf/2394ef545bd53c31533c0a036e295cc2baaec9da.pdf").content
    stream = del_cnki_waterMark(stream)
    with open("demo.pdf",'wb') as f:
        f.write(stream)