# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['cognitivefactory',
 'cognitivefactory.interactive_clustering',
 'cognitivefactory.interactive_clustering.clustering',
 'cognitivefactory.interactive_clustering.constraints',
 'cognitivefactory.interactive_clustering.sampling',
 'cognitivefactory.interactive_clustering.utils']

package_data = \
{'': ['*']}

install_requires = \
['cvxopt>=1.2,<2.0',
 'numpy>=1.19.4,<2.0.0',
 'scikit-learn>=0.24.1,<0.25.0',
 'scipy>=1.5.3,<2.0.0',
 'spacy>=2.3,<3.0,!=2.3.6']

setup_kwargs = {
    'name': 'cognitivefactory-interactive-clustering',
    'version': '0.1.2',
    'description': 'Python package used to apply NLP interactive clustering methods.',
    'long_description': '# Interactive Clustering\n\n[![ci](https://github.com/cognitivefactory/interactive-clustering/workflows/ci/badge.svg)](https://github.com/cognitivefactory/interactive-clustering/actions?query=workflow%3Aci)\n[![documentation](https://img.shields.io/badge/docs-mkdocs%20material-blue.svg?style=flat)](https://cognitivefactory.github.io/interactive-clustering/)\n[![pypi version](https://img.shields.io/pypi/v/cognitivefactory-interactive-clustering.svg)](https://pypi.org/project/cognitivefactory-interactive-clustering/)\n\nPython package used to apply NLP interactive clustering methods.\n\n## <a name="Description"></a> Quick description\n\n_Interactive clustering_ is a method intended to assist in the design of a training data set.\n\nThis iterative process begins with an unlabeled dataset, and it uses a sequence of two substeps :\n\n1. the user defines constraints on the data ;\n\n2. the machine performs data partitioning using a constrained clustering algorithm.\n\nThus, at each step of the process :\n\n- the user corrects the clustering of the previous steps using constraints, and\n\n- the machine offers a corrected and more relevant data partitioning for the next step.\n\nThe process use severals objects :\n\n- a _constraints manager_ : its role is to manage the constraints annotated by the user and to feed back the information deduced (such as the transitivity between constraints or the situation of inconsistency) ;\n\n- a _constraints sampler_ : its role is to select the most relevant data during the annotation of constraints by the user ;\n\n- a _constrained clustering algorithm_ : its role is to partition the data while respecting the constraints provided by the user.\n\n_NB_ :\n\n- This python library does not contain integration into a graphic interface.\n\n- For more details, read the [Documentation](#Documentation) and the articles in the [References](#References) section.\n\n## <a name="Documentation"></a> Documentation\n\n- [Main documentation](https://cognitivefactory.github.io/interactive-clustering/)\n\n## <a name="Requirements"></a> Requirements\n\nInteractive Clustering requires Python 3.6 or above.\n\n<details>\n<summary>To install Python 3.6, I recommend using <a href="https://github.com/pyenv/pyenv"><code>pyenv</code></a>.</summary>\n\n```bash\n# install pyenv\ngit clone https://github.com/pyenv/pyenv ~/.pyenv\n\n# setup pyenv (you should also put these three lines in .bashrc or similar)\nexport PATH="${HOME}/.pyenv/bin:${PATH}"\nexport PYENV_ROOT="${HOME}/.pyenv"\neval "$(pyenv init -)"\n\n# install Python 3.6\npyenv install 3.6.12\n\n# make it available globally\npyenv global system 3.6.12\n```\n</details>\n\n## <a name="Installation"></a> Installation\n\nWith `pip`:\n```bash\n# install package\npython3 -m pip install cognitivefactory-interactive-clustering\n\n# install spacy language model dependencies (the one you want, with version "^2.3")\npython3 -m spacy download fr_core_news_sm-2.3.0 --direct\n```\n\nWith [`pipx`](https://github.com/pipxproject/pipx):\n```bash\n# install pipx\npython3 -m pip install --user pipx\n\n# install package\npipx install --python python3 cognitivefactory-interactive-clustering\n\n# install spacy language model dependencies (the one you want, with version "^2.3")\npython3 -m spacy download fr_core_news_sm-2.3.0 --direct\n```\n\n_NB_ : Other spaCy language models can be downloaded here : [spaCy - Models & Languages](https://spacy.io/usage/models). Use spacy version `"^2.3"`.\n\n## <a name="Development"></a> Development\n\nTo work on this project or contribute to it, please read\n[the Copier Poetry documentation](https://pawamoy.github.io/copier-poetry/).\n\n### Quick setup and help\n\nGet the code and prepare the environment:\n\n```bash\ngit clone https://github.com/cognitivefactory/interactive-clustering/\ncd interactive-clustering\nmake setup\n```\n\nShow the help:\n\n```bash\nmake help  # or just make\n```\n\n## <a name="References"></a> References\n\n- **Interactive Clustering**:\n    - Theory and Implementation: `Erwan Schild, Gautier Durantin, Jean-Charles Lamirel, Florian Miconi. Conception itérative et semi-supervisée d\'assistants conversationnels par regroupement interactif des questions. EGC 2021 - 21èmes Journées Francophones Extraction et Gestion des Connaissances, Association EGC, Jan 2021, Montpellier / Virtual, France. ⟨hal-03133007⟩`\n    - Methodological instructions: `Erwan Schild, Gautier Durantin, Jean-Charles Lamirel. Concevoir un assistant conversationnel de manière itérative et semi-supervisée avec le clustering interactif. Atelier - Fouille de Textes - Text Mine 2021 - En conjonction avec EGC 2021, Association EGC, Jan 2021, Montpellier / Virtual, France. ⟨hal-03133060⟩`\n\n- **Constraints and Constrained Clustering**:\n    - Constraints in clustering: `Wagstaff, K. et C. Cardie (2000). Clustering with Instance-level Constraints. Proceedings of the Seventeenth International Conference on Machine Learning, 1103–1110.`\n    - Survey on Constrained Clustering: `Lampert, T., T.-B.-H. Dao, B. Lafabregue, N. Serrette, G. Forestier, B. Cremilleux, C. Vrain, et P. Gancarski (2018). Constrained distance based clustering for time-series : a comparative and experimental study. Data Mining and Knowledge Discovery 32(6), 1663–1707.`\n    - KMeans Clustering:\n        - KMeans Clustering: `MacQueen, J. (1967). Some methods for classification and analysis of multivariate observations. Proceedings of the fifth Berkeley symposium on mathematical statistics and probability 1(14), 281–297.`\n        - Constrained _\'COP\'_ KMeans Clustering: `Wagstaff, K., C. Cardie, S. Rogers, et S. Schroedl (2001). Constrained K-means Clustering with Background Knowledge. International Conference on Machine Learning`\n    - Hierarchical Clustering:\n        - Hierarchical Clustering: `Murtagh, F. et P. Contreras (2012). Algorithms for hierarchical clustering : An overview. Wiley Interdisc. Rew.: Data Mining and Knowledge Discovery 2, 86–97.`\n        - Constrained Hierarchical Clustering: `Davidson, I. et S. S. Ravi (2005). Agglomerative Hierarchical Clustering with Constraints : Theoretical and Empirical Results. Springer, Berlin, Heidelberg 3721, 12.`\n    - Spectral Clustering:\n        - Spectral Clustering: `Ng, A. Y., M. I. Jordan, et Y.Weiss (2002). On Spectral Clustering: Analysis and an algorithm. In T. G. Dietterich, S. Becker, et Z. Ghahramani (Eds.), Advances in Neural Information Processing Systems 14. MIT Press.`\n        - Constrained _\'SPEC\'_ Spectral Clustering: `Kamvar, S. D., D. Klein, et C. D. Manning (2003). Spectral Learning. Proceedings of the international joint conference on artificial intelligence, 561–566.`\n\n- **Preprocessing and Vectorization**:\n    - _spaCy_: `Honnibal, M. et I. Montani (2017). spaCy 2 : Natural language understanding with Bloom embeddings, convolutional neural networks and incremental parsing.`\n        - _spaCy_ language models: `https://spacy.io/usage/models`\n    - _NLTK_: `Bird, Steven, Edward Loper and Ewan Klein (2009), Natural Language Processing with Python. O’Reilly Media Inc.`\n        - _NLTK_ _\'SnowballStemmer\'_: `https://www.nltk.org/api/nltk.stem.html#module-nltk.stem.snowball`\n    - _Scikit-learn_: `Pedregosa, F., G. Varoquaux, A. Gramfort, V. Michel, B. Thirion, O. Grisel, M. Blondel, P. Prettenhofer, R.Weiss, V. Dubourg, J. Vanderplas, A. Passos, D. Cournapeau, M. Brucher, M. Perrot, et E. Duchesnay (2011). Scikit-learn : Machine Learning in Python. Journal of Machine Learning Research 12, 2825–2830.`\n        - _Scikit-learn_ _\'TfidfVectorizer\'_: `https://scikit-learn.org/stable/modules/generated/sklearn.feature_extraction.text.TfidfVectorizer.html`\n',
    'author': 'Erwan Schild',
    'author_email': 'erwan.schild@e-i.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cognitivefactory/interactive-clustering',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
