# coding: utf-8

"""
    configapi

    Config API lets you easily manage configuration at scale.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudmersive_configuration_api_client.models.http_form_data_parameter import HttpFormDataParameter  # noqa: F401,E501
from cloudmersive_configuration_api_client.models.http_get_parameter import HttpGetParameter  # noqa: F401,E501
from cloudmersive_configuration_api_client.models.http_orchestration_header import HttpOrchestrationHeader  # noqa: F401,E501
from cloudmersive_configuration_api_client.models.http_raw_binary_parameter import HttpRawBinaryParameter  # noqa: F401,E501
from cloudmersive_configuration_api_client.models.http_raw_text_parameter import HttpRawTextParameter  # noqa: F401,E501
from cloudmersive_configuration_api_client.models.http_www_form_url_encoded_parameter import HttpWwwFormUrlEncodedParameter  # noqa: F401,E501


class HttpOrchestrationTask(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'task_name': 'str',
        'http_method': 'str',
        'url': 'str',
        'http_headers': 'list[HttpOrchestrationHeader]',
        'query_parameters': 'list[HttpGetParameter]',
        'form_data_parameters': 'list[HttpFormDataParameter]',
        'www_form_url_encoded_parameters': 'list[HttpWwwFormUrlEncodedParameter]',
        'raw_text_body': 'HttpRawTextParameter',
        'raw_binary_body': 'HttpRawBinaryParameter'
    }

    attribute_map = {
        'task_name': 'TaskName',
        'http_method': 'HttpMethod',
        'url': 'URL',
        'http_headers': 'HttpHeaders',
        'query_parameters': 'QueryParameters',
        'form_data_parameters': 'FormDataParameters',
        'www_form_url_encoded_parameters': 'WwwFormUrlEncodedParameters',
        'raw_text_body': 'RawTextBody',
        'raw_binary_body': 'RawBinaryBody'
    }

    def __init__(self, task_name=None, http_method=None, url=None, http_headers=None, query_parameters=None, form_data_parameters=None, www_form_url_encoded_parameters=None, raw_text_body=None, raw_binary_body=None):  # noqa: E501
        """HttpOrchestrationTask - a model defined in Swagger"""  # noqa: E501

        self._task_name = None
        self._http_method = None
        self._url = None
        self._http_headers = None
        self._query_parameters = None
        self._form_data_parameters = None
        self._www_form_url_encoded_parameters = None
        self._raw_text_body = None
        self._raw_binary_body = None
        self.discriminator = None

        if task_name is not None:
            self.task_name = task_name
        if http_method is not None:
            self.http_method = http_method
        if url is not None:
            self.url = url
        if http_headers is not None:
            self.http_headers = http_headers
        if query_parameters is not None:
            self.query_parameters = query_parameters
        if form_data_parameters is not None:
            self.form_data_parameters = form_data_parameters
        if www_form_url_encoded_parameters is not None:
            self.www_form_url_encoded_parameters = www_form_url_encoded_parameters
        if raw_text_body is not None:
            self.raw_text_body = raw_text_body
        if raw_binary_body is not None:
            self.raw_binary_body = raw_binary_body

    @property
    def task_name(self):
        """Gets the task_name of this HttpOrchestrationTask.  # noqa: E501

        An identifier for this task name, e.g. CreateCustomer or ScanForVirus; allows you to refer to this task from other tasks; if not supplied, it will default to a 0-based integer index of the task  # noqa: E501

        :return: The task_name of this HttpOrchestrationTask.  # noqa: E501
        :rtype: str
        """
        return self._task_name

    @task_name.setter
    def task_name(self, task_name):
        """Sets the task_name of this HttpOrchestrationTask.

        An identifier for this task name, e.g. CreateCustomer or ScanForVirus; allows you to refer to this task from other tasks; if not supplied, it will default to a 0-based integer index of the task  # noqa: E501

        :param task_name: The task_name of this HttpOrchestrationTask.  # noqa: E501
        :type: str
        """

        self._task_name = task_name

    @property
    def http_method(self):
        """Gets the http_method of this HttpOrchestrationTask.  # noqa: E501

        HTTP Method, e.g. GET, PUT, POST, etc.  # noqa: E501

        :return: The http_method of this HttpOrchestrationTask.  # noqa: E501
        :rtype: str
        """
        return self._http_method

    @http_method.setter
    def http_method(self, http_method):
        """Sets the http_method of this HttpOrchestrationTask.

        HTTP Method, e.g. GET, PUT, POST, etc.  # noqa: E501

        :param http_method: The http_method of this HttpOrchestrationTask.  # noqa: E501
        :type: str
        """

        self._http_method = http_method

    @property
    def url(self):
        """Gets the url of this HttpOrchestrationTask.  # noqa: E501

        HTTP URL to orchestrate  # noqa: E501

        :return: The url of this HttpOrchestrationTask.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this HttpOrchestrationTask.

        HTTP URL to orchestrate  # noqa: E501

        :param url: The url of this HttpOrchestrationTask.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def http_headers(self):
        """Gets the http_headers of this HttpOrchestrationTask.  # noqa: E501

        Optional; HTTP headers to apply to the request  # noqa: E501

        :return: The http_headers of this HttpOrchestrationTask.  # noqa: E501
        :rtype: list[HttpOrchestrationHeader]
        """
        return self._http_headers

    @http_headers.setter
    def http_headers(self, http_headers):
        """Sets the http_headers of this HttpOrchestrationTask.

        Optional; HTTP headers to apply to the request  # noqa: E501

        :param http_headers: The http_headers of this HttpOrchestrationTask.  # noqa: E501
        :type: list[HttpOrchestrationHeader]
        """

        self._http_headers = http_headers

    @property
    def query_parameters(self):
        """Gets the query_parameters of this HttpOrchestrationTask.  # noqa: E501

        Optional; query parameters, these query parameters will be incorporated into the URL  # noqa: E501

        :return: The query_parameters of this HttpOrchestrationTask.  # noqa: E501
        :rtype: list[HttpGetParameter]
        """
        return self._query_parameters

    @query_parameters.setter
    def query_parameters(self, query_parameters):
        """Sets the query_parameters of this HttpOrchestrationTask.

        Optional; query parameters, these query parameters will be incorporated into the URL  # noqa: E501

        :param query_parameters: The query_parameters of this HttpOrchestrationTask.  # noqa: E501
        :type: list[HttpGetParameter]
        """

        self._query_parameters = query_parameters

    @property
    def form_data_parameters(self):
        """Gets the form_data_parameters of this HttpOrchestrationTask.  # noqa: E501

        Optional; FormData parameters, these parameters will be stored in the body in a multi-part encoding  # noqa: E501

        :return: The form_data_parameters of this HttpOrchestrationTask.  # noqa: E501
        :rtype: list[HttpFormDataParameter]
        """
        return self._form_data_parameters

    @form_data_parameters.setter
    def form_data_parameters(self, form_data_parameters):
        """Sets the form_data_parameters of this HttpOrchestrationTask.

        Optional; FormData parameters, these parameters will be stored in the body in a multi-part encoding  # noqa: E501

        :param form_data_parameters: The form_data_parameters of this HttpOrchestrationTask.  # noqa: E501
        :type: list[HttpFormDataParameter]
        """

        self._form_data_parameters = form_data_parameters

    @property
    def www_form_url_encoded_parameters(self):
        """Gets the www_form_url_encoded_parameters of this HttpOrchestrationTask.  # noqa: E501

        Optional; x-www-form-urlencoded paramereters, these parameters will be stored in the body as an application/x-www-form-urlencoded encoding  # noqa: E501

        :return: The www_form_url_encoded_parameters of this HttpOrchestrationTask.  # noqa: E501
        :rtype: list[HttpWwwFormUrlEncodedParameter]
        """
        return self._www_form_url_encoded_parameters

    @www_form_url_encoded_parameters.setter
    def www_form_url_encoded_parameters(self, www_form_url_encoded_parameters):
        """Sets the www_form_url_encoded_parameters of this HttpOrchestrationTask.

        Optional; x-www-form-urlencoded paramereters, these parameters will be stored in the body as an application/x-www-form-urlencoded encoding  # noqa: E501

        :param www_form_url_encoded_parameters: The www_form_url_encoded_parameters of this HttpOrchestrationTask.  # noqa: E501
        :type: list[HttpWwwFormUrlEncodedParameter]
        """

        self._www_form_url_encoded_parameters = www_form_url_encoded_parameters

    @property
    def raw_text_body(self):
        """Gets the raw_text_body of this HttpOrchestrationTask.  # noqa: E501

        Optional; sets the body of the request as raw text, cannot be used with other parameter types in the same request  # noqa: E501

        :return: The raw_text_body of this HttpOrchestrationTask.  # noqa: E501
        :rtype: HttpRawTextParameter
        """
        return self._raw_text_body

    @raw_text_body.setter
    def raw_text_body(self, raw_text_body):
        """Sets the raw_text_body of this HttpOrchestrationTask.

        Optional; sets the body of the request as raw text, cannot be used with other parameter types in the same request  # noqa: E501

        :param raw_text_body: The raw_text_body of this HttpOrchestrationTask.  # noqa: E501
        :type: HttpRawTextParameter
        """

        self._raw_text_body = raw_text_body

    @property
    def raw_binary_body(self):
        """Gets the raw_binary_body of this HttpOrchestrationTask.  # noqa: E501

        Optional; set the body of the request as binary, cannot be used with other parameter types in the same request  # noqa: E501

        :return: The raw_binary_body of this HttpOrchestrationTask.  # noqa: E501
        :rtype: HttpRawBinaryParameter
        """
        return self._raw_binary_body

    @raw_binary_body.setter
    def raw_binary_body(self, raw_binary_body):
        """Sets the raw_binary_body of this HttpOrchestrationTask.

        Optional; set the body of the request as binary, cannot be used with other parameter types in the same request  # noqa: E501

        :param raw_binary_body: The raw_binary_body of this HttpOrchestrationTask.  # noqa: E501
        :type: HttpRawBinaryParameter
        """

        self._raw_binary_body = raw_binary_body

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HttpOrchestrationTask, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HttpOrchestrationTask):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
