# -*- coding: utf-8 -*-
from collective.collectionfilter import _
from collective.collectionfilter.baseviews import BaseMapsView
from collective.collectionfilter.interfaces import ICollectionMapsSchema
from collective.collectionfilter.portlets import BasePortletRenderer
from plone.app.portlets.portlets import base
from plone.formwidget.geolocation.vocabularies import default_map_layer
from plone.formwidget.geolocation.vocabularies import default_map_layers
from plone.portlets.interfaces import IPortletDataProvider
from Products.Five.browser.pagetemplatefile import ViewPageTemplateFile
from zope.interface import implementer


class ICollectionMapsPortlet(ICollectionMapsSchema, IPortletDataProvider):
    """Portlet interface based on ICollectionMapsSchema"""


@implementer(ICollectionMapsPortlet)
class Assignment(base.Assignment):

    header = ""
    target_collection = None
    view_name = None
    content_selector = "#content-core"
    narrow_down = False
    default_map_layer = default_map_layer
    map_layers = default_map_layers

    def __init__(
        self,
        header="",
        target_collection=None,
        view_name=None,
        content_selector="#content-core",
        narrow_down=False,
        default_map_layer=default_map_layer,
        map_layers=default_map_layers,
    ):
        self.header = header
        self.target_collection = target_collection
        self.view_name = view_name
        self.content_selector = content_selector
        self.narrow_down = narrow_down
        self.default_map_layers = default_map_layers
        self.map_layers = map_layers

    @property
    def title(self):
        if self.header:
            return self.header
        else:
            return _("Collection Maps")


class Renderer(BasePortletRenderer, BaseMapsView):
    render = ViewPageTemplateFile("maps.pt")


class AddForm(base.AddForm):

    schema = ICollectionMapsPortlet
    label = _("Add Collection Maps Portlet")
    description = _("This portlet allows map filtering in collection results.")

    def create(self, data):
        return Assignment(**data)


class EditForm(base.EditForm):

    schema = ICollectionMapsPortlet
    label = _("Edit Collection Maps Portlet")
    description = _("This portlet allows map filtering in collection results.")
