'use strict';
angular.module('mopify.account.services.spotify', [
  'spotify',
  'mopify.services.servicemanager',
  'mopify.services.spotifylogin',
  'mopify.services.settings',
  'toggle-switch'
]).config([
  '$routeProvider',
  function ($routeProvider) {
    $routeProvider.when('/account/services/spotify', {
      templateUrl: 'account/services/spotify/spotify.tmpl.html',
      controller: 'SpotifyServiceController'
    });
  }
]).controller('SpotifyServiceController', [
  '$scope',
  '$location',
  'ServiceManager',
  'Settings',
  'Spotify',
  'SpotifyLogin',
  function SpotifyServiceController($scope, $location, ServiceManager, Settings, Spotify, SpotifyLogin) {
    if (!ServiceManager.isEnabled('spotify')) {
      $location.path('/account/services');
      return;
    }
    // Bind settings to the scope
    Settings.bind($scope);
    // Get current user
    Spotify.getCurrentUser().then(function (response) {
      $scope.profile = response.data;
    });
    /**
     * Disconnect and connect with Spotify
     * @return {[type]} [description]
     */
    $scope.reconnect = function () {
      SpotifyLogin.disconnect();
      SpotifyLogin.login();
    };
  }
]).controller('SpotifyMenuController', [
  '$q',
  '$scope',
  'Spotify',
  'SpotifyLogin',
  function SpotifyMenuController($q, $scope, Spotify, SpotifyLogin) {
    // Set some scope vars
    $scope.userProfile = {};
    $scope.authorized = false;
    // Check if we are logged in
    SpotifyLogin.getLoginStatus().then(function (data) {
      if (data.status == 'connected') {
        collectdata();
      } else {
        SpotifyLogin.login().then(function () {
          collectdata();
        });
      }
    });
    // Get the user porfile from Spotify
    function collectdata() {
      // Make the call
      Spotify.getCurrentUser().then(function (response) {
        $scope.authorized = true;
        $scope.userProfile = response.data;
      });
    }
    $scope.$on('mopify:services:disconnected', function (e, service) {
      if (service.name == 'Spotify') {
        SpotifyLogin.disconnect();
      }
    });
    /**
     * Collect user data on spotify:connected message
     */
    $scope.$on('mopify:spotify:connected', function () {
      collectdata();
    });
  }
]);