#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['usim',
 'usim._basics',
 'usim._concurrent',
 'usim._core',
 'usim._primitives',
 'usim.py',
 'usim.py.resources']

package_data = \
{'': ['*']}

install_requires = \
['sortedcontainers', 'asyncstdlib>=1.1.1', 'typing_extensions>=3.10.0']

extras_require = \
{'doc': ['sphinx',
         'sphinx_rtd_theme',
         'sphinxcontrib-contentui',
         'sphinxcontrib-trio'],
 'test': ['pytest >=4.3.0', 'flake8', 'flake8-bugbear'],
 "test:implementation_name=='cpython'": ['black']}

setup(name='usim',
      version='0.4.4',
      description='Lightweight Simulation Framework',
      author='Eileen Kuehn, Max Fischer',
      author_email='mainekuehn@gmail.com',
      url='https://github.com/MaineKuehn/usim',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
     )
