# Keepassxc-cli WRAPPER

Create a wrapper around **keepassxc-cli open** command and keep it open without need of keep the terminal open. 
It allows you to access any password (or other attributes) from database in **terminal** or **scripts** without 
need of providing the password to the database again.

## install
I strongly recommend use of **pipx** to install keepassxc-cli.
```shell
pipx install keepassxcli-wrapper
```
Eventually you can install it by yourself in global 
```shell
pip install keepassxcli-wrapper
```
or better in some virtualenv, for example like this:
```shell
python -m venv ~/.keepassxcli-wrapper
.keepassxcli-wrapper/bin/pip install .keepassxcli-wrapper
echo "alias kpowg=~/.keepassxcli-wrapper/bin/kpowg" >> .bashrc
echo "alias kpowr=~/.keepassxcli-wrapper/bin/kpowr" >> .bashrc
```

## How it works
When you ask for a password for some entry in keepassxc db and the db is not open yet, you will be prompted for 
the keepassxc database password. It will start a server in a background with opened **keepassxcli open** session.
If you ask for some entry's password again, you get the password from the existing server. The connection with the server
is maintained with a file sockets. This limits usage for linux and OSX. **One socket file can have only one 
database**.

```bash
# server is not running
> ps -x | grep keepasxcli_wrapper/server.py | grep -v grep | wc -l 
  0
# first time usage trigger prompt for database file and password
> kpowr ls
Open database: path/to/db.kdbx
Password:
gmail
facebook
# server is running now in background
> ps -x | grep keepasxcli_wrapper/server.py | grep -v grep | wc -l 
  1
# no password is required
> kpowr ls
gmail
facebook
> kpowg facebook
password for entry facebook has been clipped
# quiting server
> kpowr quit
> ps -x | grep keepasxcli_wrapper/server.py | grep -v grep | wc -l 
  0
# open db again
> kpowr ls
Open database:
```

## Examples
There are two scripts. Both can open db. **kpowg** *(KeePassxc Open Wrapper Get)* is for accessing entry's attributes. 
**kpowr** *(KeePassxc Open Run) is for run command on original **keepassc-cli open** session.
### kpowg
Either **clip** or **print** the **attributes** for the entries. 

clip the **password** for gmail in the db (gmail is the title of entry)
```shell
> kpowg gmail
password for entry facebook has been clipped
```
clip the **username** for gmail
```shell
> kpowg gmail username
username for entry entry1 has been clipped
```
**(-s/--show)** print the **username** (it is printed without new line at the end)
```shell
> kpowg --show gmail username
xyz@gmail.com
```
A partial name let you choose between all the matches.
```shell
> kpowg mail
[1] gmail
[2] yahoo e-mail

Choose entry 1 - 2 (default 1): 2
password for entry yahoo email has been clipped
```
Use **(-np/--no-prompt)** in script to prevent from prompt. If the db is not open it will fail, but it will not
block the rest of script.
``` 
#! /bin/sh
GMAILPASSWORD="$(kpowg -np -s gmail)"
```
**(-wfp/--window-for-password)** will create dialog window for password input. Use for scripts running in 
background. Use in the pair with -np in case of wrong db path configuration.
``` 
#! /bin/sh
GMAILPASSWORD="$(kpowg --wfp -np -s gmail)"
```
### kpowr
This just pass commands to **keepassxcli-cli**.

#### !!! WARNING
**kpowr add --password-prompt** and **kpowr edit --password-prompt** is not yet supported.

#### help
```shell
# show help for kpowr
> kpowr --help
# show help for keepassxc-cli
> kpowr help
# show help for keepassxc-cli add entry
> kpowr help add
```

#### some useful commands
```shell
# add entry gmail-for-work with usernam work@gmail.com and autogenerated password
> kpowr add -g -u work@gmail.com gmail-for-work
# change url for previous password
> kpowr edit --url https://gmail.com gmail-for-work
# move entry to Recycle Bin
> kpowr rm gmail-for-work
```

## Configuration
You are always prompt for db path. You can tell **kpowr** or **kpowg** where the database file exists
via **configuration file** or **ENVIRONMENT VARIABLES**.

### Simple one database only usage
Insert in .bashrc
```shell
export KEEPASSXCCLI2_NONAME_DB=/path/to/db.kdbx
```

### Multiple databases
Multiple databases require multiple entries in config file (or env).
#### File config
Config file can be passed with **(-cf/--config-file)**. ie: ```kpowg -cf path/to/mycfg.ini gmail```. Also looking in 
these files:
- ~/.keepassxccli2.ini
- ~/.config/.keepassxccli2.ini
Result is merged from all founded files, but passed file has priority in case of conflict.
```ini
# default database (if you do not specify (-n/--name) in kpowg/kpowr command
[noname] 
db = /my/persona/db.kdbx
# for noname db is setup default file for socket

# other custom db must contain pid_file for socket communication between kpowg/kpowr and server
[work]
# db is optional, but you will be prompted each time
pid_file = /tmp/work_keepassxc

[work2]
db = /path/to/work2.kdbx
pid_file = /tmp/work2_keepassxc

[work3]
db = /path/to/work3.kdbx
pid_file = /tmp/work3_keepassxc
# path to key file
key_file = /path/to/keyfile
# yubikey slot[:serial]
yubikey = 1:7370001
# for bigger databases could be default (0.3) timeout not enough to read all entries (in seconds)
timeout = 0.5
```
#### ENV
Same config can be achieved with setting ENV. In case of conflict (ENV and config is set for same name) 
the **ENV** has priority. So you can use ENV for override config. Format is **KEEPASSXCCLI2_{{NAME}}_{{ATTR}}**.
```shell
export KEEPASSXCCLI2_NONAME_DB=/my/persona/db.kdbx

export KEEPASSXCCLI2_WORK_PID_FILE=/tmp/work_keepassxc

export KEEPASSXCCLI2_WORK2_DB=/path/to/work2.kdbx
export KEEPASSXCCLI2_WORK2_PID_FILE=/tmp/work2_keepassxc

export KEEPASSXCCLI2_WORK3_DB=/path/to/work3.kdbx
export KEEPASSXCCLI2_WORK3_PID_FILE=/tmp/work3_keepassxc
export KEEPASSXCCLI2_WORK3_KEY_FILE=/path/to/keyfile
export KEEPASSXCCLI2_WORK3_YUBIKEY=1:7370001
export KEEPASSXCCLI2_WORK3_TIMEOUT=0.5
```

#### Example:

```shell
>kpowg facebook
# open /my/persona/db.kdbx from config
Password:
password for facebook has been clipped

>kpowg -n work2 gmail
# open /path/to/work.kdbx from config
Password:
password for entry gmail has been clipped
```

