# This an autogenerated file
# 
# Generated with ExternalProgramNode
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.externalprogramnode import ExternalProgramNodeBlueprint
from typing import Dict
from sima.post.controlsignalinputslot import ControlSignalInputSlot
from sima.post.fileformat import FileFormat
from sima.post.inputslot import InputSlot
from sima.post.runnode import RunNode
from sima.sima.scriptablevalue import ScriptableValue
from sima.workflow.fileinputslot import FileInputSlot
from sima.workflow.fileoutputslot import FileOutputSlot

class ExternalProgramNode(RunNode):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default "")
    x : int
         (default 0)
    y : int
         (default 0)
    h : int
         (default 0)
    w : int
         (default 0)
    controlSignalInputSlots : List[ControlSignalInputSlot]
    executable : str
         Executable to run(default "")
    arguments : str
         Process arguments(default "")
    fileInputSlots : List[FileInputSlot]
    fileOutputSlots : List[FileOutputSlot]
    fileFormat : FileFormat
         file format
    failOnErrorCode : bool
         When checked, the workflow will fail if the external program exits with a non-zero exit code. This is usually the preferred behaviour.(default True)
    addInputFiles : bool
         Add additional input files before running. These will be copied to working directory(default False)
    inputFileSlot : InputSlot
    environmentVariables : str
         Environment variables to set when executing. Separate each variable with a semicolon and path segments with colon.(default "")
    """

    def __init__(self , _id="", name="", x=0, y=0, h=0, w=0, executable="", arguments="", fileFormat=FileFormat.HDF5, failOnErrorCode=True, addInputFiles=False, environmentVariables="", **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.name = name
        self.x = x
        self.y = y
        self.h = h
        self.w = w
        self.controlSignalInputSlots = list()
        self.executable = executable
        self.arguments = arguments
        self.fileInputSlots = list()
        self.fileOutputSlots = list()
        self.fileFormat = fileFormat
        self.failOnErrorCode = failOnErrorCode
        self.addInputFiles = addInputFiles
        self.inputFileSlot = None
        self.environmentVariables = environmentVariables
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ExternalProgramNodeBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def x(self) -> int:
        """"""
        return self.__x

    @x.setter
    def x(self, value: int):
        """Set x"""
        self.__x = int(value)

    @property
    def y(self) -> int:
        """"""
        return self.__y

    @y.setter
    def y(self, value: int):
        """Set y"""
        self.__y = int(value)

    @property
    def h(self) -> int:
        """"""
        return self.__h

    @h.setter
    def h(self, value: int):
        """Set h"""
        self.__h = int(value)

    @property
    def w(self) -> int:
        """"""
        return self.__w

    @w.setter
    def w(self, value: int):
        """Set w"""
        self.__w = int(value)

    @property
    def controlSignalInputSlots(self) -> List[ControlSignalInputSlot]:
        """"""
        return self.__controlSignalInputSlots

    @controlSignalInputSlots.setter
    def controlSignalInputSlots(self, value: List[ControlSignalInputSlot]):
        """Set controlSignalInputSlots"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__controlSignalInputSlots = value

    @property
    def executable(self) -> str:
        """Executable to run"""
        return self.__executable

    @executable.setter
    def executable(self, value: str):
        """Set executable"""
        self.__executable = str(value)

    @property
    def arguments(self) -> str:
        """Process arguments"""
        return self.__arguments

    @arguments.setter
    def arguments(self, value: str):
        """Set arguments"""
        self.__arguments = str(value)

    @property
    def fileInputSlots(self) -> List[FileInputSlot]:
        """"""
        return self.__fileInputSlots

    @fileInputSlots.setter
    def fileInputSlots(self, value: List[FileInputSlot]):
        """Set fileInputSlots"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__fileInputSlots = value

    @property
    def fileOutputSlots(self) -> List[FileOutputSlot]:
        """"""
        return self.__fileOutputSlots

    @fileOutputSlots.setter
    def fileOutputSlots(self, value: List[FileOutputSlot]):
        """Set fileOutputSlots"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__fileOutputSlots = value

    @property
    def fileFormat(self) -> FileFormat:
        """file format"""
        return self.__fileFormat

    @fileFormat.setter
    def fileFormat(self, value: FileFormat):
        """Set fileFormat"""
        self.__fileFormat = value

    @property
    def failOnErrorCode(self) -> bool:
        """When checked, the workflow will fail if the external program exits with a non-zero exit code. This is usually the preferred behaviour."""
        return self.__failOnErrorCode

    @failOnErrorCode.setter
    def failOnErrorCode(self, value: bool):
        """Set failOnErrorCode"""
        self.__failOnErrorCode = bool(value)

    @property
    def addInputFiles(self) -> bool:
        """Add additional input files before running. These will be copied to working directory"""
        return self.__addInputFiles

    @addInputFiles.setter
    def addInputFiles(self, value: bool):
        """Set addInputFiles"""
        self.__addInputFiles = bool(value)

    @property
    def inputFileSlot(self) -> InputSlot:
        """"""
        return self.__inputFileSlot

    @inputFileSlot.setter
    def inputFileSlot(self, value: InputSlot):
        """Set inputFileSlot"""
        self.__inputFileSlot = value

    @property
    def environmentVariables(self) -> str:
        """Environment variables to set when executing. Separate each variable with a semicolon and path segments with colon."""
        return self.__environmentVariables

    @environmentVariables.setter
    def environmentVariables(self, value: str):
        """Set environmentVariables"""
        self.__environmentVariables = str(value)
