# This an autogenerated file
# 
# Generated with SmallBodyHydrodynamicData
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.smallbodyhydrodynamicdata import SmallBodyHydrodynamicDataBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.depthdependency import DepthDependency
from sima.simo.depthdependenthydrodynamiccoefficient import DepthDependenthydrodynamicCoefficient
from sima.simo.soilpenetration import SoilPenetration
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.hydro.diffractedwave import DiffractedWave

class SmallBodyHydrodynamicData(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    svol : float
         Fully submerged volume(default 0.0)
    am1 : float
         Added mass in 1. degree of freedom, fully submerged(default 0.0)
    am2 : float
         Added mass in 2. degree of freedom, fully submerged(default 0.0)
    am3 : float
         Added mass in 3. degree of freedom, fully submerged(default 0.0)
    c11 : float
         Linear drag coefficient in 1. degree of freedom, \nfully submerged(default 0.0)
    c12 : float
         Linear drag coefficient in 2. degree of freedom, \nfully submerged(default 0.0)
    c13 : float
         Linear drag coefficient in 3. degree of freedom, \nfully submerged(default 0.0)
    c21 : float
         Quadratic drag coefficient in 1. degree of freedom,\nfully submerged(default 0.0)
    c22 : float
         Quadratic drag coefficient in 2. degree of freedom,\nfully submerged(default 0.0)
    c23 : float
         Quadratic drag coefficient in 3. degree of freedom,fully submerged(default 0.0)
    zcoef : float
         Vertical position used as reference for depth dependency(default 0.0)
    depthDependency : DepthDependency
         Reference for depth dependency
    depthDependentHydrodynamicCoefficients : List[DepthDependenthydrodynamicCoefficient]
    soilPenetration : SoilPenetration
    diffractedWave : DiffractedWave
    """

    def __init__(self , _id="", svol=0.0, am1=0.0, am2=0.0, am3=0.0, c11=0.0, c12=0.0, c13=0.0, c21=0.0, c22=0.0, c23=0.0, zcoef=0.0, depthDependency=DepthDependency.WAVE_ELEVATION, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.svol = svol
        self.am1 = am1
        self.am2 = am2
        self.am3 = am3
        self.c11 = c11
        self.c12 = c12
        self.c13 = c13
        self.c21 = c21
        self.c22 = c22
        self.c23 = c23
        self.zcoef = zcoef
        self.depthDependency = depthDependency
        self.depthDependentHydrodynamicCoefficients = list()
        self.soilPenetration = None
        self.diffractedWave = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SmallBodyHydrodynamicDataBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def svol(self) -> float:
        """Fully submerged volume"""
        return self.__svol

    @svol.setter
    def svol(self, value: float):
        """Set svol"""
        self.__svol = float(value)

    @property
    def am1(self) -> float:
        """Added mass in 1. degree of freedom, fully submerged"""
        return self.__am1

    @am1.setter
    def am1(self, value: float):
        """Set am1"""
        self.__am1 = float(value)

    @property
    def am2(self) -> float:
        """Added mass in 2. degree of freedom, fully submerged"""
        return self.__am2

    @am2.setter
    def am2(self, value: float):
        """Set am2"""
        self.__am2 = float(value)

    @property
    def am3(self) -> float:
        """Added mass in 3. degree of freedom, fully submerged"""
        return self.__am3

    @am3.setter
    def am3(self, value: float):
        """Set am3"""
        self.__am3 = float(value)

    @property
    def c11(self) -> float:
        """Linear drag coefficient in 1. degree of freedom, 
fully submerged"""
        return self.__c11

    @c11.setter
    def c11(self, value: float):
        """Set c11"""
        self.__c11 = float(value)

    @property
    def c12(self) -> float:
        """Linear drag coefficient in 2. degree of freedom, 
fully submerged"""
        return self.__c12

    @c12.setter
    def c12(self, value: float):
        """Set c12"""
        self.__c12 = float(value)

    @property
    def c13(self) -> float:
        """Linear drag coefficient in 3. degree of freedom, 
fully submerged"""
        return self.__c13

    @c13.setter
    def c13(self, value: float):
        """Set c13"""
        self.__c13 = float(value)

    @property
    def c21(self) -> float:
        """Quadratic drag coefficient in 1. degree of freedom,
fully submerged"""
        return self.__c21

    @c21.setter
    def c21(self, value: float):
        """Set c21"""
        self.__c21 = float(value)

    @property
    def c22(self) -> float:
        """Quadratic drag coefficient in 2. degree of freedom,
fully submerged"""
        return self.__c22

    @c22.setter
    def c22(self, value: float):
        """Set c22"""
        self.__c22 = float(value)

    @property
    def c23(self) -> float:
        """Quadratic drag coefficient in 3. degree of freedom,fully submerged"""
        return self.__c23

    @c23.setter
    def c23(self, value: float):
        """Set c23"""
        self.__c23 = float(value)

    @property
    def zcoef(self) -> float:
        """Vertical position used as reference for depth dependency"""
        return self.__zcoef

    @zcoef.setter
    def zcoef(self, value: float):
        """Set zcoef"""
        self.__zcoef = float(value)

    @property
    def depthDependency(self) -> DepthDependency:
        """Reference for depth dependency"""
        return self.__depthDependency

    @depthDependency.setter
    def depthDependency(self, value: DepthDependency):
        """Set depthDependency"""
        self.__depthDependency = value

    @property
    def depthDependentHydrodynamicCoefficients(self) -> List[DepthDependenthydrodynamicCoefficient]:
        """"""
        return self.__depthDependentHydrodynamicCoefficients

    @depthDependentHydrodynamicCoefficients.setter
    def depthDependentHydrodynamicCoefficients(self, value: List[DepthDependenthydrodynamicCoefficient]):
        """Set depthDependentHydrodynamicCoefficients"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__depthDependentHydrodynamicCoefficients = value

    @property
    def soilPenetration(self) -> SoilPenetration:
        """"""
        return self.__soilPenetration

    @soilPenetration.setter
    def soilPenetration(self, value: SoilPenetration):
        """Set soilPenetration"""
        self.__soilPenetration = value

    @property
    def diffractedWave(self) -> DiffractedWave:
        """"""
        return self.__diffractedWave

    @diffractedWave.setter
    def diffractedWave(self, value: DiffractedWave):
        """Set diffractedWave"""
        self.__diffractedWave = value
