# This an autogenerated file
# 
# Generated with SimpleWireCoupling
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.simplewirecoupling import SimpleWireCouplingBlueprint
from typing import Dict
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.activationfailuremode import ActivationFailureMode
from sima.simo.guidepointspecification import GuidePointSpecification
from sima.simo.simplecoupling import SimpleCoupling
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.simo.simobodypoint import SIMOBodyPoint

class SimpleWireCoupling(SimpleCoupling):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default "")
    endPoint1 : SIMOBodyPoint
    endPoint2 : SIMOBodyPoint
    failureMode : ActivationFailureMode
         Failure mode of coupling element
    failureTime : float
         Earliest possible time of failure(default 0.0)
    breakingStrength : float
         Breaking strength(default 0.0)
    ea : float
         Wire cross section stiffness(default 0.0)
    length : float
         Initial, unstretched wire length(default 0.0)
    damping : float
         Material damping(default 0.0)
    flexibility : float
         Connection flexibility(default 0.0)
    guidePointSpecifications : List[GuidePointSpecification]
    constantTensionControl : bool
         Enable constant tension control for this wire(default True)
    tensionLevel : float
         Desired tension level(default 0.0)
    tensionDeadband : float
         Tension level deadband(default 0.0)
    maxSpeed : float
         Max wire length rate of change(default 0.0)
    activationTime : float
         Activation time for constant tension control(default 0.0)
    deactivationTime : float
         Deactivation time for constant tension control. If value is less then or equal to activation time, controller will remain active throughout simulation(default 0.0)
    """

    def __init__(self , _id="", name="", failureMode=ActivationFailureMode.NONE, failureTime=0.0, breakingStrength=0.0, ea=0.0, length=0.0, damping=0.0, flexibility=0.0, constantTensionControl=True, tensionLevel=0.0, tensionDeadband=0.0, maxSpeed=0.0, activationTime=0.0, deactivationTime=0.0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.name = name
        self.endPoint1 = None
        self.endPoint2 = None
        self.failureMode = failureMode
        self.failureTime = failureTime
        self.breakingStrength = breakingStrength
        self.ea = ea
        self.length = length
        self.damping = damping
        self.flexibility = flexibility
        self.guidePointSpecifications = list()
        self.constantTensionControl = constantTensionControl
        self.tensionLevel = tensionLevel
        self.tensionDeadband = tensionDeadband
        self.maxSpeed = maxSpeed
        self.activationTime = activationTime
        self.deactivationTime = deactivationTime
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SimpleWireCouplingBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def endPoint1(self) -> SIMOBodyPoint:
        """"""
        return self.__endPoint1

    @endPoint1.setter
    def endPoint1(self, value: SIMOBodyPoint):
        """Set endPoint1"""
        self.__endPoint1 = value

    @property
    def endPoint2(self) -> SIMOBodyPoint:
        """"""
        return self.__endPoint2

    @endPoint2.setter
    def endPoint2(self, value: SIMOBodyPoint):
        """Set endPoint2"""
        self.__endPoint2 = value

    @property
    def failureMode(self) -> ActivationFailureMode:
        """Failure mode of coupling element"""
        return self.__failureMode

    @failureMode.setter
    def failureMode(self, value: ActivationFailureMode):
        """Set failureMode"""
        self.__failureMode = value

    @property
    def failureTime(self) -> float:
        """Earliest possible time of failure"""
        return self.__failureTime

    @failureTime.setter
    def failureTime(self, value: float):
        """Set failureTime"""
        self.__failureTime = float(value)

    @property
    def breakingStrength(self) -> float:
        """Breaking strength"""
        return self.__breakingStrength

    @breakingStrength.setter
    def breakingStrength(self, value: float):
        """Set breakingStrength"""
        self.__breakingStrength = float(value)

    @property
    def ea(self) -> float:
        """Wire cross section stiffness"""
        return self.__ea

    @ea.setter
    def ea(self, value: float):
        """Set ea"""
        self.__ea = float(value)

    @property
    def length(self) -> float:
        """Initial, unstretched wire length"""
        return self.__length

    @length.setter
    def length(self, value: float):
        """Set length"""
        self.__length = float(value)

    @property
    def damping(self) -> float:
        """Material damping"""
        return self.__damping

    @damping.setter
    def damping(self, value: float):
        """Set damping"""
        self.__damping = float(value)

    @property
    def flexibility(self) -> float:
        """Connection flexibility"""
        return self.__flexibility

    @flexibility.setter
    def flexibility(self, value: float):
        """Set flexibility"""
        self.__flexibility = float(value)

    @property
    def guidePointSpecifications(self) -> List[GuidePointSpecification]:
        """"""
        return self.__guidePointSpecifications

    @guidePointSpecifications.setter
    def guidePointSpecifications(self, value: List[GuidePointSpecification]):
        """Set guidePointSpecifications"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__guidePointSpecifications = value

    @property
    def constantTensionControl(self) -> bool:
        """Enable constant tension control for this wire"""
        return self.__constantTensionControl

    @constantTensionControl.setter
    def constantTensionControl(self, value: bool):
        """Set constantTensionControl"""
        self.__constantTensionControl = bool(value)

    @property
    def tensionLevel(self) -> float:
        """Desired tension level"""
        return self.__tensionLevel

    @tensionLevel.setter
    def tensionLevel(self, value: float):
        """Set tensionLevel"""
        self.__tensionLevel = float(value)

    @property
    def tensionDeadband(self) -> float:
        """Tension level deadband"""
        return self.__tensionDeadband

    @tensionDeadband.setter
    def tensionDeadband(self, value: float):
        """Set tensionDeadband"""
        self.__tensionDeadband = float(value)

    @property
    def maxSpeed(self) -> float:
        """Max wire length rate of change"""
        return self.__maxSpeed

    @maxSpeed.setter
    def maxSpeed(self, value: float):
        """Set maxSpeed"""
        self.__maxSpeed = float(value)

    @property
    def activationTime(self) -> float:
        """Activation time for constant tension control"""
        return self.__activationTime

    @activationTime.setter
    def activationTime(self, value: float):
        """Set activationTime"""
        self.__activationTime = float(value)

    @property
    def deactivationTime(self) -> float:
        """Deactivation time for constant tension control. If value is less then or equal to activation time, controller will remain active throughout simulation"""
        return self.__deactivationTime

    @deactivationTime.setter
    def deactivationTime(self, value: float):
        """Set deactivationTime"""
        self.__deactivationTime = float(value)
