# This an autogenerated file
# 
# Generated with SIMOQuadraticDampingMatrix
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.simoquadraticdampingmatrix import SIMOQuadraticDampingMatrixBlueprint
from numpy import ndarray,asarray
from sima.hydro.quadraticdampingmatrix import QuadraticDampingMatrix
from sima.sima.named import Named
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.dampingmatrixmotionmode import DampingMatrixMotionMode

class SIMOQuadraticDampingMatrix(QuadraticDampingMatrix,Named):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    values : ndarray
    name : str
         (default "")
    mode : DampingMatrixMotionMode
         Select which motions the damping matrix force should be calculated from. When 'default' is selected, low frequency motion is used for bodies of type '6 DOF - separated analysis' and total motion otherwise.
    """

    def __init__(self , _id="", name="", mode=DampingMatrixMotionMode.DEFAULT, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.values = ndarray(1)
        self.name = name
        self.mode = mode
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SIMOQuadraticDampingMatrixBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def values(self) -> ndarray:
        """"""
        return self.__values

    @values.setter
    def values(self, value: ndarray):
        """Set values"""
        self.__values = asarray(value)

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def mode(self) -> DampingMatrixMotionMode:
        """Select which motions the damping matrix force should be calculated from. When 'default' is selected, low frequency motion is used for bodies of type '6 DOF - separated analysis' and total motion otherwise."""
        return self.__mode

    @mode.setter
    def mode(self, value: DampingMatrixMotionMode):
        """Set mode"""
        self.__mode = value
