# This an autogenerated file
# 
# Generated with ProplibPropellerAndRudderThruster
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.proplibpropellerandrudderthruster import ProplibPropellerAndRudderThrusterBlueprint
from typing import Dict
from sima.sima.point3 import Point3
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.ithruster import IThruster
from sima.simo.thrustercontrolsequence import ThrusterControlSequence
from sima.simo.thrusterdynamics import ThrusterDynamics
from sima.simo.thrusterfailurespecification import ThrusterFailureSpecification

class ProplibPropellerAndRudderThruster(IThruster):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default "")
    minForce : float
         Minimum thruster force(default 0.0)
    maxForce : float
         Maximum thruster force(default 0.0)
    position : Point3
    force : float
         Resulting force, initial value if controlled by a DP-system(default 0.0)
    forceDirection : float
         Direction of thrust force in body x-y plane, initial value if controlled by a DP-system(default 0.0)
    thrusterDynamics : ThrusterDynamics
    controlSequence : ThrusterControlSequence
    failureSpecification : ThrusterFailureSpecification
    includeSurfaceProximityLoss : bool
         Should surface proximity loss be included?(default True)
    includeThrusterHullInteraction : bool
         Should thruster-hull interaction be included?(default True)
    includeThrusterThrusterInteraction : bool
         Should thruster-thruster interaction be included?(default True)
    maxRps : float
         The RPS giving maximum force(default 0.0)
    diameter : float
         Thruster diameter(default 0.0)
    bladeAreaRatio : float
         Propeller blade area ratio(default 0.0)
    headboxHeight : float
         Headbox height(default 0.0)
    headboxRootChord : float
         Headbox root chord(default 0.0)
    headboxTipChord : float
         Headbox tip chord(default 0.0)
    headboxArea : float
         Headbox area(default 0.0)
    rudderHeight : float
         Rudder height(default 0.0)
    rudderRootChord : float
         Rudder root chord(default 0.0)
    rudderTipChord : float
         Rudder tip chord(default 0.0)
    rudderHornArea : float
         Rudder horn area(default 0.0)
    rudderTotalArea : float
         Rudder total area (including horn)(default 0.0)
    rudderPropellerHorizontalDistance : float
         Horizontal distance from propeller plane to rudder stock(default 0.0)
    rudderPropellerVerticalDistance : float
         Vertical distance from propeller plane to rudder top(default 0.0)
    rudderHeadboxGap : float
         Initial gap between rudder and headbox(default 0.0)
    wakeFraction : float
         Wake fraction(default 0.0)
    pitchRatio : float
         Propeller pitch ratio(default 0.0)
    bilgeRadius : float
         Bilge radius(default 0.0)
    verticalDistanceHull : float
         Vertical distance from propeller center to hull(default 0.0)
    thrustDeductionFactor : float
         Thrust deduction factor(default 0.0)
    """

    def __init__(self , _id="", name="", minForce=0.0, maxForce=0.0, force=0.0, forceDirection=0.0, includeSurfaceProximityLoss=True, includeThrusterHullInteraction=True, includeThrusterThrusterInteraction=True, maxRps=0.0, diameter=0.0, bladeAreaRatio=0.0, headboxHeight=0.0, headboxRootChord=0.0, headboxTipChord=0.0, headboxArea=0.0, rudderHeight=0.0, rudderRootChord=0.0, rudderTipChord=0.0, rudderHornArea=0.0, rudderTotalArea=0.0, rudderPropellerHorizontalDistance=0.0, rudderPropellerVerticalDistance=0.0, rudderHeadboxGap=0.0, wakeFraction=0.0, pitchRatio=0.0, bilgeRadius=0.0, verticalDistanceHull=0.0, thrustDeductionFactor=0.0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.name = name
        self.minForce = minForce
        self.maxForce = maxForce
        self.position = None
        self.force = force
        self.forceDirection = forceDirection
        self.thrusterDynamics = None
        self.controlSequence = None
        self.failureSpecification = None
        self.includeSurfaceProximityLoss = includeSurfaceProximityLoss
        self.includeThrusterHullInteraction = includeThrusterHullInteraction
        self.includeThrusterThrusterInteraction = includeThrusterThrusterInteraction
        self.maxRps = maxRps
        self.diameter = diameter
        self.bladeAreaRatio = bladeAreaRatio
        self.headboxHeight = headboxHeight
        self.headboxRootChord = headboxRootChord
        self.headboxTipChord = headboxTipChord
        self.headboxArea = headboxArea
        self.rudderHeight = rudderHeight
        self.rudderRootChord = rudderRootChord
        self.rudderTipChord = rudderTipChord
        self.rudderHornArea = rudderHornArea
        self.rudderTotalArea = rudderTotalArea
        self.rudderPropellerHorizontalDistance = rudderPropellerHorizontalDistance
        self.rudderPropellerVerticalDistance = rudderPropellerVerticalDistance
        self.rudderHeadboxGap = rudderHeadboxGap
        self.wakeFraction = wakeFraction
        self.pitchRatio = pitchRatio
        self.bilgeRadius = bilgeRadius
        self.verticalDistanceHull = verticalDistanceHull
        self.thrustDeductionFactor = thrustDeductionFactor
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ProplibPropellerAndRudderThrusterBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def minForce(self) -> float:
        """Minimum thruster force"""
        return self.__minForce

    @minForce.setter
    def minForce(self, value: float):
        """Set minForce"""
        self.__minForce = float(value)

    @property
    def maxForce(self) -> float:
        """Maximum thruster force"""
        return self.__maxForce

    @maxForce.setter
    def maxForce(self, value: float):
        """Set maxForce"""
        self.__maxForce = float(value)

    @property
    def position(self) -> Point3:
        """"""
        return self.__position

    @position.setter
    def position(self, value: Point3):
        """Set position"""
        self.__position = value

    @property
    def force(self) -> float:
        """Resulting force, initial value if controlled by a DP-system"""
        return self.__force

    @force.setter
    def force(self, value: float):
        """Set force"""
        self.__force = float(value)

    @property
    def forceDirection(self) -> float:
        """Direction of thrust force in body x-y plane, initial value if controlled by a DP-system"""
        return self.__forceDirection

    @forceDirection.setter
    def forceDirection(self, value: float):
        """Set forceDirection"""
        self.__forceDirection = float(value)

    @property
    def thrusterDynamics(self) -> ThrusterDynamics:
        """"""
        return self.__thrusterDynamics

    @thrusterDynamics.setter
    def thrusterDynamics(self, value: ThrusterDynamics):
        """Set thrusterDynamics"""
        self.__thrusterDynamics = value

    @property
    def controlSequence(self) -> ThrusterControlSequence:
        """"""
        return self.__controlSequence

    @controlSequence.setter
    def controlSequence(self, value: ThrusterControlSequence):
        """Set controlSequence"""
        self.__controlSequence = value

    @property
    def failureSpecification(self) -> ThrusterFailureSpecification:
        """"""
        return self.__failureSpecification

    @failureSpecification.setter
    def failureSpecification(self, value: ThrusterFailureSpecification):
        """Set failureSpecification"""
        self.__failureSpecification = value

    @property
    def includeSurfaceProximityLoss(self) -> bool:
        """Should surface proximity loss be included?"""
        return self.__includeSurfaceProximityLoss

    @includeSurfaceProximityLoss.setter
    def includeSurfaceProximityLoss(self, value: bool):
        """Set includeSurfaceProximityLoss"""
        self.__includeSurfaceProximityLoss = bool(value)

    @property
    def includeThrusterHullInteraction(self) -> bool:
        """Should thruster-hull interaction be included?"""
        return self.__includeThrusterHullInteraction

    @includeThrusterHullInteraction.setter
    def includeThrusterHullInteraction(self, value: bool):
        """Set includeThrusterHullInteraction"""
        self.__includeThrusterHullInteraction = bool(value)

    @property
    def includeThrusterThrusterInteraction(self) -> bool:
        """Should thruster-thruster interaction be included?"""
        return self.__includeThrusterThrusterInteraction

    @includeThrusterThrusterInteraction.setter
    def includeThrusterThrusterInteraction(self, value: bool):
        """Set includeThrusterThrusterInteraction"""
        self.__includeThrusterThrusterInteraction = bool(value)

    @property
    def maxRps(self) -> float:
        """The RPS giving maximum force"""
        return self.__maxRps

    @maxRps.setter
    def maxRps(self, value: float):
        """Set maxRps"""
        self.__maxRps = float(value)

    @property
    def diameter(self) -> float:
        """Thruster diameter"""
        return self.__diameter

    @diameter.setter
    def diameter(self, value: float):
        """Set diameter"""
        self.__diameter = float(value)

    @property
    def bladeAreaRatio(self) -> float:
        """Propeller blade area ratio"""
        return self.__bladeAreaRatio

    @bladeAreaRatio.setter
    def bladeAreaRatio(self, value: float):
        """Set bladeAreaRatio"""
        self.__bladeAreaRatio = float(value)

    @property
    def headboxHeight(self) -> float:
        """Headbox height"""
        return self.__headboxHeight

    @headboxHeight.setter
    def headboxHeight(self, value: float):
        """Set headboxHeight"""
        self.__headboxHeight = float(value)

    @property
    def headboxRootChord(self) -> float:
        """Headbox root chord"""
        return self.__headboxRootChord

    @headboxRootChord.setter
    def headboxRootChord(self, value: float):
        """Set headboxRootChord"""
        self.__headboxRootChord = float(value)

    @property
    def headboxTipChord(self) -> float:
        """Headbox tip chord"""
        return self.__headboxTipChord

    @headboxTipChord.setter
    def headboxTipChord(self, value: float):
        """Set headboxTipChord"""
        self.__headboxTipChord = float(value)

    @property
    def headboxArea(self) -> float:
        """Headbox area"""
        return self.__headboxArea

    @headboxArea.setter
    def headboxArea(self, value: float):
        """Set headboxArea"""
        self.__headboxArea = float(value)

    @property
    def rudderHeight(self) -> float:
        """Rudder height"""
        return self.__rudderHeight

    @rudderHeight.setter
    def rudderHeight(self, value: float):
        """Set rudderHeight"""
        self.__rudderHeight = float(value)

    @property
    def rudderRootChord(self) -> float:
        """Rudder root chord"""
        return self.__rudderRootChord

    @rudderRootChord.setter
    def rudderRootChord(self, value: float):
        """Set rudderRootChord"""
        self.__rudderRootChord = float(value)

    @property
    def rudderTipChord(self) -> float:
        """Rudder tip chord"""
        return self.__rudderTipChord

    @rudderTipChord.setter
    def rudderTipChord(self, value: float):
        """Set rudderTipChord"""
        self.__rudderTipChord = float(value)

    @property
    def rudderHornArea(self) -> float:
        """Rudder horn area"""
        return self.__rudderHornArea

    @rudderHornArea.setter
    def rudderHornArea(self, value: float):
        """Set rudderHornArea"""
        self.__rudderHornArea = float(value)

    @property
    def rudderTotalArea(self) -> float:
        """Rudder total area (including horn)"""
        return self.__rudderTotalArea

    @rudderTotalArea.setter
    def rudderTotalArea(self, value: float):
        """Set rudderTotalArea"""
        self.__rudderTotalArea = float(value)

    @property
    def rudderPropellerHorizontalDistance(self) -> float:
        """Horizontal distance from propeller plane to rudder stock"""
        return self.__rudderPropellerHorizontalDistance

    @rudderPropellerHorizontalDistance.setter
    def rudderPropellerHorizontalDistance(self, value: float):
        """Set rudderPropellerHorizontalDistance"""
        self.__rudderPropellerHorizontalDistance = float(value)

    @property
    def rudderPropellerVerticalDistance(self) -> float:
        """Vertical distance from propeller plane to rudder top"""
        return self.__rudderPropellerVerticalDistance

    @rudderPropellerVerticalDistance.setter
    def rudderPropellerVerticalDistance(self, value: float):
        """Set rudderPropellerVerticalDistance"""
        self.__rudderPropellerVerticalDistance = float(value)

    @property
    def rudderHeadboxGap(self) -> float:
        """Initial gap between rudder and headbox"""
        return self.__rudderHeadboxGap

    @rudderHeadboxGap.setter
    def rudderHeadboxGap(self, value: float):
        """Set rudderHeadboxGap"""
        self.__rudderHeadboxGap = float(value)

    @property
    def wakeFraction(self) -> float:
        """Wake fraction"""
        return self.__wakeFraction

    @wakeFraction.setter
    def wakeFraction(self, value: float):
        """Set wakeFraction"""
        self.__wakeFraction = float(value)

    @property
    def pitchRatio(self) -> float:
        """Propeller pitch ratio"""
        return self.__pitchRatio

    @pitchRatio.setter
    def pitchRatio(self, value: float):
        """Set pitchRatio"""
        self.__pitchRatio = float(value)

    @property
    def bilgeRadius(self) -> float:
        """Bilge radius"""
        return self.__bilgeRadius

    @bilgeRadius.setter
    def bilgeRadius(self, value: float):
        """Set bilgeRadius"""
        self.__bilgeRadius = float(value)

    @property
    def verticalDistanceHull(self) -> float:
        """Vertical distance from propeller center to hull"""
        return self.__verticalDistanceHull

    @verticalDistanceHull.setter
    def verticalDistanceHull(self, value: float):
        """Set verticalDistanceHull"""
        self.__verticalDistanceHull = float(value)

    @property
    def thrustDeductionFactor(self) -> float:
        """Thrust deduction factor"""
        return self.__thrustDeductionFactor

    @thrustDeductionFactor.setter
    def thrustDeductionFactor(self, value: float):
        """Set thrustDeductionFactor"""
        self.__thrustDeductionFactor = float(value)
