# This an autogenerated file
# 
# Generated with NonlinearBuoyancyCorrection
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.nonlinearbuoyancycorrection import NonlinearBuoyancyCorrectionBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.point3 import Point3
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.nonlinearbuoyancycorrectionmethod import NonlinearBuoyancyCorrectionMethod

class NonlinearBuoyancyCorrection(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    fileName : str
         Name of geometry file ('.gdf'-file)(default "")
    location : Point3
    minZ : float
         Minimum vertical range value to be used given in '.gdf' file system(default 0.0)
    maxZ : float
         Maximum vertical range value to be used given in '.gdf' file system(default 0.0)
    correctionMethod : NonlinearBuoyancyCorrectionMethod
    """

    def __init__(self , _id="", fileName="", minZ=0.0, maxZ=0.0, correctionMethod=NonlinearBuoyancyCorrectionMethod.MWL, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.fileName = fileName
        self.location = None
        self.minZ = minZ
        self.maxZ = maxZ
        self.correctionMethod = correctionMethod
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return NonlinearBuoyancyCorrectionBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def fileName(self) -> str:
        """Name of geometry file ('.gdf'-file)"""
        return self.__fileName

    @fileName.setter
    def fileName(self, value: str):
        """Set fileName"""
        self.__fileName = str(value)

    @property
    def location(self) -> Point3:
        """"""
        return self.__location

    @location.setter
    def location(self, value: Point3):
        """Set location"""
        self.__location = value

    @property
    def minZ(self) -> float:
        """Minimum vertical range value to be used given in '.gdf' file system"""
        return self.__minZ

    @minZ.setter
    def minZ(self, value: float):
        """Set minZ"""
        self.__minZ = float(value)

    @property
    def maxZ(self) -> float:
        """Maximum vertical range value to be used given in '.gdf' file system"""
        return self.__maxZ

    @maxZ.setter
    def maxZ(self, value: float):
        """Set maxZ"""
        self.__maxZ = float(value)

    @property
    def correctionMethod(self) -> NonlinearBuoyancyCorrectionMethod:
        """"""
        return self.__correctionMethod

    @correctionMethod.setter
    def correctionMethod(self, value: NonlinearBuoyancyCorrectionMethod):
        """Set correctionMethod"""
        self.__correctionMethod = value
