# This an autogenerated file
# 
# Generated with LineCharacteristicItem
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.linecharacteristicitem import LineCharacteristicItemBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.linetensionitem import LineTensionItem

class LineCharacteristicItem(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    seaBedX : float
         Global x-coordinate of the line end point anchored at the sea bed(default 0.0)
    seaBedY : float
         Global y-coordinate of the line end point anchored at the sea bed(default 0.0)
    vesselX : float
         X-coordinate of the line end point attached to the vessel (given in the body fixed coordinate system)(default 0.0)
    vesselY : float
         Y-coordinate of the line end point attached to the vessel (given in the body fixed coordinate system)(default 0.0)
    lineTensionItems : List[LineTensionItem]
    """

    def __init__(self , _id="", seaBedX=0.0, seaBedY=0.0, vesselX=0.0, vesselY=0.0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.seaBedX = seaBedX
        self.seaBedY = seaBedY
        self.vesselX = vesselX
        self.vesselY = vesselY
        self.lineTensionItems = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return LineCharacteristicItemBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def seaBedX(self) -> float:
        """Global x-coordinate of the line end point anchored at the sea bed"""
        return self.__seaBedX

    @seaBedX.setter
    def seaBedX(self, value: float):
        """Set seaBedX"""
        self.__seaBedX = float(value)

    @property
    def seaBedY(self) -> float:
        """Global y-coordinate of the line end point anchored at the sea bed"""
        return self.__seaBedY

    @seaBedY.setter
    def seaBedY(self, value: float):
        """Set seaBedY"""
        self.__seaBedY = float(value)

    @property
    def vesselX(self) -> float:
        """X-coordinate of the line end point attached to the vessel (given in the body fixed coordinate system)"""
        return self.__vesselX

    @vesselX.setter
    def vesselX(self, value: float):
        """Set vesselX"""
        self.__vesselX = float(value)

    @property
    def vesselY(self) -> float:
        """Y-coordinate of the line end point attached to the vessel (given in the body fixed coordinate system)"""
        return self.__vesselY

    @vesselY.setter
    def vesselY(self, value: float):
        """Set vesselY"""
        self.__vesselY = float(value)

    @property
    def lineTensionItems(self) -> List[LineTensionItem]:
        """"""
        return self.__lineTensionItems

    @lineTensionItems.setter
    def lineTensionItems(self, value: List[LineTensionItem]):
        """Set lineTensionItems"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__lineTensionItems = value
