# This an autogenerated file
# 
# Generated with GuidePoint
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.guidepoint import GuidePointBlueprint
from typing import Dict
from sima.sima.scriptablevalue import ScriptableValue
from sima.sima.vector3 import Vector3
from sima.simo.simobodypoint import SIMOBodyPoint
from sima.simo.simoheavecompensator import SIMOHeaveCompensator
from sima.simo.simotensioner import SIMOTensioner
from sima.simo.winch import Winch

class GuidePoint(SIMOBodyPoint):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    name : str
         (default "")
    winch : Winch
    tensioner : SIMOTensioner
    heaveCompensator : SIMOHeaveCompensator
    x : float
         Local  x position(default 0.0)
    y : float
         Local  y position(default 0.0)
    z : float
         Local z position(default 0.0)
    diameter : float
         Diameter of guide hole(default 0.0)
    normalVector : Vector3
         Vector normal to hole in body fixed coordinate system
    """

    def __init__(self , _id="", name="", x=0.0, y=0.0, z=0.0, diameter=0.0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.name = name
        self.winch = None
        self.tensioner = None
        self.heaveCompensator = None
        self.x = x
        self.y = y
        self.z = z
        self.diameter = diameter
        self.normalVector = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return GuidePointBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def winch(self) -> Winch:
        """"""
        return self.__winch

    @winch.setter
    def winch(self, value: Winch):
        """Set winch"""
        self.__winch = value

    @property
    def tensioner(self) -> SIMOTensioner:
        """"""
        return self.__tensioner

    @tensioner.setter
    def tensioner(self, value: SIMOTensioner):
        """Set tensioner"""
        self.__tensioner = value

    @property
    def heaveCompensator(self) -> SIMOHeaveCompensator:
        """"""
        return self.__heaveCompensator

    @heaveCompensator.setter
    def heaveCompensator(self, value: SIMOHeaveCompensator):
        """Set heaveCompensator"""
        self.__heaveCompensator = value

    @property
    def x(self) -> float:
        """Local  x position"""
        return self.__x

    @x.setter
    def x(self, value: float):
        """Set x"""
        self.__x = float(value)

    @property
    def y(self) -> float:
        """Local  y position"""
        return self.__y

    @y.setter
    def y(self, value: float):
        """Set y"""
        self.__y = float(value)

    @property
    def z(self) -> float:
        """Local z position"""
        return self.__z

    @z.setter
    def z(self, value: float):
        """Set z"""
        self.__z = float(value)

    @property
    def diameter(self) -> float:
        """Diameter of guide hole"""
        return self.__diameter

    @diameter.setter
    def diameter(self, value: float):
        """Set diameter"""
        self.__diameter = float(value)

    @property
    def normalVector(self) -> Vector3:
        """Vector normal to hole in body fixed coordinate system"""
        return self.__normalVector

    @normalVector.setter
    def normalVector(self, value: Vector3):
        """Set normalVector"""
        self.__normalVector = value
