# This an autogenerated file
# 
# Generated with EquilibriumGridDefinition
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.equilibriumgriddefinition import EquilibriumGridDefinitionBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.equilibriumgriddefinitionrow import EquilibriumGridDefinitionRow
from sima.simo.equilibriumgridtype import EquilibriumGridType
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.simo.simobody import SIMOBody

class EquilibriumGridDefinition(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    roll : EquilibriumGridDefinitionRow
    pitch : EquilibriumGridDefinitionRow
    body : SIMOBody
         Body for which the grid will be defined
    typeOfGrid : EquilibriumGridType
    """

    def __init__(self , _id="", typeOfGrid=EquilibriumGridType.ROLL_AND_PITCH_ANGLES, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self.roll = None
        self.pitch = None
        self.body = None
        self.typeOfGrid = typeOfGrid
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return EquilibriumGridDefinitionBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def roll(self) -> EquilibriumGridDefinitionRow:
        """"""
        return self.__roll

    @roll.setter
    def roll(self, value: EquilibriumGridDefinitionRow):
        """Set roll"""
        self.__roll = value

    @property
    def pitch(self) -> EquilibriumGridDefinitionRow:
        """"""
        return self.__pitch

    @pitch.setter
    def pitch(self, value: EquilibriumGridDefinitionRow):
        """Set pitch"""
        self.__pitch = value

    @property
    def body(self) -> SIMOBody:
        """Body for which the grid will be defined"""
        return self.__body

    @body.setter
    def body(self, value: SIMOBody):
        """Set body"""
        self.__body = value

    @property
    def typeOfGrid(self) -> EquilibriumGridType:
        """"""
        return self.__typeOfGrid

    @typeOfGrid.setter
    def typeOfGrid(self, value: EquilibriumGridType):
        """Set typeOfGrid"""
        self.__typeOfGrid = value
