# This an autogenerated file
# 
# Generated with ArticulatedStructureData
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.articulatedstructuredata import ArticulatedStructureDataBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.point3 import Point3
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.articulatedstructuretype import ArticulatedStructureType
from sima.simo.motionmode import MotionMode
from sima.simo.motionsequence import MotionSequence
from sima.simo.motionsequencetype import MotionSequenceType

class ArticulatedStructureData(MOAO):
    """
    Keyword arguments
    -----------------
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    _type : ArticulatedStructureType
         Type of articulated structure coupling control
    masterPoint : Point3
    localPoint : Point3
    motionMode : MotionMode
         Mode of motion (X,Y,Z,PHI,THETA,PSI)
    initialPosition : float
         Initial position(default 0.0)
    lowerPositionLimit : float
         Lower position limit in master coordinate system(default 0.0)
    upperPositionLimit : float
         Upper position limit in master coordinate system(default 0.0)
    maxSpeed : float
         Maximum speed for chosen mode of motion(default 0.0)
    maxAcceleration : float
         Maximum acceleration for chosen mode of motion(default 0.0)
    sequenceItems : List[MotionSequence]
    motionSequenceType : MotionSequenceType
    maximumAngle : float
         Maximum angle that turret follows the vessel before sliding(default 0.0)
    slipAngle : float
         Slip (turn-back) angle(default 0.0)
    """

    def __init__(self , _id="", _type=ArticulatedStructureType.NRUN, motionMode=MotionMode.PHI, initialPosition=0.0, lowerPositionLimit=0.0, upperPositionLimit=0.0, maxSpeed=0.0, maxAcceleration=0.0, motionSequenceType=MotionSequenceType.TSTOP, maximumAngle=0.0, slipAngle=0.0, **kwargs):
        super().__init__(**kwargs)
        self._id = _id
        self.scriptableValues = list()
        self._type = _type
        self.masterPoint = None
        self.localPoint = None
        self.motionMode = motionMode
        self.initialPosition = initialPosition
        self.lowerPositionLimit = lowerPositionLimit
        self.upperPositionLimit = upperPositionLimit
        self.maxSpeed = maxSpeed
        self.maxAcceleration = maxAcceleration
        self.sequenceItems = list()
        self.motionSequenceType = motionSequenceType
        self.maximumAngle = maximumAngle
        self.slipAngle = slipAngle
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ArticulatedStructureDataBlueprint()


    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def _type(self) -> ArticulatedStructureType:
        """Type of articulated structure coupling control"""
        return self.___type

    @_type.setter
    def _type(self, value: ArticulatedStructureType):
        """Set _type"""
        self.___type = value

    @property
    def masterPoint(self) -> Point3:
        """"""
        return self.__masterPoint

    @masterPoint.setter
    def masterPoint(self, value: Point3):
        """Set masterPoint"""
        self.__masterPoint = value

    @property
    def localPoint(self) -> Point3:
        """"""
        return self.__localPoint

    @localPoint.setter
    def localPoint(self, value: Point3):
        """Set localPoint"""
        self.__localPoint = value

    @property
    def motionMode(self) -> MotionMode:
        """Mode of motion (X,Y,Z,PHI,THETA,PSI)"""
        return self.__motionMode

    @motionMode.setter
    def motionMode(self, value: MotionMode):
        """Set motionMode"""
        self.__motionMode = value

    @property
    def initialPosition(self) -> float:
        """Initial position"""
        return self.__initialPosition

    @initialPosition.setter
    def initialPosition(self, value: float):
        """Set initialPosition"""
        self.__initialPosition = float(value)

    @property
    def lowerPositionLimit(self) -> float:
        """Lower position limit in master coordinate system"""
        return self.__lowerPositionLimit

    @lowerPositionLimit.setter
    def lowerPositionLimit(self, value: float):
        """Set lowerPositionLimit"""
        self.__lowerPositionLimit = float(value)

    @property
    def upperPositionLimit(self) -> float:
        """Upper position limit in master coordinate system"""
        return self.__upperPositionLimit

    @upperPositionLimit.setter
    def upperPositionLimit(self, value: float):
        """Set upperPositionLimit"""
        self.__upperPositionLimit = float(value)

    @property
    def maxSpeed(self) -> float:
        """Maximum speed for chosen mode of motion"""
        return self.__maxSpeed

    @maxSpeed.setter
    def maxSpeed(self, value: float):
        """Set maxSpeed"""
        self.__maxSpeed = float(value)

    @property
    def maxAcceleration(self) -> float:
        """Maximum acceleration for chosen mode of motion"""
        return self.__maxAcceleration

    @maxAcceleration.setter
    def maxAcceleration(self, value: float):
        """Set maxAcceleration"""
        self.__maxAcceleration = float(value)

    @property
    def sequenceItems(self) -> List[MotionSequence]:
        """"""
        return self.__sequenceItems

    @sequenceItems.setter
    def sequenceItems(self, value: List[MotionSequence]):
        """Set sequenceItems"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__sequenceItems = value

    @property
    def motionSequenceType(self) -> MotionSequenceType:
        """"""
        return self.__motionSequenceType

    @motionSequenceType.setter
    def motionSequenceType(self, value: MotionSequenceType):
        """Set motionSequenceType"""
        self.__motionSequenceType = value

    @property
    def maximumAngle(self) -> float:
        """Maximum angle that turret follows the vessel before sliding"""
        return self.__maximumAngle

    @maximumAngle.setter
    def maximumAngle(self, value: float):
        """Set maximumAngle"""
        self.__maximumAngle = float(value)

    @property
    def slipAngle(self) -> float:
        """Slip (turn-back) angle"""
        return self.__slipAngle

    @slipAngle.setter
    def slipAngle(self, value: float):
        """Set slipAngle"""
        self.__slipAngle = float(value)
